/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.ui;

import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.autoplot.datasource.ui.RowHeaderRenderer;
import org.autoplot.datasource.ui.TableRowHeaderModel;

public class TableRowHeader
extends JList {
    private JTable table;

    public TableRowHeader(JTable table) {
        super(new TableRowHeaderModel(table));
        this.table = table;
        this.setFixedCellHeight(table.getRowHeight());
        this.setFixedCellWidth(this.preferredHeaderWidth());
        this.setCellRenderer(new RowHeaderRenderer(table));
        this.setSelectionModel(table.getSelectionModel());
    }

    @Override
    public Rectangle getCellBounds(int index0, int index1) {
        int height;
        int y;
        Rectangle rect0 = this.table.getCellRect(index0, 0, true);
        Rectangle rect1 = this.table.getCellRect(index1, 0, true);
        if (rect0.y < rect1.y) {
            y = rect0.y;
            height = rect1.y + rect1.height - y;
        } else {
            y = rect1.y;
            height = rect0.y + rect0.height - y;
        }
        return new Rectangle(0, y, this.getFixedCellWidth(), height);
    }

    private int preferredHeaderWidth() {
        JLabel longestRowLabel = new JLabel("65356");
        JTableHeader header = this.table.getTableHeader();
        longestRowLabel.setBorder(header.getBorder());
        longestRowLabel.setHorizontalAlignment(0);
        longestRowLabel.setFont(header.getFont());
        return longestRowLabel.getPreferredSize().width;
    }
}

