/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.jython;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.jython.JythonDataSourceFactory;
import org.autoplot.datasource.jython.JythonDataSourceTimeSeriesBrowse;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.ui.EditorAnnotationsSupport;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.jythonsupport.ui.ScriptPanelSupport;
import org.autoplot.jythonsupport.ui.Util;
import org.das2.components.TearoffTabbedPane;
import org.das2.datum.DatumRangeUtil;
import org.das2.jythoncompletion.nbadapt.Utilities;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.python.core.PyException;

public class JythonEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = Logger.getLogger("apdss.jyds");
    ScriptPanelSupport support;
    String suri;
    File file;
    URI resourceUri;
    boolean hasVariables = false;
    List<JComponent> tflist;
    List<String> paramsList;
    List<String> deftsList;
    List<Character> typesList;
    private JLabel caretPositionLabel;
    protected JLabel fileNameLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel paramsPanel;
    private JScrollPane paramsScrollPane;
    private JPanel scriptPanel;
    private JScrollPane scriptScrollPane;
    private TearoffTabbedPane tearoffTabbedPane1;
    private EditorTextPane textArea;
    private JComboBox variableComboBox;

    public JythonEditorPanel() {
        this.initComponents();
        this.tearoffTabbedPane1.hideMouseAdapter();
        this.support = new ScriptPanelSupport(this.textArea);
        this.support.addCaretLabel(this.caretPositionLabel);
        this.support.addFileLabel(this.fileNameLabel);
        this.support.setReadOnly();
        this.scriptScrollPane.getVerticalScrollBar().setUnitIncrement(this.scriptScrollPane.getFont().getSize());
        this.paramsScrollPane.getVerticalScrollBar().setUnitIncrement(this.scriptScrollPane.getFont().getSize());
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    String id;
                    int idx;
                    int offs = JythonEditorPanel.this.textArea.viewToModel(e.getPoint());
                    int[] ii = Utilities.getIdentifierBlock(JythonEditorPanel.this.textArea, offs);
                    if (ii != null && (idx = JythonEditorPanel.this.lookupResultVariableIndex(id = JythonEditorPanel.this.textArea.getDocument().getText(ii[0], ii[1] - ii[0]))) != -1) {
                        JythonEditorPanel.this.variableComboBox.setSelectedIndex(idx);
                    }
                }
                catch (BadLocationException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        });
    }

    private void redoVariables() {
        this.paramsPanel.removeAll();
        Map<String, String> params = this.getParamsFromGui();
        try {
            if (this.doDocumentation(this.file)) {
                this.paramsPanel.add(new JLabel("<html><br></html>"));
            }
            this.doVariables(this.file, params);
            this.paramsPanel.revalidate();
        }
        catch (PyException ex) {
            JOptionPane.showMessageDialog(this, "<html>Error:<br>" + (Object)((Object)ex));
        }
    }

    private void initComponents() {
        this.variableComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.tearoffTabbedPane1 = new TearoffTabbedPane();
        this.scriptPanel = new JPanel();
        this.caretPositionLabel = new JLabel();
        this.fileNameLabel = new JLabel();
        this.scriptScrollPane = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.textArea = new EditorTextPane();
        this.paramsScrollPane = new JScrollPane();
        this.paramsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.setName("jythonDataSourceEditorPanel");
        this.variableComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"(running script)"}));
        this.jLabel1.setText("Select variable:");
        this.jLabel1.setToolTipText("The dataset pointed to by the URI");
        this.caretPositionLabel.setText("1,1");
        this.fileNameLabel.setMinimumSize(new Dimension(200, 16));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.textArea, "Center");
        this.scriptScrollPane.setViewportView(this.jPanel1);
        GroupLayout scriptPanelLayout = new GroupLayout((Container)this.scriptPanel);
        this.scriptPanel.setLayout((LayoutManager)scriptPanelLayout);
        scriptPanelLayout.setHorizontalGroup((GroupLayout.Group)scriptPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)scriptPanelLayout.createSequentialGroup().add((Component)this.fileNameLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.caretPositionLabel, -2, 56, -2)).add((Component)this.scriptScrollPane));
        scriptPanelLayout.setVerticalGroup((GroupLayout.Group)scriptPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)scriptPanelLayout.createSequentialGroup().add((Component)this.scriptScrollPane, -1, 208, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)scriptPanelLayout.createParallelGroup(2).add((Component)this.fileNameLabel, -2, 20, -2).add((Component)this.caretPositionLabel))));
        this.tearoffTabbedPane1.addTab("script", this.scriptPanel);
        this.paramsPanel.setLayout(new BoxLayout(this.paramsPanel, 1));
        this.paramsScrollPane.setViewportView(this.paramsPanel);
        this.tearoffTabbedPane1.addTab("params", this.paramsScrollPane);
        this.jLabel2.setText("Select from the variables calculated by the script, 'data' or 'result' is used by default:");
        this.jLabel2.setMinimumSize(new Dimension(200, 17));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.variableComboBox, 0, -1, Short.MAX_VALUE)).add((Component)this.tearoffTabbedPane1, -2, 0, Short.MAX_VALUE).add((Component)this.jLabel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tearoffTabbedPane1, -1, -1, Short.MAX_VALUE).add(8, 8, 8).add((Component)this.jLabel2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.variableComboBox, -2, -1, -2).add((Component)this.jLabel1))));
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    private boolean isBoolean(List<Object> parms) {
        return parms.size() == 2 && parms.contains("T") && parms.contains("F");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDocumentation(File f) {
        BufferedReader reader = null;
        boolean hasDoc = false;
        try {
            String description;
            reader = new BufferedReader(new FileReader(f));
            Map<String, String> doc = JythonUtil.getDocumentation(reader);
            String title = doc.get("TITLE");
            if (title != null) {
                this.paramsPanel.add(new JLabel("<html><b>" + title + "</b></html>"));
                hasDoc = true;
            }
            if ((description = doc.get("DESCRIPTION")) != null) {
                this.paramsPanel.add(new JLabel("<html>" + description + "</html>"));
                hasDoc = true;
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        return hasDoc;
    }

    private JComponent getSpacer() {
        JLabel spacer = new JLabel("  ");
        spacer.setSize(new Dimension(20, 16));
        spacer.setMinimumSize(new Dimension(20, 16));
        spacer.setPreferredSize(new Dimension(20, 16));
        return spacer;
    }

    private JComponent getSpacer(int size) {
        JLabel spacer = new JLabel(" ");
        spacer.setSize(new Dimension(size, 16));
        spacer.setMinimumSize(new Dimension(size, 16));
        spacer.setPreferredSize(new Dimension(size, 16));
        return spacer;
    }

    private boolean doVariables(File f, Map<String, String> params) throws PyException {
        boolean hasVars = false;
        this.tflist = new ArrayList<JComponent>();
        this.paramsList = new ArrayList<String>();
        this.deftsList = new ArrayList<String>();
        this.typesList = new ArrayList<Character>();
        try {
            Map<String, JythonUtil.Param> parms = JythonDataSourceFactory.getParams(f.toURI(), params, (ProgressMonitor)new NullProgressMonitor());
            this.paramsPanel.add(new JLabel("<html>This script has the following input parameters.  Buttons on the right show default values.<br><br></html>"));
            for (Map.Entry<String, JythonUtil.Param> e : parms.entrySet()) {
                Dimension x;
                JTextField tf;
                String val;
                JComponent ctf;
                DataSetSelector sel;
                String label;
                String colon;
                JythonUtil.Param parm = e.getValue();
                String vname = parm.name;
                boolean isBool = parm.enums != null && this.isBoolean(parm.enums);
                String string = colon = isBool ? "" : ":";
                if (parm.doc == null) {
                    label = vname + colon;
                } else {
                    String doc = parm.doc;
                    if (doc.startsWith("'")) {
                        doc = doc.substring(1, doc.length() - 1);
                    }
                    if (!parm.label.equals(parm.name)) {
                        doc = doc + " (" + parm.label + " inside the script)";
                    }
                    label = "<html>" + parm.name + ", <i>" + doc + "</i>" + colon + "</html>";
                }
                if (!isBool) {
                    JPanel labelPanel = new JPanel();
                    labelPanel.setLayout(new BoxLayout(labelPanel, 0));
                    JLabel l = new JLabel(label);
                    labelPanel.add(this.getSpacer());
                    labelPanel.add(l);
                    labelPanel.setAlignmentX(0.0f);
                    this.paramsPanel.add(labelPanel);
                } else {
                    this.paramsPanel.add(Box.createVerticalStrut(this.paramsPanel.getFont().getSize() / 2));
                }
                JPanel valuePanel = new JPanel();
                valuePanel.setLayout(new BoxLayout(valuePanel, 0));
                if (!isBool) {
                    valuePanel.add(this.getSpacer());
                }
                if (parm.type == 'R') {
                    String val2;
                    sel = new DataSetSelector();
                    sel.setPlotItButtonVisible(false);
                    sel.setEnableDataSource(false);
                    sel.setSuggestFiles(true);
                    sel.setSuggestFsAgg(true);
                    if (params.get(vname) != null) {
                        val2 = params.get(vname);
                        if (val2.startsWith("'")) {
                            val2 = val2.substring(1);
                        }
                        if (val2.endsWith("'")) {
                            val2 = val2.substring(0, val2.length() - 1);
                        }
                    } else {
                        val2 = String.valueOf(parm.deft);
                        params.put(vname, val2);
                    }
                    sel.setRecent(DataSetSelector.getDefaultRecent());
                    sel.setValue(val2);
                    valuePanel.add(this.getSpacer(7));
                    valuePanel.add(sel);
                    sel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
                    sel.setValue(val2);
                    valuePanel.add(this.getSpacer(10));
                    ctf = sel;
                } else if (parm.type == 'U') {
                    String blurVal;
                    String val3;
                    sel = new DataSetSelector();
                    sel.setPlotItButtonVisible(false);
                    JythonUtil.Param timerange = parms.get("timerange");
                    if (timerange != null) {
                        try {
                            sel.setTimeRange(DatumRangeUtil.parseTimeRange(String.valueOf(timerange.deft)));
                        }
                        catch (ParseException ex) {
                            logger.log(Level.WARNING, "unable to parse as time range: {0}", timerange.deft);
                        }
                    }
                    if (params.get(vname) != null) {
                        val3 = params.get(vname);
                        if (val3.startsWith("'")) {
                            val3 = val3.substring(1);
                        }
                        if (val3.endsWith("'")) {
                            val3 = val3.substring(0, val3.length() - 1);
                        }
                    } else {
                        val3 = String.valueOf(parm.deft);
                        params.put(vname, val3);
                    }
                    if (timerange != null && (blurVal = DataSetURI.blurTsbUri(val3)) != null) {
                        val3 = blurVal;
                        logger.finer("blurring URI because timerange is used.");
                    }
                    sel.setRecent(DataSetSelector.getDefaultRecent());
                    sel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
                    sel.setValue(val3);
                    valuePanel.add(this.getSpacer(7));
                    valuePanel.add(sel);
                    sel.setValue(val3);
                    valuePanel.add(this.getSpacer(10));
                    ctf = sel;
                } else if (parm.type == 'T') {
                    if (params.get(vname) != null) {
                        val = params.get(vname);
                        if (val.startsWith("'")) {
                            val = val.substring(1);
                        }
                        if (val.endsWith("'")) {
                            val = val.substring(0, val.length() - 1);
                        }
                    } else {
                        val = String.valueOf(parm.deft);
                        params.put(vname, val);
                    }
                    tf = new JTextField();
                    x = tf.getPreferredSize();
                    x.width = Integer.MAX_VALUE;
                    tf.setMaximumSize(x);
                    tf.setAlignmentX(0.0f);
                    tf.setText(val);
                    ctf = tf;
                    ImageIcon fileIcon = new ImageIcon(Util.class.getResource("/org/autoplot/datasource/calendar.png"));
                    JButton button = new JButton(fileIcon);
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LoggerManager.logGuiEvent(e);
                            TimeRangeTool tt = new TimeRangeTool();
                            tt.setSelectedRange(tf.getText());
                            int r = JOptionPane.showConfirmDialog(JythonEditorPanel.this.paramsPanel, tt, "Select Time Range", 2);
                            if (r == 0) {
                                tf.setText(tt.getSelectedRange());
                            }
                        }
                    });
                    button.setToolTipText("Time Range Tool");
                    valuePanel.add(ctf);
                    button.setAlignmentX(0.0f);
                    valuePanel.add(button);
                } else {
                    if (params.get(vname) != null) {
                        val = params.get(vname);
                        if (val.startsWith("'")) {
                            val = val.substring(1);
                        }
                        if (val.endsWith("'")) {
                            val = val.substring(0, val.length() - 1);
                        }
                    } else {
                        val = String.valueOf(parm.deft);
                    }
                    if (parm.enums != null && parm.enums.size() > 0) {
                        JComponent jcb;
                        if (this.isBoolean(parm.enums)) {
                            jcb = new JCheckBox(label);
                            ((AbstractButton)jcb).setSelected(val.equals("T"));
                            ctf = jcb;
                            ((AbstractButton)jcb).addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    LoggerManager.logGuiEvent(e);
                                    JythonEditorPanel.this.redoVariables();
                                }
                            });
                        } else {
                            jcb = new JComboBox<Object>(parm.enums.toArray());
                            ((JComboBox)jcb).setEditable(false);
                            Object oval = parm.deft instanceof Long ? Long.valueOf(val) : (parm.deft instanceof Integer ? Integer.valueOf(val) : (parm.deft instanceof Double ? Double.valueOf(val) : (parm.deft instanceof Float ? Float.valueOf(val) : val)));
                            ((JComboBox)jcb).setSelectedItem(oval);
                            ((JComboBox)jcb).addItemListener(new ItemListener(){

                                @Override
                                public void itemStateChanged(ItemEvent e) {
                                    JythonEditorPanel.this.redoVariables();
                                }
                            });
                            ctf = jcb;
                            Dimension x2 = ctf.getPreferredSize();
                            x2.width = Integer.MAX_VALUE;
                            ctf.setMaximumSize(x2);
                            ctf.setAlignmentX(0.0f);
                        }
                    } else {
                        tf = new JTextField();
                        x = tf.getPreferredSize();
                        x.width = Integer.MAX_VALUE;
                        tf.setMaximumSize(x);
                        tf.setAlignmentX(0.0f);
                        tf.setText(val);
                        ctf = tf;
                    }
                    valuePanel.add(ctf);
                }
                boolean shortLabel = parm.type == 'R' || String.valueOf(parm.deft).length() > 22;
                String fdeft = shortLabel ? "default" : String.valueOf(parm.deft);
                final String fvalue = String.valueOf(parm.deft);
                final JComponent ftf = ctf;
                JButton defaultButton = new JButton(new AbstractAction(fdeft){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ftf instanceof DataSetSelector) {
                            ((DataSetSelector)ftf).setValue(fvalue);
                        } else if (ftf instanceof JComboBox) {
                            JComboBox jcb = (JComboBox)ftf;
                            for (int i = 0; i < jcb.getItemCount(); ++i) {
                                if (!fvalue.equals(jcb.getItemAt(i).toString())) continue;
                                jcb.setSelectedIndex(i);
                            }
                        } else if (ftf instanceof JCheckBox) {
                            ((JCheckBox)ftf).setSelected(fvalue.equals("T"));
                        } else {
                            ((JTextField)ftf).setText(fvalue);
                        }
                    }
                });
                defaultButton.setToolTipText(shortLabel ? String.valueOf(parm.deft) : "Click to reset to default");
                valuePanel.add(defaultButton);
                valuePanel.add(this.getSpacer());
                valuePanel.setAlignmentX(0.0f);
                this.paramsPanel.add(valuePanel);
                this.tflist.add(ctf);
                this.paramsList.add(parm.name);
                this.deftsList.add(String.valueOf(parm.deft));
                this.typesList.add(Character.valueOf(parm.type));
            }
            boolean bl = hasVars = parms.size() > 0;
            if (!hasVars) {
                this.paramsPanel.add(new JLabel("<html><i>no input parameters</i></html>"));
            }
            this.paramsPanel.add(Box.createVerticalStrut(this.paramsPanel.getFont().getSize() * 2));
            this.paramsPanel.revalidate();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return hasVars;
    }

    private Map<String, String> getParamsFromGui() throws IllegalArgumentException {
        int j;
        URISplit split = URISplit.parse(this.suri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String param = (String)this.variableComboBox.getSelectedItem();
        int i = param.indexOf("<span");
        if (i == -1) {
            params.put("arg_0", param.trim());
        } else {
            j = param.startsWith("<html>") ? 6 : 0;
            params.put("arg_0", param.substring(j, i).trim());
        }
        for (j = 0; j < this.paramsList.size(); ++j) {
            URISplit ruriSplit;
            String value;
            String name = this.paramsList.get(j);
            JComponent jc = this.tflist.get(j);
            if (jc instanceof JTextField) {
                value = ((JTextField)jc).getText();
            } else if (jc instanceof DataSetSelector) {
                String blurredValue;
                value = ((DataSetSelector)jc).getValue();
                if (params.get("timerange") != null && (blurredValue = DataSetURI.blurTsbUri(value)) != null) {
                    value = blurredValue;
                }
            } else if (jc instanceof JComboBox) {
                value = String.valueOf(((JComboBox)jc).getSelectedItem());
            } else if (jc instanceof JCheckBox) {
                value = ((JCheckBox)jc).isSelected() ? "T" : "F";
            } else {
                throw new IllegalArgumentException("the code needs attention: component for " + name + " not supported ");
            }
            String deft = this.deftsList.get(j);
            char type = this.typesList.get(j).charValue();
            if (name.equals("timerange") || !value.equals(deft) || params.containsKey(name)) {
                if (type == 'A') {
                    value = value.replaceAll("'", "");
                    params.put(name, value);
                    continue;
                }
                if (type == 'R') {
                    ruriSplit = URISplit.parse(value);
                    if (!params.containsKey("script")) {
                        params.put("script", split.resourceUri.toString());
                        params.put("resourceURI", ruriSplit.resourceUri.toString());
                    }
                    split.resourceUri = ruriSplit.resourceUri;
                    split.scheme = ruriSplit.scheme;
                    split.authority = ruriSplit.authority;
                    split.path = ruriSplit.path;
                    split.file = ruriSplit.file;
                    if (split.vapScheme == null) {
                        split.vapScheme = "vap+jyds";
                    }
                    params.put("resourceURI", split.file);
                    continue;
                }
                params.put(name, value);
                continue;
            }
            if (type != 'R' || !value.equals(deft) || split.resourceUri != null && split.resourceUri.toString().equals(deft)) continue;
            ruriSplit = URISplit.parse(value);
            if (params.get("script") == null) {
                params.put("script", split.resourceUri.toString());
                params.put("resourceURI", ruriSplit.resourceUri.toString());
            }
            split.resourceUri = ruriSplit.resourceUri;
            split.scheme = ruriSplit.scheme;
            split.authority = ruriSplit.authority;
            split.path = ruriSplit.path;
            split.file = ruriSplit.file;
            if (split.vapScheme != null) continue;
            split.vapScheme = "vap+jyds";
        }
        return params;
    }

    private String[] getScriptURI(URISplit split) {
        String resourceUri1;
        String furi;
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        if (params.containsKey("script")) {
            furi = (String)params.get("script");
            resourceUri1 = split.resourceUri == null ? null : split.resourceUri.toString();
        } else {
            furi = split.resourceUri.toString();
            resourceUri1 = null;
        }
        return new String[]{furi, resourceUri1};
    }

    @Override
    public void setURI(String url) {
        try {
            File f;
            this.suri = url;
            URISplit split = URISplit.parse(this.suri);
            String[] furir = this.getScriptURI(split);
            this.file = f = DataSetURI.getFile(furir[0], (ProgressMonitor)new NullProgressMonitor());
            Map<String, String> results = JythonDataSourceFactory.getResultParameters(f.toString(), new NullProgressMonitor());
            String[] dropList = new String[results.size() + 1];
            int i = 0;
            int idx = -1;
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            String param = (String)params.remove("arg_0");
            dropList[0] = "";
            for (Map.Entry<String, String> ent : results.entrySet()) {
                dropList[i + 1] = "<html>" + ent.getKey() + "<span color=#808080>: <i>" + ent.getValue() + "</i></span>";
                if (param != null && param.equals(ent.getKey())) {
                    idx = i + 1;
                }
                ++i;
            }
            this.variableComboBox.setModel(new DefaultComboBoxModel<String>(dropList));
            if (idx >= 0) {
                this.variableComboBox.setSelectedIndex(idx);
            } else {
                this.variableComboBox.setSelectedIndex(0);
            }
            if (this.doDocumentation(f)) {
                this.paramsPanel.add(new JLabel("<html><br></html>"));
            }
            HashMap<String, String> ffparams = new HashMap<String, String>(params);
            if (furir[1] != null) {
                ffparams.put("resourceURI", furir[1]);
            }
            this.support.loadFile(f);
            if (FileSystemUtil.isChildOf(FileSystem.settings().getLocalCacheDir(), this.support.getFile()) || !this.support.getFile().canWrite()) {
                this.support.setReadOnly();
            }
            try {
                this.hasVariables = this.doVariables(f, ffparams);
            }
            catch (PyException e) {
                this.hasVariables = false;
                try {
                    this.support.annotateError(e, 0);
                }
                catch (BadLocationException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                this.paramsPanel.add(new JLabel("<html>Script contains errors.</html>"));
            }
            if (this.hasVariables) {
                this.tearoffTabbedPane1.setSelectedIndex(1);
            }
            ArrayList<String> errs = new ArrayList<String>();
            if (JythonUtil.pythonLint(f.toURI(), errs)) {
                EditorAnnotationsSupport esa = this.textArea.getEditorAnnotationsSupport();
                for (String s : errs) {
                    String[] ss = s.split(":", 2);
                    try {
                        String doc = ss[1];
                        doc = doc.replaceAll("<", "&lt;");
                        doc = doc.replaceAll(">", "&gt;");
                        esa.annotateLine(Integer.parseInt(ss[0]), "warning", "Variable name is already used before execution: " + doc + "<br>Consider using a different name");
                    }
                    catch (BadLocationException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private int lookupResultVariableIndex(String var) {
        for (int jj = 0; jj < this.variableComboBox.getItemCount(); ++jj) {
            int j;
            String it = (String)this.variableComboBox.getItemAt(jj);
            int i = it.indexOf("<span");
            if (i == -1) {
                if (!var.equals(it)) continue;
                return jj;
            }
            int n = j = it.startsWith("<html>") ? 6 : 0;
            if (!var.equals(it.substring(j, i).trim())) continue;
            return jj;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getURI() {
        if (this.support.isDirty() && this.support.getFile() != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.support.getFile());
                String text = this.textArea.getText();
                ((OutputStream)out).write(text.getBytes());
                this.support.setDirty(false);
            }
            catch (IOException text) {
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException text) {}
                }
            }
        }
        URISplit split = URISplit.parse(this.suri);
        Map<String, String> params = this.getParamsFromGui();
        if (split.resourceUri != null && params.get("resourceURI") != null) {
            try {
                split.resourceUri = new URI(params.remove("resourceURI"));
                split.file = split.resourceUri.toString();
                split.vapScheme = "vap+jyds";
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            logger.fine("bugfix code used to go through here and do something that appeared to be incorrect.");
        }
        if (this.support.isDirty()) {
            try (FileWriter writer = new FileWriter(this.support.getFile());){
                writer.write(this.textArea.getText());
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        try {
            JythonDataSourceTimeSeriesBrowse tsb1 = JythonDataSourceTimeSeriesBrowse.checkForTimeSeriesBrowse(this.suri, this.support.getFile());
            if (tsb1 == null) {
                params.remove("timerange");
                if ("".equals(params.get("arg_0"))) {
                    params.remove("arg_0");
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        split.params = params.isEmpty() ? null : URISplit.formatParams(params);
        String uri = URISplit.format(split);
        return uri;
    }

    @Override
    public boolean reject(String uri) throws Exception {
        URISplit split = URISplit.parse(uri);
        if (split.file == null || split.file.length() == 0 || split.file.equals("file:///")) {
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            return !params.containsKey("script");
        }
        return false;
    }

    @Override
    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse(uri);
        String[] furir = this.getScriptURI(split);
        DataSetURI.getFile(furir[0], mon);
        return true;
    }

    @Override
    public void markProblems(List<String> problems) {
    }
}

