/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.jython;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.datasource.jython.JythonDataSource;
import org.autoplot.jythonsupport.Util;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;

public class JythonDataSourceTimeSeriesBrowse
implements TimeSeriesBrowse {
    private static final Logger logger = Logger.getLogger("apdss.jyds");
    DatumRange timeRange;
    String uri;
    JythonDataSource jds;

    JythonDataSourceTimeSeriesBrowse(String uri) {
        this.uri = uri;
    }

    protected void setJythonDataSource(JythonDataSource jds) {
        this.jds = jds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeRange(DatumRange dr) {
        if (!(this.jds == null || this.timeRange != null && this.timeRange.equals(dr))) {
            JythonDataSource jythonDataSource = this.jds;
            synchronized (jythonDataSource) {
                if (this.jds.interp != null) {
                    logger.fine("TSB resetting interpretter and caching");
                    this.jds.interp = null;
                }
            }
        }
        this.timeRange = dr;
        URISplit split = URISplit.parse(this.uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        params.put("timerange", dr.toString());
        split.params = URISplit.formatParams(params);
        this.uri = URISplit.format(split);
    }

    @Override
    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    @Override
    public void setTimeResolution(Datum d) {
    }

    @Override
    public Datum getTimeResolution() {
        return null;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String blurURI() {
        URISplit split = URISplit.parse(this.uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        params.remove("timerange");
        split.params = URISplit.formatParams(params);
        return URISplit.format(split);
    }

    @Override
    public void setURI(String suri) throws ParseException {
        this.uri = suri;
        DatumRange tr = URISplit.parseTimeRange(this.uri);
        if (tr != null) {
            this.timeRange = tr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JythonDataSourceTimeSeriesBrowse checkForTimeSeriesBrowse(String uri, File jythonScript) throws IOException, ParseException {
        JythonDataSourceTimeSeriesBrowse tsb1 = null;
        try (BufferedReader reader = null;){
            reader = new LineNumberReader(new FileReader(jythonScript));
            String line = reader.readLine();
            Pattern s = Pattern.compile(".*getParam\\(\\s*\\'timerange\\',\\s*\\'([-0-9a-zA-Z:/]+)\\'\\s*(,\\s*\\'.*\\')?\\s*\\).*");
            while (line != null) {
                String[] ss = Util.guardedSplit(line, '#', '\'', '\"');
                Matcher m = s.matcher(line = ss[0]);
                if (m.matches()) {
                    tsb1 = new JythonDataSourceTimeSeriesBrowse(uri);
                    String str = m.group(1);
                    URISplit split = URISplit.parse(uri);
                    LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
                    String stimerange = (String)params.get("timerange");
                    if (stimerange != null && stimerange.length() > 0 && (str = (String)params.get("timerange")).startsWith("'") && str.endsWith("'") && str.length() > 1) {
                        str = str.substring(1, str.length() - 1);
                    }
                    DatumRange tr = DatumRangeUtil.parseTimeRange(str);
                    tsb1.setTimeRange(tr);
                } else if (line.contains("timerange") && line.contains("getParam(")) {
                    int i0 = line.indexOf("timerange");
                    int i1 = line.indexOf("getParam(");
                    if (i1 < 30 && i0 - i1 < 12) {
                        logger.log(Level.WARNING, "warning: getParam(''timerange'') default cannot contain spaces: {0}", line);
                    }
                }
                line = reader.readLine();
            }
        }
        return tsb1;
    }
}

