/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.jython;

import java.beans.ExceptionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.datasource.jython.JythonDataSource;
import org.autoplot.datasource.jython.JythonDataSourceTimeSeriesBrowse;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.PyQDataSet;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class JythonDataSourceFactory
extends AbstractDataSourceFactory {
    private static final Logger logger = Logger.getLogger("apdss.jyds");
    ExceptionListener listener;

    @Override
    public DataSource getDataSource(URI uri) throws Exception {
        JythonDataSource result = new JythonDataSource(uri, this);
        return result;
    }

    private static String getScript(String suri) {
        URISplit split = URISplit.parse(suri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String jythonScript = params.get("script") != null ? (String)params.get("script") : split.resourceUri.toString();
        return jythonScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getNames(URI uri, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> paramsl = URISplit.parseParams(split.params);
        InteractiveInterpreter interp = JythonUtil.createInterpreter(true);
        JythonUtil.setupInterp((PythonInterpreter)interp, split.path, split.resourceUri.toString(), paramsl, mon);
        File src = DataSetURI.getFile(uri, (ProgressMonitor)new NullProgressMonitor());
        try {
            mon.setLabel("Executing script to get names.");
            InputStream in = new FileInputStream(src);
            in = JythonRefactory.fixImports(in);
            interp.execfile(in, src.getName());
            PyStringMap map = (PyStringMap)interp.getLocals();
            PyList list = map.keys();
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (int i = 0; i < list.__len__(); ++i) {
                String key = (String)list.get(i);
                PyObject o = map.get((PyObject)Py.newString((String)key));
                if (!(o instanceof PyQDataSet)) continue;
                result.put(key, o);
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (!mon.isFinished()) {
                mon.finished();
            }
        }
    }

    protected static Map<String, JythonUtil.Param> getParams(String suri, Map<String, String> current, ProgressMonitor mon) throws IOException, PyException {
        String furi = JythonDataSourceFactory.getScript(suri);
        File src = DataSetURI.getFile(furi, mon);
        try (FileReader reader = new FileReader(src);){
            String script = JythonUtil.readScript(new BufferedReader(reader));
            List<JythonUtil.Param> r2 = JythonUtil.getGetParams(script, current);
            LinkedHashMap<String, JythonUtil.Param> result = new LinkedHashMap<String, JythonUtil.Param>();
            for (JythonUtil.Param r : r2) {
                result.put(r.name, r);
            }
            LinkedHashMap<String, JythonUtil.Param> linkedHashMap = result;
            return linkedHashMap;
        }
    }

    protected static Map<String, JythonUtil.Param> getParams(URI uri, Map<String, String> current, ProgressMonitor mon) throws IOException, PyException {
        return JythonDataSourceFactory.getParams(uri.toString(), current, mon);
    }

    protected static Map<String, JythonUtil.Param> getParams(URI uri, ProgressMonitor mon) throws IOException, PyException {
        return JythonDataSourceFactory.getParams(uri.toString(), new HashMap<String, String>(), mon);
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        Map<String, JythonUtil.Param> po2;
        JythonUtil.Param pp;
        String paramName;
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            String ext = DataSetURI.fromUri(cc.resourceURI);
            int i = ext.lastIndexOf(".");
            if (i != -1) {
                ext = ext.substring(i + 1);
            }
            if (ext.equals("jyds") || ext.equals("jy") || ext.equals("py")) {
                Map<String, Object> po = this.getNames(cc.resourceURI, mon);
                for (String n : po.keySet()) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, n, this, "arg_0", null, null));
                }
                Map<String, JythonUtil.Param> po22 = JythonDataSourceFactory.getParams(cc.resourceURI, new NullProgressMonitor());
                for (Map.Entry<String, JythonUtil.Param> e : po22.entrySet()) {
                    String n = e.getKey();
                    JythonUtil.Param parm = e.getValue();
                    if (parm.doc == null) {
                        parm.doc = "";
                    }
                    if (!parm.name.equals(parm.label)) {
                        parm.doc = parm.doc + " (named " + parm.label + " in the script)";
                    }
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, n + "=", n + " default is '" + po22.get((Object)n).deft + "'", po22.get((Object)n).doc));
                }
            } else {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "script=", "the name of the python script to run"));
            }
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE && !(paramName = CompletionContext.get(CompletionContext.CONTEXT_PARAMETER_NAME, cc)).equals("script") && (pp = (po2 = JythonDataSourceFactory.getParams(cc.resourceURI, new NullProgressMonitor())).get(paramName)) != null) {
            if (pp.deft instanceof Number) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, String.valueOf(pp.deft), paramName + " default is '" + pp.deft + "'", pp.doc));
            } else {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, String.format("'%s'", pp.deft), paramName + " default is '" + pp.deft + "'", pp.doc));
            }
        }
        return result;
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> uriParams = URISplit.parseParams(split.params);
        try {
            Map<String, JythonUtil.Param> parms = JythonDataSourceFactory.getParams(surl, new HashMap<String, String>(), mon);
            if (parms.containsKey("timerange") && !uriParams.containsKey("timerange")) {
                problems.add("no timerange provided");
                return true;
            }
        }
        catch (IOException | PyException ex) {
            String s = ex.toString();
            if (s.startsWith("Traceback (innermost last):\n  File \"<string>\", ")) {
                s = s.substring(47);
            }
            problems.add(s);
            return true;
        }
        if (surl.contains("?")) {
            return split.params.length() <= 0;
        }
        try {
            boolean haveResult;
            if (split.scheme != null && split.scheme.equals("inline")) {
                return false;
            }
            URL url = DataSetURI.getURL(surl);
            if (url == null) {
                return true;
            }
            File src = DataSetURI.getFile(url, (ProgressMonitor)new NullProgressMonitor());
            try (BufferedReader reader = new BufferedReader(new FileReader(src));){
                String s = reader.readLine();
                haveResult = false;
                while (s != null) {
                    if (s.trim().startsWith("result")) {
                        haveResult = true;
                        break;
                    }
                    if (s.trim().startsWith("data")) {
                        haveResult = true;
                        break;
                    }
                    s = reader.readLine();
                }
            }
            if (!haveResult) {
                problems.add("there must be a line that starts with \"data\" or \"result\"");
            }
            return !haveResult;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return true;
        }
    }

    protected static Map<String, String> getResultParameters(String surl, ProgressMonitor mon) throws IOException {
        LinkedHashMap<String, String> result;
        File src = DataSetURI.getFile(DataSetURI.getURL(surl), mon);
        try (BufferedReader reader = new BufferedReader(new FileReader(src));){
            String s = reader.readLine();
            Pattern assignPattern = Pattern.compile("\\s*([_a-zA-Z][_a-zA-Z0-9]*)\\s*=(.*)(#(.*))?");
            Pattern tuplePattern = Pattern.compile("\\s*\\(?\\s*([_a-zA-Z][_a-zA-Z0-9\\s*,\\s*]*)\\s*\\)?\\s*=(.*)(#(.*))?");
            Pattern defPattern = Pattern.compile("def .*");
            boolean inDef = false;
            result = new LinkedHashMap<String, String>();
            while (s != null) {
                Matcher defm;
                if (!inDef) {
                    defm = defPattern.matcher(s);
                    if (defm.matches()) {
                        inDef = true;
                    }
                } else if (s.length() > 0 && !Character.isWhitespace(s.charAt(0))) {
                    defm = defPattern.matcher(s);
                    inDef = defm.matches();
                }
                if (!inDef) {
                    Matcher m = assignPattern.matcher(s);
                    if (m.matches()) {
                        String rhs = m.group(2);
                        if (!rhs.contains("getParam(")) {
                            if (m.group(4) != null) {
                                result.put(m.group(1), m.group(4));
                            } else {
                                result.put(m.group(1), s);
                            }
                        }
                    } else {
                        m = tuplePattern.matcher(s);
                        if (m.matches()) {
                            String tuple = m.group(1);
                            String rhs = m.group(2);
                            if (!rhs.contains("getParam(")) {
                                String[] ss;
                                for (String s1 : ss = tuple.split(",")) {
                                    if (m.group(4) != null) {
                                        result.put(s1, m.group(4));
                                        continue;
                                    }
                                    result.put(s1, s);
                                }
                            }
                        }
                    }
                }
                s = reader.readLine();
            }
        }
        return result;
    }

    public void addExeceptionListener(ExceptionListener listener) {
        this.listener = listener;
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new JythonDataSourceTimeSeriesBrowse("file:///");
        }
        return super.getCapability(clazz);
    }

    public static boolean jydsHasLocalReferences(URI uri) {
        return true;
    }
}

