/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.jython;

import java.beans.ExceptionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.ReferenceCache;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.Caching;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.datasource.jython.JythonDataSourceFactory;
import org.autoplot.datasource.jython.JythonDataSourceTimeSeriesBrowse;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.PyQDataSet;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.CacheTag;
import org.das2.datum.DatumRangeUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.util.PythonInterpreter;

public class JythonDataSource
extends AbstractDataSource
implements Caching {
    ExceptionListener listener;
    private Map<String, Object> metadata;
    protected static final String PARAM_SCRIPT = "script";
    protected static final String PARAM_TIMERANGE = "timerange";
    protected static final String PARAM_RESOURCE_URI = "resourceURI";
    private static final Logger logger = LoggerManager.getLogger("apdss.jyds");
    private boolean notCheckedTsb = true;
    PythonInterpreter interp = null;
    TimeSeriesBrowse tsb = null;
    Date cacheDate = null;
    String cacheUrl = null;

    public JythonDataSource(URI uri, JythonDataSourceFactory factory) {
        super(uri);
        this.addCapability(Caching.class, this);
        this.listener = factory.listener;
        try {
            File jythonScript = this.getScript();
            JythonDataSourceTimeSeriesBrowse tsb1 = JythonDataSourceTimeSeriesBrowse.checkForTimeSeriesBrowse(uri.toString(), jythonScript);
            if (tsb1 != null) {
                tsb1.setJythonDataSource(this);
                this.addCapability(TimeSeriesBrowse.class, tsb1);
                this.tsb = tsb1;
                this.notCheckedTsb = false;
            }
        }
        catch (ParseException ex) {
            logger.severe(ex.toString());
        }
        catch (IOException ex) {
            logger.severe(ex.toString());
        }
    }

    private File getScript() throws IOException {
        File jythonScript = this.params.get(PARAM_SCRIPT) != null ? this.getFile(new URL((String)this.params.get(PARAM_SCRIPT)), (ProgressMonitor)new NullProgressMonitor()) : this.getFile(new NullProgressMonitor());
        return jythonScript;
    }

    private String nextExec(LineNumberReader reader, String[] nextLine) throws IOException {
        StringBuilder s;
        if (nextLine[0] != null) {
            s = new StringBuilder(nextLine[0]);
            nextLine[0] = null;
        } else {
            String ss = reader.readLine();
            if (ss == null) {
                ss = "";
            }
            s = new StringBuilder(ss);
        }
        String stest = s.toString();
        if (stest.startsWith("def ") || stest.startsWith("if") || stest.startsWith("else")) {
            String s1 = reader.readLine();
            while (s1 != null && (s1.length() == 0 || Character.isWhitespace(s1.charAt(0)))) {
                s.append("\n").append(s1);
                s1 = reader.readLine();
            }
            while (s1 != null && s1.startsWith("else")) {
                s.append("\n").append(s1);
                s1 = reader.readLine();
                while (s1 != null && (s1.length() == 0 || Character.isWhitespace(s1.charAt(0)))) {
                    s.append("\n").append(s1);
                    s1 = reader.readLine();
                }
            }
            nextLine[0] = s1;
        }
        return s.toString();
    }

    private synchronized QDataSet getInlineDataSet(URI uri) throws Exception {
        this.interp = JythonUtil.createInterpreter(false);
        PyObject result = this.interp.eval(uri.getRawSchemeSpecificPart());
        QDataSet res = result instanceof PyList ? JythonOps.dataset((PyObject)((PyList)result)) : (QDataSet)result.__tojava__(QDataSet.class);
        return res;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        block77: {
            block78: {
                mon.started();
                suri = DataSetURI.fromUri(this.uri);
                if (this.tsb != null) {
                    suri = this.tsb.getURI();
                }
                split = URISplit.parse(suri);
                paramsl = URISplit.parseParams(split.params);
                if (split.scheme.equals("inline")) {
                    return this.getInlineDataSet(new URI(this.uri.getRawSchemeSpecificPart()));
                }
                useReferenceCache = "true".equals(System.getProperty("enableReferenceCache", "false"));
                suri = URISplit.makeCanonical(suri);
                split1 = URISplit.parse(suri);
                params1 = URISplit.parseParams(split1.params);
                split1.params = URISplit.formatParams(params1);
                suri = URISplit.format(split1);
                params1.remove("arg_0");
                split1.params = URISplit.formatParams(params1);
                lockUri = URISplit.format(split1);
                rcent = null;
                if (!useReferenceCache) break block77;
                rcent = ReferenceCache.getInstance().getDataSetOrLock(lockUri, mon);
                if (rcent.shouldILoad(Thread.currentThread())) break block78;
                rcent.park(mon);
                entry = ReferenceCache.getInstance().getReferenceCacheEntry(suri);
                if (entry == null) ** GOTO lbl37
                result = ReferenceCache.getInstance().getDataSet(suri);
                if (result == null) {
                    JythonDataSource.logger.fine("garbage collector got the data before a non-weak reference could be made");
                    JythonDataSource.logger.log(Level.FINE, "miss {0}", suri);
                    rcent = null;
                    mon = new NullProgressMonitor();
                } else {
                    if (result == ReferenceCache.NULL) {
                        return null;
                    }
                    return result;
lbl37:
                    // 1 sources

                    JythonDataSource.logger.log(Level.FINE, "referenceCache doesn''t know the URI: {0}", suri);
                    rcent = null;
                    mon = new NullProgressMonitor();
                }
                break block77;
            }
            JythonDataSource.logger.log(Level.FINE, "reference cache in use, {0} is loading {1}", new Object[]{Thread.currentThread().toString(), this.resourceURI});
        }
        v0 = allowCaching = "F".equals(this.params.get("allowCaching")) == false;
        if (!allowCaching) {
            this.interp = null;
        }
        causedBy = null;
        try {
            if (this.params.get("script") != null) {
                jythonScript = this.getFile(new URL((String)this.params.get("script")), (ProgressMonitor)new NullProgressMonitor());
                mon.setProgressMessage("loading " + this.uri);
                split.params = null;
                lresourceURI = DataSetURI.fromUri(DataSetURI.getResourceURI(URISplit.format(split)));
            } else {
                lresourceURI = null;
                jythonScript = this.getFile(new NullProgressMonitor());
            }
            if (this.interp == null) {
                JythonDataSource.logger.log(Level.FINE, "running script {0} {1}", new Object[]{jythonScript, paramsl});
                mon.setProgressMessage("initialize Jython interpreter...");
                this.interp = JythonUtil.createInterpreter(false);
                mon.setProgressMessage("done initializing Jython interpreter");
                try {
                    this.interp.set("monitor", (Object)mon);
                }
                catch (ConcurrentModificationException ex) {
                    JythonDataSource.logger.warning("avoiding strange concurrent modification bug that occurs within Jython on the server...");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException var15_19) {
                        // empty catch block
                    }
                    this.interp.set("monitor", (Object)mon);
                    JythonDataSource.logger.warning("done.");
                }
                this.interp.set("PWD", (Object)split.path);
                this.interp.exec("import autoplot2017 as autoplot");
                this.interp.exec("autoplot.params=dict()");
                for (Map.Entry<K, V> e : paramsl.entrySet()) {
                    s = (String)e.getKey();
                    if (s.equals("arg_0") || s.equals("script")) continue;
                    sval = (String)e.getValue();
                    sval = JythonUtil.maybeQuoteString(sval);
                    JythonDataSource.logger.log(Level.FINE, "autoplot.params[''{0}'']={1}", new Object[]{s, sval});
                    this.interp.exec("autoplot.params['" + s + "']=" + sval);
                }
                if (lresourceURI != null) {
                    this.interp.set("resourceURI", (Object)lresourceURI);
                    this.interp.exec("autoplot.params['resourceURI']=" + JythonUtil.maybeQuoteString(lresourceURI));
                }
                mon.setProgressMessage("executing script");
                reader = null;
                try {
                    debug = false;
                    if (debug) {
                        fr = new FileReader(jythonScript);
                        reader = new LineNumberReader(fr);
                        nextLine = new String[1];
                        s = this.nextExec(reader, nextLine);
                        t0 = System.currentTimeMillis();
                        while (s != null) {
                            JythonDataSource.logger.log(Level.FINEST, "{0}: {1}", new Object[]{reader.getLineNumber(), s});
                            this.interp.exec(s);
                            JythonDataSource.logger.finest(String.format("line=%d time=%dms  %s\n", new Object[]{reader.getLineNumber(), System.currentTimeMillis() - t0, s}));
                            if (mon.isCancelled()) break;
                            mon.setProgressMessage("exec line " + reader.getLineNumber());
                            s = this.nextExec(reader, nextLine);
                            t0 = System.currentTimeMillis();
                        }
                        fr.close();
                    } else {
                        in = new FileInputStream(jythonScript);
                        try {
                            in = JythonRefactory.fixImports(in);
                            this.interp.execfile(in, jythonScript.getName());
                        }
                        catch (PyException ex) {
                            if (ex.toString().contains("checkForComodification")) {
                                in.close();
                                in = new FileInputStream(jythonScript);
                                JythonDataSource.logger.warning("avoiding second strange concurrent modification bug that occurs within Jython on the server.  Run the whole thing again.");
                                Thread.sleep(200L);
                                in = JythonRefactory.fixImports(in);
                                this.interp.execfile(in, jythonScript.getName());
                            }
                            throw ex;
                        }
                        in.close();
                    }
                    mon.setProgressMessage("done executing script");
                }
                catch (PyException ex) {
                    if (reader != null) {
                        JythonDataSource.logger.log(Level.FINE, "debugging line number={0}", reader.getLineNumber());
                    }
                    causedBy = ex;
                    javaClass = ex.value.__tojava__(Exception.class);
                    if (javaClass instanceof FileNotFoundException) {
                        throw (Exception)javaClass;
                    }
                    if (javaClass instanceof NoDataInIntervalException) {
                        throw (Exception)javaClass;
                    }
                    if (javaClass instanceof org.das2.CancelledOperationException) {
                        throw (Exception)javaClass;
                    }
                    if (javaClass instanceof CancelledOperationException) {
                        throw (Exception)javaClass;
                    }
                    JythonDataSource.logger.warning(ex.toString());
                    if (this.listener != null) {
                        this.listener.exceptionThrown((Exception)ex);
                    }
                }
                catch (Exception ex) {
                    throw ex;
                }
                if (causedBy == null && allowCaching) {
                    this.cacheDate = this.resourceDate(this.uri);
                    this.cacheUrl = this.cacheUrl(this.uri);
                }
            } else {
                JythonDataSource.logger.fine("using existing interpreter to provide caching");
            }
            expr = (String)this.params.get("arg_0");
            result = null;
            label = null;
            if (expr == null) {
                try {
                    result = this.interp.eval("result");
                }
                catch (PyException ex) {
                    try {
                        result = this.interp.eval("data");
                    }
                    catch (PyException ex2) {
                        if (causedBy != null) {
                            throw ex2;
                        }
                        throw new IllegalArgumentException("neither \"data\" nor \"result\" is defined");
                    }
                }
            } else {
                o = this.interp.get("outputParams");
                if (o != null && o instanceof PyDictionary) {
                    dict = (PyDictionary)o;
                    result = dict.get((PyObject)Py.newString((String)expr));
                }
                if (result == null || result == Py.None) {
                    result = this.interp.eval(expr);
                }
                label = expr;
            }
            this.metadata = new LinkedHashMap<String, Object>();
            try {
                pymeta = this.interp.eval("metadata");
                if (pymeta instanceof PyDictionary) {
                    dict = (PyDictionary)pymeta;
                    keys = dict.keys();
                    for (E key : keys) {
                        name = key.toString();
                        o = dict.get(Py.java2py(key));
                        if (o instanceof PyList) {
                            arr = new String[((PyList)o).__len__()];
                            for (i2 = 0; i2 < arr.length; ++i2) {
                                arr[i2] = ((PyList)o).__getitem__(i2).toString();
                            }
                            this.metadata.put(name, arr);
                            continue;
                        }
                        val = o.toString();
                        this.metadata.put(name, val);
                    }
                }
            }
            catch (PyException dict) {
                // empty catch block
            }
            res = result instanceof PyList != false ? JythonOps.dataset((PyObject)((PyList)result)) : (result instanceof PyArray != false ? JythonOps.dataset((PyObject)((PyArray)result)) : (result instanceof PyInteger != false ? JythonOps.dataset((PyObject)((PyInteger)result)) : (result instanceof PyFloat != false ? JythonOps.dataset((PyObject)((PyFloat)result)) : (QDataSet)result.__tojava__(QDataSet.class))));
            if (label != null && res instanceof MutablePropertyDataSet && res.property("LABEL") == null) {
                ((MutablePropertyDataSet)res).putProperty("LABEL", label);
            }
            if (this.notCheckedTsb) {
                tr = this.interp.eval("getParam('timerange','x')");
                tsb1 = JythonDataSourceTimeSeriesBrowse.checkForTimeSeriesBrowse(this.uri.toString(), jythonScript);
                if (tsb1 != null) {
                    tsb1.setJythonDataSource(this);
                    if (!tr.toString().equals("x")) {
                        tsb1.setTimeRange(DatumRangeUtil.parseTimeRange(tr.toString()));
                    }
                    this.addCapability(TimeSeriesBrowse.class, tsb1);
                    this.tsb = tsb1;
                }
                this.notCheckedTsb = false;
            }
            if (this.tsb != null && res != null && (dep0 = (QDataSet)res.property("DEPEND_0")) != null) {
                tag = (CacheTag)dep0.property("CACHE_TAG");
                if (tag == null) {
                    tag = new CacheTag(this.tsb.getTimeRange(), null);
                    mdep0 = DataSetOps.makePropertiesMutable(dep0);
                    mdep0.putProperty("CACHE_TAG", tag);
                    mres = DataSetOps.makePropertiesMutable(res);
                    mres.putProperty("DEPEND_0", mdep0);
                    res = mres;
                } else {
                    JythonDataSource.logger.log(Level.FINE, "result reports cache tag: {0}", tag);
                }
            }
            if (rcent != null) {
                t = URISplit.parse(suri);
                m = URISplit.parseParams(t.params);
                s = (String)m.remove("arg_0");
                locals = (PyStringMap)this.interp.getLocals();
                keys = locals.keys();
                values = locals.values();
                useOutputParams = false;
                o = this.interp.get("outputParams");
                if (o != null && o instanceof PyDictionary && ((PyDictionary)o).__len__() > 0) {
                    useOutputParams = true;
                }
                if (!useOutputParams) {
                    JythonDataSource.logger.fine("loading local datasets to cache");
                    for (i = 0; i < keys.size(); ++i) {
                        key = (String)keys.get(i);
                        value = values.get(i);
                        if (value instanceof PyQDataSet) {
                            value = ((PyQDataSet)value).getQDataSet();
                        }
                        if (!(value instanceof QDataSet) && value != null) continue;
                        m.put("arg_0", String.valueOf(key));
                        t.params = URISplit.formatParams(m);
                        uri1 = URISplit.makeCanonical(URISplit.format(t));
                        ReferenceCache.getInstance().offerDataSet(uri1, (QDataSet)value);
                        JythonDataSource.logger.log(Level.FINE, "Also adding to reference cache: {0}->{1}", new Object[]{uri1, value});
                    }
                } else {
                    JythonDataSource.logger.fine("loading output params to cache");
                    dict = (PyDictionary)o;
                    if (!JythonDataSource.$assertionsDisabled && dict == null) {
                        throw new AssertionError();
                    }
                    keys = dict.keys();
                    for (i = 0; i < keys.size(); ++i) {
                        key = (String)keys.get(i);
                        value /* !! */  = dict.get((PyObject)Py.newString((String)key));
                        if (value /* !! */  instanceof PyQDataSet) {
                            value /* !! */  = ((PyQDataSet)value /* !! */ ).getQDataSet();
                        }
                        if (!(value /* !! */  instanceof QDataSet) && value /* !! */  != null) continue;
                        m.put("arg_0", String.valueOf(key));
                        t.params = URISplit.formatParams(m);
                        uri1 = URISplit.makeCanonical(URISplit.format(t));
                        ReferenceCache.getInstance().offerDataSet(uri1, (QDataSet)value /* !! */ );
                        JythonDataSource.logger.log(Level.FINE, "Also adding to reference cache: {0}->{1}", new Object[]{uri1, value /* !! */ });
                    }
                }
                if (s == null) {
                    rcent.finished(res);
                } else {
                    rcent.finished(Ops.dataset("1971-01-01T00:00"));
                }
            }
            if (causedBy != null) {
                this.interp = null;
                this.cacheUrl = null;
                this.cacheDate = null;
                JythonDataSource.logger.log(Level.WARNING, "exception in processing: {0}", causedBy);
                throw causedBy;
            }
            if (!allowCaching) {
                JythonDataSource.logger.log(Level.FINE, "reset caching because allowCaching is false");
                this.interp = null;
            }
            var19_37 = res;
            return var19_37;
        }
        catch (PyException ex) {
            if (rcent != null) {
                rcent.exception((Exception)ex);
            }
            if (causedBy != null) {
                JythonDataSource.logger.log(Level.FINE, "rethrow causedBy");
                throw causedBy;
            }
            JythonDataSource.logger.log(Level.FINE, "resetting caching because of PyException");
            this.interp = null;
            this.cacheUrl = null;
            this.cacheDate = null;
            throw ex;
        }
        catch (Exception ex) {
            if (rcent != null) {
                rcent.exception(ex);
            }
            throw ex;
        }
        finally {
            if (!mon.isFinished()) {
                mon.finished();
            }
        }
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        return this.metadata;
    }

    private String cacheUrl(URI uri) {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> params2 = URISplit.parseParams(split.params);
        params2.remove("arg_0");
        split.params = URISplit.formatParams(params2);
        return URISplit.format(split);
    }

    private Date resourceDate(URI uri) throws IOException {
        File src = DataSetURI.getFile(uri.toString(), true, new NullProgressMonitor());
        return new Date(src.lastModified());
    }

    private synchronized boolean useCache(URI uri) {
        try {
            if (this.cacheDate != null && !this.resourceDate(uri).after(this.cacheDate) && this.cacheUrl != null && this.cacheUrl.equals(this.cacheUrl(uri))) {
                return !uri.toString().contains("allowCaching=F");
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean satisfies(String surl) {
        URISplit split = URISplit.parse(surl);
        if (!"vap+jyds".equals(split.vapScheme)) {
            return false;
        }
        try {
            return this.useCache(DataSetURI.getURI(surl));
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    @Override
    public void resetURI(String surl) {
        try {
            this.uri = DataSetURI.getURI(surl);
            URISplit split = URISplit.parse(this.uri);
            this.params = URISplit.parseParams(split.params);
            this.resourceURI = DataSetURI.toUri(split.file);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public synchronized void reset() {
        logger.fine("JythonDataSource.reset() clears cache");
        this.interp = null;
    }
}

