/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.components.DasProgressPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public class TimeRangeToolEventsList
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger("apdss.gui");
    DataSource dss = null;
    QDataSet currentDataSet = null;
    TimeSeriesBrowse tsb = null;
    boolean hasIcons = false;
    TableCellRenderer tableCellRenderer = new TableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            QDataSet rec;
            boolean nextPreviousItem;
            Color foreground;
            Color background;
            JLabel result = new JLabel(String.valueOf(value));
            int index = row;
            result.setIcon(null);
            if (isSelected) {
                background = TimeRangeToolEventsList.this.jTable1.getSelectionBackground();
                foreground = TimeRangeToolEventsList.this.jTable1.getSelectionForeground();
            } else {
                background = TimeRangeToolEventsList.this.jTable1.getBackground();
                foreground = TimeRangeToolEventsList.this.jTable1.getForeground();
            }
            result.setOpaque(true);
            result.setForeground(foreground);
            result.setBackground(background);
            if (TimeRangeToolEventsList.this.currentDataSet == null) {
                return result;
            }
            boolean bl = nextPreviousItem = TimeRangeToolEventsList.this.tsb != null && (index == 0 || index == TimeRangeToolEventsList.this.currentDataSet.length() + 1);
            if (nextPreviousItem) {
                return result;
            }
            try {
                rec = TimeRangeToolEventsList.this.tsb == null ? TimeRangeToolEventsList.this.currentDataSet.slice(index) : TimeRangeToolEventsList.this.currentDataSet.slice(index - 1);
            }
            catch (IndexOutOfBoundsException ex) {
                return result;
            }
            QDataSet bds = (QDataSet)TimeRangeToolEventsList.this.currentDataSet.property("BUNDLE_1");
            Units eu = (Units)bds.property("UNITS", 3);
            String s = eu.createDatum(rec.value(3)).toString();
            if (column == 0) {
                result.setText(String.valueOf(value));
            } else {
                result.setText(s);
            }
            if (TimeRangeToolEventsList.this.hasIcons && column == 0) {
                int color = (int)rec.value(2);
                Icon icon = TimeRangeToolEventsList.colorIcon(new Color(color), 12, 12);
                result.setIcon(icon);
            }
            return result;
        }
    };
    private DataSetSelector currentDataSetSelector;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JButton nextButton;
    private JButton prevButton;
    private JComboBox rescaleComboBox;
    private JButton timeRangeButton;
    private JTextField timeRangeTF;

    public TimeRangeToolEventsList() {
        this.initComponents();
        this.fillList();
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    logger.finest("value is adjusting");
                } else {
                    ListSelectionModel lsm = TimeRangeToolEventsList.this.jTable1.getSelectionModel();
                    if (TimeRangeToolEventsList.this.tsb != null) {
                        if (lsm.getMinSelectionIndex() == 0) {
                            TimeRangeToolEventsList.this.loadTsb(-1);
                        } else if (lsm.getMaxSelectionIndex() == TimeRangeToolEventsList.this.jTable1.getRowCount() - 1) {
                            TimeRangeToolEventsList.this.loadTsb(1);
                        }
                    }
                    TimeRangeToolEventsList.this.fireTableSelection();
                    Rectangle r = TimeRangeToolEventsList.this.jTable1.getCellRect(lsm.getMinSelectionIndex(), 0, false);
                    r = r.union(TimeRangeToolEventsList.this.jTable1.getCellRect(lsm.getMaxSelectionIndex(), 0, false));
                    if (r != null) {
                        TimeRangeToolEventsList.this.jTable1.scrollRectToVisible(r);
                    }
                }
            }
        });
    }

    public DataSetSelector getDataSetSelector() {
        return this.currentDataSetSelector;
    }

    private DatumRange getRange(int i) {
        QDataSet ds1 = this.currentDataSet.slice(i).trim(0, 2);
        Units tu = (Units)((QDataSet)this.currentDataSet.property("BUNDLE_1")).property("UNITS", 0);
        if (ds1.value(0) < ds1.value(1)) {
            return DatumRange.newDatumRange(ds1.value(0), ds1.value(1), tu);
        }
        logger.log(Level.INFO, "start and stop times are out-of-order at index {0}", i);
        return DatumRange.newDatumRange(ds1.value(1), ds1.value(0), tu);
    }

    private void fillWithEmpty(DefaultTableModel tm) {
        for (int i = 0; i < tm.getRowCount(); ++i) {
            for (int j = 0; j < tm.getColumnCount(); ++j) {
                tm.setValueAt("", i, j);
            }
        }
    }

    private void fillList() {
        DefaultTableModel tm;
        if (this.currentDataSet == null) {
            tm = new DefaultTableModel(new String[]{"Range", "Label"}, 3);
            this.fillWithEmpty(tm);
            if (this.tsb == null) {
                tm.setValueAt("(no intervals loaded)", 0, 0);
            } else {
                tm.setValueAt("Load Previous Set...", 0, 0);
                tm.setValueAt("(" + this.tsb.getTimeRange() + " contains no intervals)", 1, 0);
                tm.setValueAt("Load Next Set...", 2, 0);
            }
        } else {
            int offset = this.tsb == null ? 0 : 1;
            tm = new DefaultTableModel(new String[]{"Range", "Label"}, this.currentDataSet.length() + offset * 2);
            if (this.tsb != null) {
                tm.setValueAt("Load Previous Set...", 0, 0);
                tm.setValueAt("", 0, 1);
            }
            QDataSet bds = (QDataSet)this.currentDataSet.property("BUNDLE_1");
            Units eu = (Units)bds.property("UNITS", 3);
            for (int i = 0; i < this.currentDataSet.length(); ++i) {
                tm.setValueAt(this.getRange(i).toString(), i + offset, 0);
                String s = eu.createDatum(this.currentDataSet.slice(i).value(3)).toString();
                tm.setValueAt(s, i + offset, 1);
            }
            if (this.tsb != null) {
                tm.setValueAt("Load Next Set...", this.currentDataSet.length() + 1, 0);
                tm.setValueAt("", this.currentDataSet.length() + 1, 1);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimeRangeToolEventsList.this.jTable1.setModel(tm);
                TimeRangeToolEventsList.this.jTable1.setDefaultRenderer(Object.class, TimeRangeToolEventsList.this.tableCellRenderer);
            }
        });
    }

    private static Icon colorIcon(Color iconColor, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.setColor(new Color(iconColor.getRed(), iconColor.getGreen(), iconColor.getBlue(), 140));
        g.fillRect(0, 0, w, h);
        return new ImageIcon(image);
    }

    public static QDataSet makeCanonical(QDataSet vds) {
        return Ops.createEvents(vds);
    }

    private void initComponents() {
        this.rescaleComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.currentDataSetSelector = new DataSetSelector();
        this.timeRangeTF = new JTextField();
        this.timeRangeButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.rescaleComboBox.setEditable(true);
        this.rescaleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "-5%,105%", "-10%,110%", "-100%,200%", "-300%,400%"}));
        this.rescaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeToolEventsList.this.rescaleComboBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Rescale:");
        this.jLabel1.setToolTipText("Expand the interval range");
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/prevPrev.png")));
        this.prevButton.setToolTipText("Previous Interval");
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeToolEventsList.this.prevButtonActionPerformed(evt);
            }
        });
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/nextNext.png")));
        this.nextButton.setToolTipText("Next Interval");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeToolEventsList.this.nextButtonActionPerformed(evt);
            }
        });
        this.currentDataSetSelector.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TimeRangeToolEventsList.this.currentDataSetSelectorFocusGained(evt);
            }
        });
        this.currentDataSetSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeToolEventsList.this.currentDataSetSelectorActionPerformed(evt);
            }
        });
        this.timeRangeTF.setText(" ");
        this.timeRangeTF.setToolTipText("Load events from the given timerange");
        this.timeRangeTF.setEnabled(false);
        this.timeRangeTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeToolEventsList.this.timeRangeTFActionPerformed(evt);
            }
        });
        this.timeRangeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/calendar.png")));
        this.timeRangeButton.setToolTipText("Time Range Tool for setting the interval range");
        this.timeRangeButton.setEnabled(false);
        this.timeRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeRangeToolEventsList.this.timeRangeButtonActionPerformed(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TimeRangeToolEventsList.this.jTable1FocusLost(evt);
            }
        });
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TimeRangeToolEventsList.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTable1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rescaleComboBox, -2, 137, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prevButton, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.timeRangeTF, -2, 196, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeRangeButton).addContainerGap()).addComponent(this.currentDataSetSelector, -1, 573, Short.MAX_VALUE).addComponent(this.jScrollPane2));
        layout.linkSize(0, this.nextButton, this.prevButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.currentDataSetSelector, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.prevButton, -2, 27, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rescaleComboBox, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.nextButton).addComponent(this.timeRangeTF, -2, -1, -2).addComponent(this.timeRangeButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 270, Short.MAX_VALUE).addContainerGap()));
        layout.linkSize(1, this.nextButton, this.prevButton);
    }

    public void addDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.add(DataRangeSelectionListener.class, listener);
    }

    public void removeDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.remove(DataRangeSelectionListener.class, listener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataRangeSelectionListener.class) continue;
            ((DataRangeSelectionListener)listeners[i + 1]).dataRangeSelected(event);
        }
    }

    private void fireTableSelection() {
        int i1 = this.jTable1.getSelectionModel().getMinSelectionIndex();
        int i2 = this.jTable1.getSelectionModel().getMaxSelectionIndex();
        if (this.currentDataSet == null) {
            return;
        }
        DatumRange fire = null;
        String rescale = (String)this.rescaleComboBox.getSelectedItem();
        for (int i = i1; i <= i2; ++i) {
            int isel;
            if (!this.jTable1.getSelectionModel().isSelectedIndex(i)) continue;
            int n = isel = this.tsb != null ? i - 1 : i;
            if (isel < 0 || this.currentDataSet != null && isel >= this.currentDataSet.length()) continue;
            fire = fire == null ? this.getRange(isel) : DatumRangeUtil.union(fire, this.getRange(isel));
        }
        if (fire == null) {
            return;
        }
        if (UnitsUtil.isNominalMeasurement(fire.getUnits())) {
            return;
        }
        if (fire.width().value() == 0.0) {
            logger.fine("zero width.");
            Units tu = UnitsUtil.isTimeLocation(fire.min().getUnits()) ? Units.seconds : fire.min().getUnits().getOffsetUnits();
            fire = new DatumRange(fire.min().subtract(1.0, tu), fire.min().add(1.0, tu));
        }
        if (this.rescaleComboBox.getSelectedIndex() > 0) {
            try {
                fire = DatumRangeUtil.rescale(fire, rescale);
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        this.fireDataRangeSelectionListenerDataRangeSelected(new DataRangeSelectionEvent(this, fire.min(), fire.max()));
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        int i0 = this.jTable1.getSelectionModel().getMinSelectionIndex();
        int i1 = this.jTable1.getSelectionModel().getMaxSelectionIndex();
        if (i0 == -1) {
            i0 = 0;
            i1 = 0;
        }
        int de = i1 - i0 + 1;
        i0 = Math.max(0, i0 - 1);
        i1 = i0 + de - 1;
        this.jTable1.getSelectionModel().setSelectionInterval(i0, i1);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        int i0 = this.jTable1.getSelectionModel().getMinSelectionIndex();
        int i1 = this.jTable1.getSelectionModel().getMaxSelectionIndex();
        if (i0 == -1) {
            i0 = 0;
            i1 = 0;
        }
        int de = i1 - i0 + 1;
        i1 = Math.min(this.jTable1.getRowCount() - 1, i1 + 1);
        i0 = i1 - de + 1;
        int[] indexes = new int[de];
        for (int i = i0; i <= i1; ++i) {
            indexes[i - i0] = i;
        }
        this.jTable1.getSelectionModel().setSelectionInterval(i0, i1);
    }

    private void rescaleComboBoxActionPerformed(ActionEvent evt) {
        this.fireTableSelection();
    }

    private void loadTsb(final int dir) {
        this.jTable1.setEnabled(false);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    DatumRange current = TimeRangeToolEventsList.this.tsb.getTimeRange();
                    current = dir == -1 ? current.previous() : current.next();
                    TimeRangeToolEventsList.this.loadViaTsb(current, dir);
                }
                finally {
                    TimeRangeToolEventsList.this.jTable1.setEnabled(true);
                }
            }
        };
        new Thread(run).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadViaTsb(DatumRange range, int dir) {
        int i;
        this.tsb.setTimeRange(range);
        DasProgressPanel mon = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(this), "Loading Events File...");
        try {
            QDataSet currentDataSet1 = this.dss.getDataSet(mon);
            currentDataSet1 = TimeRangeToolEventsList.makeCanonical(currentDataSet1);
            this.currentDataSet = SemanticOps.trim(currentDataSet1, range, null);
            if (!mon.isFinished()) {
                mon.finished();
            }
            this.fillList();
            i = dir == -1 ? this.jTable1.getRowCount() - 2 : (dir == 1 ? 1 : -1);
        }
        catch (Exception ex) {
            int i2;
            try {
                this.currentDataSet = null;
                if (!mon.isFinished()) {
                    mon.finished();
                }
                this.fillList();
                i2 = dir == -1 ? this.jTable1.getRowCount() - 2 : (dir == 1 ? 1 : -1);
            }
            catch (Throwable throwable) {
                if (!mon.isFinished()) {
                    mon.finished();
                }
                this.fillList();
                int i3 = dir == -1 ? this.jTable1.getRowCount() - 2 : (dir == 1 ? 1 : -1);
                Runnable run = new Runnable(i3, range){
                    final /* synthetic */ int val$i;
                    final /* synthetic */ DatumRange val$range;
                    {
                        this.val$i = n;
                        this.val$range = datumRange;
                    }

                    @Override
                    public void run() {
                        if (this.val$i > 0) {
                            TimeRangeToolEventsList.this.jTable1.getSelectionModel().setSelectionInterval(this.val$i, this.val$i);
                            TimeRangeToolEventsList.this.jTable1.setEnabled(true);
                        }
                        TimeRangeToolEventsList.this.timeRangeTF.setText(this.val$range.toString());
                    }
                };
                SwingUtilities.invokeLater(run);
                throw throwable;
            }
            Runnable run = new /* invalid duplicate definition of identical inner class */;
            SwingUtilities.invokeLater(run);
        }
        Runnable run = new /* invalid duplicate definition of identical inner class */;
        SwingUtilities.invokeLater(run);
    }

    private void currentDataSetSelectorActionPerformed(ActionEvent evt) {
        final String uri = this.currentDataSetSelector.getValue();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DasProgressPanel mon = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(TimeRangeToolEventsList.this), "Loading Events File...");
                try {
                    DataSource dsource;
                    TimeRangeToolEventsList.this.tsb = null;
                    TimeRangeToolEventsList.this.dss = dsource = DataSetURI.getDataSource(uri);
                    QDataSet currentDataSet1 = TimeRangeToolEventsList.this.dss.getDataSet(mon);
                    TimeRangeToolEventsList.this.tsb = dsource.getCapability(TimeSeriesBrowse.class);
                    if (TimeRangeToolEventsList.this.tsb != null) {
                        TimeRangeToolEventsList.this.timeRangeTF.setText(TimeRangeToolEventsList.this.tsb.getTimeRange().toString());
                        TimeRangeToolEventsList.this.timeRangeTF.setEnabled(true);
                        TimeRangeToolEventsList.this.timeRangeButton.setEnabled(true);
                    } else {
                        TimeRangeToolEventsList.this.timeRangeTF.setText("");
                        TimeRangeToolEventsList.this.timeRangeTF.setEnabled(false);
                        TimeRangeToolEventsList.this.timeRangeButton.setEnabled(false);
                    }
                    currentDataSet1 = TimeRangeToolEventsList.makeCanonical(currentDataSet1);
                    if (TimeRangeToolEventsList.this.tsb != null) {
                        currentDataSet1 = SemanticOps.trim(currentDataSet1, TimeRangeToolEventsList.this.tsb.getTimeRange(), null);
                    }
                    TimeRangeToolEventsList.this.currentDataSet = currentDataSet1;
                    TimeRangeToolEventsList.this.hasIcons = false;
                    if (TimeRangeToolEventsList.this.currentDataSet.length() > 0) {
                        double color0 = TimeRangeToolEventsList.this.currentDataSet.value(0, 2);
                        for (int i = 0; i < TimeRangeToolEventsList.this.currentDataSet.length(); ++i) {
                            if (TimeRangeToolEventsList.this.currentDataSet.value(i, 2) == color0) continue;
                            TimeRangeToolEventsList.this.hasIcons = true;
                        }
                    }
                    TimeRangeToolEventsList.this.fillList();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    TimeRangeToolEventsList.this.currentDataSetSelector.setEnabled(true);
                    if (!mon.isFinished()) {
                        mon.finished();
                    }
                }
            }
        };
        this.currentDataSetSelector.setEnabled(false);
        new Thread(run).start();
    }

    private void timeRangeButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        TimeRangeTool tt = new TimeRangeTool();
        JTextField tf = this.timeRangeTF;
        tt.setSelectedRange(tf.getText());
        int r = JOptionPane.showConfirmDialog(this, tt, "Select Time Range", 2);
        if (r == 0) {
            tf.setText(tt.getSelectedRange());
            String str = this.timeRangeTF.getText();
            final DatumRange drtr = DatumRangeUtil.parseTimeRangeValid(str);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    TimeRangeToolEventsList.this.loadViaTsb(drtr, 0);
                }
            };
            new Thread(run).start();
        }
    }

    private void timeRangeTFActionPerformed(ActionEvent evt) {
        try {
            String str = this.timeRangeTF.getText();
            final DatumRange drtr = DatumRangeUtil.parseTimeRange(str);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    TimeRangeToolEventsList.this.loadViaTsb(drtr, 0);
                }
            };
            new Thread(run).start();
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void jTable1MouseClicked(MouseEvent evt) {
    }

    private void jTable1FocusLost(FocusEvent evt) {
    }

    private void currentDataSetSelectorFocusGained(FocusEvent evt) {
    }
}

