/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSourceRegistry;
import org.jdesktop.layout.GroupLayout;

public class SourceTypesBrowser
extends JPanel {
    List<String> types;
    private DataSetSelector dataSetSelector1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JComboBox sourceTypesComboBox;

    public SourceTypesBrowser() {
        this.initComponents();
        this.initTypes();
        this.dataSetSelector1.setHidePlayButton(true);
        this.dataSetSelector1.setDisableDataSources(true);
    }

    public DataSetSelector getDataSetSelector() {
        return this.dataSetSelector1;
    }

    private static String getDescriptionFor(String ext) {
        if (ext.equals("dat") || ext.equals("txt")) {
            return "Ascii table";
        }
        if (ext.equals("csv")) {
            return "Comma Separated Values Ascii Table";
        }
        if (ext.equals("cdf")) {
            return "NASA Common Data Format";
        }
        if (ext.equals("cdfj")) {
            return "NASA Common Data Format (Java reader)";
        }
        if (ext.equals("cdaweb")) {
            return "NASA CDAWeb database";
        }
        if (ext.equals("nc") || ext.equals("ncml")) {
            return "NetCDF";
        }
        if (ext.equals("h5") || ext.equals("hdf5")) {
            return "HDF5 data model file";
        }
        if (ext.equals("jyds")) {
            return "Autoplot Jython Script";
        }
        if (ext.equals("inline")) {
            return "Array literals and Jython code defining datasets";
        }
        if (ext.equals("htm")) {
            return "Tables within HTML files";
        }
        return "";
    }

    private void initTypes() {
        int i;
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        List<CompletionContext> cc = DataSourceRegistry.getPlugins();
        this.types = new ArrayList<String>(cc.size());
        for (i = 0; i < cc.size(); ++i) {
            String label = cc.get((int)i).completable;
            String desc = SourceTypesBrowser.getDescriptionFor(label = label.substring(4, label.length() - 1));
            if (!desc.equals("")) {
                label = label + ": " + desc;
            }
            this.types.add(i, label);
        }
        Collections.sort(this.types);
        for (i = 0; i < this.types.size(); ++i) {
            model.insertElementAt(this.types.get(i), i);
        }
        this.sourceTypesComboBox.setModel(model);
    }

    private void initComponents() {
        this.sourceTypesComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.dataSetSelector1 = new DataSetSelector();
        this.jLabel3 = new JLabel();
        this.sourceTypesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel1.setText("Select Data Source Type:");
        this.jLabel2.setText("Select File:");
        this.jLabel3.setText("<html>Autoplot has data source plugins that are used to read in data, and the plug-in can not be identified from the file extention.  Select the data source type for the file.  ");
        this.jLabel3.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3, -2, 0, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.dataSetSelector1, -1, 555, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(0, 0, Short.MAX_VALUE)).add(2, (Component)this.sourceTypesComboBox, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(15, 15, 15).add((Component)this.jLabel3, -2, 62, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.sourceTypesComboBox, -2, -1, -2).add(20, 20, 20).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.dataSetSelector1, -2, -1, -2).addContainerGap(109, Short.MAX_VALUE)));
    }

    public String getUri() {
        if (this.sourceTypesComboBox.getSelectedIndex() == -1) {
            return this.dataSetSelector1.getValue();
        }
        String s = this.types.get(this.sourceTypesComboBox.getSelectedIndex());
        int i = s.indexOf(58);
        if (i > -1) {
            s = s.substring(0, i);
        }
        return "vap+" + s + ":" + this.dataSetSelector1.getValue();
    }
}

