/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class ReferenceCache {
    public static final String PROP_ENABLE_REFERENCE_CACHE = "enableReferenceCache";
    private static final Logger logger = LoggerManager.getLogger("apdss.refcache");
    private static ReferenceCache instance;
    private final Map<String, ReferenceCacheEntry> uris = new LinkedHashMap<String, ReferenceCacheEntry>();
    private final Map<String, ProgressMonitor> locks = new LinkedHashMap<String, ProgressMonitor>();
    public static final QDataSet NULL;
    Map<String, QDataSet> strongReferences = new HashMap<String, QDataSet>();

    private ReferenceCache() {
    }

    public static synchronized ReferenceCache getInstance() {
        if (instance == null) {
            instance = new ReferenceCache();
        }
        return instance;
    }

    public synchronized ReferenceCacheEntry getReferenceCacheEntry(String uri) {
        ReferenceCacheEntry entry = this.uris.get(uri);
        return entry;
    }

    public synchronized QDataSet getDataSet(String uri) {
        ReferenceCacheEntry entry = this.uris.get(uri);
        if (entry == null) {
            logger.log(Level.FINER, "getDataSet {0} -> no entry", uri);
            return null;
        }
        if (entry.qds == null) {
            logger.log(Level.FINER, "getDataSet {0} -> no entry.qds==null", uri);
            return null;
        }
        QDataSet result = (QDataSet)entry.qds.get();
        logger.log(Level.FINER, "getDataSet {0} -> entry.qds.get()=={1}", new Object[]{uri, result});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceCacheEntry getDataSetOrLock(String uri, ProgressMonitor monitor) {
        ReferenceCacheEntry result;
        this.tidy();
        if (monitor.isFinished()) {
            throw new IllegalStateException("Finished monitor was sent to reference cache getDataSetOrLock");
        }
        logger.log(Level.FINE, "getDataSetOrLock on thread {0} {1}", new Object[]{Thread.currentThread(), uri});
        ReferenceCache referenceCache = this;
        synchronized (referenceCache) {
            result = this.uris.get(uri);
            if (result != null) {
                if (result.wasGarbageCollected()) {
                    result = new ReferenceCacheEntry(uri, monitor);
                    result.status = ReferenceCacheEntryStatus.LOADING;
                    result.loadThread = Thread.currentThread();
                    this.uris.put(uri, result);
                    logger.log(Level.FINEST, "this thread must reload garbage-collected uri");
                } else {
                    logger.log(Level.FINEST, "wait for another thread which is loading uri");
                    if (result.monitor.isFinished() && result.status != ReferenceCacheEntryStatus.DONE) {
                        logger.log(Level.WARNING, "cache entry was never cleared: {0}", result.uri);
                    }
                }
            } else {
                result = new ReferenceCacheEntry(uri, monitor);
                result.status = ReferenceCacheEntryStatus.LOADING;
                result.loadThread = Thread.currentThread();
                this.uris.put(uri, result);
                logger.log(Level.FINEST, "this thread will load uri");
            }
        }
        return result;
    }

    public void park(ReferenceCacheEntry ent, ProgressMonitor monitor) {
        if (ent.loadThread == Thread.currentThread() && ent.status != ReferenceCacheEntryStatus.DONE) {
            throw new IllegalStateException("This thread was supposed to load the data");
        }
        if (monitor.isFinished()) {
            throw new IllegalStateException("Finished monitor was sent to reference cache park");
        }
        monitor.started();
        monitor.setProgressMessage("waiting for load");
        int warn1095Count = 0;
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (!ent.monitor.isFinished() && !ent.monitor.isCancelled()) {
                monitor.setTaskSize(ent.monitor.getTaskSize());
                monitor.setTaskProgress(ent.monitor.getTaskProgress());
            }
            if (!ent.monitor.isFinished() || ent.status == ReferenceCacheEntryStatus.DONE) continue;
            if (warn1095Count > 100) {
                logger.warning("bug 1095: there is a monitor that is finished, but the reference cache entry is not marked as done.");
            }
            ++warn1095Count;
        } while (ent.status != ReferenceCacheEntryStatus.DONE);
        monitor.finished();
    }

    private synchronized void putDataSet(String uri, QDataSet ds) {
        ReferenceCacheEntry result = this.uris.get(uri);
        if (result == null) {
            throw new IllegalStateException("nobody asked for this dataset, use offerDataSet");
        }
        logger.log(Level.FINEST, "putDataSet on thread {0} {1}", new Object[]{Thread.currentThread(), uri});
        if (ds instanceof MutablePropertyDataSet) {
            MutablePropertyDataSet mpds = (MutablePropertyDataSet)ds;
            if (!mpds.isImmutable()) {
                ds = Ops.copy(mpds);
                ((MutablePropertyDataSet)ds).makeImmutable();
            }
        } else if (ds == null) {
            ds = NULL;
        }
        result.qds = new WeakReference<QDataSet>(ds);
        result.status = ReferenceCacheEntryStatus.DONE;
    }

    public synchronized void offerDataSet(String uri, QDataSet ds) {
        logger.log(Level.FINE, "offerDataSet {0} {1}", new Object[]{uri, ds});
        ReferenceCacheEntry result = this.uris.get(uri);
        if (result == null) {
            NullProgressMonitor mon = new NullProgressMonitor();
            mon.finished();
            result = new ReferenceCacheEntry(uri, mon);
            result.status = ReferenceCacheEntryStatus.DONE;
            result.loadThread = Thread.currentThread();
            this.uris.put(uri, result);
        }
        this.putDataSet(uri, ds);
    }

    public synchronized void reset() {
        logger.fine("reset");
        this.uris.clear();
        this.locks.clear();
    }

    public synchronized void tidy() {
        ArrayList<String> rm = new ArrayList<String>();
        for (Map.Entry<String, ReferenceCacheEntry> ent : ReferenceCache.instance.uris.entrySet()) {
            ReferenceCacheEntry ent1 = ent.getValue();
            if (!ent1.wasGarbageCollected()) continue;
            rm.add(ent1.uri);
        }
        for (String uri : rm) {
            ReferenceCache.instance.uris.remove(uri);
        }
    }

    public synchronized void printStatus() {
        System.err.println("== uris ==");
        int i = 0;
        for (Map.Entry<String, ReferenceCacheEntry> entry : ReferenceCache.instance.uris.entrySet()) {
            System.err.printf("%3d %s%n", ++i, String.valueOf(entry.getValue()));
            ReferenceCacheEntry ent1 = entry.getValue();
            QDataSet ds = ent1.qds == null ? null : (QDataSet)ent1.qds.get();
            if (ds == null) continue;
            Class<?> dsclass = ds.getClass();
            Method m = null;
            try {
                m = dsclass.getDeclaredMethod("jvmMemory", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                try {
                    m = dsclass.getSuperclass().getDeclaredMethod("jvmMemory", new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException ex1) {
                    Logger.getLogger(ReferenceCache.class.getName()).log(Level.SEVERE, null, ex1);
                }
            }
            if (m == null) continue;
            try {
                Object r = m.invoke((Object)ds, new Object[0]);
                System.err.println("     jvmMemory (bytes): " + r + "  " + dsclass.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(ReferenceCache.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.err.println("== locks ==");
        i = 0;
        for (Map.Entry<String, Object> entry : ReferenceCache.instance.locks.entrySet()) {
            System.err.printf("%3d %s%n", ++i, String.valueOf(entry.getValue()));
        }
    }

    static {
        NULL = Ops.labelsDataset(new String[]{"NULL-REFCACHE"}).slice(0);
    }

    public static class ReferenceCacheEntry {
        String uri = null;
        WeakReference<QDataSet> qds = null;
        Exception exception = null;
        ProgressMonitor monitor = null;
        Thread loadThread = null;
        ReferenceCacheEntryStatus status = ReferenceCacheEntryStatus.LOADING;

        ReferenceCacheEntry(String uri, ProgressMonitor monitor) {
            this.uri = uri;
            this.monitor = monitor;
        }

        public boolean shouldILoad(Thread t) {
            boolean result;
            logger.log(Level.FINE, "shouldILoad({0})= {1}", new Object[]{Thread.currentThread(), this.loadThread == t});
            boolean bl = result = this.loadThread == t && this.status != ReferenceCacheEntryStatus.DONE && !this.wasGarbageCollected();
            if (this.wasGarbageCollected()) {
                this.status = ReferenceCacheEntryStatus.LOADING;
            }
            return result;
        }

        public QDataSet park(ProgressMonitor mon) throws Exception {
            logger.log(Level.FINE, "parking thread {0} {1}", new Object[]{Thread.currentThread(), this.uri});
            ReferenceCache.getInstance().park(this, mon);
            if (this.exception != null) {
                throw this.exception;
            }
            logger.log(Level.FINE, "park of {0} {1} resulted in {2}", new Object[]{Thread.currentThread(), this.uri, this.qds.get()});
            QDataSet result = (QDataSet)this.qds.get();
            return result;
        }

        public void finished(QDataSet ds) {
            logger.log(Level.FINE, "finished {0} {1} {2}", new Object[]{Thread.currentThread(), ds, this.uri});
            if (ds instanceof MutablePropertyDataSet) {
                MutablePropertyDataSet mpds = (MutablePropertyDataSet)ds;
                if (!mpds.isImmutable()) {
                    WritableDataSet wds = Ops.copy(ds);
                    wds.makeImmutable();
                    ds = wds;
                }
            } else if (ds == null) {
                ds = NULL;
            }
            this.qds = new WeakReference<QDataSet>(ds);
            this.status = ReferenceCacheEntryStatus.DONE;
        }

        public void exception(Exception ex) {
            logger.log(Level.FINE, "finished {0} {1} {2}", new Object[]{Thread.currentThread(), ex, this.uri});
            this.exception = ex;
            this.status = ReferenceCacheEntryStatus.DONE;
        }

        public boolean wasGarbageCollected() {
            return ReferenceCacheEntryStatus.DONE == this.status && (this.qds == null || this.qds.get() == null);
        }

        public String toString() {
            QDataSet _qds = this.qds == null ? null : (QDataSet)this.qds.get();
            return String.format("loadThread=%s \tmonitor=%s \tstatus=%s \turi=%s \tqds=%s", new Object[]{this.loadThread.getName(), this.monitor, this.status, this.uri, String.valueOf(_qds)});
        }
    }

    public static enum ReferenceCacheEntryStatus {
        LOADING,
        DONE;

    }
}

