/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.InputVerifier;
import org.das2.util.LoggerManager;

public class RecentComboBox
extends JComboBox {
    private static final int RECENT_SIZE = 20;
    File bookmarksFolder = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks");
    File recentFile;
    String preferenceNode = "";
    public static final String PREF_NODE_TIMERANGE = "timerange";
    private static final Logger logger = org.das2.datum.LoggerManager.getLogger("apdss.uri");
    InputVerifier verifier = null;

    public RecentComboBox() {
        this.setEditable(true);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    // empty if block
                }
            }
        });
    }

    public void setPreferenceNode(String pref) {
        this.preferenceNode = pref;
        this.recentFile = new File(this.bookmarksFolder, "recent." + pref + ".txt");
        Runnable run = new Runnable(){

            @Override
            public void run() {
                RecentComboBox.this.loadRecent();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(run, "loadRecent-" + this.preferenceNode).start();
        } else {
            run.run();
        }
    }

    public void setVerifier(InputVerifier v) {
        this.verifier = v;
    }

    public void setText(String text) {
        this.setSelectedItem(text);
    }

    public String getText() {
        if (this.getSelectedItem() == null) {
            return "";
        }
        return this.getSelectedItem().toString();
    }

    private void loadRecent() {
        ArrayList<String> items = new ArrayList<String>(22);
        try {
            if (this.recentFile != null && this.recentFile.exists()) {
                BufferedReader r = new BufferedReader(new FileReader(this.recentFile));
                Object object = null;
                try {
                    String s = r.readLine();
                    while (s != null) {
                        if (this.verifier != null && !this.verifier.verify(s)) {
                            s = r.readLine();
                            continue;
                        }
                        items.add(s);
                        s = r.readLine();
                    }
                }
                catch (Throwable s) {
                    object = s;
                    throw s;
                }
                finally {
                    if (r != null) {
                        if (object != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable s) {
                                ((Throwable)object).addSuppressed(s);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
            Collections.reverse(items);
            ArrayList<String> nitems = new ArrayList<String>(items.size());
            for (String item : items) {
                if (nitems.contains(item)) continue;
                nitems.add(item);
            }
            items = nitems;
            final ArrayList<String> fitems = items;
            int n = items.size();
            if (n > 20) {
                items = items.subList(0, 20);
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    Object s = RecentComboBox.this.getModel().getSelectedItem();
                    DefaultComboBoxModel<Object> newModel = new DefaultComboBoxModel<Object>(fitems.toArray());
                    newModel.setSelectedItem(s);
                    RecentComboBox.this.setModel(newModel);
                }
            };
            SwingUtilities.invokeLater(run);
            this.saveRecent(items);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void saveRecent(List<String> items) {
        File recentFileTemp;
        if (this.recentFile == null || !this.bookmarksFolder.exists()) {
            return;
        }
        try {
            recentFileTemp = File.createTempFile("recent." + this.preferenceNode, ".txt", this.bookmarksFolder);
        }
        catch (IOException ex) {
            logger.warning(ex.getMessage());
            return;
        }
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new FileWriter(recentFileTemp));
            items = new ArrayList<String>(items);
            Collections.reverse(items);
            for (String s : items) {
                w.append(s, 0, s.length());
                w.append("\n");
            }
            w.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (!recentFileTemp.renameTo(this.recentFile)) {
            logger.log(Level.WARNING, "unable to overwrite file {0}", this.recentFile);
        }
    }

    public void addToRecent(final String s) {
        if (this.verifier != null && !this.verifier.verify(s)) {
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                File recentFileTemp;
                try {
                    recentFileTemp = File.createTempFile("recent." + RecentComboBox.this.preferenceNode, ".txt", RecentComboBox.this.bookmarksFolder);
                }
                catch (IOException ex) {
                    logger.warning(ex.getMessage());
                    return;
                }
                BufferedWriter w = null;
                try {
                    if (RecentComboBox.this.recentFile != null) {
                        w = new BufferedWriter(new FileWriter(recentFileTemp));
                        w.append(s, 0, s.length());
                        w.append("\n");
                        w.close();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    try {
                        if (w != null) {
                            w.close();
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
                if (!recentFileTemp.renameTo(RecentComboBox.this.recentFile)) {
                    logger.log(Level.WARNING, "unable to overwrite file {0}", RecentComboBox.this.recentFile);
                }
                RecentComboBox.this.loadRecent();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(run, "addToRecent-" + this.preferenceNode).start();
        } else {
            run.run();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LoggerManager.logGuiEvent(e);
        super.actionPerformed(e);
        String s = this.getSelectedItem().toString();
        this.addToRecent(s);
    }

    public static void main(String[] args) {
        JOptionPane.showConfirmDialog(null, new RecentComboBox());
    }
}

