/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class DataSourceUtil {
    private static final Logger logger = LoggerManager.getLogger("apdss.util");
    public static final DatumRange DEFAULT_TIME_RANGE = DatumRangeUtil.parseTimeRangeValid("2010-01-01");
    private static final Map<String, URIMap> makeAggSchemes = new HashMap<String, URIMap>();
    private static volatile Pattern doublePattern = null;

    private DataSourceUtil() {
    }

    public static String unescape(String s) {
        try {
            if (s.contains(" ") && s.contains("%3A")) {
                s = s.replaceAll(" ", "");
            }
            s = URLDecoder.decode(s, "UTF-8");
            if ((s = s.replaceAll("\\&amp;", "&")).startsWith("vap ")) {
                s = "vap+" + s.substring(4);
            }
            return s;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String unescapeParam(String s) {
        String[] ss = s.split("\\+\\D");
        if (ss.length == 1) {
            return s;
        }
        StringBuilder b = new StringBuilder(ss[0]);
        int ich = ss[0].length() + 1;
        for (int i = 1; i < ss.length; ++i) {
            b.append(" ").append(s.charAt(ich)).append(ss[i]);
            ich = ich + ss[i].length() + 1;
        }
        return b.toString();
    }

    public static URL newURL(URL context, String spec) throws MalformedURLException {
        if (context == null || spec.contains("://") || spec.startsWith("file:/")) {
            if (!(spec.startsWith("file:/") || spec.startsWith("ftp://") || spec.startsWith("http://") || spec.startsWith("https://"))) {
                spec = "file://" + (spec.charAt(0) == '/' ? spec : '/' + spec);
            }
            return new URL(spec);
        }
        String contextString = context.toString();
        if (!contextString.endsWith("/")) {
            contextString = contextString + "/";
        }
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        return new URL(contextString + spec);
    }

    public static String urlWithinContext(URL context, String url) {
        String result = url.startsWith(context.toString()) ? url.substring(context.toString().length()) : url;
        return result;
    }

    public static String unquote(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static int firstIndexOf(String str, List<String> targets) {
        int i0 = Integer.MAX_VALUE;
        for (String t : targets) {
            int i = str.indexOf(t);
            if (i <= -1 || i >= i0) continue;
            i0 = i;
        }
        return i0 == Integer.MAX_VALUE ? -1 : i0;
    }

    private static int splitIndex(String surl) {
        int i = DataSourceUtil.firstIndexOf(surl, Arrays.asList("%Y", "$Y", "%y", "$y", ".*"));
        i = i != -1 ? surl.lastIndexOf(47, i) : surl.lastIndexOf(47);
        return i;
    }

    public static List<String> findAggregations(List<String> files, boolean remove) {
        return DataSourceUtil.findAggregations(files, remove, false);
    }

    public static List<String> findAggregations(List<String> files, boolean remove, boolean loose) {
        ArrayList<String> accountedFor = new ArrayList<String>();
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> nonAgg = new ArrayList<String>();
        LinkedList<String> notAccountedFor = new LinkedList<String>(files);
        while (notAccountedFor.size() > 0) {
            DatumRange dr;
            TimeParser tp;
            String surl = (String)notAccountedFor.remove(0);
            String sagg = DataSourceUtil.makeAggregation(surl);
            if (sagg == null || sagg.equals(surl)) {
                nonAgg.add(surl);
                continue;
            }
            accountedFor.add(surl);
            sagg = URISplit.removeParam(sagg, "timerange");
            try {
                tp = TimeParser.create(sagg, "v", TimeParser.IGNORE_FIELD_HANDLER, new Object[0]);
                tp.parse(surl);
            }
            catch (ParseException ex) {
                continue;
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                continue;
            }
            DatumRange dr1 = dr = tp.getTimeRange();
            ArrayList<String> moveUs = new ArrayList<String>();
            Pattern p = Pattern.compile(tp.getRegex());
            for (String s : notAccountedFor) {
                if (!p.matcher(s).matches()) continue;
                try {
                    tp.parse(s);
                    dr = DatumRangeUtil.union(dr, tp.getTimeRange());
                    moveUs.add(s);
                }
                catch (ParseException parseException) {}
            }
            double nc = dr.width().divide(dr1.width()).doubleValue(Units.dimensionless);
            if (loose || moveUs.size() > 0 && (moveUs.size() > 4 || nc < (double)((1 + moveUs.size()) * 2))) {
                notAccountedFor.removeAll(moveUs);
                accountedFor.addAll(moveUs);
                result.add(URISplit.putParam(sagg, "timerange", dr.toString()));
                continue;
            }
            notAccountedFor.removeAll(moveUs);
        }
        logger.log(Level.FINER, "found {0}.", nonAgg.size());
        if (remove) {
            files.removeAll(accountedFor);
        }
        return result;
    }

    public static String makeAggregation(String surl, String[] surls) {
        try {
            String sagg = DataSourceUtil.makeAggregation(surl);
            if (sagg == null || sagg.equals(surl)) {
                return surl;
            }
            sagg = URISplit.removeParam(sagg, "timerange");
            TimeParser tp = TimeParser.create(sagg);
            tp.parse(surl);
            DatumRange dr = tp.getTimeRange();
            boolean okay = true;
            for (int i = 0; okay && i < surls.length; ++i) {
                try {
                    tp.parse(surls[i]);
                    dr = DatumRangeUtil.union(dr, tp.getTimeRange());
                    continue;
                }
                catch (ParseException ex) {
                    okay = false;
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            if (!okay) {
                return surl;
            }
            return URISplit.putParam(sagg, "timerange", dr.toString());
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return surl;
        }
    }

    private static String replaceLast(String s, List<String> search, List<String> replaceWith, List<Integer> resolution) {
        block9: {
            HashMap<String, Integer> found = new HashMap<String, Integer>();
            int last = -1;
            String flast = null;
            String frepl = null;
            int best = -1;
            int n = search.size();
            int limit = s.indexOf(63);
            if (limit == -1) {
                limit = s.length();
            }
            DatumRange dr = null;
            while (true) {
                for (int i = 0; i < n; ++i) {
                    if (search.get(i) == null) continue;
                    Matcher m = Pattern.compile(search.get(i)).matcher(s);
                    int idx = -1;
                    while (m.find()) {
                        idx = m.start();
                    }
                    if (idx <= -1 || idx >= limit) continue;
                    found.put(search.get(i), idx);
                    if (idx <= last) continue;
                    last = idx;
                    flast = search.get(i);
                    frepl = replaceWith.get(i);
                    best = i;
                }
                if (best <= -1) break block9;
                String date = s.substring(last);
                String ch = date.substring(4, 5);
                assert (frepl != null);
                String stp = frepl.replaceAll("\\\\", "");
                stp = stp.replaceAll("\\$2", ch);
                stp = stp.replaceAll("\\$3", ch);
                TimeParser tp = TimeParser.create(stp);
                DatumRange dr1 = null;
                try {
                    dr1 = tp.parse(date).getTimeRange();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (dr1 == null || dr != null && !dr1.intersects(dr)) break;
                dr = dr1;
                s = s.substring(0, last) + s.substring(last).replaceAll(flast, frepl);
                int res = resolution.get(best);
                int count = 0;
                for (int j = 0; j < n; ++j) {
                    if (resolution.get(j) <= res) continue;
                    ++count;
                    search.set(j, null);
                }
                if (count == search.size()) {
                    return s;
                }
                best = -1;
                last = -1;
            }
            return s;
        }
        return s;
    }

    public static void addMakeAggregationForScheme(String scheme, URIMap map) {
        makeAggSchemes.put(scheme, map);
    }

    public static String makeAggregation(String surl) {
        String s;
        URIMap map;
        URISplit split = URISplit.parse(surl);
        if (split.file == null) {
            return surl;
        }
        if (split.vapScheme != null && (map = makeAggSchemes.get(split.vapScheme)) != null) {
            return map.map(surl);
        }
        String yyyy = "/(19|20)\\d{2}/";
        String yyyymmdd = "(?<!\\d)(19|20)(\\d{6})(?!\\d)";
        String yyyyjjj = "(?<!\\d)(19|20)\\d{2}\\d{3}(?!\\d)";
        String yyyymm = "(?<!\\d)(19|20)\\d{2}\\d{2}(?!\\d)";
        String yyyy_mm_dd = "(?<!\\d)(19|20)\\d{2}([\\-_/])\\d{2}\\2\\d{2}(?!\\d)";
        String yyyy_jjj = "(?<!\\d)(19|20)\\d{2}([\\-_/])\\d{3}(?!\\d)";
        String yyyymmdd_HH = "(?<!\\d)(19|20)(\\d{6})(\\D)\\d{2}(?!\\d)";
        String yyyymmdd_HHMM = "(?<!\\d)(19|20)(\\d{6})(\\D)\\d{2}\\d{2}(?!\\d)";
        String version = "([Vv])\\d{2}";
        String vsep = "([Vv])(\\d+\\.\\d+(\\.\\d+)+)";
        String[] abs = new String[]{yyyymmdd_HHMM, yyyymmdd_HH, yyyy_mm_dd, yyyy_jjj, yyyymmdd, yyyyjjj, yyyymm};
        String timeRange = null;
        for (String ab : abs) {
            Matcher m = Pattern.compile(ab).matcher(surl);
            if (!m.find()) continue;
            timeRange = m.group(0);
            break;
        }
        if (timeRange == null) {
            return null;
        }
        int day = 3;
        int year = 1;
        int month = 2;
        int hour = 4;
        int minute = 5;
        ArrayList<String> search = new ArrayList<String>(Arrays.asList(yyyymmdd_HHMM, yyyymmdd_HH, yyyy_jjj, yyyymmdd, yyyyjjj, yyyymm, yyyy_mm_dd, yyyy));
        ArrayList<String> replac = new ArrayList<String>(Arrays.asList("\\$Y\\$m\\$d$3\\$H\\$M", "\\$Y\\$m\\$d$3\\$H", "\\$Y$2\\$j", "\\$Y\\$m\\$d", "\\$Y\\$j", "\\$Y\\$m", "\\$Y$2\\$m$2\\$d", "/\\$Y/"));
        ArrayList<Integer> resol = new ArrayList<Integer>(Arrays.asList(minute, hour, day, day, day, month, day, year));
        try {
            s = DataSourceUtil.replaceLast(split.file, search, replac, resol);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, ex.getMessage(), ex);
            return null;
        }
        try {
            TimeParser tp = TimeParser.create(s);
            timeRange = tp.parse(split.file).getTimeRange().toString();
            Matcher m = Pattern.compile(vsep).matcher(s);
            if (m.find()) {
                s = s.replaceFirst(m.group(), Matcher.quoteReplacement(m.group(1) + "$(v,sep)"));
            }
            if ((m = Pattern.compile(version).matcher(s)).find()) {
                s = s.replaceFirst(m.group(), Matcher.quoteReplacement(m.group(1) + "$v"));
            }
            split.file = s;
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            if (!params.containsKey("timerange")) {
                params.put("timerange", timeRange);
                split.params = URISplit.formatParams(params);
            }
            String result = URISplit.format(split);
            return result;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static String toJavaIdentifier(String label) {
        StringBuilder buf = new StringBuilder(label.length());
        for (int i = 0; i < label.length(); ++i) {
            char ch = label.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                buf.append(ch);
                continue;
            }
            if (ch != ' ') continue;
            buf.append("_");
        }
        return buf.toString();
    }

    public static boolean isJavaIdentifier(String label) {
        if (label.length() == 0 || !Character.isJavaIdentifierStart(label.charAt(0))) {
            return false;
        }
        for (int i = 1; i < label.length(); ++i) {
            if (Character.isJavaIdentifierPart(label.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isJavaDouble(String myString) {
        if (doublePattern != null) return doublePattern.matcher(myString).matches();
        Class<DataSourceUtil> clazz = DataSourceUtil.class;
        synchronized (DataSourceUtil.class) {
            if (doublePattern != null) return doublePattern.matcher(myString).matches();
            String Digits = "(\\p{Digit}+)";
            String HexDigits = "(\\p{XDigit}+)";
            String Exp = "[eE][+-]?(\\p{Digit}+)";
            String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
            doublePattern = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return doublePattern.matcher(myString).matches();
        }
    }

    public static String strjoin(Collection<String> c, String delim) {
        StringBuilder result = new StringBuilder();
        for (String s : c) {
            if (result.length() > 0) {
                result.append(delim);
            }
            result.append(s);
        }
        return result.toString();
    }

    public static String strjoin(long[] dims, String delim) {
        StringBuilder sdims = new StringBuilder();
        if (dims.length > 0) {
            sdims.append(dims[0]);
            for (int i = 1; i < dims.length; ++i) {
                sdims.append(delim).append(dims[i]);
            }
        }
        return sdims.toString();
    }

    public static String strjoin(int[] dims, String delim) {
        StringBuilder sdims = new StringBuilder();
        if (dims.length > 0) {
            sdims.append(dims[0]);
            for (int i = 1; i < dims.length; ++i) {
                sdims.append(delim).append(dims[i]);
            }
        }
        return sdims.toString();
    }

    public static void transfer(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            while (src.read(buffer) != -1) {
                buffer.flip();
                dest.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                dest.write(buffer);
            }
        }
        finally {
            dest.close();
            src.close();
        }
    }

    public static void transfer(InputStream src, OutputStream dest) throws IOException {
        byte[] buffer = new byte[16384];
        int i = src.read(buffer);
        while (i != -1) {
            dest.write(buffer, 0, i);
            i = src.read(buffer);
        }
        dest.close();
        src.close();
    }

    public static Map<Integer, long[]> parseConstraint(String constraint, long[] qubeDims) throws ParseException {
        String[] ss;
        if (constraint == null) {
            ss = new String[]{null, null, null};
        } else {
            if (constraint.startsWith("[") && constraint.endsWith("]")) {
                constraint = constraint.substring(1, constraint.length() - 1);
            }
            ss = constraint.split("\\,", -2);
        }
        HashMap<Integer, long[]> result = new HashMap<Integer, long[]>();
        int ndim = Math.min(ss.length, qubeDims.length);
        for (int i = 0; i < ndim; ++i) {
            long[] r = DataSourceUtil.parseConstraint(ss[i], qubeDims[i]);
            result.put(i, r);
        }
        return result;
    }

    public static long[] parseConstraint(String constraint, long recCount) throws ParseException {
        long[] result = new long[]{0L, recCount, 1L};
        if (constraint == null) {
            return result;
        }
        if (constraint.startsWith("[") && constraint.endsWith("]")) {
            constraint = constraint.substring(1, constraint.length() - 1);
        }
        try {
            String[] ss = constraint.split(":", -2);
            if (ss.length > 0 && ss[0].length() > 0) {
                result[0] = Integer.parseInt(ss[0]);
                if (result[0] < 0L) {
                    result[0] = recCount + result[0];
                }
            }
            if (ss.length > 1 && ss[1].length() > 0) {
                result[1] = Integer.parseInt(ss[1]);
                if (result[1] < 0L) {
                    result[1] = recCount + result[1];
                }
            }
            if (ss.length > 2 && ss[2].length() > 0) {
                result[2] = Integer.parseInt(ss[2]);
            }
            if (ss.length == 1) {
                result[1] = -1L;
                result[2] = -1L;
            }
        }
        catch (NumberFormatException ex) {
            throw new ParseException("expected integer: " + ex.toString(), 0);
        }
        if (result[0] > recCount) {
            result[0] = recCount;
        }
        if (result[1] > recCount) {
            result[1] = recCount;
        }
        return result;
    }

    public static String guessRenderType(QDataSet fillds) {
        String spec;
        String specPref = "spectrogram";
        String srenderType = (String)fillds.property("RENDER_TYPE");
        if (srenderType != null && srenderType.length() > 0) {
            return srenderType;
        }
        QDataSet dep1 = (QDataSet)fillds.property("DEPEND_1");
        QDataSet plane0 = (QDataSet)fillds.property("PLANE_0");
        QDataSet bundle1 = (QDataSet)fillds.property("BUNDLE_1");
        if (fillds.property("JOIN_0") != null) {
            if (fillds.length() == 0) {
                return "series";
            }
            dep1 = (QDataSet)fillds.property("DEPEND_1", 0);
            plane0 = (QDataSet)fillds.property("PLANE_0", 0);
            bundle1 = (QDataSet)fillds.property("BUNDLE_1", 0);
        }
        if (fillds.rank() >= 2) {
            if (bundle1 != null || dep1 != null && SemanticOps.isBundle(fillds) || Ops.isLegacyBundle(fillds)) {
                spec = fillds.length() > 80000 ? "hugeScatter" : "series";
                if (bundle1 != null) {
                    if (bundle1.length() == 3 && bundle1.property("DEPEND_0", 2) != null) {
                        spec = "colorScatter";
                    } else if (bundle1.length() == 3 || bundle1.length() == 4) {
                        Units u3;
                        Units u1;
                        Units u0 = (Units)bundle1.property("UNITS", 0);
                        if (u0 == null) {
                            u0 = Units.dimensionless;
                        }
                        if ((u1 = (Units)bundle1.property("UNITS", 1)) == null) {
                            u1 = Units.dimensionless;
                        }
                        if ((u3 = (Units)bundle1.property("UNITS", bundle1.length() - 1)) != null && UnitsUtil.isOrdinalMeasurement(u3) && u0.getOffsetUnits().isConvertibleTo(u1)) {
                            spec = "eventsBar";
                        }
                    }
                }
            } else {
                spec = dep1 == null && fillds.rank() == 2 && fillds.length() > 3 && fillds.length(0) < 4 ? "series" : specPref;
            }
        } else if (fillds.rank() == 0 || fillds.rank() == 1 && SemanticOps.isBundle(fillds)) {
            spec = "digital";
        } else {
            spec = fillds.length() > 80000 ? "hugeScatter" : "series";
            if (plane0 != null) {
                Units u = (Units)plane0.property("UNITS");
                if (u == null) {
                    u = Units.dimensionless;
                }
                if (u != null && (UnitsUtil.isRatioMeasurement(u) || UnitsUtil.isIntervalMeasurement(u))) {
                    spec = "colorScatter";
                }
            }
        }
        return spec;
    }

    public static void openBrowser(String url) {
        String osName;
        try {
            URI target = DataSetURI.getResourceURI(url);
            Desktop.getDesktop().browse(target);
            return;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedOperationException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        String errMsg = "Error attempting to launch web browser";
        try {
            osName = System.getProperty("os.name", "applet");
        }
        catch (SecurityException ex) {
            osName = "applet";
        }
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                if (osName.equals("applet")) {
                    throw new RuntimeException("applets can't start browser yet");
                }
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    public static boolean isHtmlStream(String text) {
        return text.toLowerCase().startsWith("<!doc") || text.toLowerCase().startsWith("<html");
    }

    public static TimeSeriesBrowse getTimeSeriesBrowse(DataSource dss) {
        return dss.getCapability(TimeSeriesBrowse.class);
    }

    public static QDataSet trimScatterToTimeRange(QDataSet tsbData, DatumRange timeRange) {
        if (tsbData == null) {
            return null;
        }
        QDataSet time = null;
        QDataSet dep0 = (QDataSet)tsbData.property("DEPEND_0");
        if (dep0 != null) {
            time = (QDataSet)dep0.property("DEPEND_0");
        } else if (SemanticOps.isBundle(tsbData)) {
            time = Ops.unbundle(tsbData, 0);
        }
        if (time != null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(time)) && time.rank() == 1) {
            QDataSet w = Ops.where(Ops.within((Object)time, timeRange));
            tsbData = DataSetOps.applyIndex(tsbData, w);
            return tsbData;
        }
        return tsbData;
    }

    public static String setTimeRange(String uri, DatumRange timeRange, ProgressMonitor mon) throws URISyntaxException, IOException, ParseException {
        if (timeRange == null) {
            logger.fine("timeRange is null");
            return uri;
        }
        if (!UnitsUtil.isTimeLocation(timeRange.getUnits())) {
            logger.fine("timeRange is not UTC time range");
            return uri;
        }
        DataSourceFactory f = DataSetURI.getDataSourceFactory(DataSetURI.getURI(uri), mon);
        TimeSeriesBrowse tsb = f.getCapability(TimeSeriesBrowse.class);
        if (tsb != null) {
            tsb.setURI(uri);
            tsb.setTimeRange(timeRange);
            uri = tsb.getURI();
            logger.log(Level.FINER, "resetting timerange to {0}: {1}", new Object[]{timeRange, uri});
        } else {
            logger.finer("uri is not a TimeSeriesBrowse");
        }
        return uri;
    }

    public static String guessNameFor(String uri) {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
        String name = "ds";
        String altName = null;
        if (args.containsKey("arg_0")) {
            altName = Ops.safeName((String)args.get("arg_0"));
        } else if (args.containsKey("id")) {
            altName = Ops.safeName((String)args.get("id"));
        } else if (args.containsKey("column")) {
            altName = Ops.safeName((String)args.get("column"));
        }
        if (altName != null && altName.length() < 30) {
            name = altName;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            name = name.toLowerCase();
        } else if (name.length() > 0 && Character.isUpperCase(name.charAt(0))) {
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    public static String getMessage(Exception ex) {
        if (ex == null) {
            throw new IllegalArgumentException("Expected exception, but got null");
        }
        if (ex instanceof NullPointerException) {
            return ex.toString();
        }
        if (ex.getMessage() == null) {
            return ex.toString();
        }
        if (ex.getMessage().length() < 5) {
            return ex.toString() + ": " + ex.getMessage();
        }
        return ex.getMessage();
    }

    public static void main(String[] args) {
        String surl = "ftp://virbo.org/LANL/LANL1991/SOPA+ESP/H0/LANL_1991_080_H0_SOPA_ESP_19920308_V01.cdf?L";
        System.err.println(DataSourceUtil.makeAggregation(surl));
        System.err.println(DataSourceUtil.makeAggregation(surl));
    }

    public static void showMessageDialog(Component parent, String msg, String title, int messageType, Exception causeBy) {
        JOptionPane.showMessageDialog(parent, msg, title, messageType);
    }

    public static XPathFactory getXPathFactory() {
        XPathFactory xpf;
        try {
            xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl", null);
        }
        catch (XPathFactoryConfigurationException ex) {
            xpf = XPathFactory.newInstance();
            logger.log(Level.INFO, "using default xpath implementation: {0}", xpf.getClass());
        }
        return xpf;
    }

    public static interface URIMap {
        public String map(String var1);
    }
}

