/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.aggregator.AggregatingDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceFormat;

public class DataSourceRegistry {
    private static final Logger logger = Logger.getLogger("apdss.uri");
    private static DataSourceRegistry instance;
    HashMap<String, Object> dataSourcesByExt = new HashMap();
    HashMap<String, Object> dataSourcesByMime = new HashMap();
    HashMap<String, Object> dataSourceFormatByExt = new HashMap();
    HashMap<String, Object> dataSourceFormatEditorByExt;
    HashMap<String, Object> dataSourceEditorByExt = new HashMap();
    HashMap<String, String> extToDescription;

    private DataSourceRegistry() {
        this.dataSourceFormatEditorByExt = new HashMap();
        this.extToDescription = new HashMap();
    }

    public static DataSourceRegistry getInstance() {
        if (instance == null) {
            instance = new DataSourceRegistry();
        }
        return instance;
    }

    public static Object getInstanceFromClassName(String o) {
        try {
            Class<?> clas = Class.forName(o);
            Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
            Object result = constructor.newInstance(new Object[0]);
            return result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public List<String> getFormatterExtensions() {
        ArrayList<String> result = new ArrayList<String>();
        for (String k : this.dataSourceFormatByExt.keySet()) {
            result.add(k);
        }
        return result;
    }

    public List<String> getSourceExtensions() {
        ArrayList<String> result = new ArrayList<String>();
        for (String k : this.dataSourcesByExt.keySet()) {
            result.add(k);
        }
        return result;
    }

    public List<String> getSourceEditorExtensions() {
        ArrayList<String> result = new ArrayList<String>();
        for (String k : this.dataSourceEditorByExt.keySet()) {
            result.add(k);
        }
        return result;
    }

    protected void discoverFactories() {
        DataSourceRegistry registry = this;
        try {
            ClassLoader loader = DataSetURI.class.getClassLoader();
            Enumeration<URL> urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.autoplot.datasource.DataSourceFactory") : loader.getResources("META-INF/org.autoplot.datasource.DataSourceFactory");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s = reader.readLine();
                while (s != null) {
                    if (s.trim().length() > 0) {
                        List extensions = null;
                        List mimeTypes = null;
                        String factoryClassName = s;
                        try {
                            Method m2;
                            Class<?> c = Class.forName(factoryClassName);
                            DataSourceFactory f = (DataSourceFactory)c.newInstance();
                            try {
                                m2 = c.getMethod("extensions", new Class[0]);
                                extensions = (List)m2.invoke((Object)f, new Object[0]);
                            }
                            catch (NoSuchMethodException m2) {
                            }
                            catch (InvocationTargetException ex) {
                                logger.log(Level.SEVERE, ex.getMessage(), ex);
                            }
                            try {
                                m2 = c.getMethod("mimeTypes", new Class[0]);
                                mimeTypes = (List)m2.invoke((Object)f, new Object[0]);
                            }
                            catch (NoSuchMethodException ex) {
                                logger.log(Level.SEVERE, ex.getMessage(), ex);
                            }
                            catch (InvocationTargetException ex) {
                                logger.log(Level.SEVERE, ex.getMessage(), ex);
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                        catch (InstantiationException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                        catch (IllegalAccessException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                        if (extensions != null) {
                            for (String e : extensions) {
                                registry.registerExtension(factoryClassName, e, null);
                            }
                        }
                        if (mimeTypes != null) {
                            for (String m : mimeTypes) {
                                registry.registerMimeType(factoryClassName, m);
                            }
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private Map<String, String> readStuff(Iterator<URL> urls) throws IOException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while (urls.hasNext()) {
            URL url = urls.next();
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String s = reader.readLine();
            while (s != null) {
                if ((s = s.trim()).length() > 0) {
                    String[] ss = s.split("\\s");
                    for (int i = 1; i < ss.length; ++i) {
                        result.put(ss[i], ss[0]);
                    }
                }
                s = reader.readLine();
            }
            reader.close();
        }
        return result;
    }

    protected void discoverRegistryEntries() {
        logger.fine("discoverRegistryEntries");
        DataSourceRegistry registry = this;
        try {
            int i;
            String[] ss;
            String s;
            BufferedReader reader;
            URL url;
            ClassLoader loader = DataSetURI.class.getClassLoader();
            Enumeration<URL> urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.autoplot.datasource.DataSourceFactory.extensions") : loader.getResources("META-INF/org.autoplot.datasource.DataSourceFactory.extensions");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                logger.log(Level.FINE, "loading {0}", url);
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        ss = s.split("\\s");
                        for (i = 1; i < ss.length; ++i) {
                            if (ss[i].contains(".")) {
                                logger.warning("META-INF/org.autoplot.datasource.DataSourceFactory.extensions contains extension that contains period: ");
                                logger.warning(ss[0] + " " + ss[i] + " in " + url);
                                logger.warning("This sometimes happens when extension files are concatenated, so check that all are terminated by end-of-line");
                                logger.warning("");
                                throw new IllegalArgumentException("DataSourceFactory.extensions contains extension that contains period: " + url);
                            }
                            registry.registerExtension(ss[0], ss[i], null);
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
            urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.autoplot.datasource.DataSourceFactory.mimeTypes") : loader.getResources("META-INF/org.autoplot.datasource.DataSourceFactory.mimeTypes");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                logger.log(Level.FINE, "loading {0}", url);
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        ss = s.split("\\s");
                        for (i = 1; i < ss.length; ++i) {
                            registry.registerMimeType(ss[0], ss[i]);
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
            urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.autoplot.datasource.DataSourceFormat.extensions") : loader.getResources("META-INF/org.autoplot.datasource.DataSourceFormat.extensions");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                logger.log(Level.FINE, "loading {0}", url);
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        ss = s.split("\\s");
                        for (i = 1; i < ss.length; ++i) {
                            if (ss[i].contains(".")) {
                                logger.warning("META-INF/org.autoplot.datasource.DataSourceFormat.extensions contains extension that contains period: ");
                                logger.warning(ss[0] + " " + ss[i] + " in " + url);
                                logger.warning("This sometimes happens when extension files are concatenated, so check that all are terminated by end-of-line");
                                logger.warning("");
                                throw new IllegalArgumentException("DataSourceFactory.extensions contains extension that contains period: " + url);
                            }
                            registry.registerFormatter(ss[0], ss[i]);
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
            urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.autoplot.datasource.DataSourceEditorPanel.extensions") : loader.getResources("META-INF/org.autoplot.datasource.DataSourceEditorPanel.extensions");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                logger.log(Level.FINE, "loading {0}", url);
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        ss = s.split("\\s");
                        for (i = 1; i < ss.length; ++i) {
                            if (ss[i].contains(".")) {
                                logger.warning("META-INF/org.autoplot.datasource.DataSourceEditorPanel.extensions contains extension that contains period: ");
                                logger.log(Level.WARNING, "{0} {1} in {2}", new Object[]{ss[0], ss[i], url});
                                logger.warning("This sometimes happens when extension files are concatenated, so check that all are terminated by end-of-line");
                                logger.warning("");
                                throw new IllegalArgumentException("DataSourceFactory.extensions contains extension that contains period: " + url);
                            }
                            registry.registerEditor(ss[0], ss[i]);
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
            urls = loader == null ? ClassLoader.getSystemResources("META-INF/org.autoplot.datasource.DataSourceFormatEditorPanel.extensions") : loader.getResources("META-INF/org.autoplot.datasource.DataSourceFormatEditorPanel.extensions");
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                logger.log(Level.FINE, "loading {0}", url);
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        ss = s.split("\\s");
                        for (i = 1; i < ss.length; ++i) {
                            if (ss[i].contains(".")) {
                                logger.warning("META-INF/org.autoplot.datasource.DataSourceFormatEditorPanel.extensions contains extension that contains period: ");
                                logger.log(Level.WARNING, "{0} {1} in {2}", new Object[]{ss[0], ss[i], url});
                                logger.warning("This sometimes happens when extension files are concatenated, so check that all are terminated by end-of-line");
                                logger.warning("");
                                throw new IllegalArgumentException("DataSourceFactory.extensions contains extension that contains period: " + url);
                            }
                            registry.registerFormatEditor(ss[0], ss[i]);
                        }
                    }
                    s = reader.readLine();
                }
                reader.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void registerDataSourceJar(String ext, final URL jarFile) throws IOException {
        URLClassLoader loader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URLClassLoader load = new URLClassLoader(new URL[]{jarFile}, DataSourceRegistry.class.getClassLoader());
                return load;
            }
        });
        Enumeration<URL> re = loader.getResources("META-INF/org.autoplot.datasource.DataSourceFactory.extensions");
        ArrayList<URL> rre = new ArrayList<URL>();
        while (re.hasMoreElements()) {
            URL u = re.nextElement();
            if (!u.toString().startsWith("jar:" + jarFile.toString())) continue;
            rre.add(u);
        }
        Map<String, String> stuff = this.readStuff(rre.iterator());
        for (Map.Entry<String, String> ent : stuff.entrySet()) {
            try {
                Class<?> clas = loader.loadClass(ent.getValue());
                if (ext != null) {
                    this.dataSourcesByExt.put(DataSourceRegistry.getExtension(ext), clas.getConstructor(new Class[0]).newInstance(new Object[0]));
                    continue;
                }
                this.dataSourcesByExt.put(DataSourceRegistry.getExtension(ent.getKey()), clas.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    public boolean hasSourceByExt(String ext) {
        if (ext == null) {
            return false;
        }
        return this.dataSourcesByExt.get(DataSourceRegistry.getExtension(ext)) != null;
    }

    public boolean hasSourceByMime(String mime) {
        if (mime == null) {
            return false;
        }
        return this.dataSourcesByMime.get(mime) != null;
    }

    public void register(DataSourceFactory factory, String extension) {
        extension = DataSourceRegistry.getExtension(extension);
        this.dataSourcesByExt.put(extension, factory);
    }

    public void register(DataSourceFactory factory, String extension, String mime) {
        extension = DataSourceRegistry.getExtension(extension);
        this.dataSourcesByExt.put(extension, factory);
        this.dataSourcesByMime.put(mime.toLowerCase(), factory);
    }

    public void registerExtension(String className, String extension, String description) {
        Object old = this.dataSourcesByExt.get(extension = DataSourceRegistry.getExtension(extension));
        if (old != null) {
            String oldClassName;
            String string = oldClassName = old instanceof String ? (String)old : old.getClass().getName();
            if (!oldClassName.equals(className)) {
                logger.log(Level.FINE, "extension {0} is already handled by {1}, replacing with {2}", new Object[]{extension, oldClassName, className});
            }
        }
        this.dataSourcesByExt.put(extension, className);
        if (description != null) {
            this.extToDescription.put(extension, description);
        }
    }

    public void registerFormatter(String className, String extension) {
        if (extension.indexOf(46) != 0) {
            extension = "." + extension;
        }
        this.dataSourceFormatByExt.put(extension, className);
    }

    public void registerEditor(String className, String extension) {
        extension = DataSourceRegistry.getExtension(extension);
        this.dataSourceEditorByExt.put(extension, className);
    }

    public void registerFormatEditor(String className, String extension) {
        extension = DataSourceRegistry.getExtension(extension);
        this.dataSourceFormatEditorByExt.put(extension, className);
    }

    public void registerMimeType(String className, String mimeType) {
        this.dataSourcesByMime.put(mimeType, className);
    }

    public void register(String className, String extension, String mime) {
        extension = DataSourceRegistry.getExtension(extension);
        this.dataSourcesByExt.put(extension, className);
        this.dataSourcesByMime.put(mime.toLowerCase(), className);
    }

    private DataSourceFactory useJavaCdfForNative(String extension, Error ex) {
        logger.fine("attempting to use java based reader to handle cdfn.");
        DataSourceFactory dsf = this.getSource(".cdfj");
        if (dsf != null) {
            this.dataSourcesByExt.put(extension, dsf);
            this.dataSourceEditorByExt.put(extension, this.getDataSourceEditorByExt(".cdfj"));
            this.dataSourceFormatByExt.put(extension, this.getDataSourceFormatEditorByExt(".cdfj"));
            return dsf;
        }
        throw new RuntimeException(ex);
    }

    public synchronized DataSourceFactory getSource(String extension) {
        DataSourceFactory result;
        if (extension == null) {
            return null;
        }
        Object o = this.dataSourcesByExt.get(extension = DataSourceRegistry.getExtension(extension));
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                if (((String)o).endsWith("DataSource")) {
                    throw new IllegalArgumentException("DataSourceFactory names cannot end in DataSource: " + o);
                }
                Class<?> clas = Class.forName((String)o);
                Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
                result = (DataSourceFactory)constructor.newInstance(new Object[0]);
                this.dataSourcesByExt.put(extension, result);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoClassDefFoundError ex) {
                if (extension.equals(".cdfn") || extension.equals(".cdf")) {
                    result = this.useJavaCdfForNative(extension, ex);
                }
                throw new RuntimeException(ex);
            }
            catch (UnsatisfiedLinkError ex) {
                if (extension.equals(".cdfn") || extension.equals(".cdf")) {
                    result = this.useJavaCdfForNative(extension, ex);
                }
                throw new RuntimeException(ex);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            result = (DataSourceFactory)o;
        }
        return result;
    }

    protected static String getExtension(String name) {
        int i;
        if (name.indexOf(46) == -1) {
            name = "." + name;
        }
        if (name.indexOf(46) > 0) {
            i = name.lastIndexOf(46);
            name = name.substring(i);
        }
        if ((i = name.indexOf(63)) != -1) {
            name = name.substring(0, i);
        }
        if ((i = name.indexOf(38)) != -1) {
            name = name.substring(0, i);
        }
        name = name.toLowerCase();
        return name;
    }

    public DataSourceFormat getFormatByExt(String extension) {
        DataSourceFormat result;
        if (extension == null) {
            return null;
        }
        Object o = this.dataSourceFormatByExt.get(extension = DataSourceRegistry.getExtension(extension));
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                Class<?> clas = Class.forName((String)o);
                Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
                Object oresult = constructor.newInstance(new Object[0]);
                if (!(oresult instanceof DataSourceFormat)) {
                    logger.log(Level.WARNING, "constructor of incorrect type for {0}, extension {1}", new Object[]{o, extension});
                    return null;
                }
                result = (DataSourceFormat)constructor.newInstance(new Object[0]);
                logger.log(Level.FINE, "constructor for getFormat: {0}", clas);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            result = (DataSourceFormat)o;
        }
        return result;
    }

    public synchronized DataSourceFactory getSourceByMime(String mime) {
        DataSourceFactory result;
        if (mime == null) {
            return null;
        }
        Object o = this.dataSourcesByMime.get(mime.toLowerCase());
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                Class<?> clas = Class.forName((String)o);
                Constructor<?> constructor = clas.getDeclaredConstructor(new Class[0]);
                result = (DataSourceFactory)constructor.newInstance(new Object[0]);
                this.dataSourcesByMime.put(mime.toLowerCase(), result);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            result = (DataSourceFactory)o;
        }
        return result;
    }

    public synchronized Object getDataSourceEditorByExt(String ext) {
        return this.dataSourceEditorByExt.get(DataSourceRegistry.getExtension(ext));
    }

    public synchronized Object getDataSourceFormatEditorByExt(String ext) {
        return this.dataSourceFormatEditorByExt.get(DataSourceRegistry.getExtension(ext));
    }

    String getExtensionFor(DataSourceFactory factory) {
        for (String ext : this.dataSourcesByExt.keySet()) {
            if (this.dataSourcesByExt.get(ext) != factory) continue;
            return ext;
        }
        return null;
    }

    public static String getPluginsText() {
        String k;
        StringBuilder buf = new StringBuilder();
        buf.append("<html>");
        buf.append("<h1>Plugins by Extension:</h1>");
        HashMap<String, Object> m = DataSourceRegistry.getInstance().dataSourcesByExt;
        for (Map.Entry e : m.entrySet()) {
            k = (String)e.getKey();
            buf.append("").append(k).append(": ").append(e.getValue()).append("<br>");
        }
        buf.append("<h1>Plugins by Mime Type:</h1>");
        m = DataSourceRegistry.getInstance().dataSourcesByMime;
        for (Map.Entry e : m.entrySet()) {
            k = (String)e.getKey();
            buf.append("").append(k).append(": ").append(e.getValue()).append("<br>");
        }
        buf.append("</html>");
        return buf.toString();
    }

    public static List<CompletionContext> getPlugins() {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        HashMap<String, Object> m = DataSourceRegistry.getInstance().dataSourcesByExt;
        for (Map.Entry e : m.entrySet()) {
            String k = (String)e.getKey();
            result.add(new CompletionContext(CompletionContext.CONTEXT_AUTOPLOT_SCHEME, "vap+" + k.substring(1) + ":"));
        }
        return result;
    }

    public static String getDescriptionFor(String vapext) {
        if (vapext.startsWith("vap+cdaweb")) {
            return "CDAWeb database at NASA/SPDF";
        }
        if (vapext.startsWith("vap+das2server")) {
            return "Das2Server";
        }
        if (vapext.startsWith("vap+inline")) {
            return "Data encoded within the URI";
        }
        return null;
    }

    public boolean hasResourceUri(String vapScheme) {
        int i = vapScheme.indexOf(58);
        if (i > 0) {
            vapScheme = vapScheme.substring(0, i);
        }
        boolean noUri = vapScheme.endsWith("cdaweb") || vapScheme.endsWith("inline") || vapScheme.endsWith("pdsppi");
        return !noUri;
    }

    public boolean hasParamOrder(String vapScheme) {
        if (vapScheme.startsWith("vap+inline:")) {
            return true;
        }
        return vapScheme.startsWith("vap+internal:");
    }

    String describe(DataSourceFactory f, String uri) {
        if (f instanceof AggregatingDataSourceFactory) {
            return "aggregation";
        }
        String ext = DataSourceRegistry.getExtension(uri);
        String s = this.extToDescription.get(ext);
        if (s != null) {
            return s;
        }
        return ext;
    }
}

