/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import org.autoplot.datasource.CompletionsDataSourceEditor;
import org.autoplot.datasource.CompletionsList;
import org.autoplot.datasource.DataSetSelectorDemo;
import org.autoplot.datasource.DataSetSelectorSupport;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorDialog;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceEditorPanelUtil;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.EmptyFileException;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.HtmlResponseIOException;
import org.autoplot.datasource.JScrollPopupMenu;
import org.autoplot.datasource.SourceTypesBrowser;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.UnrecognizedDataSourceException;
import org.autoplot.datasource.WindowManager;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.datasource.ui.PromptComboBoxEditor;
import org.autoplot.datasource.ui.PromptTextField;
import org.das2.DasApplication;
import org.das2.components.DasProgressPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DomainDivider;
import org.das2.datum.DomainDividerUtil;
import org.das2.datum.OrbitDatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ops.Ops;
import org.das2.system.MonitorFactory;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;

public class DataSetSelector
extends JPanel {
    public static final String PROP_RECENT = "recent";
    private static final int MAX_RECENT = 20;
    public static final Icon BUSY_ICON = new ImageIcon(DataSetSelector.class.getResource("/org/autoplot/aggregator/spinner_16.gif"));
    public static final Icon FILEMAG_ICON = new ImageIcon(DataSetSelector.class.getResource("/org/autoplot/datasource/fileMag.png"));
    private Map<Object, Object> pendingChanges = new HashMap<Object, Object>();
    private final String MESSAGE_RECENT = "(application will put recent items here)";
    private final Object PENDING_EDIT = "edit";
    private final Object PENDING_GO = "gobutton";
    private final Object PENDING_CHECKING_REJECT = "checkingReject";
    private final Object PENDING_PLOT = "plot";
    boolean needToAddKeys = true;
    Runnable completionsRunnable = null;
    ProgressMonitor completionsMonitor = null;
    JPopupMenu completionsPopupMenu = null;
    private JTextField editor;
    DataSetSelectorSupport support = new DataSetSelectorSupport(this);
    public static final String PROPERTY_MESSAGE = "message";
    static final Logger logger = LoggerManager.getLogger("apdss.gui.dss");
    MonitorFactory monitorFactory = null;
    Timer maybePlotTimer;
    int keyModifiers = 0;
    boolean playButton = true;
    public static final String FILE_NOT_FOUND = "File not found";
    private final Action ABOUT_PLUGINS_ACTION = new AbstractAction("About Plugins"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LoggerManager.logGuiEvent(e);
            String about = DataSetSelectorSupport.getPluginsText();
            JOptionPane.showMessageDialog(DataSetSelector.this, about);
        }
    };
    private boolean popupCancelled = false;
    private JComboBox dataSetSelector;
    private JButton inspectButton;
    private JButton plotItButton;
    private String lastValue = null;
    private String browseTypeExt;
    protected boolean hidePlayButton = false;
    public static final String PROP_HIDEPLAYBUTTON = "hidePlayButton";
    private transient ArrayList actionListenerList;
    private List<String> recent;
    private static List<String> defaultRecent;
    private String message;
    Map<String, Action> actionTriggers = new LinkedHashMap<String, Action>();
    protected boolean plotItButtonVisible = true;
    public static final String PROP_PLOTITBUTTONVISIBLE = "plotItButtonVisible";
    Map<String, Action> browseTriggers = new LinkedHashMap<String, Action>();
    protected boolean enableDataSource = true;
    public static final String PROP_ENABLEDATASOURCE = "enableDataSource";
    private DatumRange timeRange = null;
    public static final String PROP_TIMERANGE = "timeRange";
    protected boolean suggestFsAgg = true;
    public static final String PROP_SUGGESTFSAGG = "suggestFsAgg";
    protected boolean suggestFiles = true;
    public static final String PROP_SUGGESTFILES = "suggestFiles";
    private final List<String> suggestFile = new ArrayList<String>();
    private String acceptPattern = null;
    private boolean cardSelected = false;
    public static final String PROP_CARDSELECTED = "cardSelected";
    private String alternatePeer;
    private String alternatePeerCard;
    private boolean expertMode = true;

    public DataSetSelector() {
        this.initComponents();
        this.dataSetSelector.setEditor(new PromptComboBoxEditor("Enter data location"));
        this.plotItButton.setActionCommand("doplot");
        this.inspectButton.setActionCommand("inspect");
        this.editor = (JTextField)this.dataSetSelector.getEditor().getEditorComponent();
        this.dataSetSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DataSetSelector.this.keyModifiers = ev.getModifiers();
            }
        });
        this.editor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                int i = DataSetSelector.this.editor.getCaretPosition();
                DataSetSelector.this.editor.setSelectionStart(i);
                DataSetSelector.this.editor.setSelectionEnd(i);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.addCompletionKeys();
        this.addAbouts();
        this.maybePlotTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                try {
                    DataSetSelector.this.maybePlotImmediately();
                }
                finally {
                    DataSetSelector.this.pendingChanges.remove(DataSetSelector.this.PENDING_GO);
                }
            }
        });
        this.maybePlotTimer.setActionCommand("maybePlot");
        this.maybePlotTimer.setRepeats(false);
        this.editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DataSetSelector.this.showPopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DataSetSelector.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DataSetSelector.this.showPopup(e);
                }
            }
        });
    }

    public JTextField getEditor() {
        return this.editor;
    }

    public JButton getGoButton() {
        return this.plotItButton;
    }

    public void setPlayButton(boolean t) {
        this.playButton = t;
    }

    public boolean isPendingChanges() {
        return this.maybePlotTimer.isRunning() || !this.pendingChanges.isEmpty();
    }

    public JButton getBrowseButton() {
        return this.inspectButton;
    }

    private ProgressMonitor getMonitor() {
        return this.getMonitor("Please Wait", "unidentified task in progress");
    }

    private ProgressMonitor getMonitor(String label, String desc) {
        if (this.monitorFactory == null) {
            ProgressMonitor mon = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(label, desc);
            return mon;
        }
        return this.monitorFactory.getMonitor(label, desc);
    }

    public void setMonitorFactory(MonitorFactory factory) {
        this.monitorFactory = factory;
    }

    private void showPluginsScreen() {
        StringBuilder msg = new StringBuilder();
        msg.append("<html>Unable to use the address <br><br>").append(this.getValue()).append("<br><br>Qualify the address by adding a supported plugin id (e.g. vap+dat:)<br>").append("or use an address that matches one of these triggers:<br><br>");
        for (String at : this.actionTriggers.keySet()) {
            msg.append(at).append("<br>");
        }
        msg.append("</html>");
        JOptionPane.showMessageDialog(this, msg, "Unrecognized address", 0);
    }

    private boolean checkActionTriggers(String suri) {
        for (Map.Entry<String, Action> e : this.actionTriggers.entrySet()) {
            String actionTriggerRegex = e.getKey();
            if (!Pattern.matches(actionTriggerRegex, suri)) continue;
            logger.finest("matches action trigger");
            Action action = e.getValue();
            action.actionPerformed(new ActionEvent(this, 123, "dataSetSelect"));
            return true;
        }
        return false;
    }

    private void setTextInternal(final String text) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataSetSelector.this.editor.setText(text);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
        this.lastValue = text;
    }

    public boolean hasActionTrigger(String suri) {
        for (String actionTriggerRegex : this.actionTriggers.keySet()) {
            if (!Pattern.matches(actionTriggerRegex, suri)) continue;
            logger.log(Level.FINEST, "matches action trigger: {0}", actionTriggerRegex);
            return true;
        }
        return false;
    }

    private void maybePlotImmediatelyOffEvent(String surl) {
        block34: {
            Pattern accept;
            logger.log(Level.FINE, "maybePlotImmediatelyOffEvent( {0} )", surl);
            Pattern pattern = accept = this.acceptPattern == null ? null : Pattern.compile(this.acceptPattern);
            if (!this.enableDataSource && (accept == null || accept.matcher(surl).matches())) {
                this.firePlotDataSetURL();
                return;
            }
            String ext = DataSetURI.getExt(surl);
            if (ext != null && ext.equals("vap")) {
                this.firePlotDataSetURL();
                return;
            }
            if (surl.contains(".vap&") && !surl.contains("?")) {
                JOptionPane.showMessageDialog(this.getEditor(), "URI contains \".vap&\" and no ?, try \".vap?\"...");
                return;
            }
            URISplit split = URISplit.parse(surl);
            String file = split.file;
            if (file == null || file.equals("file:///")) {
                file = "";
            }
            try {
                if (file.endsWith("/") || file.contains("/?") || file.endsWith(".zip") || file.contains(".zip?") || file.endsWith(".ZIP") || surl.contains(".ZIP?")) {
                    int carotpos = this.editor.getCaretPosition();
                    this.setMessage("busy: getting filesystem completions.");
                    this.showCompletions(surl, carotpos);
                    break block34;
                }
                if (file.endsWith("/..")) {
                    logger.fine("jump to parent directory");
                    int carotpos = surl.lastIndexOf("/..");
                    carotpos = surl.lastIndexOf(47, carotpos - 1);
                    if (carotpos != -1) {
                        String sval = surl.substring(0, carotpos + 1);
                        this.dataSetSelector.getEditor().setItem(sval);
                        this.dataSetSelector.setSelectedItem(sval);
                        this.editor.setCaretPosition(carotpos + 1);
                        this.setTextInternal(sval);
                        this.maybePlotImmediately();
                    }
                    break block34;
                }
                try {
                    URI uri = DataSetURI.getURI(surl);
                    if (uri == null) {
                        this.setMessage("error: URI cannot be formed from \"" + surl + "\"");
                        return;
                    }
                    DataSourceFactory f = DataSetURI.getDataSourceFactory(uri, this.getMonitor());
                    if (f == null) {
                        SourceTypesBrowser browser = new SourceTypesBrowser();
                        URI resourceURI = DataSetURI.getResourceURI(surl);
                        if (resourceURI == null) {
                            this.showPluginsScreen();
                            return;
                        }
                        browser.getDataSetSelector().setValue(DataSetURI.fromUri(resourceURI));
                        int r = JOptionPane.showConfirmDialog(this, browser, "Select Data Source Type", 2);
                        if (r == 0) {
                            surl = browser.getUri();
                            this.setTextInternal(surl);
                            this.setValue(surl);
                            this.maybePlot(true);
                            return;
                        }
                        this.showPluginsScreen();
                        return;
                    }
                    TimeSeriesBrowse tsb = f.getCapability(TimeSeriesBrowse.class);
                    String tsbProblem = "";
                    if (tsb != null) {
                        try {
                            tsb.setURI(surl);
                            DatumRange tr = tsb.getTimeRange();
                            if (tr != null && tr.width().le(Units.seconds.createDatum(0))) {
                                tsbProblem = "<html>Unable to parse timerange in <br>" + surl + "<br>See http://autoplot.org/help#Time_Parsing_.2F_Formatting";
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException | ParseException ex) {
                            tsbProblem = "<html>Unable to parse: " + surl + "<br>See http://autoplot.org/help#Time_Parsing_.2F_Formatting";
                        }
                    }
                    if (tsbProblem.length() > 0) {
                        logger.warning(tsbProblem);
                    }
                    this.setMessage("busy: checking to see if uri looks acceptable");
                    ProgressMonitor mon = this.getMonitor();
                    ArrayList<String> problems = new ArrayList<String>();
                    if (f.reject(surl, problems, mon)) {
                        if (tsb != null && this.timeRange != null && UnitsUtil.isTimeLocation(this.timeRange.getUnits()) && !this.timeRange.equals(DataSourceUtil.DEFAULT_TIME_RANGE)) {
                            try {
                                tsb.setURI(surl);
                                tsb.setTimeRange(this.timeRange);
                                String suri = tsb.getURI();
                                problems.remove("no timerange provided");
                                if (!f.reject(suri, problems, mon)) {
                                    this.setMessage("accepted uri after setting timerange");
                                    int modifiers = this.keyModifiers;
                                    this.setValue(suri);
                                    this.keyModifiers = modifiers;
                                    this.firePlotDataSetURL();
                                    return;
                                }
                            }
                            catch (IllegalArgumentException | ParseException ex) {
                                JOptionPane.showMessageDialog(this.plotItButton, ex.getMessage());
                                this.setMessage(ex.getMessage());
                                logger.log(Level.SEVERE, ex.getMessage(), ex);
                                return;
                            }
                        }
                        this.setMessage("busy: uri rejected, inspecting resource for parameters");
                        this.browseSourceType(problems);
                        break block34;
                    }
                    if (mon.isCancelled()) {
                        this.setMessage("download cancelled");
                        return;
                    }
                    boolean bug1098 = true;
                    if (bug1098) {
                        if (tsb != null && this.timeRange != null && !this.timeRange.equals(DataSourceUtil.DEFAULT_TIME_RANGE) && UnitsUtil.isTimeLocation(this.timeRange.getUnits())) {
                            try {
                                tsb.setURI(surl);
                                if (tsb.getTimeRange() != null && !this.timeRange.equals(tsb.getTimeRange())) {
                                    this.timeRange = DataSetSelector.pickTimeRange((Component)SwingUtilities.getWindowAncestor(this), Arrays.asList(this.timeRange, tsb.getTimeRange()), Arrays.asList("Current", "URI"));
                                    tsb.setTimeRange(this.timeRange);
                                }
                                String suri = tsb.getURI();
                                logger.log(Level.FINE, "resetting timerange to {0}", this.timeRange);
                                this.setTextInternal(suri);
                            }
                            catch (ParseException ex) {
                                logger.log(Level.SEVERE, ex.getMessage(), ex);
                            }
                        }
                    } else {
                        logger.fine("bug1098 switch turned off, otherwise we would reset the timerange");
                    }
                    this.setMessage("busy: resolving uri to data set with plugin \"" + DataSourceRegistry.getInstance().describe(f, surl) + "\"");
                    this.firePlotDataSetURL();
                }
                catch (DataSetURI.NonResourceException ex) {
                    int carotpos = surl.length();
                    this.setMessage("no extension or mime type, try filesystem completions");
                    this.showCompletions(surl, carotpos);
                }
                catch (IllegalArgumentException | URISyntaxException ex) {
                    this.setMessage(ex.getMessage());
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    this.firePlotDataSetURL();
                }
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.setMessage(ex.getMessage());
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.setMessage("warning: " + ex.getMessage());
            }
        }
    }

    private void maybePlotImmediately() {
        final String surl = this.getValue();
        logger.log(Level.FINE, "maybePlotImmediately({0})", surl);
        if (surl.equals("")) {
            logger.finest("empty value, returning");
            return;
        }
        if (surl.startsWith("vap+internal:")) {
            this.firePlotDataSetURL();
            return;
        }
        if (this.checkActionTriggers(surl)) {
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    DataSetSelector.this.maybePlotImmediatelyOffEvent(surl);
                }
                finally {
                    DataSetSelector.this.pendingChanges.remove(DataSetSelector.this.PENDING_CHECKING_REJECT);
                }
            }
        };
        this.pendingChanges.put(this.PENDING_CHECKING_REJECT, this);
        RequestProcessor.invokeLater(run);
    }

    public void maybePlot(boolean allowModifiers) {
        logger.log(Level.FINE, "go {0}", this.getValue());
        if (!allowModifiers) {
            this.keyModifiers = 0;
        }
        this.pendingChanges.put(this.PENDING_GO, this);
        this.maybePlotTimer.restart();
    }

    public void maybePlot(int keyModifiers) {
        this.keyModifiers = keyModifiers;
        if ((keyModifiers & 8) == 8) {
            this.browseSourceType();
        } else {
            this.maybePlot(true);
        }
    }

    private void firePlotDataSetURL() {
        String value;
        this.pendingChanges.put(this.PENDING_PLOT, this);
        ArrayList<String> r = new ArrayList<String>(this.getRecent());
        this.lastValue = value = this.getValue();
        if (r.contains(value)) {
            r.remove(value);
        }
        r.add(value);
        while (r.size() > 20) {
            r.remove(0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActionEvent e = new ActionEvent(this, 123, "dataSetSelect", DataSetSelector.this.keyModifiers);
                DataSetSelector.this.fireActionListenerActionPerformed(e);
                DataSetSelector.this.pendingChanges.remove(DataSetSelector.this.PENDING_PLOT);
            }
        });
    }

    public static String maybeAddFileNotFound(String msg) {
        if (msg.startsWith("file:/") || msg.startsWith("http://") || msg.startsWith("https://")) {
            msg = "File not found: " + msg;
        }
        return msg;
    }

    private boolean maybeHandleException(Exception ex) {
        String msg = ex.getMessage();
        if (msg == null) {
            msg = ex.toString();
        }
        msg = msg.trim();
        if (ex instanceof FileNotFoundException && msg.length() == 0) {
            msg = FILE_NOT_FOUND;
        }
        if ((ex instanceof FileNotFoundException || ex.toString().contains("file not found") || ex.toString().contains("root does not exist")) && msg.length() > 0) {
            msg = DataSetSelector.maybeAddFileNotFound(msg);
            this.setMessage(msg);
            if (msg.startsWith("File not found: ")) {
                String[] ss = msg.split(":", 2);
                msg = "<html>" + ss[0] + ":<br>" + ss[1] + "</html>";
            }
            JOptionPane.showMessageDialog(this, msg, "No Such File", 2);
            return true;
        }
        if (ex instanceof HtmlResponseIOException) {
            JPanel r = new JPanel(new BorderLayout());
            final String link = ((HtmlResponseIOException)ex).getURL().toString();
            r.add((Component)new JLabel(" "), "North");
            r.add(new JLabel(msg));
            JPanel se = new JPanel(new BorderLayout());
            se.add((Component)new JButton(new AbstractAction("View Page"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    DataSourceUtil.openBrowser(link);
                }
            }), "East");
            r.add((Component)se, "South");
            JOptionPane.showMessageDialog(this, r, "Content is HTML", 2);
            this.setMessage("" + ex.getMessage());
            return true;
        }
        if (ex instanceof EmptyFileException) {
            JOptionPane.showMessageDialog(this, msg, "Empty File", 2);
            this.setMessage("" + ex.getMessage());
            return true;
        }
        if (ex instanceof UnrecognizedDataSourceException) {
            JOptionPane.showMessageDialog(this, "<html>Unable to find data source plugin for:<br>" + msg, "Unrecognized data source", 2);
            this.setMessage("" + ex.getMessage());
            return true;
        }
        return false;
    }

    DatumRange quantizeTimeRange(DatumRange tr) {
        DomainDivider dd = DomainDividerUtil.getDomainDivider(tr.min(), tr.max());
        while (dd.boundaryCount(tr.min(), tr.max()) < 50L) {
            dd = dd.finerDivider(false);
        }
        while (dd.boundaryCount(tr.min(), tr.max()) > 200L) {
            dd = dd.coarserDivider(false);
        }
        DatumRange maxR = dd.rangeContaining(tr.max());
        if (maxR.min().equals(tr.max())) {
            return DatumRangeUtil.union(dd.rangeContaining(tr.min()), maxR.min());
        }
        return DatumRangeUtil.union(dd.rangeContaining(tr.min()), maxR.max());
    }

    public void browseSourceType() {
        this.browseSourceType(new ArrayList<String>());
    }

    public void browseSourceType(final List<String> problems) {
        DataSourceEditorPanel edit;
        boolean wasRejected;
        String surl;
        block17: {
            surl = ((String)this.dataSetSelector.getEditor().getItem()).trim();
            logger.log(Level.FINE, "browseSourceType {0}", surl);
            for (Map.Entry<String, Action> e : this.browseTriggers.entrySet()) {
                String browseTriggerRegex = e.getKey();
                if (!Pattern.matches(browseTriggerRegex, surl)) continue;
                logger.finest("matches browse trigger");
                Action action = e.getValue();
                action.actionPerformed(new ActionEvent(this, 123, "dataSetSelect"));
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            wasRejected = false;
            try {
                edit = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.getURIValid(surl));
                if (edit != null && edit.reject(surl)) {
                    edit = null;
                    wasRejected = true;
                }
                if (edit != null) {
                    try {
                        Method m = edit.getClass().getDeclaredMethod("setExpertMode", Boolean.TYPE);
                        m.invoke((Object)edit, this.isExpertMode());
                    }
                    catch (NoSuchMethodException m) {}
                    break block17;
                }
                URISplit split = URISplit.parse(surl);
                if (!".vap".equals(split.ext)) {
                    if (split.ext != null) {
                        edit = new CompletionsDataSourceEditor();
                    }
                    break block17;
                }
                if (split.path.startsWith("file:")) {
                    String result = DataSetSelectorSupport.browseLocalVap(this, surl);
                    if (result != null) {
                        this.setValue(result);
                        this.maybePlot(false);
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                JOptionPane.showMessageDialog(this, "Unable to inspect .vap files");
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                edit = null;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                edit = null;
            }
        }
        if (edit != null) {
            final Window window = SwingUtilities.getWindowAncestor(this);
            final DataSourceEditorPanel fedit = edit;
            final String fsurl = surl;
            if (surl != null && surl.startsWith("vap+internal:")) {
                JOptionPane.showMessageDialog(window, "Internal URI cannot be edited");
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String surl = fsurl;
                    if (DataSetSelector.this.timeRange != null && UnitsUtil.isTimeLocation(DataSetSelector.this.timeRange.getUnits())) {
                        try {
                            TimeSeriesBrowse tsb;
                            DataSourceFactory dsf = DataSetURI.getDataSourceFactory(DataSetURI.getURI(surl), new NullProgressMonitor());
                            if (dsf != null && (tsb = dsf.getCapability(TimeSeriesBrowse.class)) != null && !DataSetSelector.this.timeRange.equals(DatumRangeUtil.parseTimeRangeValid("2010-01-01"))) {
                                tsb.setURI(surl);
                                DatumRange tr2 = DataSetSelector.this.timeRange instanceof OrbitDatumRange ? DataSetSelector.this.timeRange : DataSetSelector.this.quantizeTimeRange(DataSetSelector.this.timeRange);
                                tsb.setTimeRange(tr2);
                                surl = tsb.getURI();
                            }
                        }
                        catch (IOException | IllegalArgumentException | URISyntaxException | ParseException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    logger.log(Level.FINER, "browseSourceType after TSB {0}", surl);
                    try {
                        boolean proceed = fedit.prepare(surl, window, DataSetSelector.this.getMonitor("download file", "downloading file and preparing editor"));
                        if (!proceed) {
                            return;
                        }
                    }
                    catch (InterruptedIOException ex) {
                        DataSetSelector.this.setMessage("download cancelled");
                        return;
                    }
                    catch (Exception ex) {
                        if (!DataSetSelector.this.maybeHandleException(ex)) {
                            throw new RuntimeException(ex);
                        }
                        return;
                    }
                    finally {
                        DataSetSelector.this.setCursor(Cursor.getDefaultCursor());
                    }
                    fedit.setURI(surl);
                    fedit.markProblems(problems);
                    String fsurl2 = surl;
                    Runnable run = DataSetSelector.this.getURIReviewDialog(fsurl2, fedit, problems);
                    SwingUtilities.invokeLater(run);
                }
            };
            Thread thread = new Thread(run);
            thread.start();
        } else {
            int carotpos;
            this.setCursor(Cursor.getDefaultCursor());
            if (!wasRejected) {
                if (!surl.contains("?")) {
                    surl = surl + "?";
                }
                this.setValue(surl);
            }
            carotpos = (carotpos = surl.indexOf(63)) == -1 ? surl.length() : ++carotpos;
            surl = surl.substring(0, carotpos);
            this.showCompletions(surl, carotpos);
        }
    }

    private Runnable getURIReviewDialog(final String fsurl, final DataSourceEditorPanel fedit, final List<String> problems) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataSourceEditorDialog dialog;
                Window window = SwingUtilities.getWindowAncestor(DataSetSelector.this);
                String title = "Editing URI " + fsurl;
                if (window instanceof Frame) {
                    dialog = new DataSourceEditorDialog((Frame)window, (Component)fedit.getPanel(), true);
                } else if (window instanceof Dialog) {
                    dialog = new DataSourceEditorDialog((Dialog)window, (Component)fedit.getPanel(), true);
                } else {
                    throw new RuntimeException("parent windowAncestor type is not supported.");
                }
                dialog.setTitle(title);
                dialog.setProblems(problems);
                if (DataSetSelector.this.actionListenerList == null || DataSetSelector.this.actionListenerList.isEmpty() || !DataSetSelector.this.playButton) {
                    dialog.setPlayButton(false);
                } else {
                    dialog.setExpertMode(DataSetSelector.this.isExpertMode());
                }
                DataSetSelector.this.pendingChanges.put(DataSetSelector.this.PENDING_EDIT, DataSetSelector.this);
                WindowManager.getInstance().showModalDialog(dialog);
                if (!dialog.isCancelled()) {
                    String surl = fedit.getURI();
                    logger.log(Level.FINE, "dataSetSelector.setSelectedItem(\"{0}\");", surl);
                    DataSetSelector.this.dataSetSelector.setSelectedItem(surl);
                    boolean bug1098 = false;
                    if (bug1098) {
                        try {
                            DataSourceFactory dsf = DataSetURI.getDataSourceFactory(DataSetURI.getURI(surl), new NullProgressMonitor());
                            TimeSeriesBrowse tsb = dsf.getCapability(TimeSeriesBrowse.class);
                            tsb.setURI(surl);
                            DatumRange timeRangeNew = tsb.getTimeRange();
                            if (!timeRangeNew.equals(DataSetSelector.this.timeRange)) {
                                logger.log(Level.FINE, "resetting timerange to {0}", timeRangeNew);
                                DataSetSelector.this.timeRange = timeRangeNew;
                            }
                        }
                        catch (IOException | IllegalArgumentException | URISyntaxException | ParseException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    DataSetSelector.this.keyModifiers = dialog.getModifiers();
                    DataSetSelector.this.maybePlot(true);
                    DataSetSelector.this.pendingChanges.remove(DataSetSelector.this.PENDING_EDIT);
                } else {
                    DataSetSelector.this.setMessage("editor cancelled");
                    DataSetSelector.this.pendingChanges.remove(DataSetSelector.this.PENDING_EDIT);
                }
            }
        };
        return run;
    }

    public void showCompletions() {
        JTextField tf = (JTextField)this.dataSetSelector.getEditor().getEditorComponent();
        String surl = tf.getText();
        int carotpos = tf.getCaretPosition();
        this.setMessage("busy: getting completions");
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.showCompletions(surl, carotpos);
    }

    private void clearBusyIcon() {
        this.inspectButton.setIcon(FILEMAG_ICON);
    }

    private static void maybeClearVap(URISplit split) {
        if (split.vapScheme != null && split.vapScheme.equals("vap")) {
            split.vapScheme = null;
            split.formatCarotPos -= 4;
        }
    }

    private void showCompletions(String surl1, int carotpos1) {
        boolean sourceNeedsNoFile;
        logger.log(Level.FINE, "showCompletions({0},{1})", new Object[]{surl1, carotpos1});
        this.inspectButton.setIcon(BUSY_ICON);
        String surl2 = surl1.trim();
        int off = surl1.indexOf(surl2);
        String surl = surl2;
        int carotpos = Math.min(carotpos1 - off, surl2.length());
        URISplit split = URISplit.parse(surl, carotpos, true);
        if (surl1.startsWith("~")) {
            surl = split.resourceUri.toString();
            carotpos = split.resourceUriCarotPos;
        }
        if (surl.startsWith("vap ")) {
            surl = "vap+" + surl.substring(4);
        }
        boolean shortFsCompletion = carotpos < 6 && (surl.startsWith("/") || surl.length() > 1 && Character.isLetter(surl.charAt(0)) && surl.charAt(1) == ':');
        String ext = DataSetURI.getExt(surl);
        boolean haveSource = DataSourceRegistry.getInstance().hasSourceByExt(ext);
        boolean bl = sourceNeedsNoFile = ext != null && (ext.equals("inline") || ext.equals("cdaweb") || ext.equals("pdsppi"));
        if ((split.file == null || split.resourceUriCarotPos > split.file.length()) && haveSource || sourceNeedsNoFile) {
            this.showFactoryCompletions(surl, carotpos);
        } else if (carotpos == 0 || !surl.substring(0, carotpos).contains(":") && (carotpos < 4 && surl.substring(0, carotpos).equals("vap".substring(0, carotpos)) || surl.length() > 3 && surl.substring(0, 3).equals("vap"))) {
            this.showTypesCompletions(surl, carotpos);
        } else if (carotpos < 6 && !shortFsCompletion) {
            String home = "file://" + FileSystem.toCanonicalFolderName(System.getProperty("user.home"));
            String[] types = new String[]{"ftp://", "http://", "https://", "sftp://", "file:/", home};
            ArrayList<DataSetURI.CompletionResult> result = new ArrayList<DataSetURI.CompletionResult>();
            for (String type : types) {
                if (type.length() < carotpos || !surl.substring(0, carotpos).equals(type.substring(0, carotpos))) continue;
                result.add(new DataSetURI.CompletionResult(type, ""));
            }
            this.clearBusyIcon();
            this.showCompletionsGui("", result);
        } else if (surl.startsWith("vap") && surl.substring(0, carotpos).split("\\:", -2).length == 2) {
            String[] types = new String[]{"ftp://", "http://", "https://", "file:/", "sftp://"};
            String[] sp = surl.substring(0, carotpos).split("\\:", -2);
            String test = sp[1];
            int testCarotpos = carotpos - (sp[0].length() + 1);
            ArrayList<DataSetURI.CompletionResult> result = new ArrayList<DataSetURI.CompletionResult>();
            for (String type : types) {
                if (type.length() < testCarotpos || !test.substring(0, testCarotpos).equals(type.substring(0, testCarotpos))) continue;
                result.add(new DataSetURI.CompletionResult(sp[0] + ":" + type, ""));
            }
            this.clearBusyIcon();
            this.showCompletionsGui("", result);
        } else {
            int firstSlashAfterHost;
            if (split.scheme != null && split.scheme.equals("file")) {
                if (".vap".equals(split.ext) && split.resourceUriCarotPos > split.file.length()) {
                    this.showVapCompletions(URISplit.format(split), split.formatCarotPos);
                    return;
                }
                if (!surl.startsWith("vap")) {
                    DataSetSelector.maybeClearVap(split);
                }
                this.showFileSystemCompletions(URISplit.format(split), split.formatCarotPos);
                return;
            }
            if (!this.enableDataSource) {
                split.formatCarotPos = split.formatCarotPos - (split.vapScheme == null ? 0 : split.vapScheme.length() - 1);
                split.vapScheme = null;
            }
            int n = firstSlashAfterHost = split.authority == null ? 0 : split.authority.length();
            if (split.resourceUriCarotPos <= firstSlashAfterHost) {
                if (!surl.startsWith("vap")) {
                    DataSetSelector.maybeClearVap(split);
                }
                String doHost = URISplit.format(split);
                this.showHostCompletions(doHost, split.formatCarotPos);
            } else {
                if (!surl.startsWith("vap")) {
                    DataSetSelector.maybeClearVap(split);
                }
                this.showFileSystemCompletions(URISplit.format(split), split.formatCarotPos);
            }
        }
    }

    private void calcAndShowCompletions(Runnable run) {
        if (this.completionsRunnable != null) {
            this.completionsMonitor.cancel();
            this.completionsRunnable = null;
        }
        this.completionsMonitor = this.getMonitor();
        this.completionsMonitor.setLabel("getting completions");
        this.completionsRunnable = run;
        new Thread(this.completionsRunnable, "completionsThread").start();
    }

    private void showCompletionsGui(final String labelPrefix, List<DataSetURI.CompletionResult> completions) {
        CompletionsList.CompletionListListener listener = new CompletionsList.CompletionListListener(){

            @Override
            public void itemSelected(DataSetURI.CompletionResult s1) {
                if (s1 == DataSetURI.CompletionResult.SEPARATOR) {
                    return;
                }
                DataSetSelector.this.setValue(s1.completion);
                if (s1.maybePlot) {
                    DataSetSelector.this.maybePlot(true);
                }
            }
        };
        this.completionsPopupMenu = CompletionsList.fillPopupNew(completions, labelPrefix, new JScrollPopupMenu(), listener);
        this.setMessage("done getting completions");
        this.setCursor(Cursor.getPredefinedCursor(0));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int xpos2 = DataSetSelector.this.editor.getGraphics().getFontMetrics().stringWidth(labelPrefix);
                    BoundedRangeModel model = DataSetSelector.this.editor.getHorizontalVisibility();
                    int xpos = xpos2 - model.getValue();
                    xpos = Math.min(model.getExtent(), xpos);
                    if (DataSetSelector.this.dataSetSelector.isShowing()) {
                        DataSetSelector.this.completionsPopupMenu.show(DataSetSelector.this.dataSetSelector, xpos, DataSetSelector.this.dataSetSelector.getHeight());
                    } else {
                        JOptionPane.showMessageDialog(DataSetSelector.this.dataSetSelector, "<html>Completions for " + DataSetSelector.this.getValue() + "<br>are not available when the data set selector is not showing.</html>");
                    }
                    DataSetSelector.this.completionsRunnable = null;
                }
                catch (NullPointerException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        });
    }

    private void showTypesCompletions(final String surl, final int carotpos) {
        this.calcAndShowCompletions(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String labelPrefix = "";
                try {
                    List<DataSetURI.CompletionResult> completions = DataSetURI.getTypesCompletions(surl, carotpos, DataSetSelector.this.getMonitor());
                    DataSetSelector.this.showCompletionsGui(labelPrefix, completions);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>URI Syntax Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", 2);
                }
                finally {
                    DataSetSelector.this.clearBusyIcon();
                }
            }
        });
    }

    private void showHostCompletions(final String surl, final int carotpos) {
        this.calcAndShowCompletions(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<DataSetURI.CompletionResult> completions;
                ProgressMonitor mon = DataSetSelector.this.getMonitor();
                URISplit split = URISplit.parse(surl);
                String surlDir = split.path;
                boolean hasScheme = split.scheme != null;
                String labelPrefix = surlDir == null ? "" : surlDir;
                try {
                    completions = DataSetURI.getHostCompletions(surl, carotpos, mon);
                }
                catch (IOException ex) {
                    DataSetSelector.this.setMessage(ex.toString());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>I/O Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", 2);
                    return;
                }
                finally {
                    DataSetSelector.this.clearBusyIcon();
                }
                String doHost = surl.substring(0, carotpos);
                if (hasScheme && (doHost.endsWith(".gov") || doHost.endsWith(".edu") || doHost.endsWith(".com") || doHost.endsWith(".net"))) {
                    DataSetURI.CompletionResult extra = new DataSetURI.CompletionResult(doHost + "/", "explore this host");
                    boolean haveIt = false;
                    for (DataSetURI.CompletionResult completion : completions) {
                        if (!completion.completion.equals(extra.completion)) continue;
                        haveIt = true;
                    }
                    if (!haveIt) {
                        completions = new ArrayList<DataSetURI.CompletionResult>(completions);
                        completions.add(extra);
                    }
                }
                DataSetSelector.this.showCompletionsGui(labelPrefix, completions);
            }
        });
    }

    public void showFileSystemCompletions(final boolean suggestFsAgg, final boolean suggestFiles, final String acceptRegex) {
        final String surl = this.editor.getText();
        final int carotpos = this.editor.getCaretPosition();
        this.calcAndShowCompletions(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<DataSetURI.CompletionResult> completions;
                ProgressMonitor mon = DataSetSelector.this.getMonitor();
                String labelPrefix = surl.substring(0, carotpos);
                try {
                    completions = DataSetURI.getFileSystemCompletions(surl, carotpos, suggestFsAgg, suggestFiles, acceptRegex, mon);
                }
                catch (UnknownHostException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    DataSetSelector.this.setMessage("Unknown host: " + ex.getLocalizedMessage());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>Unknown host:<br>" + ex.getLocalizedMessage() + "</html>", "Unknown Host Exception", 2);
                    return;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    DataSetSelector.this.setMessage(ex.toString());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>I/O Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", 2);
                    return;
                }
                catch (URISyntaxException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    DataSetSelector.this.setMessage(ex.toString());
                    JOptionPane.showMessageDialog(DataSetSelector.this, "<html>URI Syntax Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", 2);
                    return;
                }
                finally {
                    DataSetSelector.this.clearBusyIcon();
                }
                int i2 = labelPrefix.lastIndexOf(47);
                if (i2 != -1) {
                    labelPrefix = labelPrefix.substring(0, i2 + 1);
                }
                DataSetSelector.this.showCompletionsGui(labelPrefix, completions);
            }
        });
    }

    private void mergeLocalIntoRemote(List<DataSetURI.CompletionResult> remote, List<DataSetURI.CompletionResult> local) {
        boolean sep = false;
        remote = new ArrayList<DataSetURI.CompletionResult>(remote);
        ArrayList<String> remoteLabels = new ArrayList<String>(remote.size());
        for (DataSetURI.CompletionResult remote1 : remote) {
            remoteLabels.add(remote1.completion);
        }
        for (DataSetURI.CompletionResult l : local) {
            if (remoteLabels.contains(l.completion)) {
                logger.log(Level.FINEST, "already contains {0}", l.completion);
                continue;
            }
            if (!sep && remote.size() > 0) {
                remote.add(DataSetURI.CompletionResult.SEPARATOR);
                sep = true;
            }
            remote.add(l);
            logger.log(Level.FINEST, "appending {0}", l.completion);
        }
    }

    private void showVapCompletions(final String format, final int formatCarotPos) {
        this.calcAndShowCompletions(new Runnable(){

            @Override
            public void run() {
                ArrayList<DataSetURI.CompletionResult> completions = new ArrayList<DataSetURI.CompletionResult>();
                completions.add(new DataSetURI.CompletionResult("timerange", "reset the timerange"));
                completions.add(new DataSetURI.CompletionResult("plots[0].yaxis.range", "reset the yaxis range"));
                DataSetSelector.this.showCompletionsGui(format.substring(0, formatCarotPos), completions);
            }
        });
    }

    private void showFileSystemCompletions(final String surl, final int carotpos) {
        logger.log(Level.FINE, "entering showFileSystemCompletions({0},{1})", new Object[]{surl, carotpos});
        this.calcAndShowCompletions(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<DataSetURI.CompletionResult> completions;
                ProgressMonitor mon = DataSetSelector.this.getMonitor();
                String labelPrefix = surl.substring(0, carotpos);
                String surll = surl;
                int carotposl = carotpos;
                try {
                    String atrigger = DataSetSelector.this.checkActionTrigger(surl);
                    if (atrigger != null) {
                        surll = surl.substring(atrigger.length() + 1);
                        carotposl = carotposl - atrigger.length() - 1;
                        completions = DataSetSelector.this.suggestFile.size() > 0 ? DataSetURI.getFileSystemCompletions(surll, carotposl, DataSetSelector.this.suggestFsAgg, DataSetSelector.this.suggestFile, DataSetSelector.this.acceptPattern, mon) : DataSetURI.getFileSystemCompletions(surll, carotposl, DataSetSelector.this.suggestFsAgg, DataSetSelector.this.suggestFiles, DataSetSelector.this.acceptPattern, mon);
                        for (DataSetURI.CompletionResult completion : completions) {
                            completion.completable = atrigger + ":" + completion.completable;
                            completion.completion = atrigger + ":" + completion.completion;
                            completion.maybePlot = false;
                        }
                    } else if (DataSetSelector.this.suggestFile.size() > 0) {
                        completions = DataSetURI.getFileSystemCompletions(surll, carotposl, DataSetSelector.this.suggestFsAgg, DataSetSelector.this.suggestFile, DataSetSelector.this.acceptPattern, mon);
                    } else {
                        completions = DataSetURI.getFileSystemCompletions(surll, carotposl, DataSetSelector.this.suggestFsAgg, DataSetSelector.this.suggestFiles, DataSetSelector.this.acceptPattern, mon);
                        if (completions.isEmpty() || surll.startsWith("http:") || surll.startsWith("ftp:")) {
                            List<DataSetURI.CompletionResult> compl1 = DataSetURI.getFileSystemCacheCompletions(surll, carotposl, DataSetSelector.this.suggestFsAgg, DataSetSelector.this.suggestFiles, DataSetSelector.this.acceptPattern, mon);
                            DataSetSelector.this.mergeLocalIntoRemote(completions, compl1);
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (ex.getMessage().startsWith("unsupported protocol")) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                        DataSetSelector.this.setMessage("Unknown host: " + ex.getLocalizedMessage());
                        DataSetSelector.showUserExceptionDialog(DataSetSelector.this, "<html>Unsupported Protocol:<br>" + surl + "</html>", "Unsupported Protocol", ex, 2);
                        return;
                    }
                    throw ex;
                }
                catch (UnknownHostException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    DataSetSelector.this.setMessage("Unknown host: " + ex.getLocalizedMessage());
                    DataSetSelector.showUserExceptionDialog(DataSetSelector.this, "<html>Unknown host:<br>" + ex.getLocalizedMessage() + "</html>", "Unknown Host Exception", ex, 2);
                    return;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    DataSetSelector.this.setMessage(ex.toString());
                    DataSetSelector.showUserExceptionDialog(DataSetSelector.this, "<html>I/O Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", ex, 2);
                    return;
                }
                catch (URISyntaxException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    DataSetSelector.this.setMessage(ex.toString());
                    DataSetSelector.showUserExceptionDialog(DataSetSelector.this, "<html>URI Syntax Exception occurred:<br>" + ex.getLocalizedMessage() + "</html>", "I/O Exception", ex, 2);
                    return;
                }
                finally {
                    DataSetSelector.this.clearBusyIcon();
                }
                int i2 = labelPrefix.lastIndexOf(47);
                if (i2 != -1) {
                    labelPrefix = labelPrefix.substring(0, i2 + 1);
                }
                DataSetSelector.this.showCompletionsGui(labelPrefix, completions);
            }
        });
    }

    public static void showUserExceptionDialog(Component parent, String msg, String title, final Exception ex, int messageType) {
        JPanel p = new JPanel();
        p.add((Component)new JLabel(msg), "Center");
        JPanel buttons = new JPanel();
        buttons.add((Component)new JButton(new AbstractAction("Details..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                JComponent c = (JComponent)e.getSource();
                JDialog dia = (JDialog)SwingUtilities.getWindowAncestor(c);
                dia.dispose();
                FileSystem.getExceptionHandler().handle(ex);
            }
        }), "East");
        p.add((Component)buttons, "South");
        JOptionPane.showMessageDialog(parent, p, title, messageType);
    }

    private void showFactoryCompletions(final String surl, final int carotpos) {
        logger.log(Level.FINE, "entering showFactoryCompletions({0},{1})", new Object[]{surl, carotpos});
        this.calcAndShowCompletions(new Runnable(){

            @Override
            public void run() {
                String labelPrefix;
                List<DataSetURI.CompletionResult> completions2;
                try {
                    completions2 = DataSetURI.getFactoryCompletions(surl, carotpos, DataSetSelector.this.completionsMonitor);
                    DataSetSelector.this.setMessage("done getting completions");
                    DataSetSelector.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Exception ex) {
                    if (!DataSetSelector.this.maybeHandleException(ex)) {
                        DataSetSelector.this.setMessage("" + ex.getClass().getName() + " " + ex.getMessage());
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                        throw new RuntimeException(ex);
                    }
                    return;
                }
                finally {
                    DataSetSelector.this.clearBusyIcon();
                }
                int n = Math.min(carotpos, DataSetSelector.this.editor.getText().length());
                try {
                    labelPrefix = DataSetSelector.this.editor.getText(0, n);
                }
                catch (BadLocationException ex) {
                    throw new RuntimeException(ex);
                }
                DataSetSelector.this.showCompletionsGui(labelPrefix, completions2);
            }
        });
    }

    public final void addCompletionKeys() {
        ActionMap map = this.dataSetSelector.getActionMap();
        map.put("complete", new AbstractAction("completionsPopup"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                String context = (String)DataSetSelector.this.dataSetSelector.getEditor().getItem();
                if (context == null) {
                    context = "";
                }
                for (String browseTriggerRegex : DataSetSelector.this.browseTriggers.keySet()) {
                    if (!Pattern.matches(browseTriggerRegex, context)) continue;
                    logger.finest("matches browse trigger");
                    Action action = DataSetSelector.this.browseTriggers.get(browseTriggerRegex);
                    action.actionPerformed(new ActionEvent(DataSetSelector.this, 123, "dataSetSelect"));
                    return;
                }
                DataSetSelector.this.showCompletions();
            }
        });
        map.put("plot", new AbstractAction("plotUrl"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                DataSetSelector.this.setValue(DataSetSelector.this.getEditor().getText());
                DataSetSelector.this.keyModifiers = ev.getModifiers();
                DataSetSelector.this.maybePlot(true);
            }
        });
        this.dataSetSelector.setActionMap(map);
        final JTextField tf = (JTextField)this.dataSetSelector.getEditor().getEditorComponent();
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                DataSetSelector.this.dataSetSelector.setSelectedItem(tf.getText());
                DataSetSelector.this.keyModifiers = ev.getModifiers();
                try {
                    DataSetSelector.this.setValue(DataSetSelector.this.getEditor().getText());
                    DataSetSelector.this.maybePlot(true);
                }
                catch (IllegalArgumentException ex) {
                    JOptionPane.showMessageDialog(DataSetSelector.this, ex.getMessage(), "Unable to parse URI", 2);
                }
            }
        });
        Set trav = Collections.emptySet();
        this.setFocusTraversalKeys(0, trav);
        this.setFocusTraversalKeys(1, trav);
        InputMap imap = SwingUtilities.getUIInputMap(this.dataSetSelector, 1);
        imap.put(KeyStroke.getKeyStroke(32, 2), "complete");
        imap.put(KeyStroke.getKeyStroke(9, 0), "complete");
        imap.put(KeyStroke.getKeyStroke(10, 2), "plot");
        imap.put(KeyStroke.getKeyStroke(10, 1), "plot");
        this.needToAddKeys = false;
    }

    public final void addAbouts() {
        String regex = "about:(.*)";
        this.registerActionTrigger("about:(.*)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String arg;
                LoggerManager.logGuiEvent(e);
                String ss = DataSetSelector.this.getValue();
                Pattern p = Pattern.compile("about:(.*)");
                Matcher m = p.matcher(ss);
                if (!m.matches()) {
                    throw new IllegalArgumentException("huh?");
                }
                switch (arg = m.group(1)) {
                    case "plugins": {
                        DataSetSelector.this.ABOUT_PLUGINS_ACTION.actionPerformed(e);
                        break;
                    }
                    case "classpath": {
                        try {
                            LoggerManager.logGuiEvent(e);
                            StringBuilder result = new StringBuilder("<html>");
                            ClassLoader cl = ClassLoader.getSystemClassLoader();
                            if (cl instanceof URLClassLoader) {
                                URL[] urls;
                                for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                                    result.append(url.toString()).append("<br>");
                                }
                            }
                            JTextPane jtp = new JTextPane();
                            jtp.setContentType("text/html");
                            jtp.read(new StringReader(result.toString()), null);
                            jtp.setEditable(false);
                            JScrollPane pane = new JScrollPane(jtp);
                            pane.setPreferredSize(new Dimension(640, 480));
                            pane.setVerticalScrollBarPolicy(22);
                            JOptionPane.showMessageDialog(DataSetSelector.this, pane);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(DataSetSelector.this, "about:plugins or about:classpath");
                    }
                }
            }
        });
    }

    private String checkActionTrigger(String surl) {
        for (String s : this.actionTriggers.keySet()) {
            String tr;
            int i;
            if (!surl.matches(s) || (i = s.indexOf(58)) <= -1 || !Ops.safeName(tr = s.substring(0, i)).equals(tr)) continue;
            return tr;
        }
        return null;
    }

    private void initComponents() {
        this.inspectButton = new JButton();
        this.plotItButton = new JButton();
        this.dataSetSelector = new JComboBox();
        this.setMaximumSize(new Dimension(1000, 27));
        this.inspectButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/fileMag.png")));
        this.inspectButton.setToolTipText("<html>Inspect this resource.<br>\nFor folder names, this enters the file system browser, or shows a list of remote folders.<br>\nFor files, this will enter an editor panel for the resource, or show a list of parameter options.<br>\n</html>\n\n");
        this.inspectButton.setMargin(new Insets(2, 2, 2, 2));
        this.inspectButton.setMaximumSize(new Dimension(27, 27));
        this.inspectButton.setMinimumSize(new Dimension(27, 27));
        this.inspectButton.setName("browse");
        this.inspectButton.setPreferredSize(new Dimension(27, 27));
        this.inspectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSetSelector.this.inspectButtonActionPerformed(evt);
            }
        });
        this.plotItButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/go.png")));
        this.plotItButton.setToolTipText("<html>Plot this data location, or URI.<br>\nCtrl modifier: plot the dataset by adding a new plot<br>\nShift modifier: plot the dataset as an overplot<br>\nAlt modifier: inspect this resource.<br>");
        this.plotItButton.setMaximumSize(new Dimension(27, 27));
        this.plotItButton.setMinimumSize(new Dimension(27, 27));
        this.plotItButton.setName("go");
        this.plotItButton.setPreferredSize(new Dimension(27, 27));
        this.plotItButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSetSelector.this.plotItButtonActionPerformed(evt);
            }
        });
        this.dataSetSelector.setEditable(true);
        this.dataSetSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"(application will put recent items here)"}));
        this.dataSetSelector.setToolTipText("Enter data source address");
        this.dataSetSelector.setMaximumSize(new Dimension(2000, 27));
        this.dataSetSelector.setMinimumSize(new Dimension(100, 27));
        this.dataSetSelector.setPreferredSize(new Dimension(300, 27));
        this.dataSetSelector.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                DataSetSelector.this.dataSetSelectorPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                DataSetSelector.this.dataSetSelectorPopupMenuCanceled(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.dataSetSelector, 0, 386, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.plotItButton, -2, 26, -2).addPreferredGap(0).add((Component)this.inspectButton, -2, 20, -2)));
        layout.linkSize(new Component[]{this.inspectButton, this.plotItButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.plotItButton, -1, -1, Short.MAX_VALUE).add((Component)this.inspectButton, -2, 20, -2).add((Component)this.dataSetSelector, -1, -1, Short.MAX_VALUE));
        layout.linkSize(new Component[]{this.dataSetSelector, this.inspectButton, this.plotItButton}, 2);
        this.inspectButton.getAccessibleContext().setAccessibleDescription("inspect contents of file or directory");
    }

    private void plotItButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.keyModifiers = evt.getModifiers();
        try {
            this.setValue(this.getEditor().getText());
            this.maybePlot(true);
        }
        catch (IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Unable to parse URI", 2);
        }
    }

    private void inspectButtonActionPerformed(ActionEvent evt) {
        block17: {
            LoggerManager.logGuiEvent(evt);
            String context = ((String)this.dataSetSelector.getEditor().getItem()).trim();
            if (context.startsWith("vap ")) {
                context = "vap+" + context.substring(4);
            }
            String ext = DataSetURI.getExt(context);
            final String fcontext = context;
            for (Map.Entry<String, Action> e : this.browseTriggers.entrySet()) {
                String browseTriggerRegex = e.getKey();
                if (!Pattern.matches(browseTriggerRegex, context)) continue;
                logger.finest("matches browse trigger");
                Action action = e.getValue();
                action.actionPerformed(new ActionEvent(this, 123, "dataSetSelect"));
                return;
            }
            if (this.enableDataSource && (context.trim().length() == 0 || context.trim().equals("vap+"))) {
                this.showCompletions();
            } else if (this.enableDataSource && (!context.contains("/?") && context.contains("?") || DataSourceRegistry.getInstance().hasSourceByExt(ext))) {
                this.browseSourceType();
            } else {
                final URISplit split = URISplit.parse(context);
                if (split.scheme != null && (split.scheme.equals("file") || split.scheme.equals("http") || split.scheme.equals("https") || split.scheme.equals("ftp") || split.scheme.equals("sftp"))) {
                    try {
                        if (FileSystemUtil.resourceExists(context) && FileSystemUtil.resourceIsFile(context)) {
                            if (!FileSystemUtil.resourceIsLocal(context)) {
                                Runnable run = new Runnable(){

                                    @Override
                                    public void run() {
                                        DasProgressPanel mon = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(DataSetSelector.this), "downloading " + split.file.substring(split.path.length()));
                                        try {
                                            FileSystemUtil.doDownload(fcontext, mon);
                                        }
                                        catch (IOException | URISyntaxException ex) {
                                            FileSystem.getExceptionHandler().handle(ex);
                                        }
                                        DataSetSelector.this.browseSourceType();
                                    }
                                };
                                RequestProcessor.invokeLater(run);
                            } else {
                                this.browseSourceType();
                            }
                            break block17;
                        }
                        if (split.scheme.equals("file")) {
                            JFileChooser chooser = new JFileChooser(new File(DataSetURI.toUri(split.path)));
                            chooser.setMultiSelectionEnabled(true);
                            int result = chooser.showOpenDialog(this);
                            if (result == 0) {
                                File[] ff = chooser.getSelectedFiles();
                                File f = chooser.getSelectedFile();
                                String suri = DataSetURI.newUri(context, f.toString());
                                if (ff.length > 1) {
                                    String asuri;
                                    String[] suris = new String[ff.length];
                                    for (int i = 0; i < suris.length; ++i) {
                                        suris[i] = DataSetURI.newUri(context, ff[i].toString());
                                    }
                                    suri = asuri = DataSourceUtil.makeAggregation(suri, suris);
                                }
                                this.setValue(suri);
                                this.maybePlot(false);
                            }
                            break block17;
                        }
                        this.showCompletions();
                    }
                    catch (IOException | URISyntaxException ex) {
                        FileSystem.getExceptionHandler().handle(ex);
                    }
                } else {
                    this.showCompletions();
                }
            }
        }
    }

    private void dataSetSelectorPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        if (!this.popupCancelled) {
            if ((this.keyModifiers & 8) == 8) {
                this.browseSourceType();
            } else {
                this.maybePlot(true);
            }
        }
        this.popupCancelled = false;
    }

    private void dataSetSelectorPopupMenuCanceled(PopupMenuEvent evt) {
        this.popupCancelled = true;
    }

    protected String getLastValue() {
        return this.lastValue;
    }

    public String getValue() {
        String val = (String)this.dataSetSelector.getEditor().getItem();
        if (val == null) {
            return "";
        }
        if (val.startsWith("file://") && val.length() > 7 && val.charAt(7) != '/') {
            val = "file:/" + val.substring(7);
        }
        return val.trim();
    }

    public void setValue(String value) {
        logger.log(Level.FINE, "setValue to \"{0}\"", value);
        if (value != null) {
            value = value.trim();
        }
        this.lastValue = value;
        if (value == null) {
            value = "";
        }
        value = URISplit.makeColloquial(value);
        this.setTextInternal(value);
    }

    public String getBrowseTypeExt() {
        return this.browseTypeExt;
    }

    public void setBrowseTypeExt(String browseTypeExt) {
        String oldBrowseTypeExt = this.browseTypeExt;
        this.browseTypeExt = browseTypeExt;
        this.firePropertyChange("browseTypeExt", oldBrowseTypeExt, browseTypeExt);
    }

    public boolean isHidePlayButton() {
        return this.hidePlayButton;
    }

    public void setHidePlayButton(boolean hidePlayButton) {
        boolean oldHidePlayButton = this.hidePlayButton;
        this.hidePlayButton = hidePlayButton;
        this.plotItButton.setVisible(!hidePlayButton);
        this.firePropertyChange(PROP_HIDEPLAYBUTTON, oldHidePlayButton, hidePlayButton);
    }

    public void replacePlayButton(Icon icon, AbstractAction action) {
        this.plotItButton.setAction(action);
        this.plotItButton.setIcon(icon);
        this.plotItButton.revalidate();
        this.plotItButton.setText("");
        this.plotItButton.setToolTipText(String.valueOf(action.getValue("Name")));
        this.plotItButton.setVisible(true);
        this.plotItButtonVisible = false;
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList();
        }
        this.actionListenerList.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionListenerActionPerformed(ActionEvent event) {
        ArrayList list;
        DataSetSelector dataSetSelector = this;
        synchronized (dataSetSelector) {
            if (this.actionListenerList == null) {
                return;
            }
            list = (ArrayList)this.actionListenerList.clone();
        }
        for (ActionListener list1 : list) {
            list1.actionPerformed(event);
        }
    }

    public List<String> getRecent() {
        if (this.recent == null) {
            this.recent = new ArrayList<String>();
        }
        return this.recent;
    }

    public void setRecent(List<String> recent) {
        List<String> oldRecent = this.recent;
        this.recent = recent;
        String value = this.editor.getText();
        ArrayList<String> r = new ArrayList<String>(recent);
        if (r.size() > 0 && !value.equals("(application will put recent items here)") && !r.get(r.size() - 1).equals(value)) {
            r.add(value);
        }
        Collections.reverse(r);
        this.dataSetSelector.setModel(new DefaultComboBoxModel<Object>(r.toArray()));
        this.support.refreshRecentFilesMenu();
        this.firePropertyChange(PROP_RECENT, oldRecent, recent);
        defaultRecent = recent;
    }

    public static void setDefaultRecent(List<String> recent) {
        defaultRecent = recent;
    }

    public static List<String> getDefaultRecent() {
        if (defaultRecent == null) {
            throw new IllegalArgumentException("defaultRecent has not been set");
        }
        return defaultRecent;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldMessage = this.message;
        this.message = message;
        this.firePropertyChange(PROPERTY_MESSAGE, oldMessage, message);
    }

    public boolean isPlotItButtonVisible() {
        return this.plotItButtonVisible;
    }

    public void setPlotItButtonVisible(boolean plotItButtonVisible) {
        boolean oldPlotItButtonVisible = this.plotItButtonVisible;
        this.plotItButtonVisible = plotItButtonVisible;
        this.plotItButton.setVisible(plotItButtonVisible);
        this.firePropertyChange(PROP_PLOTITBUTTONVISIBLE, oldPlotItButtonVisible, plotItButtonVisible);
    }

    public void registerActionTrigger(String regex, Action action) {
        this.actionTriggers.put(regex, action);
    }

    public void registerBrowseTrigger(String regex, Action action) {
        this.browseTriggers.put(regex, action);
    }

    public Action getOpenLocalAction() {
        return this.support.openLocalAction();
    }

    public Action getOpenLocalVapAction() {
        return this.support.openLocalVapAction();
    }

    public JMenu getRecentMenu() {
        return this.support.recentMenu();
    }

    public void setDisableDataSources(boolean b) {
        this.enableDataSource = !b;
    }

    public boolean isEnableDataSource() {
        return this.enableDataSource;
    }

    public void setEnableDataSource(boolean enableDataSource) {
        boolean oldEnableDataSource = this.enableDataSource;
        this.enableDataSource = enableDataSource;
        this.firePropertyChange(PROP_ENABLEDATASOURCE, oldEnableDataSource, enableDataSource);
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(DatumRange timerange) {
        DatumRange oldRange = this.timeRange;
        this.timeRange = timerange;
        this.firePropertyChange(PROP_TIMERANGE, oldRange, timerange);
    }

    public boolean isSuggestFsAgg() {
        return this.suggestFsAgg;
    }

    public void setSuggestFsAgg(boolean suggestFsAgg) {
        boolean oldSuggestFsAgg = this.suggestFsAgg;
        this.suggestFsAgg = suggestFsAgg;
        this.firePropertyChange(PROP_SUGGESTFSAGG, oldSuggestFsAgg, suggestFsAgg);
    }

    public boolean isSuggestFiles() {
        return this.suggestFiles;
    }

    public void setSuggestFiles(boolean suggestFiles) {
        boolean oldSuggestFiles = this.suggestFiles;
        this.suggestFiles = suggestFiles;
        this.firePropertyChange(PROP_SUGGESTFILES, oldSuggestFiles, suggestFiles);
    }

    public void addSuggestFile(String template) {
        this.suggestFile.add(template);
    }

    public String getAcceptPattern() {
        return this.acceptPattern;
    }

    public void setAcceptPattern(String acceptPattern) {
        this.acceptPattern = acceptPattern;
    }

    public void setPromptText(String text) {
        if (text == null) {
            throw new NullPointerException("Prompt text can't be null; use empty string instead.");
        }
        ((PromptTextField)this.getEditor()).setPromptText(text);
    }

    public String getPromptText() {
        return ((PromptTextField)this.getEditor()).getPromptText();
    }

    private void showPopup(MouseEvent e) {
        this.getPopupMenu().show(this.editor, e.getX(), e.getY());
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        JMenuItem cutItem = result.add(new DefaultEditorKit.CutAction());
        cutItem.setText("Cut");
        JMenuItem copyItem = result.add(new DefaultEditorKit.CopyAction());
        copyItem.setText("Copy");
        JMenuItem pasteItem = result.add(new DefaultEditorKit.PasteAction());
        pasteItem.setText("Paste");
        result.add(new JSeparator());
        JMenu fontMenu = new JMenu("Font Size");
        fontMenu.add(new AbstractAction("Big"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                Font f = DataSetSelector.this.getEditor().getFont();
                int size = 16;
                if (size > 4 && size < 18) {
                    Font nf = f.deriveFont((float)size);
                    DataSetSelector.this.dataSetSelector.setFont(nf);
                }
            }
        });
        fontMenu.add(new AbstractAction("Normal"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                Font f = DataSetSelector.this.getEditor().getFont();
                int size = DataSetSelector.this.getParent().getFont().getSize();
                if (size > 4 && size < 18) {
                    Font nf = f.deriveFont((float)size);
                    DataSetSelector.this.dataSetSelector.setFont(nf);
                }
            }
        });
        fontMenu.add(new AbstractAction("Small"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                Font f = DataSetSelector.this.getEditor().getFont();
                int size = 8;
                if (size > 4 && size < 18) {
                    Font nf = f.deriveFont((float)size);
                    DataSetSelector.this.dataSetSelector.setFont(nf);
                }
            }
        });
        result.add(fontMenu);
        if (this.alternatePeerCard != null) {
            result.add(new JSeparator());
            result.add(new AbstractAction(this.alternatePeer){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    LoggerManager.logGuiEvent(ev);
                    Container trp = DataSetSelector.this.getParent();
                    if (trp.getLayout() instanceof CardLayout) {
                        DataSetSelector.this.setCardSelected(false);
                    }
                }
            });
        }
        return result;
    }

    public boolean isCardSelected() {
        return this.cardSelected;
    }

    public void setCardSelected(boolean cardSelected) {
        boolean oldCardSelected = this.cardSelected;
        this.cardSelected = cardSelected;
        this.firePropertyChange(PROP_CARDSELECTED, oldCardSelected, cardSelected);
    }

    public void setCardSelectedNoEventKludge(boolean cardSelected) {
        boolean oldCardSelected = this.cardSelected;
        this.cardSelected = cardSelected;
    }

    public static void main(String[] args) {
        DataSetSelectorDemo.main(args);
    }

    public void setAlternatePeer(String title, String card) {
        this.alternatePeer = title;
        this.alternatePeerCard = card;
    }

    private boolean isExpertMode() {
        return this.expertMode;
    }

    public void setExpertMode(boolean expert) {
        this.getEditor().setEditable(expert);
        this.getEditor().setEnabled(expert);
        this.expertMode = expert;
        if (expert) {
            this.plotItButton.setToolTipText("<html>Plot this data location, or URI.<br> Ctrl modifier: plot the dataset by adding a new plot<br> Shift modifier: plot the dataset as an overplot<br> ");
        } else {
            this.plotItButton.setToolTipText("<html>Plot this data location, or URI.<br> ");
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.dataSetSelector.setEnabled(enabled);
        this.plotItButton.setEnabled(enabled);
        this.inspectButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public static DatumRange pickTimeRange(Component parent, DatumRange timeRange1, DatumRange timeRange2) {
        if (timeRange2 == null) {
            return timeRange1;
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(new JLabel("<html>The URI contains a time different than the application<br>time range.  Which should be used?</html>"));
        ButtonGroup bg = new ButtonGroup();
        String s1 = timeRange1.toString();
        JRadioButton b1 = new JRadioButton(s1);
        p.add(b1);
        bg.add(b1);
        bg.setSelected(b1.getModel(), true);
        String s2 = timeRange2.toString();
        JRadioButton b2 = new JRadioButton(s2);
        p.add(b2);
        bg.add(b2);
        JOptionPane.showMessageDialog(parent, p, "Which Range?", 3);
        if (b1.isSelected()) {
            LoggerManager.getLogger("gui").log(Level.FINE, "user picked first timerange {0}", s1);
            return timeRange1;
        }
        LoggerManager.getLogger("gui").log(Level.FINE, "user picked second timerange {0}", s2);
        return timeRange2;
    }

    public static DatumRange pickTimeRange(Component parent, List<DatumRange> timeRange, List<String> labels) {
        int i;
        timeRange = new ArrayList<DatumRange>(timeRange);
        labels = new ArrayList<String>(labels);
        for (int i2 = timeRange.size() - 1; i2 >= 0; --i2) {
            if (timeRange.get(i2) != null) continue;
            timeRange.remove(i2);
            labels.remove(i2);
        }
        if (timeRange.size() == 1) {
            return timeRange.get(0);
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(new JLabel("<html>The URI contains a time different than the current<br>application time range.  Which should be used?</html>"));
        ButtonGroup bg = new ButtonGroup();
        ArrayList<JRadioButton> buttons = new ArrayList<JRadioButton>();
        for (i = 0; i < timeRange.size(); ++i) {
            String s1 = "<html>" + timeRange.get(i).toString() + " <i>(" + labels.get(i) + ")";
            JRadioButton b1 = new JRadioButton(s1);
            p.add(b1);
            bg.add(b1);
            if (i == 0) {
                bg.setSelected(b1.getModel(), true);
            }
            buttons.add(b1);
        }
        JOptionPane.showMessageDialog(parent, p, "Which Range?", 3);
        for (i = 0; i < timeRange.size(); ++i) {
            if (!((JRadioButton)buttons.get(i)).isSelected()) continue;
            LoggerManager.getLogger("gui").log(Level.FINE, "user picked {0} timerange {1}", new Object[]{i, timeRange.get(i)});
            return timeRange.get(i);
        }
        return null;
    }
}

