/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.autoplot.datasource.DataSetURI;
import org.das2.util.LoggerManager;

public class CompletionsList {
    public static JPopupMenu fillPopupNew(List<DataSetURI.CompletionResult> completions, String labelprefix, JPopupMenu popupMenu, final CompletionListListener listener) {
        JMenu subMenu = null;
        int i = 0;
        while (i < completions.size()) {
            while (i < completions.size()) {
                JComponent menuItem;
                final DataSetURI.CompletionResult s1 = completions.get(i);
                if (s1 == DataSetURI.CompletionResult.SEPARATOR) {
                    menuItem = new JSeparator();
                } else {
                    String label = s1.label;
                    if (label.startsWith(labelprefix)) {
                        label = label.substring(labelprefix.length());
                    }
                    AbstractAction a = new AbstractAction(label){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            LoggerManager.logGuiEvent(ev);
                            listener.itemSelected(s1);
                        }
                    };
                    JMenuItem item = new JMenuItem(a);
                    if (s1.doc != null) {
                        item.setToolTipText(s1.doc);
                    }
                    if (!s1.label.endsWith("/") && s1.completion.contains("?") && s1.maybePlot) {
                        item.setIcon(new ImageIcon(CompletionsList.class.getResource("/org/autoplot/datasource/go-small.png")));
                    }
                    menuItem = item;
                }
                if (subMenu == null) {
                    popupMenu.add(menuItem);
                } else {
                    subMenu.add(menuItem);
                }
                ++i;
            }
            if (i >= completions.size()) continue;
            JMenu nextSubMenu = new JMenu("more");
            if (subMenu == null) {
                popupMenu.add(nextSubMenu);
            } else {
                subMenu.add(nextSubMenu);
            }
            subMenu = nextSubMenu;
        }
        if (completions.isEmpty()) {
            popupMenu.add("<html><i>(empty)</i></html>");
        }
        return popupMenu;
    }

    public static interface CompletionListListener {
        public void itemSelected(DataSetURI.CompletionResult var1);
    }
}

