/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.das2.util.filesystem.FileSystem;

public final class AutoplotSettings {
    private static final Logger logger = Logger.getLogger("apdss");
    private static AutoplotSettings instance;
    public static final String PREF_LAST_OPEN_FOLDER = "last_open_folder";
    public static final String PREF_RECENTLY_OPENED_FILES = "recently_opened_files";
    public static final String PREF_LAST_OPEN_VAP_FOLDER = "last_open_vap_folder";
    public static final String PREF_LAST_OPEN_VAP_FILE = "last_open_vap_file";
    PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof String) {
                prefs.put(evt.getPropertyName(), (String)evt.getNewValue());
            } else if (evt.getNewValue() instanceof Boolean) {
                prefs.putBoolean(evt.getPropertyName(), (Boolean)evt.getNewValue());
            } else {
                throw new RuntimeException("unsupported property type needs to be implemented: " + evt.getPropertyName() + "  " + evt.getNewValue().getClass());
            }
        }
    };
    static Preferences prefs;
    protected String autoplotData = "";
    public static final String PROP_AUTOPLOTDATA = "autoplotData";
    private String fscache = "";
    public static final String PROP_FSCACHE = "fscache";
    private String resolvedAutoplotData = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static synchronized AutoplotSettings settings() {
        if (instance == null) {
            instance = new AutoplotSettings();
        }
        return instance;
    }

    private AutoplotSettings() {
        try {
            prefs = this.getPreferences(AutoplotSettings.class);
            this.addPropertyChangeListener(this.listener);
            this.loadPreferences();
        }
        catch (Exception ex) {
            logger.warning("Problem encountered when attempting to load user preferences, continuing with autoplot_data in $HOME");
            this.autoplotData = "${HOME}/autoplot_data";
            this.fscache = this.autoplotData + "/fscache";
        }
    }

    public void loadPreferences() {
        this.autoplotData = prefs.get(PROP_AUTOPLOTDATA, "${HOME}/autoplot_data");
        String p = System.getProperty("AUTOPLOT_DATA");
        if (p != null) {
            logger.log(Level.WARNING, "AUTOPLOT_DATA system property used to set AUTOPLOT_DATA={0}", p);
            this.autoplotData = p;
        }
        this.fscache = prefs.get(PROP_FSCACHE, this.autoplotData + "/fscache");
        p = System.getProperty("AUTOPLOT_FSCACHE");
        if (p != null) {
            this.fscache = p;
        }
    }

    public Preferences getPreferences(Class c) {
        String s;
        switch (s = c.getPackage().getName()) {
            case "org.autoplot.dom": {
                s = "org.virbo.autoplot.dom";
                break;
            }
            case "org.autoplot": {
                s = "org.virbo.autoplot";
                break;
            }
            case "org.autoplot.scriptconsole": {
                s = "org.virbo.autoplot.scriptconsole";
                break;
            }
            case "org.autoplot.datasource": {
                s = "org.virbo.datasource";
                break;
            }
        }
        return Preferences.userRoot().node("/" + s.replace('.', '/'));
    }

    public String getAutoplotData() {
        return this.autoplotData;
    }

    public String getFscache() {
        return this.fscache;
    }

    public void setFscache(String val) {
        String old = this.fscache;
        if (old.equals(val)) {
            return;
        }
        String tval = val;
        tval = tval.replaceAll("\\$\\{HOME\\}", System.getProperty("user.home"));
        FileSystem.settings().setLocalCacheDir(new File(tval));
        this.fscache = val;
        String home = System.getProperty("user.home");
        if (val.startsWith(home)) {
            val = "${HOME}" + val.substring(home.length());
        }
        this.propertyChangeSupport.firePropertyChange(PROP_FSCACHE, old, val);
    }

    private static String maybeFixWindows(String n) {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return n.replace('\\', '/');
        }
        return n;
    }

    public String resolveProperty(String name) {
        if (name.equals(PROP_AUTOPLOTDATA)) {
            String l = this.resolvedAutoplotData;
            if (l != null) {
                return l;
            }
            String s = this.getAutoplotData().replace("${HOME}", AutoplotSettings.maybeFixWindows(System.getProperty("user.home")));
            File f = new File(s);
            f = f.getAbsoluteFile();
            this.resolvedAutoplotData = f.toString();
            return AutoplotSettings.maybeFixWindows(f.toString());
        }
        if (name.equals(PROP_FSCACHE)) {
            String result = this.getFscache();
            result = result.replace("${autoplotData}", this.resolveProperty(PROP_AUTOPLOTDATA));
            result = result.replace("${HOME}", AutoplotSettings.maybeFixWindows(System.getProperty("user.home")));
            return result;
        }
        throw new IllegalArgumentException("unable to resolve property: " + name);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

