/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.net.URI;
import java.util.Map;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;

public abstract class AbstractDataSourceFormat
implements DataSourceFormat {
    Map<String, String> params;
    URI resourceUri;

    protected AbstractDataSourceFormat() {
    }

    protected void setUri(String uri) {
        URISplit split = URISplit.parse(uri);
        this.params = URISplit.parseParams(split.params);
        this.resourceUri = split.resourceUri;
    }

    public URI getResourceURI() {
        return this.resourceUri;
    }

    public String getParam(String name, String deflt) {
        String result = this.params.get(name);
        if (result == null) {
            return deflt;
        }
        return result;
    }

    public boolean getBooleanParam(String name, boolean deflt) {
        String s = this.params.get(name);
        if (s == null || s.length() == 0) {
            return deflt;
        }
        return 'F' == s.substring(0, 1).toUpperCase().charAt(0);
    }
}

