/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.FilePollUpdating;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.Updating;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.CoerceUtil;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public abstract class AbstractDataSource
implements DataSource {
    protected static final Logger logger = Logger.getLogger("apdss");
    protected URI uri;
    protected URI resourceURI;
    protected Map<String, String> params;
    FilePollUpdating pollingUpdater;
    private HashMap<Class, Object> capabilities = new HashMap();

    public AbstractDataSource(URI uri) {
        this.uri = uri;
        String s = DataSetURI.fromUri(uri);
        if (!s.startsWith("vap")) {
            logger.fine("uri didn't start with vap!");
        }
        URISplit split = URISplit.parse(s);
        this.params = URISplit.parseParams(split.params);
        String f = split.file;
        if (split.scheme != null) {
            try {
                this.resourceURI = DataSetURI.toUri(f);
            }
            catch (Exception e) {
                logger.fine(e.toString());
            }
        }
    }

    protected String getExt(URL url) {
        try {
            return this.getExt(url.toURI());
        }
        catch (URISyntaxException e) {
            logger.fine("Failed to convert URL to URI.");
            return "";
        }
    }

    protected String getExt(URI uri) {
        String s = uri.getPath();
        int i = s.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return s.substring(i).toLowerCase();
    }

    @Override
    public abstract QDataSet getDataSet(ProgressMonitor var1) throws Exception;

    @Override
    public boolean asynchronousLoad() {
        return true;
    }

    public String toString() {
        return DataSetURI.fromUri(this.uri);
    }

    @Override
    public String getURI() {
        return DataSetURI.fromUri(this.uri);
    }

    protected File getFile(ProgressMonitor mon) throws IOException {
        if (this.resourceURI == null || this.resourceURI.toString().equals("")) {
            throw new IllegalArgumentException("expected file but didn't find one, check URI for question mark");
        }
        return this.getFile(this.resourceURI, mon);
    }

    protected File getFile(URI uri, ProgressMonitor mon) throws IOException {
        File f = DataSetURI.getFile(uri, mon);
        if (this.params.containsKey("filePollUpdates")) {
            int poll = (int)Double.parseDouble(this.params.get("filePollUpdates"));
            this.pollingUpdater = new FilePollUpdating(uri, poll);
            this.pollingUpdater.startPolling();
            this.capabilities.put(Updating.class, this.pollingUpdater);
        }
        return f;
    }

    protected File getFile(URL url, ProgressMonitor mon) throws IOException {
        File f = DataSetURI.getFile(url, mon);
        if (this.params.containsKey("filePollUpdates")) {
            try {
                int poll = (int)Double.parseDouble(this.params.get("filePollUpdates"));
                this.pollingUpdater = new FilePollUpdating(url.toURI(), poll);
                this.pollingUpdater.startPolling();
                this.capabilities.put(Updating.class, this.pollingUpdater);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(AbstractDataSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return f;
    }

    protected File getHtmlFile(URL url, ProgressMonitor mon) throws IOException {
        File f = DataSetURI.getHtmlFile(url, mon);
        if (this.params.containsKey("filePollUpdates")) {
            try {
                int poll = (int)Double.parseDouble(this.params.get("filePollUpdates"));
                this.pollingUpdater = new FilePollUpdating(url.toURI(), poll);
                this.pollingUpdater.startPolling();
                this.capabilities.put(Updating.class, this.pollingUpdater);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(AbstractDataSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return f;
    }

    protected Map<String, String> getParams() {
        logger.log(Level.FINER, "getParams()");
        return new LinkedHashMap<String, String>(this.params);
    }

    protected final String getParam(String name, String dflt) {
        logger.log(Level.FINER, "getParam(\"{0}\")", name);
        String result = this.params.get(name);
        if (result != null) {
            return result;
        }
        return dflt;
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        return new HashMap<String, Object>();
    }

    @Override
    public MetadataModel getMetadataModel() {
        return MetadataModel.createNullModel();
    }

    @Override
    public Map<String, Object> getProperties() {
        try {
            Map<String, Object> meta = this.getMetadata(new NullProgressMonitor());
            if (meta == null || this.getMetadataModel() == null) {
                logger.log(Level.FINE, "handling case where metadata or metadataModel is null: {0}, but this should be fixed.", this);
                meta = this.getMetadata(new NullProgressMonitor());
            }
            if (meta == null || this.getMetadataModel() == null) {
                return Collections.emptyMap();
            }
            return this.getMetadataModel().properties(meta);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "exception in getProperties", e);
            return Collections.singletonMap("Exception", e);
        }
    }

    private MutablePropertyDataSet applyFilter(MutablePropertyDataSet result, QDataSet parm, String op, QDataSet d) throws NoDataInIntervalException {
        block35: {
            QDataSet r;
            block33: {
                block36: {
                    double fill;
                    QDataSet r2;
                    block34: {
                        if (parm.rank() > 1 && parm.rank() < result.rank()) {
                            QDataSet[] operands = new QDataSet[2];
                            CoerceUtil.coerce(result, parm, false, operands);
                            parm = operands[1];
                        }
                        if (parm.rank() <= 1) break block33;
                        switch (op) {
                            case "gt": {
                                r2 = Ops.where(Ops.le(parm, d));
                                break;
                            }
                            case "lt": {
                                r2 = Ops.where(Ops.ge(parm, d));
                                break;
                            }
                            case "eq": {
                                r2 = Ops.where(Ops.ne(parm, d));
                                break;
                            }
                            case "ne": {
                                r2 = Ops.where(Ops.eq(parm, d));
                                break;
                            }
                            case "within": {
                                r2 = Ops.where(Ops.without(parm, d));
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("where can only contain .eq, .ne, .gt, or .lt");
                            }
                        }
                        fill = Double.NaN;
                        result = BufferDataSet.maybeCopy(result);
                        if (parm.rank() != 2 || result.rank() != 2) break block34;
                        for (int jj = 0; jj < r2.length(); ++jj) {
                            ((BufferDataSet)result).putValue((int)r2.value(jj, 0), (int)r2.value(jj, 1), fill);
                        }
                        break block35;
                    }
                    if (parm.rank() != 3 || result.rank() != 3) break block36;
                    for (int jj = 0; jj < r2.length(); ++jj) {
                        ((BufferDataSet)result).putValue((int)r2.value(jj, 0), (int)r2.value(jj, 1), (int)r2.value(jj, 2), fill);
                    }
                    break block35;
                }
                throw new IllegalArgumentException("where can only apply filter and dataset have same dimensions");
            }
            if (parm.rank() >= 2) break block35;
            switch (op) {
                case "gt": {
                    r = Ops.where(Ops.gt(parm, d));
                    break;
                }
                case "lt": {
                    r = Ops.where(Ops.lt(parm, d));
                    break;
                }
                case "eq": {
                    r = Ops.where(Ops.eq(parm, d));
                    break;
                }
                case "ne": {
                    r = Ops.where(Ops.ne(parm, d));
                    break;
                }
                case "within": {
                    r = Ops.where(Ops.within(parm, d));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("where can only contain .eq, .ne, .gt, or .lt");
                }
            }
            if (r.length() == 0) {
                throw new NoDataInIntervalException("'where' argument removes all data");
            }
            result = DataSetOps.applyIndex(result, 0, r, true);
            for (int ii = 1; ii < result.rank(); ++ii) {
                String sdep = "DEPEND_" + ii;
                QDataSet dep = (QDataSet)result.property(sdep);
                if (dep == null || dep.rank() != 2 || !DataSetUtil.isConstant(dep)) continue;
                result.putProperty(sdep, dep.slice(0));
            }
        }
        return result;
    }

    protected MutablePropertyDataSet doWhereFilter(String w, QDataSet parm, MutablePropertyDataSet result) throws NoDataInIntervalException, ParseException {
        Pattern p = Pattern.compile("\\.([elgn][qte])\\(");
        Matcher m = p.matcher(w);
        if (!m.find()) {
            Pattern p2 = Pattern.compile("\\.within\\(");
            Matcher m2 = p2.matcher(w);
            if (!m2.find()) {
                throw new IllegalArgumentException("where can only contain .eq, .ne, .gt, .lt, .within");
            }
            int ieq = w.indexOf(".within(");
            String sval = w.substring(ieq + 8).replaceAll("\\+", " ");
            if (sval.endsWith(")")) {
                sval = sval.substring(0, sval.length() - 1);
            }
            Units du = SemanticOps.getUnits(parm);
            DatumRange dr = DatumRangeUtil.parseDatumRange(sval, du);
            result = this.applyFilter(result, parm, "within", DataSetUtil.asDataSet(dr));
        } else {
            QDataSet d;
            int ieq = m.start();
            String op = m.group(1);
            String sval = w.substring(ieq + 4);
            if (sval.endsWith(")")) {
                sval = sval.substring(0, sval.length() - 1);
            }
            if ((parm = Ops.reform(parm)).rank() == 2) {
                if (sval.equals("mode") && (op.equals("eq") || op.equals("ne"))) {
                    QDataSet hash = Ops.hashcodes(parm);
                    QDataSet mode = Ops.mode(hash);
                    d = mode;
                    parm = hash;
                } else {
                    Units du = SemanticOps.getUnits(parm);
                    d = DataSetUtil.asDataSet(du.parse(sval));
                }
            } else if (parm.rank() == 1) {
                switch (sval) {
                    case "mode": {
                        QDataSet mode = Ops.mode(parm);
                        d = mode;
                        break;
                    }
                    case "median": {
                        QDataSet median = Ops.median(parm);
                        d = median;
                        break;
                    }
                    case "mean": {
                        QDataSet mean = Ops.mean(parm);
                        d = mean;
                        break;
                    }
                    default: {
                        Units du = SemanticOps.getUnits(parm);
                        d = DataSetUtil.asDataSet(du.parse(sval));
                        break;
                    }
                }
            } else {
                throw new IllegalArgumentException("param is rank>2");
            }
            result = this.applyFilter(result, parm, op, d);
        }
        return result;
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        return (T)this.capabilities.get(clazz);
    }

    public <T> void addCability(Class<T> clazz, T o) {
        this.capabilities.put(clazz, o);
    }

    public <T> void addCapability(Class<T> clazz, T o) {
        this.capabilities.put(clazz, o);
    }
}

