/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.das2Stream;

import java.io.File;
import java.io.FileOutputStream;
import java.util.LinkedHashMap;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.qds.QDataSet;
import org.das2.qstream.QdsToD2sStream;
import org.das2.qstream.StreamException;
import org.das2.util.monitor.ProgressMonitor;

public class Das2StreamDataSourceFormat
implements DataSourceFormat {
    public static String getVersion(String uri) {
        String sVer = URISplit.getParam(uri, "version", "2.2");
        if (sVer.equalsIgnoreCase("2.3-basic")) {
            return "2.3-basic";
        }
        return "2.2";
    }

    public static int getFracSeconds(String uri) {
        int nFracSec;
        String sVal = Integer.toString(3);
        String sFracSec = URISplit.getParam(uri, "fracsec", sVal);
        try {
            nFracSec = Integer.parseInt(sFracSec);
        }
        catch (NumberFormatException e) {
            nFracSec = 3;
        }
        return nFracSec;
    }

    public static int getSigDigits(String uri) {
        String sVal = URISplit.getParam(uri, "precision", null);
        int nSigDigit = 5;
        if (sVal != null) {
            try {
                nSigDigit = Integer.parseInt(sVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nSigDigit;
    }

    public static boolean getBinary(String uri) {
        String type = URISplit.getParam(uri, "type", "ascii");
        return type.equalsIgnoreCase("binary");
    }

    public static URISplit setOptions(URISplit lSplit, String version, boolean binary, int sigdigit, int fracsec) {
        if (lSplit == null) {
            return null;
        }
        LinkedHashMap<String, String> args = URISplit.parseParams(lSplit.params);
        if (binary) {
            args.put("type", "binary");
        } else {
            args.remove("type");
        }
        if (sigdigit == 5) {
            args.remove("precision");
        } else {
            args.put("precision", Integer.toString(sigdigit));
        }
        if (fracsec == 3) {
            args.remove("fracsec");
        } else {
            args.put("fracsec", Integer.toString(fracsec));
        }
        if (version.equalsIgnoreCase("2.2")) {
            args.remove("version");
        } else {
            args.put("version", version);
        }
        lSplit.params = URISplit.formatParams(args);
        return lSplit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatData(String url, QDataSet data, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse(url);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        boolean binary = Das2StreamDataSourceFormat.getBinary(url);
        int nSigDigit = Das2StreamDataSourceFormat.getSigDigits(url);
        int nFracSec = Das2StreamDataSourceFormat.getFracSeconds(url);
        String sVersion = Das2StreamDataSourceFormat.getVersion(url);
        try (FileOutputStream fo = null;){
            fo = new FileOutputStream(new File(split.resourceUri));
            QdsToD2sStream writer = binary ? new QdsToD2sStream(sVersion) : new QdsToD2sStream(sVersion, nSigDigit, nFracSec);
            if (!writer.write(data, fo)) {
                throw new StreamException("Dataset is rank 3 or otherwise incompatiable with the das2 stream format");
            }
        }
    }

    @Override
    public boolean canFormat(QDataSet ds) {
        QdsToD2sStream writer = new QdsToD2sStream("2.2");
        return writer.canWrite(ds);
    }

    @Override
    public String getDescription() {
        return "Das2 Stream data transfer format";
    }
}

