/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.das2Stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.autoplot.das2Stream.Das2StreamDataSource;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.MetadataModel;
import org.das2.qstream.QDataSetStreamHandler;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamTool;
import org.das2.util.monitor.ProgressMonitor;

public class Das2StreamDataSourceFactory
implements DataSourceFactory {
    @Override
    public DataSource getDataSource(URI uri) throws IOException {
        return new Das2StreamDataSource(uri);
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws IOException, StreamException {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME && DataSetURI.fromUri(cc.resourceURI).endsWith(".qds")) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "", this, "arg_0", "", "default dataset", true));
            Map<String, String> params = this.getNames(cc, mon);
            for (Map.Entry<String, String> e : params.entrySet()) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, e.getKey(), this, "arg_0", e.getValue(), null, true));
            }
        }
        return result;
    }

    public MetadataModel getMetadataModel(URL url) {
        return MetadataModel.createNullModel();
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        return false;
    }

    private Map<String, String> getNames(CompletionContext cc, ProgressMonitor mon) throws IOException, StreamException {
        File file = DataSetURI.getFile(cc.resourceURI, mon);
        QDataSetStreamHandler h = new QDataSetStreamHandler();
        h.setReadPackets(false);
        StreamTool.readStream(Channels.newChannel(new FileInputStream(file)), h);
        return h.getDataSetNamesAndDescriptions();
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        return null;
    }

    @Override
    public boolean supportsDiscovery() {
        return false;
    }
}

