/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.csv;

import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.util.monitor.ProgressMonitor;

public class CsvDataSourceFormat
implements DataSourceFormat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        char delim = ',';
        if (params.containsKey("delim")) {
            String sdelimiter = (String)params.get("delim");
            if (sdelimiter.equals("COMMA")) {
                sdelimiter = ",";
            }
            if (sdelimiter.equals("SEMICOLON")) {
                sdelimiter = ";";
            }
            delim = sdelimiter.charAt(0);
        }
        File f = new File(split.resourceUri);
        FileWriter fw = new FileWriter(f);
        CsvWriter writer = null;
        try {
            int j;
            writer = new CsvWriter((Writer)fw, delim);
            writer.setForceQualifier(true);
            writer.setUseTextQualifier(true);
            int col = 0;
            ArrayList<QDataSet> ldss = new ArrayList<QDataSet>();
            ArrayList<QDataSet> lwdss = new ArrayList<QDataSet>();
            if (data.property("DEPEND_0") != null) {
                ldss.add((QDataSet)data.property("DEPEND_0"));
                lwdss.add(DataSetUtil.weightsDataSet((QDataSet)data.property("DEPEND_0")));
                ++col;
            }
            ldss.add(data);
            lwdss.add(DataSetUtil.weightsDataSet(data));
            if (data.rank() == 1) {
                ++col;
            } else if (data.rank() == 2) {
                col += data.length(0);
            } else {
                throw new IllegalArgumentException("rank limit, data must be rank 1 sequence or a rank 2 table of data");
            }
            QDataSet[] dss = ldss.toArray(new QDataSet[ldss.size()]);
            QDataSet[] wdss = lwdss.toArray(new QDataSet[lwdss.size()]);
            String[] values = new String[col];
            String[] labels = new String[col];
            col = 0;
            for (int ids = 0; ids < dss.length; ++ids) {
                String u = (String)dss[ids].property("LABEL");
                if (u == null) {
                    u = (String)dss[ids].property("NAME");
                }
                if (u == null) {
                    u = "data" + ids;
                }
                if (dss[ids].rank() == 1) {
                    labels[col++] = u;
                    continue;
                }
                QDataSet dep1 = (QDataSet)dss[ids].property("DEPEND_1");
                if (dep1 != null && dep1.rank() == 1) {
                    Units dep1units = SemanticOps.getUnits(dep1);
                    for (j = 0; j < dss[ids].length(0); ++j) {
                        labels[col++] = dep1units.format(Datum.create(dep1.value(j), dep1units));
                    }
                    continue;
                }
                for (int j2 = 0; j2 < dss[ids].length(0); ++j2) {
                    labels[col++] = u + " " + j2;
                }
            }
            writer.writeRecord(labels);
            writer.setForceQualifier(false);
            writer.setUseTextQualifier(true);
            DatumFormatter[] formats = new DatumFormatter[dss.length];
            for (int ids = 0; ids < dss.length; ++ids) {
                Units u = SemanticOps.getUnits(dss[ids]);
                formats[ids] = u.getDatumFormatterFactory().defaultFormatter();
            }
            for (int i = 0; i < data.length(); ++i) {
                col = 0;
                for (int ids = 0; ids < dss.length; ++ids) {
                    Units u = SemanticOps.getUnits(dss[ids]);
                    if (dss[ids].rank() == 1) {
                        if (wdss[ids].value(i) == 0.0) {
                            values[col++] = "NaN";
                            continue;
                        }
                        values[col++] = formats[ids].format(u.createDatum(dss[ids].value(i)), u);
                        continue;
                    }
                    for (j = 0; j < dss[ids].length(0); ++j) {
                        values[col++] = wdss[ids].value(i, j) == 0.0 ? "NaN" : formats[ids].format(u.createDatum(dss[ids].value(i, j)), u);
                    }
                }
                writer.writeRecord(values);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            fw.close();
        }
    }

    @Override
    public boolean canFormat(QDataSet ds) {
        return ds.rank() == 1 || ds.rank() == 2;
    }

    @Override
    public String getDescription() {
        return "Comma Separated Values";
    }
}

