/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.csv;

import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.autoplot.csv.CsvDataSource;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.das2.util.monitor.ProgressMonitor;

public class CsvDataSourceFactory
implements DataSourceFactory {
    @Override
    public DataSource getDataSource(URI uri) throws Exception {
        return new CsvDataSource(uri);
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "column="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "bundle=", "read in more than one column to create a rank 2 bundle dataset."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "depend0="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "validMin=", "values less than this value are treated as fill."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "validMax=", "values greater than this value are treated as fill."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "delim=", "override the default delimiter (comma)."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "skipLines=", "skip this many lines before parsing"));
            return result;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String paramName = CompletionContext.get(CompletionContext.CONTEXT_PARAMETER_NAME, cc);
            if (paramName.equals("bundle")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", "number of columns to expect"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "Bx-Bz", "three named columns"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1:", "all but first column"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1:5", "second through 5th columns"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "-5:", "last five columns"));
                return result;
            }
            if (paramName.equals("delim")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, ",", "force comma delimiter"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, ";", "force semicolon delimiter"));
                return result;
            }
            if (paramName.equals("column")) {
                List<CompletionContext> result = this.getFieldNames(cc, mon);
                return result;
            }
            if (paramName.equals("depend0")) {
                List<CompletionContext> result = this.getFieldNames(cc, mon);
                return result;
            }
            if (paramName.equals("skip") || paramName.equals("skipLines")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", "number of lines to skip"));
                return result;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CompletionContext> getFieldNames(CompletionContext cc, ProgressMonitor mon) throws IOException {
        File f = DataSetURI.getFile(cc.resourceURI, mon);
        FileReader fr = new FileReader(f);
        CsvReader reader = null;
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        try {
            reader = new CsvReader((Reader)fr);
            String[] columnHeaders = CsvDataSourceFactory.getColumnHeaders(reader);
            for (int i = 0; i < columnHeaders.length; ++i) {
                String s;
                String label = s = columnHeaders[i];
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s, label, null));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            fr.close();
        }
        return result;
    }

    public static String[] getColumnHeaders(CsvReader reader) throws IOException {
        String peek;
        String[] newHeaders;
        String[] columnHeaders;
        if (reader.readHeaders()) {
            columnHeaders = reader.getHeaders();
        } else {
            columnHeaders = new String[reader.getColumnCount()];
            for (int i = 0; i < columnHeaders.length; ++i) {
                columnHeaders[i] = "field" + i;
            }
        }
        if (columnHeaders.length == 1 && (newHeaders = (peek = reader.getRawRecord()).split(";", -2)).length > 1) {
            for (int i = 0; i < newHeaders.length; ++i) {
                String s = newHeaders[i];
                if ((s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
                    s = s.substring(1, s.length() - 1);
                }
                newHeaders[i] = s;
            }
            columnHeaders = newHeaders;
            reader.setDelimiter(';');
        }
        return columnHeaders;
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        return false;
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        return null;
    }

    @Override
    public boolean supportsDiscovery() {
        return false;
    }
}

