/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.csv;

import com.csvreader.CsvReader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.csv.CsvDataSourceFactory;
import org.autoplot.csv.TableOps;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.SparseDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.AsciiParser;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class CsvDataSource
extends AbstractDataSource {
    private static final Logger logger = LoggerManager.getLogger("apdss.csv");

    public CsvDataSource(URI uri) {
        super(uri);
    }

    private QDataSet parseHeader(int icol, String header, String sval) {
        header = header.trim();
        DDataSet result = DDataSet.create(new int[0]);
        Units u = CsvDataSource.guessUnits(sval);
        if (u != Units.dimensionless) {
            result.putProperty("UNITS", u);
        }
        if (UnitsUtil.isTimeLocation(u)) {
            result.putProperty("NAME", "UTC");
        }
        if (header.length() == 0) {
            try {
                result.putValue(u.parse(sval).doubleValue(u));
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            return result;
        }
        Pattern p = Pattern.compile("([a-zA-Z0-9\\-\\+ ]*)(\\(([a-zA-Z-0-9\\-\\+ ]*)\\))?");
        Matcher m = p.matcher(header);
        if (m.matches()) {
            String label = m.group(1).trim();
            String sunits = m.group(3);
            if (header.length() > 0) {
                result.putProperty("NAME", Ops.safeName(label));
            }
            result.putProperty("LABEL", label);
            if (sunits != null) {
                result.putProperty("UNITS", SemanticOps.lookupUnits(sunits.trim()));
            }
        }
        return result;
    }

    private static Units guessUnits(String sval) {
        try {
            Units.dimensionless.parse(sval);
            return Units.dimensionless;
        }
        catch (ParseException ex) {
            logger.log(Level.FINER, "fails to parse as number: {0}", sval);
            try {
                AsciiParser.UNIT_UTC.parse(sval);
                return AsciiParser.UNIT_UTC;
            }
            catch (ParseException ex2) {
                logger.log(Level.FINER, "fails to parse as time: {0}", sval);
                return EnumerationUnits.create("enum");
            }
        }
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        int idep0column;
        int[] cols;
        int icolumn;
        InputStream in = DataSetURI.getInputStream(this.uri, mon);
        String sdelimiter = this.getParam("delim", ",");
        if (sdelimiter.equals("COMMA")) {
            sdelimiter = ",";
        }
        if (sdelimiter.equals("SEMICOLON")) {
            sdelimiter = ";";
        }
        char delimiter = sdelimiter.charAt(0);
        BufferedReader breader = new BufferedReader(new InputStreamReader(in));
        String skip = this.getParam("skipLines", "");
        if (skip.length() == 0) {
            skip = this.getParam("skip", "");
        }
        if (skip.length() > 0) {
            int iskip = Integer.parseInt(skip);
            for (int i = 0; i < iskip; ++i) {
                breader.readLine();
            }
        }
        CsvReader reader = new CsvReader((Reader)breader);
        if (delimiter != ',') {
            reader.setDelimiter(delimiter);
        }
        String[] columnHeaders = CsvDataSourceFactory.getColumnHeaders(reader);
        String column = this.getParam("column", null);
        if (column == null) {
            icolumn = -1;
        } else {
            icolumn = TableOps.columnIndex(column, columnHeaders);
            if (icolumn == -1) {
                throw new IllegalArgumentException("column not found: " + column);
            }
        }
        QDataSet icolumnDs = null;
        String bundle = this.getParam("bundle", null);
        if (bundle == null) {
            cols = null;
        } else {
            cols = TableOps.parseRangeStr(bundle, columnHeaders);
            icolumn = cols[0];
        }
        String time = this.getParam("time", null);
        String dep0column = this.getParam("depend0", time);
        if (dep0column == null) {
            idep0column = -1;
        } else {
            idep0column = TableOps.columnIndex(dep0column, columnHeaders);
            if (idep0column == -1) {
                throw new IllegalArgumentException("column not found: " + dep0column);
            }
        }
        QDataSet dep0ds = null;
        Units dep0u = Units.dimensionless;
        Units u = Units.dimensionless;
        Units[] columnUnits = null;
        double tb = 0.0;
        double cb = 0.0;
        double[] bundleb = null;
        if (cols != null) {
            bundleb = new double[cols[1] - cols[0]];
        }
        DataSetBuilder builder = bundleb != null ? new DataSetBuilder(2, 100, bundleb.length) : new DataSetBuilder(1, 100);
        DataSetBuilder tbuilder = new DataSetBuilder(1, 100);
        mon.setTaskSize(-1L);
        mon.started();
        int line = 0;
        double fill = 0.0;
        boolean needToCheckHeader = true;
        while (reader.readRecord()) {
            mon.setProgressMessage("read line " + ++line);
            if (columnUnits == null) {
                boolean foundColumnNumbers = false;
                columnUnits = new Units[reader.getColumnCount()];
                for (int j = 0; j < reader.getColumnCount(); ++j) {
                    columnUnits[j] = CsvDataSource.guessUnits(reader.get(j));
                    reader.get(0);
                    if (columnUnits[j] instanceof EnumerationUnits) continue;
                    foundColumnNumbers = true;
                }
                if (!foundColumnNumbers) {
                    logger.log(Level.FINER, "line appears to be a header: {0}", line);
                    columnUnits = null;
                }
                if (icolumn == -1) {
                    if (TimeUtil.isValidTime(reader.get(0)) && TimeUtil.isValidTime(reader.get(1)) && reader.getColumnCount() >= 2 && reader.getColumnCount() <= 5) {
                        builder = new DataSetBuilder(2, 100, reader.getColumnCount());
                        u = AsciiParser.UNIT_UTC;
                        bundleb = new double[reader.getColumnCount()];
                        icolumn = 0;
                    } else {
                        icolumn = reader.getColumnCount() - 1;
                    }
                }
                if (idep0column == -1 && reader.getColumnCount() == 2) {
                    idep0column = 0;
                }
                Units oldDep0u = dep0u;
                Units oldU = u;
                if (idep0column >= 0 && !(dep0u instanceof TimeLocationUnits)) {
                    dep0ds = this.parseHeader(idep0column, reader.getHeader(idep0column), reader.get(idep0column));
                    dep0u = SemanticOps.getUnits(dep0ds);
                }
                if (!(u instanceof TimeLocationUnits) && bundleb == null) {
                    icolumnDs = this.parseHeader(icolumn, reader.getHeader(icolumn), reader.get(icolumn));
                    u = SemanticOps.getUnits(icolumnDs);
                }
                if (columnUnits != null && (oldDep0u != dep0u || oldU != u)) {
                    builder = bundleb != null ? new DataSetBuilder(2, 100, bundleb.length) : new DataSetBuilder(1, 100);
                    tbuilder = new DataSetBuilder(1, 100);
                }
            }
            String badTimeTag = null;
            if (columnUnits != null) {
                try {
                    if (idep0column >= 0) {
                        tb = dep0u instanceof EnumerationUnits ? ((EnumerationUnits)dep0u).createDatum(reader.get(idep0column)).doubleValue(dep0u) : dep0u.parse(reader.get(idep0column)).doubleValue(dep0u);
                    }
                    if (bundleb != null) {
                        int validCount = 0;
                        for (int j = 0; j < bundleb.length; ++j) {
                            Units u1 = columnUnits[icolumn + j];
                            if (u1 instanceof EnumerationUnits) {
                                bundleb[j] = ((EnumerationUnits)u1).createDatum(reader.get(icolumn + j)).doubleValue(u1);
                                continue;
                            }
                            try {
                                bundleb[j] = u1.parse(reader.get(icolumn + j)).doubleValue(u1);
                                ++validCount;
                                continue;
                            }
                            catch (ParseException ex) {
                                if (UnitsUtil.isTimeLocation(u1)) {
                                    badTimeTag = reader.get(icolumn + j);
                                    bundleb[j] = fill = -1.0E38;
                                    continue;
                                }
                                bundleb[j] = fill = -1.0E38;
                            }
                        }
                        if (badTimeTag != null) {
                            String msg = "failed to parse timetag at line " + line + ": " + badTimeTag;
                            if (validCount == 0) {
                                badTimeTag = null;
                            }
                            throw new ParseException(msg, 0);
                        }
                    } else {
                        cb = u instanceof EnumerationUnits ? ((EnumerationUnits)u).createDatum(reader.get(icolumn)).doubleValue(u) : u.parse(reader.get(icolumn)).doubleValue(u);
                    }
                }
                catch (ParseException ex) {
                    if (badTimeTag != null) {
                        throw ex;
                    }
                    logger.log(Level.FINE, "skipping line: {0}", reader.getRawRecord());
                    continue;
                }
            }
            if (needToCheckHeader && columnUnits != null) {
                int icol;
                boolean yepItsData = true;
                double[] cbs = new double[columnUnits.length];
                for (icol = 0; icol < columnUnits.length; ++icol) {
                    try {
                        if (icol == 0 && columnHeaders[icol].length() > 1 && columnHeaders[icol].charAt(0) == '\ufeff') {
                            columnHeaders[icol] = columnHeaders[icol].substring(1);
                        }
                        Units u1 = columnUnits[icol];
                        if (columnHeaders.length <= icol) {
                            yepItsData = false;
                            continue;
                        }
                        if (u1 instanceof EnumerationUnits) {
                            cbs[icol] = ((EnumerationUnits)u1).createDatum(columnHeaders[icol]).doubleValue(u1);
                            continue;
                        }
                        cbs[icol] = u1.parse(columnHeaders[icol]).doubleValue(u1);
                        continue;
                    }
                    catch (ParseException ex) {
                        yepItsData = false;
                    }
                }
                if (yepItsData) {
                    if (idep0column >= 0) {
                        tbuilder.putValue(-1, cbs[idep0column]);
                        tbuilder.nextRecord();
                    }
                    if (bundleb != null) {
                        for (int j = 0; j < bundleb.length; ++j) {
                            builder.putValue(-1, j, cbs[icolumn + j]);
                        }
                        builder.nextRecord();
                    } else {
                        builder.putValue(-1, cbs[icolumn]);
                        builder.nextRecord();
                    }
                    for (icol = 0; icol < columnUnits.length; ++icol) {
                        columnHeaders[icol] = "field" + icol;
                    }
                }
                needToCheckHeader = false;
            }
            if (columnUnits == null) continue;
            if (idep0column >= 0) {
                tbuilder.putValue(-1, tb);
                tbuilder.nextRecord();
            }
            if (bundleb != null) {
                for (int j = 0; j < bundleb.length; ++j) {
                    builder.putValue(-1, j, bundleb[j]);
                }
                builder.nextRecord();
                continue;
            }
            builder.putValue(-1, cb);
            builder.nextRecord();
        }
        reader.close();
        mon.finished();
        if (line == 0) {
            throw new NoDataInIntervalException("file contains no data: " + this.uri);
        }
        DDataSet ds = builder.getDataSet();
        if (idep0column >= 0 && dep0ds != null) {
            DDataSet tds = tbuilder.getDataSet();
            tds.putProperty("UNITS", dep0u);
            tds.putProperty("NAME", dep0ds.property("NAME"));
            tds.putProperty("LABEL", dep0ds.property("LABEL"));
            ds.putProperty("DEPEND_0", tds);
        }
        if (bundleb != null) {
            SparseDataSet bds = SparseDataSet.createRankLen(2, bundleb.length);
            for (int j = 0; j < bundleb.length; ++j) {
                bds.putProperty("UNITS", j, columnUnits[j + icolumn]);
                bds.putProperty("LABEL", j, columnHeaders[j + icolumn]);
                bds.putProperty("NAME", j, Ops.safeName(columnHeaders[j + icolumn]));
            }
            ds.putProperty("BUNDLE_1", bds);
        } else {
            assert (icolumnDs != null);
            ds.putProperty("UNITS", u);
            ds.putProperty("NAME", icolumnDs.property("NAME"));
            ds.putProperty("LABEL", icolumnDs.property("LABEL"));
            if (fill == -1.0E38) {
                ds.putProperty("FILL_VALUE", fill);
            }
        }
        return ds;
    }
}

