/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cefdatasource;

import java.util.Arrays;
import java.util.Map;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.RankNDataSet;

public class ReformDataSet
extends AbstractDataSet
implements RankNDataSet {
    int dsLen1;
    int n0;
    int n1;
    int n2;
    int n3;
    int[] sizes;
    int offset;
    final int rank;
    final QDataSet ds;

    public ReformDataSet(QDataSet ds, int[] sizes) {
        this(ds, 0, sizes);
    }

    public ReformDataSet(QDataSet ds, int offset, int[] sizes) {
        QDataSet dep0;
        this.ds = ds;
        this.dsLen1 = ds.length(0);
        this.offset = offset;
        if (ds.rank() != 2) {
            throw new IllegalArgumentException("input rank must==2");
        }
        if (!Boolean.TRUE.equals(ds.property("QUBE"))) {
            throw new IllegalArgumentException("dataset must be marked as QUBE");
        }
        this.rank = sizes.length;
        this.sizes = Arrays.copyOf(sizes, sizes.length);
        if (this.rank > 4) {
            StringBuilder ssizes = new StringBuilder(10).append(sizes[0]);
            for (int i = 1; i < this.rank; ++i) {
                ssizes.append(",").append(sizes[i]);
            }
            throw new IllegalArgumentException(String.format("sizes=[%s] imply dataset with rank %d, which is not currently supported.", ssizes.toString(), this.rank));
        }
        this.n0 = sizes[0];
        if (this.rank > 1) {
            this.n1 = sizes[1];
        }
        if (this.rank > 2) {
            this.n2 = sizes[2];
        }
        if (this.rank > 3) {
            this.n3 = sizes[3];
        }
        if ((dep0 = (QDataSet)ds.property("DEPEND_0")) != null && sizes[0] == ds.length()) {
            this.putProperty("DEPEND_0", dep0);
        }
        DataSetUtil.putProperties(DataSetUtil.getProperties(ds), this);
        this.putProperty("DEPEND_1", null);
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public double value(int i) {
        return this.ds.value(i % this.dsLen1, i / this.dsLen1);
    }

    @Override
    public double value(int i0, int i1) {
        int i = this.offset + i0 * this.n1 + i1;
        return this.ds.value(i / this.dsLen1, i % this.dsLen1);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        int i = this.offset + i0 * this.n1 * this.n2 + i1 * this.n2 + i2;
        return this.ds.value(i / this.dsLen1, i % this.dsLen1);
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        int i = this.offset + i0 * this.n1 * this.n2 * this.n3 + i1 * this.n2 * this.n3 + i2 * this.n3 + i3;
        return this.ds.value(i / this.dsLen1, i % this.dsLen1);
    }

    @Override
    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return this.ds.property(name);
    }

    @Override
    public int length() {
        return this.n0;
    }

    @Override
    public int length(int i) {
        return this.n1;
    }

    @Override
    public int length(int i, int j) {
        return this.n2;
    }

    @Override
    public int length(int i, int j, int k) {
        return this.n3;
    }

    @Override
    public QDataSet slice(int dim) {
        int[] newSizes = new int[this.rank - 1];
        this.offset = dim;
        for (int i = 0; i < this.rank - 1; ++i) {
            newSizes[i] = this.sizes[i + 1];
            this.offset *= this.sizes[i + 1];
        }
        ReformDataSet result = new ReformDataSet(this.ds, this.offset, newSizes);
        Map<String, Object> props = DataSetOps.sliceProperties0(dim, DataSetUtil.getProperties(this));
        props = DataSetUtil.sliceProperties(this, dim, props);
        DataSetUtil.putProperties(props, result);
        return result;
    }
}

