/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cefdatasource;

import java.nio.ByteBuffer;
import java.text.ParseException;
import org.autoplot.cefdatasource.FieldParser;

public class IsoTimeParser
implements FieldParser {
    int decimalPlaces;
    int microsMult;
    byte[] cacheTag = new byte[10];
    long cacheMicros;

    public IsoTimeParser(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        this.microsMult = (int)Math.pow(10.0, 6 - decimalPlaces);
    }

    private int readPositiveInt(byte[] buf, int offset, int length) {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result = result * 10 + (buf[offset + i] - 48);
        }
        return result;
    }

    private long microsSince2000(int year, int month, int day) {
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029 - 2451545;
        return (long)jd * 86400000000L;
    }

    @Override
    public synchronized double parseField(ByteBuffer bbuf, int offset, int length) throws ParseException {
        byte[] buf = bbuf.array();
        boolean useCache = true;
        int fin = offset + length;
        while (offset < fin && Character.isWhitespace(buf[offset])) {
            ++offset;
        }
        if (offset + 20 + this.decimalPlaces > fin) {
            throw new ParseException(new String(buf, offset, length), 0);
        }
        for (int i = 0; useCache && i < 10; ++i) {
            if (buf[offset + i] == this.cacheTag[i]) continue;
            useCache = false;
        }
        if (!useCache) {
            int year = this.readPositiveInt(buf, offset, 4);
            int month = this.readPositiveInt(buf, offset + 5, 2);
            int day = this.readPositiveInt(buf, offset + 8, 2);
            for (int i = 0; i < 10; ++i) {
                this.cacheTag[i] = buf[offset + i];
            }
            this.cacheMicros = this.microsSince2000(year, month, day);
        }
        int hour = this.readPositiveInt(buf, offset + 11, 2);
        int minute = this.readPositiveInt(buf, offset + 14, 2);
        int second = this.readPositiveInt(buf, offset + 17, 2);
        int micros = this.microsMult * this.readPositiveInt(buf, offset + 20, this.decimalPlaces);
        long microsOffset = (long)hour * 3600000000L + (long)minute * 60000000L + (long)second * 1000000L + (long)micros;
        return this.cacheMicros + microsOffset;
    }
}

