/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cefdatasource;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.cefdatasource.Cef;
import org.das2.util.LoggerManager;

public class CefReaderHeader {
    private static final Logger logger = LoggerManager.getLogger("apdss.cef");
    private byte eol = (byte)10;

    private boolean cefReadHeadRec(ReadableByteChannel c, Record record) throws IOException {
        boolean status = false;
        boolean readFlag = true;
        StringBuilder recordBuf = new StringBuilder();
        boolean eofReached = false;
        byte[] buf = new byte[1];
        ByteBuffer b1 = ByteBuffer.wrap(buf);
        while (readFlag && !eofReached) {
            StringBuilder sbuf = new StringBuilder();
            do {
                b1.rewind();
                if (c.read(b1) == -1) {
                    eofReached = true;
                    break;
                }
                sbuf.append((char)buf[0]);
            } while (buf[0] != this.eol);
            String tempRecord = sbuf.toString();
            if ((tempRecord = tempRecord.trim()).length() > 0 && tempRecord.charAt(0) == '!') continue;
            if (tempRecord.length() > 0 && tempRecord.charAt(tempRecord.length() - 1) == '\\') {
                recordBuf.append(tempRecord.substring(0, tempRecord.length() - 1));
                continue;
            }
            recordBuf.append(tempRecord);
            if (recordBuf.length() > 0) {
                readFlag = false;
                status = true;
                record.data = recordBuf.toString();
                continue;
            }
            record.data = "";
        }
        return status;
    }

    private boolean cefSplitRec(String record, KeyValue kv) {
        boolean status = false;
        int pos = record.lastIndexOf(33);
        if (pos > -1) {
            record = record.substring(0, pos);
        }
        if ((pos = record.indexOf(61)) > -1) {
            status = true;
            kv.key = record.substring(0, pos).trim().toUpperCase();
            String val = record.substring(pos + 1).trim();
            if (val.charAt(0) == '\"') {
                String tab = new String(new byte[]{9});
                kv.val = val.substring(1, val.length() - 1).split("\"[ " + tab + "]*,[ " + tab + "]*\"");
            } else {
                kv.val = val.split(",");
                for (int i = 0; i < kv.val.length; ++i) {
                    kv.val[i] = kv.val[i].trim();
                }
            }
        }
        return status;
    }

    public Cef read(ReadableByteChannel c) throws IOException {
        Cef cef = new Cef();
        State state = State.TOP;
        int pdata = 0;
        int eCount = 0;
        GlobalStruct gStru = null;
        String gName = null;
        ParamStruct pStru = null;
        String pName = null;
        Record record = new Record();
        KeyValue kv = new KeyValue();
        while (state != State.DATA_READ && state != State.END && this.cefReadHeadRec(c, record) && (record.data.length() <= 2 || !record.data.startsWith("19") && !record.data.startsWith("20"))) {
            if (this.cefSplitRec(record.data, kv)) {
                String key = kv.key.intern();
                Object[] value = kv.val;
                switch (state) {
                    case TOP: {
                        if (key.equals("START_META")) {
                            state = State.GLOBAL;
                            gStru = new GlobalStruct();
                            gName = value[0];
                            gStru.valueType = "CHAR";
                            eCount = 0;
                            break;
                        }
                        if (key.equals("START_VARIABLE")) {
                            state = State.PARAM;
                            pName = value[0];
                            pStru = new ParamStruct();
                            pStru.name = value[0];
                            pStru.recType = 1;
                            break;
                        }
                        if (key.equals("INCLUDE")) {
                            throw new IllegalArgumentException("not yet supported");
                        }
                        if (key.equals("DATA_UNTIL")) {
                            state = State.DATA_READ;
                            break;
                        }
                        if (key.equals("FILE_NAME") || key.equals("FILE_FORMAT_VERSION")) break;
                        if (key.equals("END_OF_RECORD_MARKER")) {
                            cef.eor = (byte)((String)value[0]).charAt(0);
                            break;
                        }
                        throw new IllegalArgumentException("Unsupported key " + key);
                    }
                    case GLOBAL: {
                        if (value.length > 1) {
                            throw new IllegalArgumentException("Global entry not allowed multiple values per entry : " + gName);
                        }
                        if (key.equals("END_META")) {
                            state = State.TOP;
                            if (!kv.val[0].equals(gName)) {
                                throw new IllegalArgumentException("END_VARIABLE expected " + gName + "  got " + kv.val[0]);
                            }
                            ++cef.nglobal;
                            if (gStru.valueType.equals("CHAR")) {
                                cef.globals.put(gName, gStru);
                                break;
                            }
                            cef.globals.put(gName, gStru);
                            break;
                        }
                        if (key.equals("VALUE_TYPE")) {
                            gStru.valueType = value[0];
                            break;
                        }
                        if (key.equals("ENTRY")) {
                            if (eCount == 0) {
                                // empty if block
                            }
                            ++eCount;
                            break;
                        }
                        throw new IllegalArgumentException("Unsupported global key " + key);
                    }
                    case PARAM: {
                        if (key.equals("END_VARIABLE")) {
                            int[] data_idx;
                            int[] sizes = pStru.sizes;
                            if (sizes == null) {
                                pStru.sizes = new int[]{1};
                            }
                            if (pStru.recType == 0) {
                                data_idx = new int[]{-1, -1};
                            } else {
                                sizes = pStru.sizes;
                                int n = pStru.sizes[0];
                                for (int i = 1; i < sizes.length; ++i) {
                                    n *= sizes[i];
                                }
                                data_idx = new int[]{pdata, pdata + n - 1};
                                pdata += n;
                            }
                            pStru.cefFieldPos = data_idx;
                            state = State.TOP;
                            if (!((String)value[0]).equals(pStru.name)) {
                                throw new IllegalArgumentException("END_VARIABLE expected " + pName + "  got " + (String)value[0]);
                            }
                            ++cef.nparam;
                            cef.parameters.put(pName, pStru);
                            break;
                        }
                        if (key.equals("DATA")) {
                            pStru.entries.put(key, value);
                            pStru.recType = 0;
                            break;
                        }
                        if (key.equals("SIZES")) {
                            logger.log(Level.FINER, "{0}={1}", new Object[]{key, Arrays.toString(value)});
                            if (value.length > 1) {
                                String[] rev = new String[value.length];
                                for (int k = 0; k < value.length; ++k) {
                                    rev[k] = value[value.length - k - 1];
                                }
                                value = rev;
                            }
                            pStru.entries.put(key, value);
                            int[] isizes = new int[value.length];
                            for (int i = 0; i < value.length; ++i) {
                                isizes[i] = Integer.parseInt((String)value[i]);
                            }
                            pStru.sizes = isizes;
                            break;
                        }
                        pStru.entries.put(key, value[0]);
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Bad record?  " + record.data);
        }
        return cef;
    }

    protected static class GlobalStruct {
        String valueType;

        protected GlobalStruct() {
        }
    }

    protected static class KeyValue {
        String key;
        String[] val;

        protected KeyValue() {
        }
    }

    protected static class ParamStruct {
        String name;
        int[] sizes;
        int recType;
        int[] cefFieldPos;
        Map<String, Object> entries = new LinkedHashMap<String, Object>();

        protected ParamStruct() {
        }
    }

    protected static class Record {
        String data;

        protected Record() {
        }
    }

    private static enum State {
        TOP,
        END,
        DATA_READ,
        GLOBAL,
        PARAM;

    }
}

