/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cefdatasource;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.MetadataModel;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.util.LoggerManager;

public class CefMetadataModel
extends MetadataModel {
    private static final Logger logger = LoggerManager.getLogger("apdss.cef");

    private Double doubleValue(Object o, Units units) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Double) {
            return (double)((Double)o);
        }
        if (o instanceof Short) {
            return ((Short)o).doubleValue();
        }
        if (o instanceof String) {
            try {
                return units.parse((String)o).doubleValue(units);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("unable to parse " + o);
            }
        }
        throw new RuntimeException("Unsupported Data Type: " + o.getClass().getName());
    }

    private DatumRange getValidRange(Map attrs, Units units) {
        Double max = this.doubleValue(attrs.get("VALIDMAX"), units);
        Double min = this.doubleValue(attrs.get("VALIDMIN"), units);
        if (max == null || min == null) {
            return null;
        }
        return DatumRange.newDatumRange(min, max, units);
    }

    private DatumRange getRange(Map attrs, Units units) {
        double min = 0.0;
        double max = 0.0;
        if (attrs.containsKey("SCALEMIN") && attrs.containsKey("SCALEMAX")) {
            max = this.doubleValue(attrs.get("SCALEMAX"), units);
            min = this.doubleValue(attrs.get("SCALEMIN"), units);
        } else if (attrs.containsKey("SCALEMAX")) {
            max = this.doubleValue(attrs.get("SCALEMAX"), units);
            min = 0.0;
        } else if (attrs.containsKey("VALIDMAX")) {
            max = this.doubleValue(attrs.get("VALIDMAX"), units);
            min = this.doubleValue(attrs.get("VALIDMIN"), units);
        }
        if ("log".equals(this.getScaleType(attrs)) && min <= 0.0) {
            min = max / 10000.0;
        }
        if (min == max && max == 0.0) {
            return null;
        }
        DatumRange range = new DatumRange(min, max, units);
        return range;
    }

    private String getScaleType(Map attrs) {
        if (attrs.containsKey("SCALETYP")) {
            String type = (String)attrs.get("SCALETYP");
            return type.toLowerCase();
        }
        return null;
    }

    @Override
    public Map<String, Object> properties(Map<String, Object> attrs) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (attrs.containsKey("LABLAXIS")) {
            properties.put("LABEL", attrs.get("LABLAXIS"));
        }
        if (attrs.containsKey("CATDESC")) {
            properties.put("TITLE", attrs.get("CATDESC"));
        }
        if (attrs.containsKey("DISPLAY_TYPE")) {
            String type = (String)attrs.get("DISPLAY_TYPE");
            properties.put("RENDER_TYPE", type);
        }
        if (attrs.containsKey("FILLVAL")) {
            String sfill = (String)attrs.get("FILLVAL");
            properties.put("FILL_VALUE", Double.parseDouble(sfill));
        }
        Units units = Units.dimensionless;
        try {
            DatumRange range = this.getRange(attrs, units);
            if (range != null) {
                properties.put("TYPICAL_MIN", range.min().doubleValue(units));
                properties.put("TYPICAL_MAX", range.max().doubleValue(units));
            }
            if ((range = this.getValidRange(attrs, units)) != null) {
                properties.put("VALID_MIN", range.min().doubleValue(units));
                properties.put("VALID_MAX", range.max().doubleValue(units));
            }
            properties.put("SCALE_TYPE", this.getScaleType(attrs));
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        return properties;
    }

    @Override
    public String getLabel() {
        return "CEF";
    }
}

