/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cefdatasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.autoplot.cefdatasource.Cef;
import org.autoplot.cefdatasource.CefDataSource;
import org.autoplot.cefdatasource.CefReaderHeader;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.das2.util.monitor.ProgressMonitor;

public class CefDataSourceFactory
extends AbstractDataSourceFactory {
    @Override
    public DataSource getDataSource(URI uri) throws Exception {
        return new CefDataSource(uri);
    }

    private List<String> getPlottable(URI uri, ProgressMonitor mon) throws IOException {
        String parameterType;
        CefReaderHeader.ParamStruct h1;
        File f = DataSetURI.getFile(uri, mon);
        ReadableByteChannel in = Channels.newChannel(new FileInputStream(f));
        CefReaderHeader reader = new CefReaderHeader();
        Cef cef = reader.read(in);
        Map<String, CefReaderHeader.ParamStruct> h = cef.parameters;
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, CefReaderHeader.ParamStruct> ee : h.entrySet()) {
            h1 = ee.getValue();
            parameterType = (String)h1.entries.get("PARAMETER_TYPE");
            if (parameterType == null || !parameterType.equals("Data")) continue;
            result.add(ee.getKey());
        }
        for (Map.Entry<String, CefReaderHeader.ParamStruct> ee : h.entrySet()) {
            h1 = ee.getValue();
            parameterType = (String)h1.entries.get("PARAMETER_TYPE");
            if (parameterType != null && parameterType.equals("Data")) continue;
            result.add(ee.getKey());
        }
        return result;
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            try {
                String surl = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
                List<String> plottable = this.getPlottable(DataSetURI.getResourceURI(surl), mon);
                for (String s : plottable) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, s, this, "arg_0", null, null, true));
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        return !surl.contains("?") || surl.indexOf("?") == surl.length() - 1;
    }
}

