/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cefdatasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.autoplot.cefdatasource.Cef;
import org.autoplot.cefdatasource.CefMetadataModel;
import org.autoplot.cefdatasource.CefReaderData;
import org.autoplot.cefdatasource.CefReaderHeader;
import org.autoplot.cefdatasource.ReformDataSet;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.URISplit;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.DasProgressMonitorReadableByteChannel;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class CefDataSource
extends AbstractDataSource {
    Cef cef;
    String dsid;

    public CefDataSource(URI uri) {
        super(uri);
        URISplit split = URISplit.parse(DataSetURI.fromUri(uri));
        String file = split.file.substring(split.path.length());
        int i = file.indexOf("__");
        this.dsid = i != -1 ? file.substring(0, i) : null;
    }

    @Override
    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        File f = DataSetURI.getFile(this.uri, (ProgressMonitor)new NullProgressMonitor());
        ReadableByteChannel c = Channels.newChannel(new FileInputStream(f));
        DasProgressMonitorReadableByteChannel cmon = new DasProgressMonitorReadableByteChannel(c, mon);
        cmon.setStreamLength(f.length());
        CefReaderHeader readerh = new CefReaderHeader();
        this.cef = readerh.read(cmon);
        String var = this.getParams().get("arg_0");
        MutablePropertyDataSet ds = null;
        MutablePropertyDataSet dsvar = this.createDataSet(var, ds, true, cmon);
        cmon.close();
        return dsvar;
    }

    @Override
    public synchronized Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        String var = this.getParams().get("arg_0");
        CefReaderHeader.ParamStruct param = this.cef.parameters.get(var);
        return this.getMetaData(param, mon);
    }

    public synchronized Map<String, Object> getMetaData(CefReaderHeader.ParamStruct param, ProgressMonitor mon) throws Exception {
        LinkedHashMap<String, Object> entries = new LinkedHashMap<String, Object>();
        for (int i = 0; i < 4; ++i) {
            String dep = (String)param.entries.get("DEPEND_" + i);
            if (dep == null || dep.equals("")) continue;
            Map<String, Object> depMeta = this.getMetaData(this.cef.parameters.get(dep), new NullProgressMonitor());
            entries.put("DEPEND_" + i, depMeta);
        }
        entries.putAll(param.entries);
        return entries;
    }

    private MutablePropertyDataSet createDataSet(String var, MutablePropertyDataSet tds, boolean doDeps, DasProgressMonitorReadableByteChannel cmon) throws IOException, NumberFormatException, ParseException {
        ArrayDataSet dds;
        int rank0;
        MutablePropertyDataSet ds;
        int i;
        double ceffill;
        CefReaderHeader.ParamStruct param = this.cef.parameters.get(var);
        if (param == null) {
            throw new IllegalArgumentException("no such dataset: " + var);
        }
        int collapseDim = 999;
        Units u = Units.dimensionless;
        double fill = u.getFillDouble();
        String sceffill = (String)param.entries.get("FILLVAL");
        String su = (String)param.entries.get("UNITS");
        if (su != null) {
            u = Units.lookupUnits(su);
        }
        if (!param.entries.get("VALUE_TYPE").equals("ISO_TIME")) {
            try {
                ceffill = sceffill != null ? Double.parseDouble(sceffill) : fill;
            }
            catch (NumberFormatException ex) {
                ceffill = fill;
            }
        } else {
            ceffill = fill;
        }
        if (tds == null) {
            CefReaderData readerd = new CefReaderData();
            for (int i2 = 0; i2 < 40000; ++i2) {
                readerd.skipParse(i2);
            }
            this.setParseFlags(this.cef, var, readerd);
            tds = readerd.cefReadData(cmon, this.cef);
        }
        if (param.cefFieldPos[0] == -1) {
            String[] data = (String[])param.entries.get("DATA");
            double[] ddata = new double[data.length];
            for (i = 0; i < data.length; ++i) {
                try {
                    ddata[i] = Double.parseDouble(data[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("format error in data of param.name=" + param.name + ": " + data[i]);
                }
            }
            ds = DDataSet.wrap(ddata);
            ds.putProperty("FILL_VALUE", ceffill);
            ds.putProperty("UNITS", u);
            this.getDeltaPlusDeltaMinus(param, tds, ds);
            this.setDsName(var, ds);
            rank0 = ds.rank();
        } else if (param.sizes.length > 1 || param.sizes[0] > 1) {
            if (tds == null) {
                DataSetBuilder result = new DataSetBuilder(2, 0, param.cefFieldPos[1] - param.cefFieldPos[0] + 1);
                ds = result.getDataSet();
            } else {
                ds = DataSetOps.leafTrim(tds, param.cefFieldPos[0], param.cefFieldPos[1] + 1);
            }
            dds = ArrayDataSet.copy(ds);
            dds.putProperty("UNITS", u);
            dds.putProperty("FILL_VALUE", ceffill);
            ds = dds;
            this.getDeltaPlusDeltaMinus(param, tds, ds);
            this.setDsName(var, ds);
            if (param.sizes.length >= 2) {
                int[] sizes = new int[param.sizes.length + 1];
                sizes[0] = ds.length();
                int ndim = sizes.length;
                for (int i3 = 1; i3 < sizes.length; ++i3) {
                    sizes[i3] = param.sizes[ndim - i3 - 1];
                }
                ds = new ReformDataSet(ds, sizes);
                rank0 = ds.rank();
            } else {
                rank0 = ds.rank();
            }
        } else {
            ds = tds == null ? DDataSet.createRank1(0) : DataSetOps.slice1(tds, param.cefFieldPos[0]);
            rank0 = ds.rank();
            dds = ArrayDataSet.copy(ds);
            dds.putProperty("UNITS", u);
            dds.putProperty("FILL_VALUE", ceffill);
            ds = dds;
            this.setDsName(var, ds);
        }
        if (param.entries.get("VALUE_TYPE").equals("ISO_TIME")) {
            ds.putProperty("UNITS", Units.us2000);
            if (DataSetUtil.isMonotonic(ds)) {
                ds.putProperty("MONOTONIC", Boolean.TRUE);
            }
        }
        int[] qube = DataSetUtil.qubeDims(ds);
        if (doDeps) {
            for (i = 0; i < rank0; ++i) {
                String s = (String)param.entries.get("DEPEND_" + i);
                if (s == null) continue;
                int newDim = i;
                if (i > collapseDim) {
                    newDim = i - 1;
                } else {
                    if (i >= collapseDim) continue;
                    newDim = i;
                }
                MutablePropertyDataSet dep0ds = this.createDataSet(s, tds, false, cmon);
                if (dep0ds.rank() > 1) {
                    QDataSet dp01 = (QDataSet)dep0ds.property("DEPEND_0");
                    QDataSet dp02 = (QDataSet)ds.property("DEPEND_0");
                    if (dp01 != null && dp02 != null && dp01.length() == dp02.length()) {
                        dep0ds = DataSetOps.slice0(dep0ds, 0);
                        dep0ds.putProperty("CONTEXT_0", null);
                        if (dep0ds.length() > qube[newDim]) {
                            dep0ds = DataSetOps.trim(dep0ds, 0, qube[newDim]);
                        }
                    }
                }
                ds.putProperty("DEPEND_" + newDim, dep0ds);
            }
        }
        if (param.entries.containsKey("COORDINATE_SYSTEM") && ds.length(0) == 3) {
            String type = (String)param.entries.get("COORDINATE_SYSTEM");
            int size = 3;
            if (size == 3) {
                EnumerationUnits units = EnumerationUnits.create(type);
                DDataSet dep1 = DDataSet.createRank1(3);
                dep1.putValue(0, units.createDatum("X").doubleValue(units));
                dep1.putValue(1, units.createDatum("Y").doubleValue(units));
                dep1.putValue(2, units.createDatum("Z").doubleValue(units));
                dep1.putProperty("UNITS", units);
                dep1.putProperty("COORDINATE_FRAME", type);
                ds.putProperty("DEPEND_1", dep1);
            }
        }
        try {
            Map<String, Object> m = this.getMetadata(new NullProgressMonitor());
            Map<String, Object> props = new CefMetadataModel().properties(m);
            DataSetUtil.putProperties(props, ds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ds;
    }

    private MutablePropertyDataSet makeMonotonic(MutablePropertyDataSet ds, int idim, QDataSet sort) {
        DDataSet cds;
        block15: {
            int[] qube;
            block16: {
                block14: {
                    if (idim > 2) {
                        throw new IllegalArgumentException("idim must be <=2 ");
                    }
                    if (ds.rank() > 3) {
                        throw new IllegalArgumentException("rank limit");
                    }
                    qube = DataSetUtil.qubeDims(ds);
                    qube[idim] = sort.length();
                    cds = DDataSet.create(qube);
                    DataSetUtil.putProperties(DataSetUtil.getProperties(ds), cds);
                    if (idim != 0) break block14;
                    for (int i = 0; i < qube[0]; ++i) {
                        if (ds.rank() > 1) {
                            for (int j = 0; j < qube[1]; ++j) {
                                if (ds.rank() > 2) {
                                    for (int k = 0; k < qube[2]; ++k) {
                                        double d = ds.value((int)sort.value(i), j, k);
                                        cds.putValue(i, j, k, d);
                                    }
                                    continue;
                                }
                                double d = ds.value((int)sort.value(i), j);
                                cds.putValue(i, j, d);
                            }
                            continue;
                        }
                        double d = ds.value((int)sort.value(i));
                        cds.putValue(i, d);
                    }
                    break block15;
                }
                if (idim != 1) break block16;
                for (int i = 0; i < qube[0]; ++i) {
                    for (int j = 0; j < qube[1]; ++j) {
                        if (ds.rank() > 2) {
                            for (int k = 0; k < qube[2]; ++k) {
                                double d = ds.value(i, (int)sort.value(j), k);
                                cds.putValue(i, j, k, d);
                            }
                            continue;
                        }
                        double d = ds.value(i, (int)sort.value(j));
                        cds.putValue(i, j, d);
                    }
                }
                break block15;
            }
            if (idim != 2) break block15;
            for (int i = 0; i < qube[0]; ++i) {
                for (int j = 0; j < qube[1]; ++j) {
                    for (int k = 0; k < qube[2]; ++k) {
                        double d = ds.value(i, j, (int)sort.value(k));
                        cds.putValue(i, j, k, d);
                    }
                }
            }
        }
        return cds;
    }

    private void setDsName(String var, MutablePropertyDataSet ds) {
        if (this.dsid != null && var.endsWith("__" + this.dsid)) {
            ds.putProperty("NAME", var.substring(0, var.length() - (this.dsid.length() + 2)));
        } else {
            ds.putProperty("NAME", var);
        }
    }

    private void setParseFlags(Cef cef, String var, CefReaderData readerd) {
        CefReaderHeader.ParamStruct param = cef.parameters.get(var);
        if (param.cefFieldPos[0] != -1) {
            for (int i = param.cefFieldPos[0]; i < param.cefFieldPos[1] + 1; ++i) {
                readerd.doParse(i);
            }
        }
        for (int i = 0; i < 4; ++i) {
            String s = (String)param.entries.get("DEPEND_" + i);
            if (s == null) continue;
            this.setParseFlags(cef, s, readerd);
        }
    }

    @Override
    public MetadataModel getMetadataModel() {
        return new CefMetadataModel();
    }

    private void getDeltaPlusDeltaMinus(CefReaderHeader.ParamStruct param, MutablePropertyDataSet tds, MutablePropertyDataSet ds) {
        String sdeltaPlus = (String)param.entries.get("DELTA_PLUS");
        String sdeltaMinus = (String)param.entries.get("DELTA_MINUS");
        Units units = SemanticOps.getUnits(ds);
        if (sdeltaMinus != null && sdeltaPlus != null) {
            logger.finest("handling DELTA_PLUS DELTA_MINUS");
            if (DataSourceUtil.isJavaDouble(sdeltaPlus) && DataSourceUtil.isJavaDouble(sdeltaMinus)) {
                ds.putProperty("DELTA_PLUS", Ops.putProperty(Ops.replicate(Double.parseDouble(sdeltaPlus), ds.length()), "UNITS", (Object)units.getOffsetUnits()));
                ds.putProperty("DELTA_MINUS", Ops.putProperty(Ops.replicate(Double.parseDouble(sdeltaMinus), ds.length()), "UNITS", (Object)units.getOffsetUnits()));
                return;
            }
        }
        if (sdeltaMinus != null && sdeltaPlus != null) {
            logger.finest("handling DELTA_PLUS DELTA_MINUS for time series");
            CefReaderHeader.ParamStruct p1 = this.cef.parameters.get(sdeltaPlus);
            if (p1.cefFieldPos[0] > -1 && p1.cefFieldPos[1] > -1) {
                MutablePropertyDataSet mds = DataSetOps.leafTrim(tds, p1.cefFieldPos[0], p1.cefFieldPos[1] + 1);
                if (p1.entries.containsKey("UNITS")) {
                    mds.putProperty("UNITS", Units.lookupUnits((String)p1.entries.get("UNITS")));
                }
                ds.putProperty("DELTA_PLUS", mds);
                p1 = this.cef.parameters.get(sdeltaMinus);
                mds = DataSetOps.leafTrim(tds, p1.cefFieldPos[0], p1.cefFieldPos[1] + 1);
                if (p1.entries.containsKey("UNITS")) {
                    mds.putProperty("UNITS", Units.lookupUnits((String)p1.entries.get("UNITS")));
                }
                ds.putProperty("DELTA_MINUS", mds);
            } else {
                logger.fine("unable to locate DELTA_PLUS and/or DELTA_MINUS variable for " + param.name);
            }
        }
    }
}

