/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import java.util.HashMap;
import java.util.Map;
import org.autoplot.cdf.TrArrayDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.WritableDataSet;

public final class TrFDataSet
extends TrArrayDataSet
implements WritableDataSet,
RankZeroDataSet {
    float[] back;
    int rank;
    int len0;
    int len1;
    int len2;
    int len3;
    private static final boolean RANGE_CHECK = false;
    public static final String version = "20090605";

    public static TrFDataSet createRank1(int len0) {
        return new TrFDataSet(1, len0, 1, 1, 1);
    }

    public static TrFDataSet createRank2(int len0, int len1) {
        return new TrFDataSet(2, len0, len1, 1, 1);
    }

    public static TrFDataSet createRank3(int len0, int len1, int len2) {
        return new TrFDataSet(3, len0, len1, len2, 1);
    }

    public static TrFDataSet createRank4(int len0, int len1, int len2, int len3) {
        return new TrFDataSet(4, len0, len1, len2, len3);
    }

    public static TrFDataSet create(int[] qube) {
        if (qube.length == 0) {
            return new TrFDataSet(0, 1, 1, 1, 1);
        }
        if (qube.length == 1) {
            return TrFDataSet.createRank1(qube[0]);
        }
        if (qube.length == 2) {
            return TrFDataSet.createRank2(qube[0], qube[1]);
        }
        if (qube.length == 3) {
            return TrFDataSet.createRank3(qube[0], qube[1], qube[2]);
        }
        if (qube.length == 4) {
            return TrFDataSet.createRank4(qube[0], qube[1], qube[2], qube[3]);
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static TrFDataSet wrap(float[] data, int[] qube) {
        if (qube.length == 0) {
            return new TrFDataSet(1, 1, 1, 1, 1, data);
        }
        if (qube.length == 1) {
            return new TrFDataSet(1, qube[0], 1, 1, 1, data);
        }
        if (qube.length == 2) {
            return new TrFDataSet(2, qube[0], qube[1], 1, 1, data);
        }
        if (qube.length == 3) {
            return new TrFDataSet(3, qube[0], qube[1], qube[2], 1, data);
        }
        if (qube.length == 4) {
            return new TrFDataSet(4, qube[0], qube[1], qube[2], qube[3], data);
        }
        throw new IllegalArgumentException("bad qube");
    }

    private TrFDataSet(int rank, int len0, int len1, int len2, int len3) {
        this(rank, len0, len1, len2, len3, new float[len0 * len1 * len2 * len3]);
    }

    private TrFDataSet(int rank, int len0, int len1, int len2, int len3, float[] back) {
        if (back == null) {
            throw new NullPointerException("back was null");
        }
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        DataSetUtil.addQube(this);
    }

    @Override
    protected Object getBack() {
        return this.back;
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public int length() {
        return this.len0;
    }

    @Override
    public int length(int i) {
        return this.len1;
    }

    @Override
    public int length(int i0, int i1) {
        return this.len2;
    }

    @Override
    public int length(int i0, int i1, int i2) {
        return this.len3;
    }

    @Override
    public double value() {
        float v = this.back[0];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0) {
        float v = this.back[i0];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0, int i1) {
        float v = this.back[i0 * this.len1 + i1];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0, int i1, int i2) {
        float v = this.back[i0 * this.len1 * this.len2 + i2 * this.len1 + i1];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        float v = this.back[i0 * this.len1 * this.len2 * this.len3 + i3 * this.len2 * this.len1 + i2 * this.len1 + i1];
        return v == this.fill ? this.dfill : (double)v;
    }

    @Override
    public void putValue(double value) {
        this.back[0] = (float)value;
    }

    @Override
    public void putValue(int i0, double value) {
        this.back[i0] = (float)value;
    }

    @Override
    public void putValue(int i0, int i1, double value) {
        this.back[i0 * this.len1 + i1] = (float)value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, double value) {
        this.back[i0 * this.len1 * this.len2 + i2 * this.len1 + i1] = (float)value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double value) {
        this.back[i0 * this.len1 * this.len2 * this.len3 + i3 * this.len1 * this.len2 + i2 * this.len1 + i1] = (float)value;
    }

    public void putLength(int len) {
        if (len > this.len0) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    @Override
    public String toString() {
        return DataSetUtil.toString(this);
    }

    @Override
    public void putProperty(String name, Object value) {
        super.putProperty(name, value);
        if (name.equals("FILL_VALUE")) {
            this.checkFill();
        }
    }

    protected static Map copyProperties(QDataSet ds) {
        QDataSet plane0;
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> srcProps = DataSetUtil.getProperties(ds);
        result.putAll(srcProps);
        for (i = 0; i < ds.rank(); ++i) {
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (dep == ds) {
                throw new IllegalArgumentException("dataset is dependent on itsself!");
            }
            if (dep == null) continue;
            result.put("DEPEND_" + i, TrFDataSet.copy(dep));
        }
        for (i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            result.put("PLANE_" + i, TrFDataSet.copy(plane0));
        }
        return result;
    }

    private static TrFDataSet ddcopy(TrFDataSet ds) {
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        float[] newback = new float[dsLength];
        System.arraycopy(ds.back, 0, newback, 0, dsLength);
        TrFDataSet result = new TrFDataSet(ds.rank, ds.len0, ds.len1, ds.len2, ds.len3, newback);
        result.properties.putAll(TrFDataSet.copyProperties(ds));
        if (result.properties.containsKey("FILL_VALUE")) {
            result.checkFill();
        }
        return result;
    }

    public static TrFDataSet maybeCopy(QDataSet ds) {
        if (ds instanceof TrFDataSet) {
            return (TrFDataSet)ds;
        }
        return TrFDataSet.copy(ds);
    }

    public static TrFDataSet copy(QDataSet ds) {
        TrFDataSet result;
        if (ds instanceof TrFDataSet) {
            return TrFDataSet.ddcopy((TrFDataSet)ds);
        }
        int rank = ds.rank();
        if (!DataSetUtil.isQube(ds)) {
            logger.fine("copy of non-qube to DDataSet, which must be qube");
        }
        switch (rank) {
            case 0: {
                result = TrFDataSet.createRank1(1);
                result.rank = 0;
                result.putValue(ds.value());
                break;
            }
            case 1: {
                result = TrFDataSet.createRank1(ds.length());
                for (int i = 0; i < ds.length(); ++i) {
                    result.putValue(i, ds.value(i));
                }
                break;
            }
            case 2: {
                int len1 = ds.length() == 0 ? 0 : ds.length(0);
                result = TrFDataSet.createRank2(ds.length(), len1);
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        result.putValue(i, j, ds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                int len1 = ds.length() == 0 ? 0 : ds.length(0);
                int len2 = len1 == 0 ? 0 : ds.length(0, 0);
                result = TrFDataSet.createRank3(ds.length(), len1, len2);
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            result.putValue(i, j, k, ds.value(i, j, k));
                        }
                    }
                }
                break;
            }
            case 4: {
                int len1 = ds.length() == 0 ? 0 : ds.length(0);
                int len2 = len1 == 0 ? 0 : ds.length(0, 0);
                int len3 = len2 == 0 ? 0 : ds.length(0, 0, 0);
                result = TrFDataSet.createRank4(ds.length(), len1, len2, len3);
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            for (int l = 0; l < ds.length(i, j, k); ++l) {
                                result.putValue(i, j, k, l, ds.value(i, j, k, l));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        result.properties.putAll(TrFDataSet.copyProperties(ds));
        return result;
    }

    public static TrFDataSet wrap(float[] back) {
        return new TrFDataSet(1, back.length, 1, 1, 1, back);
    }

    public static TrFDataSet wrapRank2(float[] back, int n1) {
        return new TrFDataSet(2, back.length / n1, n1, 1, 1, back);
    }

    public static TrFDataSet wrapRank3(float[] back, int n1, int n2) {
        return new TrFDataSet(3, back.length / (n1 * n2), n1, n2, 1, back);
    }

    public static TrFDataSet wrap(float[] back, int nx, int ny) {
        return new TrFDataSet(2, nx, ny, 1, 1, back);
    }

    public static TrFDataSet wrap(float[] back, int rank, int len0, int len1, int len2) {
        return new TrFDataSet(rank, len0, len1, len2, 1, back);
    }

    public static TrFDataSet wrap(float[] back, int rank, int len0, int len1, int len2, int len3) {
        return new TrFDataSet(rank, len0, len1, len2, len3, back);
    }

    private void joinProperties(TrFDataSet ds) {
        TrFDataSet djoin;
        QDataSet dep0;
        QDataSet dep1;
        int i;
        HashMap<String, TrFDataSet> result = new HashMap<String, TrFDataSet>();
        for (i = 0; i < 1; ++i) {
            dep1 = (QDataSet)ds.property("DEPEND_" + i);
            if (dep1 == null) continue;
            dep0 = (QDataSet)this.property("DEPEND_" + i);
            djoin = TrFDataSet.copy(dep0);
            TrFDataSet ddep1 = dep1 instanceof TrFDataSet ? (TrFDataSet)dep1 : TrFDataSet.copy(dep1);
            djoin.append(ddep1);
            result.put("DEPEND_" + i, djoin);
        }
        for (i = 0; i < 50 && (dep1 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            dep0 = (QDataSet)this.property("PLANE_" + i);
            djoin = TrFDataSet.copy(dep0);
            TrFDataSet dd1 = dep1 instanceof TrFDataSet ? (TrFDataSet)dep1 : TrFDataSet.copy(dep1);
            djoin.append(dd1);
            result.put("PLANE_" + i, djoin);
        }
        this.properties.putAll(result);
    }

    public static void copyElements(TrFDataSet src, int srcpos, TrFDataSet dest, int destpos, int len) {
        if (src.len1 != dest.len1 || src.len2 != dest.len2) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        TrFDataSet.copyElements(src, srcpos, dest, destpos, len * src.len1 * src.len2, false);
    }

    public static void copyElements(TrFDataSet src, int srcpos, TrFDataSet dest, int destpos, int len, boolean checkAlias) {
        if (checkAlias && src.len1 * src.len2 != dest.len1 * dest.len2) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        int srcpos1 = srcpos * src.len1 * src.len2;
        int destpos1 = destpos * dest.len1 * dest.len2;
        int len1 = len;
        System.arraycopy(src.back, srcpos1, dest.back, destpos1, len1);
    }

    public void join(TrFDataSet ds) {
        this.append(ds);
    }

    public void append(TrFDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != this.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        int myLength = this.len0 * this.len1 * this.len2 * this.len3;
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        float[] newback = new float[myLength + dsLength];
        System.arraycopy(this.back, 0, newback, 0, myLength);
        System.arraycopy(ds.back, 0, newback, myLength, dsLength);
        this.len0 += ds.len0;
        this.back = newback;
        this.joinProperties(ds);
    }

    @Override
    public QDataSet trim(int start, int end) {
        int nrank = this.rank;
        int noff1 = start * this.len1 * this.len2 * this.len3;
        int noff2 = end * this.len1 * this.len2 * this.len3;
        float[] newback = new float[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        TrFDataSet result = new TrFDataSet(nrank, end - start, this.len1, this.len2, this.len3, newback);
        Map<String, Object> props = DataSetUtil.getProperties(this);
        Map<String, Object> depProps = DataSetUtil.trimProperties(this, start, end);
        props.putAll(depProps);
        DataSetUtil.putProperties(props, result);
        return result;
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        if (clazz == WritableDataSet.class) {
            return (T)this;
        }
        return super.capability(clazz);
    }
}

