/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Units;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class CdfVirtualVars {
    private static final Logger logger = LoggerManager.getLogger("apdss.cdf");

    public static QDataSet execute(Map<String, Object> metadata, String function, List<QDataSet> args, ProgressMonitor mon) throws IllegalArgumentException {
        logger.log(Level.FINE, "implement virtual variable \"{0}\"", function);
        if (function.equalsIgnoreCase("sum_values")) {
            if (args.size() < 1) {
                throw new IllegalArgumentException("virtual variable function sum_values expects at least one argument");
            }
            QDataSet sum = args.get(0);
            for (int i = 1; i < args.size(); ++i) {
                sum = Ops.add(sum, args.get(i));
            }
            return sum;
        }
        if (function.equalsIgnoreCase("compute_magnitude")) {
            return CdfVirtualVars.computeMagnitude(args.get(0));
        }
        if (function.equalsIgnoreCase("convert_log10")) {
            return CdfVirtualVars.convertLog10(args.get(0));
        }
        if (function.equalsIgnoreCase("fftPower512")) {
            return Ops.fftPower(args.get(0), 512, mon);
        }
        if (function.equalsIgnoreCase("fftPower1024")) {
            return Ops.fftPower(args.get(0), 1024, mon);
        }
        if (function.equalsIgnoreCase("fftPower")) {
            if (args.size() != 2) {
                throw new IllegalArgumentException("virtual variable function fftPower expects two arguments");
            }
            QDataSet size = args.get(1);
            while (size.rank() > 0) {
                size = size.slice(0);
            }
            mon.setProgressMessage("apply FFT power");
            return Ops.fftPower(args.get(0), Ops.windowFunction(Ops.FFTFilterType.Hann, (int)size.value()), mon);
        }
        if (function.equalsIgnoreCase("fftPowerDelta512")) {
            QDataSet deltaT = args.get(1);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable(args.get(0));
            while (deltaT.rank() > 0) {
                deltaT = deltaT.slice(0);
            }
            waves.putProperty("DEPEND_1", Ops.multiply(deltaT, Ops.findgen(waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, 512, mon);
            return pow;
        }
        if (function.equalsIgnoreCase("fftPowerDelta1024")) {
            QDataSet deltaT = args.get(1);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable(args.get(0));
            while (deltaT.rank() > 0) {
                deltaT = deltaT.slice(0);
            }
            waves.putProperty("DEPEND_1", Ops.multiply(deltaT, Ops.findgen(waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, 1024, mon);
            return pow;
        }
        if (function.equalsIgnoreCase("fftPowerDelta2048")) {
            QDataSet deltaT = args.get(1);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable(args.get(0));
            while (deltaT.rank() > 0) {
                deltaT = deltaT.slice(0);
            }
            waves.putProperty("DEPEND_1", Ops.multiply(deltaT, Ops.findgen(waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, 2048, mon);
            return pow;
        }
        if (function.equalsIgnoreCase("fftPowerDeltaTranslation512")) {
            QDataSet deltaT = args.get(1);
            QDataSet translation = args.get(2);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable(args.get(0));
            waves.putProperty("DEPEND_1", Ops.multiply(deltaT.slice(0), Ops.findgen(waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, 512, mon);
            MutablePropertyDataSet poww = DataSetOps.makePropertiesMutable(pow);
            QDataSet trs1 = Ops.add((QDataSet)pow.property("DEPEND_1"), translation.slice(0));
            poww.putProperty("DEPEND_1", trs1);
            throw new IllegalArgumentException("fftPowerDeltaTranslation512 is untested");
        }
        if (function.equalsIgnoreCase("calc_p")) {
            return CdfVirtualVars.calcP(args);
        }
        if (function.equalsIgnoreCase("conv_pos1")) {
            return CdfVirtualVars.convPos(args, "ANG-GSE");
        }
        if (function.equalsIgnoreCase("alternate_view")) {
            return args.get(0);
        }
        if (function.equalsIgnoreCase("region_filt")) {
            ArrayDataSet real_data = ArrayDataSet.copy(args.get(0));
            QDataSet region_data = args.get(1);
            Number fill = (Number)metadata.get("FILL_VALUE");
            if (fill == null) {
                fill = Double.NaN;
            }
            for (int i = 0; i < real_data.length(); ++i) {
                if (region_data.value(i) == 1.0) continue;
                real_data.putValue(i, fill.doubleValue());
            }
            return real_data;
        }
        if (function.equalsIgnoreCase("apply_qflag")) {
            QDataSet quality_data = args.get(1);
            QDataSet data = args.get(0);
            String n = ((String)data.property("NAME")).toLowerCase();
            int channel = 0;
            switch (n) {
                case "flux_h": 
                case "sigma_h": {
                    channel = 0;
                    break;
                }
                case "flux_o": 
                case "sigma_o": {
                    channel = 1;
                    break;
                }
                case "flux_he_1": 
                case "sigma_he_1": {
                    channel = 2;
                    break;
                }
                case "flux_he_2": 
                case "sigma_he_2": {
                    channel = 3;
                    break;
                }
            }
            quality_data = Ops.slice1(quality_data, channel);
            QDataSet rBad = Ops.where(Ops.ge((Object)quality_data, 4));
            double fill = (Double)data.property("FILL_VALUE");
            WritableDataSet wdata = Ops.copy(data);
            for (int i = 0; i < rBad.length(); ++i) {
                for (int j = 0; j < data.length(i); ++j) {
                    for (int k = 0; k < data.length(i, j); ++k) {
                        wdata.putValue(i, j, k, fill);
                    }
                }
            }
            return wdata;
        }
        if (function.equalsIgnoreCase("apply_esa_qflag")) {
            ArrayDataSet esa_data = ArrayDataSet.copy(args.get(0));
            QDataSet quality_data = args.get(1);
            Number fill = (Number)metadata.get("FILL_VALUE");
            if (fill == null) {
                fill = Double.NaN;
            }
            int n = DataSetUtil.product(DataSetUtil.qubeDims(esa_data.slice(0)));
            for (int i = 0; i < quality_data.length(); ++i) {
                if (!(quality_data.value(i) > 0.0)) continue;
                if (esa_data.rank() == 1) {
                    esa_data.putValue(i, fill.doubleValue());
                    continue;
                }
                for (int j = 0; j < n; ++j) {
                    esa_data.putValue(i, j, fill.doubleValue());
                }
            }
            return esa_data;
        }
        throw new IllegalArgumentException("virtual variable function not implemented: " + function);
    }

    protected static QDataSet calcP(List<QDataSet> args) {
        DRank0DataSet coefficient = DataSetUtil.asDataSet(1.6726E-6);
        QDataSet V_GSE_p = args.get(0);
        QDataSet np = args.get(1);
        QDataSet pressure = Ops.multiply(Ops.multiply(coefficient, np), Ops.pow((Object)DataSetOps.slice1(V_GSE_p, 0), (Object)2));
        return pressure;
    }

    public static QDataSet convPos(List<QDataSet> args, String coordSys) {
        throw new IllegalArgumentException("not implemented");
    }

    protected static QDataSet alternateView(QDataSet burley) {
        return burley;
    }

    protected static QDataSet computeMagnitude(QDataSet burley) {
        return Ops.magnitude(burley);
    }

    protected static QDataSet convertLog10(QDataSet burley) {
        return Ops.log10(burley);
    }

    protected static QDataSet addSeconds(QDataSet burley, double seconds) {
        QDataSet dep0 = (QDataSet)burley.property("DEPEND_0");
        if (dep0 == null) {
            throw new IllegalArgumentException("DEPEND_0 not found");
        }
        dep0 = Ops.add(dep0, DataSetUtil.asDataSet(seconds, Units.seconds));
        ArrayDataSet result = ArrayDataSet.maybeCopy(burley);
        result.putProperty("DEPEND_0", dep0);
        return result;
    }

    public static boolean isSupported(String function) {
        List<String> functions = Arrays.asList("compute_magnitude", "convert_log10", "fftpowerdelta512", "fftpowerdelta1024", "fftpowerdelta2048", "fftpower", "fftPower512", "fftPower1024", "fftpowerdeltatranslation512", "alternate_view", "calc_p", "region_filt", "apply_esa_qflag", "apply_qflag", "sum_values");
        boolean supported = functions.contains(function.toLowerCase());
        logger.log(Level.FINE, "virtual variable function \"{0}\" is supported: {1}", new Object[]{function, supported});
        return supported;
    }
}

