/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.cdf.CdfVirtualVars;
import org.autoplot.cdf.TrArrayDataSet;
import org.autoplot.datasource.DataSourceUtil;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.Slice0DataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class CdfUtil {
    private static final Logger logger = LoggerManager.getLogger("apdss.cdf");

    private static String getTargetType(int type) {
        switch (type) {
            case 22: 
            case 31: 
            case 45: {
                return "double";
            }
            case 32: {
                return "double";
            }
            case 21: 
            case 44: {
                return "float";
            }
            case 14: {
                return "double";
            }
            case 8: 
            case 33: {
                return "long";
            }
            case 4: 
            case 12: {
                return "int";
            }
            case 2: 
            case 11: {
                return "short";
            }
            case 1: 
            case 41: {
                return "byte";
            }
            case 51: 
            case 52: {
                return "string";
            }
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static Object byteBufferType(int type) {
        switch (type) {
            case 22: 
            case 31: 
            case 45: {
                return BufferDataSet.DOUBLE;
            }
            case 21: 
            case 44: {
                return BufferDataSet.FLOAT;
            }
            case 14: {
                return BufferDataSet.DOUBLE;
            }
            case 8: 
            case 33: {
                return BufferDataSet.LONG;
            }
            case 4: 
            case 12: {
                return BufferDataSet.INT;
            }
            case 2: 
            case 11: {
                return BufferDataSet.SHORT;
            }
            case 1: 
            case 41: {
                return BufferDataSet.BYTE;
            }
            case 51: {
                return BufferDataSet.BYTE;
            }
            case 52: {
                return BufferDataSet.BYTE;
            }
            case 32: {
                return BufferDataSet.DOUBLE;
            }
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static ByteBuffer transpose(int recLenBytes, int[] qube, ByteBuffer byteBuffer, Object bbType) {
        if (qube.length < 3) {
            return byteBuffer;
        }
        ByteBuffer temp = ByteBuffer.allocate(recLenBytes);
        ByteBuffer result = ByteBuffer.allocate(recLenBytes * qube[0]);
        result.order(byteBuffer.order());
        int fieldBytes = BufferDataSet.byteCount(bbType);
        switch (qube.length) {
            case 3: {
                int len1 = qube[1];
                int len2 = qube[2];
                for (int i0 = 0; i0 < qube[0]; ++i0) {
                    for (int i1 = 0; i1 < qube[1]; ++i1) {
                        for (int i2 = 0; i2 < qube[2]; ++i2) {
                            int iin = fieldBytes * (i1 * len2 + i2);
                            int iout = fieldBytes * (i0 * len1 * len2 + i2 * len1 + i1);
                            for (int j = 0; j < fieldBytes; ++j) {
                                temp.put(iin + j, byteBuffer.get(iout + j));
                            }
                        }
                    }
                    result.put(temp);
                    temp.flip();
                }
                break;
            }
            case 4: {
                int len1 = qube[1];
                int len2 = qube[2];
                int len3 = qube[3];
                for (int i0 = 0; i0 < qube[0]; ++i0) {
                    for (int i1 = 0; i1 < qube[1]; ++i1) {
                        for (int i2 = 0; i2 < qube[2]; ++i2) {
                            for (int i3 = 0; i3 < qube[3]; ++i3) {
                                int iin = fieldBytes * (i1 * len2 * len3 + i2 * len3 + i3);
                                int iout = fieldBytes * (i0 * len1 * len2 * len3 + i3 * len2 * len1 + i2 * len1 + i1);
                                for (int j = 0; j < fieldBytes; ++j) {
                                    temp.put(iin + j, byteBuffer.get(iout + j));
                                }
                            }
                        }
                    }
                    result.put(temp);
                    temp.flip();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("number of dimensions must be less than 5: " + qube.length);
            }
        }
        result.flip();
        return result;
    }

    private static ByteBuffer myGetBuffer(CDFReader cdf, String svariable, long recStart, int recStop, int recInterval) throws CDFException.ReaderError {
        ByteBuffer result;
        String stype = CdfUtil.getTargetType(cdf.getType(svariable));
        Object buff3 = cdf.getSampled(svariable, (int)recStart, recStop - 1, recInterval, stype, true);
        int type = cdf.getType(svariable);
        switch (type) {
            case 14: 
            case 22: 
            case 31: 
            case 32: 
            case 45: {
                double[] array = (double[])buff3;
                result = ByteBuffer.allocate(8 * array.length);
                for (double a : array) {
                    result.putDouble(a);
                }
                break;
            }
            case 21: 
            case 44: {
                float[] farray = (float[])buff3;
                result = ByteBuffer.allocate(4 * farray.length);
                for (float a : farray) {
                    result.putFloat(a);
                }
                break;
            }
            case 8: 
            case 33: {
                long[] larray = (long[])buff3;
                result = ByteBuffer.allocate(8 * larray.length);
                for (long a : larray) {
                    result.putLong(a);
                }
                break;
            }
            case 4: 
            case 12: {
                int[] iarray = (int[])buff3;
                result = ByteBuffer.allocate(4 * iarray.length);
                for (int a : iarray) {
                    result.putInt(a);
                }
                break;
            }
            case 2: 
            case 11: {
                short[] sarray = (short[])buff3;
                result = ByteBuffer.allocate(2 * sarray.length);
                for (short a : sarray) {
                    result.putShort(a);
                }
                break;
            }
            case 1: 
            case 41: 
            case 51: 
            case 52: {
                byte[] barray = (byte[])buff3;
                result = ByteBuffer.allocate(1 * barray.length);
                for (byte a : barray) {
                    result.put(a);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("not implemented: " + type);
            }
        }
        result.flip();
        return result;
    }

    private static double doubleValue(Object o) {
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Short) {
            return ((Short)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        throw new RuntimeException("Unsupported Data Type: " + o.getClass().getName());
    }

    public static DatumRange getRange(HashMap attrs) {
        DatumRange range = attrs.containsKey("SCALEMIN") && attrs.containsKey("SCALEMAX") ? new DatumRange(CdfUtil.doubleValue(attrs.get("SCALEMIN")), CdfUtil.doubleValue(attrs.get("SCALEMAX")), Units.dimensionless) : new DatumRange(CdfUtil.doubleValue(attrs.get("VALIDMIN")), CdfUtil.doubleValue(attrs.get("VALIDMAX")), Units.dimensionless);
        return range;
    }

    public static String getScaleType(HashMap attrs) {
        String type = "linear";
        if (attrs.containsKey("SCALETYP")) {
            type = (String)attrs.get("SCALETYP");
        }
        return type;
    }

    public static void maybeAddValidRange(Map<String, Object> props, MutablePropertyDataSet ds) {
        String t;
        Number nmin;
        UnitsConverter uc;
        Units pu = (Units)props.get("UNITS");
        Units u = (Units)ds.property("UNITS");
        if (pu == null || u == null) {
            uc = UnitsConverter.IDENTITY;
        } else if (u == Units.cdfEpoch) {
            uc = UnitsConverter.IDENTITY;
        } else if (pu == Units.microseconds && u == Units.us2000) {
            uc = UnitsConverter.IDENTITY;
        } else if (pu == u) {
            uc = UnitsConverter.IDENTITY;
        } else {
            if (UnitsUtil.isOrdinalMeasurement(u) || UnitsUtil.isOrdinalMeasurement(pu)) {
                return;
            }
            try {
                uc = UnitsConverter.getConverter(pu, u);
            }
            catch (InconvertibleUnitsException ex) {
                uc = UnitsConverter.IDENTITY;
            }
        }
        double dmin = Double.NEGATIVE_INFINITY;
        double dmax = Double.POSITIVE_INFINITY;
        if (ds.rank() == 1 && ds.length() > 0) {
            QDataSet range = Ops.extent(ds, null, null);
            dmin = uc.convert(range.value(0));
            dmax = uc.convert(range.value(1));
        }
        double vmin = (nmin = (Number)props.get("VALID_MIN")) == null ? Double.POSITIVE_INFINITY : nmin.doubleValue();
        Number nmax = (Number)props.get("VALID_MAX");
        double vmax = nmax == null ? Double.POSITIVE_INFINITY : nmax.doubleValue();
        boolean intersects = false;
        if (dmax > vmin && dmin < vmax) {
            intersects = true;
        }
        if (u instanceof EnumerationUnits) {
            EnumerationUnits eu = (EnumerationUnits)u;
            if (nmax != null && nmax.intValue() <= eu.getHighestOrdinal()) {
                nmax = eu.getHighestOrdinal() + 1;
            }
        }
        if (intersects || dmax == dmin || dmax < -1.0E30 || dmin > 1.0E30) {
            if (nmax != null) {
                ds.putProperty("VALID_MAX", uc.convert(nmax));
            }
            if (nmin != null) {
                ds.putProperty("VALID_MIN", uc.convert(nmin));
            }
        }
        if ((t = (String)props.get("SCALE_TYPE")) != null) {
            ds.putProperty("SCALE_TYPE", t);
        }
    }

    protected static int sizeOf(long itype) {
        int sizeBytes;
        if (itype == 32L) {
            sizeBytes = 16;
        } else if (itype == 45L || itype == 22L || itype == 31L || itype == 33L || itype == 8L || itype == 14L) {
            sizeBytes = 8;
        } else if (itype == 44L || itype == 21L || itype == 4L || itype == 12L) {
            sizeBytes = 4;
        } else if (itype == 2L || itype == 11L || itype == 52L) {
            sizeBytes = 2;
        } else if (itype == 1L || itype == 41L || itype == 51L) {
            sizeBytes = 1;
        } else {
            throw new IllegalArgumentException("didn't code for type");
        }
        return sizeBytes;
    }

    private static long sizeOf(int dims, int[] dimSizes, long itype, long rc) {
        long size = dims == 0 ? rc : rc * (long)DataSetUtil.product(dimSizes);
        return size *= (long)CdfUtil.sizeOf(itype);
    }

    protected static int getEffectiveRank(boolean[] varies) {
        int rank = 0;
        for (int i = 0; i < varies.length; ++i) {
            if (!varies[i]) continue;
            ++rank;
        }
        return rank;
    }

    private static ByteBuffer doSlice1(ByteBuffer buf, long varType, int[] qube, int slice1, boolean rowMajority) {
        int recSizeBytes = DataSetUtil.product(qube) / qube[0] * CdfUtil.sizeOf(varType);
        ByteBuffer result = ByteBuffer.allocate(recSizeBytes / qube[1] * qube[0]);
        result.order(buf.order());
        if (rowMajority) {
            int p1 = slice1 * recSizeBytes / qube[1];
            int p2 = slice1 * recSizeBytes / qube[1] + recSizeBytes / qube[1];
            for (int irec = 0; irec < qube[0]; ++irec) {
                buf.limit(irec * recSizeBytes + p2);
                buf.position(irec * recSizeBytes + p1);
                ByteBuffer b = buf.slice();
                result.put(b);
            }
        } else {
            int varSize = CdfUtil.sizeOf(varType);
            for (int irec = 0; irec < qube[0]; ++irec) {
                for (int j = 0; j < recSizeBytes; ++j) {
                    if (j / varSize % qube[1] != slice1) continue;
                    result.put(buf.get(irec * recSizeBytes + j));
                }
            }
        }
        result.flip();
        buf.position(0);
        buf.limit(recSizeBytes * qube[0]);
        return result;
    }

    public static synchronized MutablePropertyDataSet wrapCdfData(CDFReader cdf, String svariable, long recStart, long recCount, long recInterval, int slice1, ProgressMonitor mon) throws Exception {
        return CdfUtil.wrapCdfData(cdf, svariable, recStart, recCount, recInterval, slice1, false, mon);
    }

    public static synchronized MutablePropertyDataSet wrapCdfData(CDFReader cdf, String svariable, long recStart, long recCount, long recInterval, int slice1, boolean depend, ProgressMonitor mon) throws Exception {
        String cdfFile;
        MutablePropertyDataSet result;
        int i;
        ByteBuffer buff2;
        long t0;
        String stype;
        int[] dimSizes;
        long varType;
        block42: {
            int bytesPerRecord;
            int limit;
            int dims;
            if (recCount == 0L) {
                throw new IllegalArgumentException("recCount must be greater than 0 or -1");
            }
            if (recCount < -1L) {
                throw new IllegalArgumentException("recCount must be greater than 0 or -1");
            }
            logger.log(Level.FINE, "wrapCdfData {0}[{1}:{2}:{3}]", new Object[]{svariable, String.valueOf(recStart), "" + (recCount + recStart), recInterval});
            varType = cdf.getType(svariable);
            dimSizes = cdf.getDimensions(svariable);
            boolean[] dimVaries = cdf.getVarys(svariable);
            int[] repeatDimensions = new int[dimVaries.length];
            for (int i2 = 0; i2 < repeatDimensions.length; ++i2) {
                repeatDimensions[i2] = 1;
            }
            if (dimSizes == null) {
                dims = 0;
                dimSizes = new int[]{};
            } else {
                dims = dimSizes.length;
            }
            if (CdfUtil.getEffectiveRank(dimVaries) != dimSizes.length) {
                int[] dimSizes1 = new int[cdf.getEffectiveRank(svariable)];
                boolean[] varies = cdf.getVarys(svariable);
                int[] dimensions = cdf.getDimensions(svariable);
                int k = 0;
                for (int i3 = 0; i3 < varies.length; ++i3) {
                    if (varies[i3] && dimensions[i3] != 1) {
                        dimSizes1[k] = dimSizes[i3];
                        ++k;
                        continue;
                    }
                    repeatDimensions[i3] = dimSizes[i3];
                }
                dimSizes = dimSizes1;
            }
            if (dims > 3 && recCount != -1L) {
                throw new IllegalArgumentException("rank 5 not implemented");
            }
            int varRecCount = cdf.getNumberOfValues(svariable);
            if (recCount == -1L && recStart > 0L && varRecCount == 1) {
                recStart = 0L;
            }
            if (recCount > 1L && (long)(limit = 2147483) < recCount / 1000L / recInterval * (long)(bytesPerRecord = DataSetUtil.product(dimSizes) * CdfUtil.sizeOf(varType))) {
                int newRecCount = (int)((long)limit * recInterval * 1000L / (long)bytesPerRecord);
                String suggest = recInterval > 1L ? "[0:" + newRecCount + ":" + recInterval + "]" : "[0:" + newRecCount + "]";
                throw new IllegalArgumentException("data read would result in more than 2GB read, which is not yet supported.  Use " + svariable + suggest + " to read first records.");
            }
            long rc = recCount;
            if (rc == -1L) {
                rc = 1L;
            }
            logger.log(Level.FINEST, "size of {0}: {1}MB  type: {2}", new Object[]{svariable, (double)CdfUtil.sizeOf(dims, dimSizes, varType, rc) / 1024.0 / 1024.0, varType});
            stype = CdfUtil.getTargetType(cdf.getType(svariable));
            t0 = System.currentTimeMillis();
            logger.entering("gov.nasa.gsfc.spdf.cdfj.CDFReader", "getBuffer");
            if (recInterval == 1L) {
                try {
                    boolean preserve = true;
                    if (stype.equals("string")) {
                        buff2 = null;
                        break block42;
                    }
                    buff2 = cdf.getBuffer(svariable, stype, new int[]{(int)recStart, (int)(recStart + recInterval * (rc - 1L))}, preserve);
                }
                catch (CDFException ex) {
                    buff2 = CdfUtil.myGetBuffer(cdf, svariable, (int)recStart, (int)(recStart + rc * recInterval), (int)recInterval);
                }
            } else {
                buff2 = CdfUtil.myGetBuffer(cdf, svariable, (int)recStart, (int)(recStart + rc * recInterval), (int)recInterval);
            }
        }
        logger.exiting("gov.nasa.gsfc.spdf.cdfj.CDFReader", "getBuffer");
        logger.log(Level.FINE, "read variable {0} in (ms): {1}", new Object[]{svariable, System.currentTimeMillis() - t0});
        ByteBuffer[] buf = new ByteBuffer[]{buff2};
        Object bbType = CdfUtil.byteBufferType(cdf.getType(svariable));
        int recLenBytes = BufferDataSet.byteCount(bbType);
        if (dimSizes.length > 0) {
            recLenBytes *= DataSetUtil.product(dimSizes);
        }
        int[] qube = new int[1 + dimSizes.length];
        for (int i4 = 0; i4 < dimSizes.length; ++i4) {
            qube[i4 + 1] = dimSizes[i4];
        }
        qube[0] = recCount == -1L ? 1 : (int)recCount;
        if (stype.equals("string")) {
            MutablePropertyDataSet result2 = CdfUtil.readStringData(svariable, recInterval, cdf, recCount, qube);
            return result2;
        }
        if (buf.length > 1) {
            throw new IllegalArgumentException("multiple buffers not yet implemented");
        }
        if (slice1 > -1 && qube.length > 1) {
            buf[0] = CdfUtil.doSlice1(buf[0], varType, qube, slice1, cdf.rowMajority());
            if (recCount == -1L) {
                throw new IllegalArgumentException("recCount==-1 and slice1>-1");
            }
            int[] nqube = new int[qube.length - 1];
            nqube[0] = qube[0];
            for (i = 2; i < qube.length; ++i) {
                nqube[i - 1] = qube[i];
            }
            recLenBytes /= qube[1];
            qube = nqube;
        }
        if (varType == 31L && qube.length > 0) {
            boolean reform = true;
            for (i = 1; i < qube.length; ++i) {
                if (qube[i] == 1) continue;
                reform = false;
            }
            if (reform) {
                qube = Arrays.copyOf(qube, 1);
            }
        }
        if (cdf.rowMajority()) {
            if (recCount == -1L) {
                result = BufferDataSet.makeDataSet(qube.length, recLenBytes, 0, qube, buf[0], bbType);
                result = (MutablePropertyDataSet)result.slice(0);
            } else {
                result = BufferDataSet.makeDataSet(qube.length, recLenBytes, 0, qube, buf[0], bbType);
            }
        } else if (recCount == -1L) {
            buf[0] = CdfUtil.transpose(recLenBytes, qube, buf[0], bbType);
            result = BufferDataSet.makeDataSet(qube.length, recLenBytes, 0, qube, buf[0], bbType);
            result = (MutablePropertyDataSet)result.slice(0);
        } else {
            buf[0] = CdfUtil.transpose(recLenBytes, qube, buf[0], bbType);
            result = BufferDataSet.makeDataSet(qube.length, recLenBytes, 0, qube, buf[0], bbType);
        }
        if (varType == 51L || varType == 52L) {
            throw new IllegalArgumentException("We shouldn't get here because stype=string");
        }
        if (varType == 31L) {
            result.putProperty("UNITS", Units.cdfEpoch);
            result.putProperty("VALID_MIN", 1.0);
        } else if (varType == 32L) {
            result.putProperty("UNITS", Units.cdfEpoch);
            result.putProperty("VALID_MIN", 1.0);
            DDataSet result1 = DDataSet.createRank1(result.length());
            for (i = 0; i < result.length(); ++i) {
                double t2000 = result.value(i, 0) - 6.3113904E10;
                result1.putValue(i, t2000 * 1000000.0 + result.value(i, 1) / 1000000.0);
            }
            result1.putProperty("UNITS", Units.us2000);
            result = result1;
        } else if (varType == 33L) {
            result.putProperty("UNITS", Units.cdfTT2000);
        }
        if ((varType == 31L || varType == 32L || varType == 33L) && (cdfFile = CdfDataSource.cdfCacheFileForReader(cdf)) != null) {
            String uri = cdfFile + "?" + svariable;
            if (recStart != 0L || recCount != (long)cdf.getNumberOfValues(svariable) || recInterval > 1L) {
                uri = uri + "[" + recStart + ":" + (recStart + recCount) + ":" + recInterval + "]";
            }
            CdfDataSource.dsCachePut(uri, result);
        }
        return result;
    }

    private static MutablePropertyDataSet readStringData(String svariable, long recInterval, CDFReader cdf, long recCount, int[] qube) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, CDFException.ReaderError {
        boolean canSlice;
        String[] sdata;
        EnumerationUnits units = EnumerationUnits.create(svariable);
        if (recInterval > 1L) {
            throw new IllegalArgumentException("recInterval>1 not supported here");
        }
        Object o = cdf.get(svariable);
        Object o0 = Array.get(o, 0);
        if (o0.getClass().isArray()) {
            sdata = new String[Array.getLength(o0)];
            for (int j = 0; j < Array.getLength(o0); ++j) {
                sdata[j] = (String)Array.get(o0, j);
            }
        } else if (o0.getClass() == String.class) {
            sdata = (String[])o;
        } else {
            throw new IllegalArgumentException("not handled single array where expected double array");
        }
        int[] back = new int[sdata.length];
        for (int i = 0; i < sdata.length; ++i) {
            back[i] = (int)units.createDatum(sdata[i]).doubleValue(units);
        }
        boolean[] varies = cdf.getVarys(svariable);
        boolean bl = canSlice = recCount == -1L;
        if (canSlice) {
            for (int i = 1; i < varies.length; ++i) {
                canSlice = canSlice && !varies[i];
            }
        }
        if (canSlice) {
            qube = new int[]{qube[1]};
        }
        ArrayDataSet result = ArrayDataSet.wrap(back, qube, false);
        result.putProperty("UNITS", units);
        return result;
    }

    public static int jvmMemory(QDataSet ds) {
        if (ds instanceof ArrayDataSet) {
            return ((ArrayDataSet)ds).jvmMemory();
        }
        if (ds instanceof TrArrayDataSet) {
            return ((TrArrayDataSet)ds).jvmMemory();
        }
        if (ds instanceof Slice0DataSet) {
            return 0;
        }
        if (ds instanceof BufferDataSet) {
            return ((BufferDataSet)ds).jvmMemory();
        }
        throw new IllegalArgumentException("not supported type of QDataSet: " + ds);
    }

    public static String getStringDataType(int type) {
        switch (type) {
            case 1: {
                return "CDF_INT1";
            }
            case 2: {
                return "CDF_INT2";
            }
            case 4: {
                return "CDF_INT4";
            }
            case 8: {
                return "CDF_INT8";
            }
            case 11: {
                return "CDF_UINT1";
            }
            case 12: {
                return "CDF_UINT2";
            }
            case 14: {
                return "CDF_UINT4";
            }
            case 41: {
                return "CDF_BYTE";
            }
            case 21: {
                return "CDF_REAL4";
            }
            case 22: {
                return "CDF_REAL8";
            }
            case 44: {
                return "CDF_FLOAT";
            }
            case 45: {
                return "CDF_DOUBLE";
            }
            case 31: {
                return "CDF_EPOCH";
            }
            case 32: {
                return "CDF_EPOCH16";
            }
            case 33: {
                return "CDF_TT2000";
            }
            case 51: {
                return "CDF_CHAR";
            }
        }
        return String.valueOf(type);
    }

    private static Object getAttribute(CDFReader cdf, String var, String attrname) {
        try {
            Object att = cdf.getAttribute(var, attrname);
            if (att == null) {
                return null;
            }
            if (((Vector)att).isEmpty()) {
                return null;
            }
            att = ((Vector)att).get(0);
            return att;
        }
        catch (CDFException ex) {
            logger.fine(ex.getMessage());
            return null;
        }
    }

    public static boolean hasAttribute(CDFReader cdf, String var, String attrname) {
        try {
            Object att = cdf.getAttribute(var, attrname);
            return att != null && !((Vector)att).isEmpty();
        }
        catch (CDFException ex) {
            return false;
        }
    }

    private static DepDesc getDepDesc(CDFReader cdf, String svar, int rank, int[] dims, int dim, List<String> warn) {
        Object att;
        DepDesc result = new DepDesc();
        result.nrec = -1L;
        try {
            if (CdfUtil.hasAttribute(cdf, svar, "DEPEND_" + dim) && (att = CdfUtil.getAttribute(cdf, svar, "DEPEND_" + dim)) != null && rank > 1) {
                logger.log(Level.FINE, "get attribute DEPEND_" + dim + " entry for {0}", svar);
                result.dep = String.valueOf(att);
                if (cdf.getDimensions(result.dep).length > 0 && cdf.getNumberOfValues(result.dep) > 1 && cdf.recordVariance(result.dep)) {
                    result.rank2 = true;
                    result.nrec = cdf.getDimensions(result.dep)[0];
                    warn.add("NOTE: " + result.dep + " is record varying");
                } else {
                    result.nrec = cdf.getNumberOfValues(result.dep);
                    if (result.nrec == 1L) {
                        result.nrec = cdf.getDimensions(result.dep)[0];
                    }
                }
                if (dims.length > dim - 2 && result.nrec != (long)dims[dim - 1]) {
                    warn.add("DEPEND_" + dim + " length (" + result.nrec + ") is inconsistent with length (" + dims[dim - 1] + ")");
                }
            }
        }
        catch (CDFException e) {
            warn.add("problem with DEPEND_" + dim + ": " + e.getMessage());
        }
        catch (Exception e) {
            warn.add("problem with DEPEND_" + dim + ": " + e.getMessage());
        }
        try {
            if (result.nrec == -1L && CdfUtil.hasAttribute(cdf, svar, "LABL_PTR_" + dim)) {
                att = CdfUtil.getAttribute(cdf, svar, "LABL_PTR_" + dim);
                if (att != null && rank > 1) {
                    logger.log(Level.FINE, "get attribute LABL_PTR_" + dim + " entry for {0}", svar);
                    result.labl = String.valueOf(att);
                    if (!cdf.existsVariable(result.labl)) {
                        throw new Exception("No such variable: " + String.valueOf(att));
                    }
                    result.nrec = cdf.getNumberOfValues(result.labl);
                    if (result.nrec == 1L) {
                        result.nrec = cdf.getDimensions(svar)[0];
                    }
                    if (dims.length > dim - 2 && result.nrec != (long)dims[dim - 1]) {
                        warn.add("LABL_PTR_" + dim + " length is inconsistent with length (" + dims[dim - 1] + ")");
                    }
                }
            } else if (CdfUtil.hasAttribute(cdf, svar, "LABL_PTR_" + dim) && (att = CdfUtil.getAttribute(cdf, svar, "LABL_PTR_" + dim)) != null && rank > 1) {
                logger.log(Level.FINE, "get attribute LABL_PTR_" + dim + " entry for {0}", svar);
                result.labl = String.valueOf(att);
                int nrec = cdf.getNumberOfValues(result.labl);
                if (nrec == 1) {
                    nrec = cdf.getDimensions(result.labl)[0];
                }
                if (dims.length > dim - 2 && nrec != dims[dim - 1]) {
                    warn.add("LABL_PTR_" + dim + " length is inconsistent with length (" + dims[dim - 1] + ")");
                }
            }
        }
        catch (CDFException e) {
            warn.add("problem with LABL_PTR_" + dim + ": " + e.getMessage());
        }
        catch (Exception e) {
            warn.add("problem with LABL_PTR_" + dim + ": " + e.getMessage());
        }
        return result;
    }

    private static boolean hasVariable(CDFReader cdf, String var) {
        List<String> names = Arrays.asList(cdf.getVariableNames());
        return names.contains(var);
    }

    public static Map<String, String> getPlottable(CDFReader cdf, boolean dataOnly, int rankLimit) throws Exception {
        return CdfUtil.getPlottable(cdf, dataOnly, rankLimit, false, false);
    }

    public static Map<String, String> getPlottable(CDFReader cdf, boolean dataOnly, int rankLimit, boolean deep, boolean master) throws Exception {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> dependent = new LinkedHashMap<String, String>();
        boolean isMaster = master;
        logger.fine("getting CDF variables");
        String[] v = cdf.getVariableNames();
        logger.log(Level.FINE, "got {0} variables", v.length);
        logger.fine("getting CDF attributes");
        boolean[] isData = new boolean[v.length];
        int i = -1;
        int skipCount = 0;
        for (String svar : v) {
            ++i;
            if (!dataOnly) continue;
            Object attr = CdfUtil.getAttribute(cdf, svar, "VAR_TYPE");
            if (attr == null) {
                for (String s : cdf.variableAttributeNames(svar)) {
                    if (!s.equalsIgnoreCase("VAR_TYPE")) continue;
                    attr = CdfUtil.getAttribute(cdf, svar, s);
                }
                if (attr != null) {
                    logger.log(Level.INFO, "Wrong-case VAR_TYPE attribute found, should be \"VAR_TYPE\"");
                }
            }
            if (attr != null && "data".equalsIgnoreCase(attr.toString()) && !attr.equals("data")) {
                logger.log(Level.INFO, "var_type is case-sensitive, should be \"data\", not {0}", attr);
                attr = "data";
            }
            if (attr == null || !attr.equals("data")) {
                ++skipCount;
                isData[i] = false;
                continue;
            }
            isData[i] = true;
        }
        i = -1;
        for (String v1 : v) {
            ++i;
            String svar = null;
            ArrayList<String> warn = new ArrayList<String>();
            String xDependVariable = null;
            boolean isVirtual = false;
            long xMaxRec = -1L;
            long maxRec = -1L;
            long recCount = -1L;
            String scatDesc = null;
            String svarNotes = null;
            StringBuilder vdescr = null;
            int rank = -1;
            int[] dims = new int[]{};
            int varType = 0;
            try {
                svar = v1;
                try {
                    varType = cdf.getType(svar);
                }
                catch (CDFException ex) {
                    throw new RuntimeException(ex);
                }
                boolean hasDep0 = CdfUtil.hasAttribute(cdf, svar, "DEPEND_0");
                if (!((long)varType != 51L && (long)varType != 52L || hasDep0)) {
                    logger.log(Level.FINER, "skipping because ordinal and no depend_0: {0}", svar);
                    continue;
                }
                recCount = maxRec = (long)cdf.getNumberOfValues(svar);
                dims = cdf.getDimensions(svar);
                boolean[] dimVary = cdf.getVarys(svar);
                if (dimVary.length > 0 && !dimVary[0]) {
                    dims = new int[]{};
                }
                if ((rank = dims == null ? 1 : dims.length + 1) > rankLimit) continue;
                if (svar.equals("Time_PB5")) {
                    logger.log(Level.FINE, "skipping {0} because we always skip Time_PB5", svar);
                    continue;
                }
                if (dataOnly && !isData[i]) continue;
                Object att = CdfUtil.getAttribute(cdf, svar, "VIRTUAL");
                if (att != null) {
                    logger.log(Level.FINE, "get attribute VIRTUAL entry for {0}", svar);
                    if (String.valueOf(att).toUpperCase().equals("TRUE")) {
                        String funct = (String)CdfUtil.getAttribute(cdf, svar, "FUNCTION");
                        if (funct == null) {
                            funct = (String)CdfUtil.getAttribute(cdf, svar, "FUNCT");
                        }
                        if (!CdfVirtualVars.isSupported(funct)) {
                            if (funct.startsWith("comp_themis")) continue;
                            logger.log(Level.FINE, "virtual function not supported: {0}", funct);
                            continue;
                        }
                        vdescr = new StringBuilder(funct);
                        vdescr.append("( ");
                        int icomp = 0;
                        String comp = (String)CdfUtil.getAttribute(cdf, svar, "COMPONENT_" + icomp);
                        if (comp != null) {
                            vdescr.append(comp);
                            ++icomp;
                        }
                        while (icomp < 5 && (comp = (String)CdfUtil.getAttribute(cdf, svar, "COMPONENT_" + icomp)) != null) {
                            vdescr.append(", ").append(comp);
                            ++icomp;
                        }
                        vdescr.append(" )");
                        isVirtual = true;
                    }
                }
            }
            catch (CDFException e) {
                logger.fine(e.getMessage());
            }
            catch (Exception e) {
                logger.fine(e.getMessage());
            }
            try {
                if (CdfUtil.hasAttribute(cdf, svar, "DEPEND_0")) {
                    Object att = CdfUtil.getAttribute(cdf, svar, "DEPEND_0");
                    if (att != null) {
                        logger.log(Level.FINE, "get attribute DEPEND_0 entry for {0}", svar);
                        xDependVariable = String.valueOf(att);
                        if (!CdfUtil.hasVariable(cdf, xDependVariable)) {
                            throw new Exception("No such variable: " + String.valueOf(att));
                        }
                        xMaxRec = cdf.getNumberOfValues(xDependVariable);
                        if (xMaxRec != maxRec && vdescr == null && cdf.recordVariance(svar)) {
                            if (maxRec == -1L) {
                                ++maxRec;
                            }
                            if (maxRec == 0L) {
                                warn.add("data contains no records");
                            } else {
                                warn.add("depend0 length is inconsistent with length (" + maxRec + ")");
                            }
                        }
                    } else if (dataOnly) {
                        continue;
                    }
                }
            }
            catch (CDFException e) {
                warn.add("problem with DEPEND_0: " + e.getMessage());
            }
            catch (Exception e) {
                warn.add("problem with DEPEND_0: " + e.getMessage());
            }
            DepDesc dep1desc = CdfUtil.getDepDesc(cdf, svar, rank, dims, 1, warn);
            DepDesc dep2desc = CdfUtil.getDepDesc(cdf, svar, rank, dims, 2, warn);
            DepDesc dep3desc = CdfUtil.getDepDesc(cdf, svar, rank, dims, 3, warn);
            if (deep) {
                Object o = CdfUtil.getAttribute(cdf, svar, "CATDESC");
                if (o != null && o instanceof String) {
                    logger.log(Level.FINE, "get attribute CATDESC entry for {0}", svar);
                    scatDesc = (String)o;
                }
                if ((o = CdfUtil.getAttribute(cdf, svar, "VAR_NOTES")) != null && o instanceof String) {
                    logger.log(Level.FINE, "get attribute VAR_NOTES entry for {0}", svar);
                    svarNotes = (String)o;
                }
            }
            String desc = svar;
            if (xDependVariable != null) {
                desc = desc + "(" + xDependVariable;
                if (!(xMaxRec <= 0L && isMaster || xMaxRec != maxRec)) {
                    desc = desc + "=" + xMaxRec;
                }
                if (dep1desc.dep != null) {
                    desc = desc + "," + dep1desc.dep + "=" + dep1desc.nrec + (dep1desc.rank2 ? "*" : "");
                    if (dep2desc.dep != null) {
                        desc = desc + "," + dep2desc.dep + "=" + dep2desc.nrec + (dep2desc.rank2 ? "*" : "");
                        if (dep3desc.dep != null) {
                            desc = desc + "," + dep3desc.dep + "=" + dep3desc.nrec + (dep3desc.rank2 ? "*" : "");
                        }
                    }
                } else if (rank > 1) {
                    desc = desc + "," + DataSourceUtil.strjoin(dims, ",");
                }
                desc = desc + ")";
            }
            if (deep) {
                StringBuilder descbuf = new StringBuilder("<html><b>" + desc + "</b><br>");
                int itype = -1;
                try {
                    itype = cdf.getType(svar);
                }
                catch (CDFException cDFException) {
                    // empty catch block
                }
                String recDesc = "" + CdfUtil.getStringDataType(itype);
                if (dims != null) {
                    recDesc = recDesc + "[" + DataSourceUtil.strjoin(dims, ",") + "]";
                }
                if (maxRec != xMaxRec) {
                    if (isVirtual) {
                        descbuf.append("").append("(virtual function ").append((CharSequence)vdescr).append(")<br>");
                    } else {
                        descbuf.append("").append(recCount).append(" records of ").append(recDesc).append("<br>");
                    }
                }
                if (scatDesc != null) {
                    descbuf.append("").append(scatDesc).append("<br>");
                }
                if (svarNotes != null) {
                    descbuf.append("<br><p><small>").append(svarNotes).append("</small></p>");
                }
                descbuf.append("<br><br><small>CDF data type is ").append(CdfUtil.getStringDataType(varType)).append("</small>");
                for (String s : warn) {
                    if (s.startsWith("NOTE")) {
                        descbuf.append("<br>").append(s);
                        continue;
                    }
                    descbuf.append("<br>WARNING: ").append(s);
                }
                descbuf.append("</html>");
                if (xDependVariable != null) {
                    dependent.put(svar, descbuf.toString());
                    continue;
                }
                result.put(svar, descbuf.toString());
                continue;
            }
            if (xDependVariable != null) {
                dependent.put(svar, desc);
                continue;
            }
            result.put(svar, desc);
        }
        logger.fine("done, get plottable ");
        dependent.putAll(result);
        return dependent;
    }

    private static class DepDesc {
        String dep;
        String labl;
        long nrec;
        boolean rank2;

        private DepDesc() {
        }
    }
}

