/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.cdf.CdfUtil;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.das2.util.monitor.ProgressMonitor;

public class CdfJavaDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = Logger.getLogger("apdss.cdf");

    @Override
    public DataSource getDataSource(URI uri) throws Exception {
        return new CdfDataSource(uri);
    }

    public String editPanel(String surl) throws Exception {
        return surl;
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_NAME)) {
            File cdfFile = DataSetURI.getFile(cc.resourceURI, mon);
            String fileName = cdfFile.toString();
            logger.log(Level.FINEST, "opening cdf file {0}", fileName);
            if (!mon.isFinished()) {
                mon.started();
            }
            mon.setProgressMessage("opening CDF file");
            CDFReader cdf = CdfDataSource.getCdfFile(fileName);
            logger.finest("inspect cdf for plottable parameters");
            Map<String, String> result = CdfUtil.getPlottable(cdf, false, 4);
            mon.finished();
            logger.finest("close cdf");
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
            for (Map.Entry<String, String> e : result.entrySet()) {
                String key = e.getKey();
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, key, this, "arg_0", e.getValue(), null, true);
                ccresult.add(cc1);
            }
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "interpMeta=", "control interpretation of metadata"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "replaceLabels=", "use DEPEND data to label channels"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "doDep=", "control dependencies between variables"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "where=", "only return variables where the condition is true"));
            return ccresult;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String parmname = CompletionContext.get(CompletionContext.CONTEXT_PARAMETER_NAME, cc);
            if (parmname.equals("id")) {
                String file = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
                File cdfFile = DataSetURI.getFile(DataSetURI.getURL(file), mon);
                DataSetURI.checkLength(cdfFile);
                String fileName = cdfFile.toString();
                CDFReader cdf = CdfDataSource.getCdfFile(fileName);
                Map<String, String> result = CdfUtil.getPlottable(cdf, false, 4);
                ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                for (Map.Entry<String, String> ent : result.entrySet()) {
                    String key = ent.getKey();
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, this, null, key, ent.getValue(), true);
                    ccresult.add(cc1);
                }
                return ccresult;
            }
            if (parmname.equals("interpMeta")) {
                return Arrays.asList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "yes", "use metadata (default)"), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "no", "inhibit use of metadata"));
            }
            if (parmname.equals("doDep")) {
                return Arrays.asList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "yes", "use dependency tags (default)"), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "no", "inhibit use of dependency tags"));
            }
            if (parmname.equals("replaceLabels")) {
                return Arrays.asList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "T", "use DEPEND data for labels"), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "F", "normal behavior uses LABL_PTR (default)"));
            }
            if (parmname.equals("where")) {
                String file = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
                File cdfFile = DataSetURI.getFile(DataSetURI.getURL(file), mon);
                DataSetURI.checkLength(cdfFile);
                String fileName = cdfFile.toString();
                CDFReader cdf = CdfDataSource.getCdfFile(fileName);
                Map<String, String> result = CdfUtil.getPlottable(cdf, false, 2);
                ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                for (Map.Entry<String, String> e : result.entrySet()) {
                    String key = e.getKey();
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key + ".eq(0)", this, null, key + ".eq(0)", e.getValue(), true);
                    ccresult.add(cc1);
                }
                return ccresult;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        try {
            File file;
            if (!surl.contains("?") || surl.indexOf("?") == surl.length() - 1) {
                return true;
            }
            URISplit split = URISplit.parse(surl);
            LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
            String param = (String)args.get("arg_0");
            if (param == null && (param = (String)args.get("id")) == null) {
                return true;
            }
            String slice1 = (String)args.get("slice1");
            if (slice1 != null) {
                try {
                    Integer.parseInt(slice1);
                }
                catch (NumberFormatException ex) {
                    problems.add("misformatted slice");
                    return true;
                }
            }
            if (!(file = DataSetURI.getFile(split.resourceUri, mon)).isFile()) {
                return true;
            }
            CDFReader cdf = CdfDataSource.getCdfFile(file.getPath());
            Map<String, String> result = CdfUtil.getPlottable(cdf, false, 4);
            int i = param.indexOf("[");
            if (i > -1) {
                param = param.substring(0, i);
            }
            return !result.containsKey(param);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, surl, ex);
            return false;
        }
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        return null;
    }

    @Override
    public boolean supportsDiscovery() {
        return false;
    }
}

