/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.cdf.CdfUtil;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.util.DasExceptionHandler;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public class CdfJavaDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    public static final String NO_PLOTTABLE_PARAMETERS_MSG = "<html><i>No plottable parameters</i></html>";
    private static final int MAX_SLICE1_OFFER = 32;
    private static final Logger logger = Logger.getLogger("apdss.cdf");
    private boolean isValidCDF = false;
    private JLabel interpretMetadataLabel;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JCheckBox noDep;
    private JCheckBox noInterpMeta;
    private JLabel paramInfo;
    private JTree parameterTree;
    private JTree parameterTree1;
    private JTree parameterTree2;
    private JCheckBox showAllVarTypeCB;
    private JComboBox subsetComboBox;
    private JCheckBox whereCB;
    private JComboBox whereOp;
    private JComboBox whereParamList;
    private JTextField whereTF;
    private JCheckBox xCheckBox;
    private JCheckBox yCheckBox;
    private BindingGroup bindingGroup;
    JComponent delegateComponent = null;
    DataSetSelector delegateDataSetSelector = null;
    DataSourceEditorPanel delegateEditorPanel = null;
    Map<String, String> params;
    String vapScheme;
    URI resourceUri;
    Map<String, String> parameterDescriptions;
    Map<String, String> parameterInfo;
    String parameter;
    boolean showAllInitially = false;
    long subsetMaxRec = -1L;
    File cdfFile;
    CDFReader cdf;
    Throwable cdfException;

    public CdfJavaDataSourceEditorPanel() {
        this.initComponents();
        this.parameterTree.getSelectionModel().setSelectionMode(1);
        this.jPanel3.setVisible(false);
        if (AutoplotHelpSystem.getHelpSystem() != null) {
            AutoplotHelpSystem.getHelpSystem().registerHelpID(this, "cdf_main");
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel1 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.subsetComboBox = new JComboBox();
        this.interpretMetadataLabel = new JLabel();
        this.noInterpMeta = new JCheckBox();
        this.noDep = new JCheckBox();
        this.showAllVarTypeCB = new JCheckBox();
        this.whereCB = new JCheckBox();
        this.whereParamList = new JComboBox();
        this.whereOp = new JComboBox();
        this.whereTF = new JTextField();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane3 = new JScrollPane();
        this.parameterTree = new JTree();
        this.jPanel2 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.parameterTree1 = new JTree();
        this.xCheckBox = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.parameterTree2 = new JTree();
        this.yCheckBox = new JCheckBox();
        this.jScrollPane2 = new JScrollPane();
        this.paramInfo = new JLabel();
        this.setName("cdfDataSourceEditorPanel");
        this.setPreferredSize(new Dimension(615, 452));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setPreferredSize(new Dimension(615, 452));
        this.jSplitPane2.setDividerLocation(230);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane1.setDividerLocation(320);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Advanced"));
        this.jPanel3.setMaximumSize(new Dimension(285, Short.MAX_VALUE));
        this.jLabel4.setText("Load subset of the data:");
        this.jLabel4.setToolTipText("<html>Load a subset of the data records, for example:<br>[0:100]  first 100 records<br> [-100:] last 100 records<br> [::10] every tenth record<br> </html>");
        this.subsetComboBox.setEditable(true);
        this.subsetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "::10", "0:100", "-100:", "0:10000:5"}));
        this.subsetComboBox.setToolTipText("<html>Load a subset of the data records, for example:<br>[0:100]  first 100 records<br> [-100:] last 100 records<br> [::10] every tenth record<br> </html>");
        this.interpretMetadataLabel.setText("Interpret Metadata:");
        this.noInterpMeta.setText("no ISTP");
        this.noInterpMeta.setToolTipText("Don't interpret metadata to get titles and units.");
        this.noDep.setText("no dependencies");
        this.noDep.setToolTipText("Ignore connections between variables like \"DEPEND_0\"\n");
        this.showAllVarTypeCB.setText("show all");
        this.showAllVarTypeCB.setToolTipText("show all parameters, even if ISTP VAR_TYPE is not \"data\"");
        this.showAllVarTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.showAllVarTypeCBActionPerformed(evt);
            }
        });
        this.whereCB.setText("Only load data where:");
        this.whereCB.setToolTipText("return only the records where the condition is true");
        this.whereParamList.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.whereParamList, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.whereOp.setModel(new DefaultComboBoxModel<String>(new String[]{".eq", ".gt", ".lt", ".ne", ".within"}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.whereOp, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.whereTF.setText("0");
        this.whereTF.setToolTipText("enter the value, or \"mode\" for the most frequently occuring value.");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.whereCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.whereTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.whereParamList, 0, 209, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.whereOp, -2, 84, -2).addPreferredGap(0).add((Component)this.whereTF, -2, 53, -2)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel4).add((Component)this.interpretMetadataLabel).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.subsetComboBox, -2, 160, -2).add((Component)this.showAllVarTypeCB).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.noInterpMeta).addPreferredGap(0).add((Component)this.noDep)))).add((Component)this.whereCB)).add(0, 147, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.subsetComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this.whereCB).add(8, 8, 8).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.whereParamList, -2, -1, -2).add((Component)this.whereOp, -2, -1, -2).add((Component)this.whereTF, -2, -1, -2)).add(18, 18, 18).add((Component)this.interpretMetadataLabel).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.noInterpMeta).add((Component)this.noDep)).addPreferredGap(0).add((Component)this.showAllVarTypeCB).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel3);
        this.parameterTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.parameterTreeValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.parameterTree);
        this.jTabbedPane1.addTab("Data", this.jScrollPane3);
        this.parameterTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.parameterTree1ValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.parameterTree1);
        this.xCheckBox.setText("Set Variable for X");
        this.xCheckBox.setToolTipText("Specify the parameter to use for the X tags, overriding any settings found in the file.");
        this.xCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.xCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.xCheckBox, -1, 319, Short.MAX_VALUE).add((Component)this.jScrollPane4));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.xCheckBox).addPreferredGap(0).add((Component)this.jScrollPane4, -1, 174, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("X", this.jPanel2);
        this.parameterTree2.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                CdfJavaDataSourceEditorPanel.this.parameterTree2ValueChanged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.parameterTree2);
        this.yCheckBox.setText("Set Variable for Y");
        this.yCheckBox.setToolTipText("Specify the parameter to use for the Y tags, overriding any settings found in the file.");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.yCheckBox, -1, 319, Short.MAX_VALUE).add((Component)this.jScrollPane5));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.yCheckBox).addPreferredGap(0).add((Component)this.jScrollPane5, -1, 174, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Y", this.jPanel4);
        this.jSplitPane1.setLeftComponent(this.jTabbedPane1);
        this.jSplitPane2.setTopComponent(this.jSplitPane1);
        this.jScrollPane2.setMaximumSize(new Dimension(1000, 600));
        this.paramInfo.setText("Variable");
        this.paramInfo.setVerticalAlignment(1);
        this.paramInfo.setMaximumSize(new Dimension(1000, 4000));
        this.paramInfo.setPreferredSize(new Dimension(600, 100));
        this.paramInfo.setVerticalTextPosition(1);
        this.jScrollPane2.setViewportView(this.paramInfo);
        this.jSplitPane2.setRightComponent(this.jScrollPane2);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jSplitPane2, -1, 599, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jSplitPane2, -1, 436, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.bindingGroup.bind();
    }

    private void parameterTree1ValueChanged(TreeSelectionEvent evt) {
        this.xCheckBox.setSelected(true);
    }

    private void parameterTreeValueChanged(TreeSelectionEvent evt) {
        TreePath tp = evt.getPath();
        if (this.isValidCDF) {
            this.parameter = String.valueOf(tp.getPathComponent(1));
            this.updateMetadata();
        }
    }

    private void showAllVarTypeCBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.setURI(this.getURI());
    }

    private void parameterTree2ValueChanged(TreeSelectionEvent evt) {
        this.yCheckBox.setSelected(true);
    }

    private void xCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void updateMetadata() {
        String longName = this.parameterInfo.get(this.parameter);
        this.paramInfo.setText(longName);
    }

    @Override
    public JPanel getPanel() {
        if (this.showAllInitially) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CdfJavaDataSourceEditorPanel.this.showAllVarTypeCB.setSelected(true);
                    CdfJavaDataSourceEditorPanel.this.setURI(CdfJavaDataSourceEditorPanel.this.getURI());
                }
            });
        }
        return this;
    }

    public void setShowAdvancedSubpanel(boolean v) {
        this.interpretMetadataLabel.setVisible(v);
        this.noDep.setVisible(v);
        this.noInterpMeta.setVisible(v);
        this.showAllVarTypeCB.setVisible(v);
    }

    @Override
    public boolean reject(String url) throws IOException, URISyntaxException {
        URISplit split = URISplit.parse(url);
        if (split.resourceUri == null) {
            return true;
        }
        FileSystem fs = FileSystem.create(DataSetURI.getWebURL(DataSetURI.toUri(split.path)).toURI());
        return fs.isDirectory(split.file.substring(split.path.length()));
    }

    @Override
    public boolean prepare(String url, Window parent, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse(url);
        this.cdfFile = DataSetURI.getFile(split.resourceUri, mon);
        DataSetURI.checkLength(this.cdfFile);
        logger.log(Level.FINE, "opening cdf file {0}", this.cdfFile.toString());
        try {
            CdfDataSource.checkCdf(this.cdfFile);
            this.cdf = CdfDataSource.getCdfFile(this.cdfFile.toString());
            if (this.cdf == null) {
                throw new IllegalArgumentException("file is not a CDF file");
            }
            this.cdfException = null;
        }
        catch (IOException | IllegalArgumentException ex) {
            this.cdfException = ex;
        }
        return true;
    }

    @Override
    public void setURI(String url) {
        URISplit split = URISplit.parse(url);
        this.vapScheme = split.vapScheme;
        LinkedHashMap<String, String> lparams = URISplit.parseParams(split.params);
        try {
            int i;
            int i2;
            int i3;
            String label;
            this.resourceUri = split.resourceUri;
            this.cdfFile = DataSetURI.getFile(split.resourceUri, (ProgressMonitor)new NullProgressMonitor());
            DataSetURI.checkLength(this.cdfFile);
            String fileName = this.cdfFile.toString();
            logger.log(Level.FINE, "opening cdf file {0}", fileName);
            if (this.cdf == null && this.cdfException == null) {
                try {
                    this.cdf = CdfDataSource.getCdfFile(fileName);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (this.cdfException != null) {
                this.parameterTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("")));
                this.paramInfo.setText("<html>Unable to read CDF file:<br>" + this.cdfException.getMessage());
                return;
            }
            logger.finest("inspect cdf for plottable parameters");
            boolean isMaster = fileName.contains("MASTERS");
            this.parameterDescriptions = CdfUtil.getPlottable(this.cdf, !this.showAllVarTypeCB.isSelected(), 4, false, false);
            Map<String, String> allParameterInfo = CdfUtil.getPlottable(this.cdf, false, 4, true, isMaster);
            Map<String, String> dataParameterInfo = CdfUtil.getPlottable(this.cdf, true, 4, true, isMaster);
            Map<String, String> whereParameterInfo = CdfUtil.getPlottable(this.cdf, false, 2, false, isMaster);
            if (dataParameterInfo.isEmpty()) {
                this.showAllVarTypeCB.setSelected(true);
                this.parameterDescriptions = CdfUtil.getPlottable(this.cdf, !this.showAllVarTypeCB.isSelected(), 4, false, false);
                this.showAllVarTypeCB.setEnabled(false);
            }
            if (this.showAllVarTypeCB.isSelected()) {
                this.parameterInfo = allParameterInfo;
                label = "Select CDF Variable (%d data, %d support):";
            } else {
                this.parameterInfo = dataParameterInfo;
                label = "Select CDF Variable (%d data, %d support not shown):";
            }
            this.isValidCDF = true;
            this.jPanel3.setVisible(true);
            int numData = dataParameterInfo.size();
            int numSupport = allParameterInfo.size() - numData;
            if (this.showAllVarTypeCB.isSelected()) {
                this.jTabbedPane1.setTitleAt(0, String.format("Select CDF Variable (of %d)", numData + numSupport));
            } else {
                this.jTabbedPane1.setTitleAt(0, String.format("Select CDF Variable (of %d)", numData));
            }
            this.jTabbedPane1.setToolTipText(String.format(label, numData, numSupport));
            if (this.showAllVarTypeCB.isSelected()) {
                this.showAllVarTypeCB.setText("show all (" + numSupport + " support shown)");
            } else {
                this.showAllVarTypeCB.setText("show all (" + numSupport + " support not shown)");
            }
            Pattern slice1pattern = Pattern.compile("\\[\\:\\,(\\d+)\\]");
            String slice1 = (String)lparams.remove("slice1");
            String param = (String)lparams.remove("arg_0");
            String subset = null;
            if (param != null && (i3 = param.indexOf("[")) != -1) {
                subset = param.substring(i3);
                param = param.substring(0, i3);
                Matcher m = slice1pattern.matcher(subset);
                if (m.matches()) {
                    slice1 = m.group(1);
                    subset = null;
                }
            }
            if (allParameterInfo.containsKey(param) && !dataParameterInfo.containsKey(param)) {
                this.showAllInitially = true;
            }
            this.fillTree(this.parameterTree, this.parameterDescriptions, this.cdf, param, slice1);
            Map<String, String> parameterDescriptions2 = CdfUtil.getPlottable(this.cdf, false, 4, false, false);
            String xparam = (String)lparams.remove("depend0");
            String xslice1 = null;
            if (xparam == null) {
                xparam = (String)lparams.remove("x");
            }
            if (xparam != null && (i2 = xparam.indexOf("[")) != -1) {
                String xsubset = xparam.substring(i2);
                xparam = xparam.substring(0, i2);
                Matcher m = slice1pattern.matcher(xsubset);
                if (m.matches()) {
                    xslice1 = m.group(1);
                }
            }
            this.fillTree(this.parameterTree1, parameterDescriptions2, this.cdf, xparam, xslice1);
            String yparam = (String)lparams.remove("y");
            String yslice1 = null;
            if (yparam != null && (i = yparam.indexOf("[")) != -1) {
                String ysubset = yparam.substring(i);
                yparam = yparam.substring(0, i);
                Matcher m = slice1pattern.matcher(ysubset);
                if (m.matches()) {
                    yslice1 = m.group(1);
                }
            }
            this.fillTree(this.parameterTree2, parameterDescriptions2, this.cdf, yparam, yslice1);
            logger.finest("close cdf");
            DefaultComboBoxModel<String> cbmodel = new DefaultComboBoxModel<String>();
            for (String p : this.parameterDescriptions.keySet()) {
                cbmodel.addElement(p);
            }
            if (param != null) {
                if (subset != null) {
                    if (subset.startsWith("[")) {
                        subset = subset.substring(1);
                    }
                    if (subset.endsWith("]")) {
                        subset = subset.substring(0, subset.length() - 1);
                    }
                    this.subsetComboBox.setSelectedItem(subset);
                } else {
                    this.subsetComboBox.setSelectedItem("");
                }
            } else if (!this.parameterDescriptions.isEmpty()) {
                this.parameter = this.parameterDescriptions.entrySet().iterator().next().getKey();
                this.subsetComboBox.setSelectedItem("");
                param = this.parameter;
                this.paramInfo.setText("");
            } else {
                param = "";
                if (this.parameterTree.getRowCount() == 0 && numSupport > 0 && numData == 0 && !this.showAllVarTypeCB.isSelected()) {
                    this.paramInfo.setText("(all parameters are marked as support data, select \"show all\" above)");
                } else {
                    this.paramInfo.setText("(no plottable parameters)");
                }
            }
            this.parameter = param.replaceAll("%3D", "=");
            if ("no".equals(lparams.remove("interpMeta"))) {
                this.noInterpMeta.setSelected(true);
            }
            if ("no".equals(lparams.remove("doDep"))) {
                this.noDep.setSelected(true);
            }
            this.whereParamList.setModel(new DefaultComboBoxModel<Object>(whereParameterInfo.keySet().toArray()));
            String where = (String)lparams.remove("where");
            if (where != null && where.length() > 0) {
                this.whereCB.setSelected(true);
                int i4 = where.indexOf(".");
                if (i4 > -1) {
                    this.whereParamList.setSelectedItem(where.substring(0, i4));
                    int i0 = where.indexOf("(");
                    int i1 = where.indexOf(")", i0);
                    this.whereOp.setSelectedItem(where.substring(i4, i0));
                    this.whereTF.setText(where.substring(i0 + 1, i1).replaceAll("\\+", " "));
                }
            } else {
                this.whereCB.setSelected(false);
            }
        }
        catch (IOException ex) {
            DasExceptionHandler.handle(ex);
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IllegalArgumentException ex) {
            DasExceptionHandler.handle(ex);
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (Exception ex) {
            DasExceptionHandler.handle(ex);
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.params = lparams;
    }

    @Override
    public String getURI() {
        Map<String, String> lparams;
        URISplit split = URISplit.parse(this.resourceUri);
        split.vapScheme = this.vapScheme;
        String subset = this.subsetComboBox.getSelectedItem().toString().trim();
        if (subset.length() > 0 && subset.charAt(0) != '[') {
            subset = "[" + subset + "]";
        }
        lparams = (lparams = this.params) != null ? new HashMap<String, String>(lparams) : new HashMap<String, String>();
        if (this.isValidCDF) {
            TreePath yPath;
            int idx;
            String p;
            TreePath depend0Path;
            String p2;
            TreePath treePath = this.parameterTree.getSelectionPath();
            if (treePath == null) {
                logger.fine("param was null");
            } else if (treePath.getPathCount() == 3) {
                p2 = String.valueOf(treePath.getPathComponent(1));
                p2 = p2.replaceAll("=", "%3D");
                lparams.put("arg_0", p2 + subset);
                String val = String.valueOf(treePath.getPathComponent(2));
                int idx2 = val.indexOf(":");
                lparams.put("slice1", val.substring(0, idx2).trim());
            } else {
                p2 = String.valueOf(treePath.getPathComponent(1));
                p2 = p2.replaceAll("=", "%3D");
                lparams.put("arg_0", p2 + subset);
            }
            if (this.xCheckBox.isSelected() && (depend0Path = this.parameterTree1.getSelectionPath()) != null) {
                if (depend0Path.getPathCount() == 3) {
                    p = String.valueOf(depend0Path.getPathComponent(1));
                    p = p.replaceAll("=", "%3D");
                    String val = String.valueOf(depend0Path.getPathComponent(2));
                    idx = val.indexOf(":");
                    lparams.put("x", p + "[:," + val.substring(0, idx).trim() + "]");
                } else {
                    p = String.valueOf(depend0Path.getPathComponent(1));
                    p = p.replaceAll("=", "%3D");
                    lparams.put("x", p);
                }
            }
            if (this.yCheckBox.isSelected() && (yPath = this.parameterTree2.getSelectionPath()) != null) {
                if (yPath.getPathCount() == 3) {
                    p = String.valueOf(yPath.getPathComponent(1));
                    p = p.replaceAll("=", "%3D");
                    String val = String.valueOf(yPath.getPathComponent(2));
                    idx = val.indexOf(":");
                    lparams.put("y", p + "[:," + val.substring(0, idx).trim() + "]");
                } else {
                    p = String.valueOf(yPath.getPathComponent(1));
                    p = p.replaceAll("=", "%3D");
                    lparams.put("y", p);
                }
            }
            if (this.noDep.isSelected()) {
                lparams.put("doDep", "no");
            }
            if (this.noInterpMeta.isSelected()) {
                lparams.put("interpMeta", "no");
            }
            if (this.whereCB.isSelected()) {
                lparams.put("where", String.format("%s%s(%s)", this.whereParamList.getSelectedItem(), this.whereOp.getSelectedItem(), this.whereTF.getText().replaceAll(" ", "+")));
            }
        }
        split.params = URISplit.formatParams(lparams);
        if (split.params != null && split.params.length() == 0) {
            split.params = null;
        }
        return URISplit.format(split);
    }

    @Override
    public void markProblems(List<String> problems) {
    }

    private void fillTree(JTree parameterTree, Map<String, String> mm, CDFReader cdf, String param, String slice1) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        ArrayList<TreePath> expand = new ArrayList<TreePath>(mm.size());
        TreePath selection = null;
        for (Map.Entry<String, String> e : mm.entrySet()) {
            try {
                boolean doComponents;
                Object oattr = cdf.getAttribute(e.getKey(), "LABL_PTR_1");
                String lablPtr1 = null;
                if (oattr != null && oattr instanceof List) {
                    List voattr = (List)oattr;
                    if (voattr.size() > 0) {
                        lablPtr1 = (String)((List)oattr).get(0);
                    } else {
                        oattr = null;
                    }
                }
                int[] dimensions = cdf.getDimensions(e.getKey());
                boolean bl = doComponents = oattr != null && dimensions.length == 1 && dimensions[0] <= 32;
                if (doComponents) {
                    String s = lablPtr1;
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(e.getKey());
                    try {
                        String[] rec;
                        Object o = cdf.get(s);
                        if (o.getClass().isArray() && String.class.isAssignableFrom(o.getClass().getComponentType())) {
                            rec = (String[])o;
                        } else {
                            Object oo = Array.get(o, 0);
                            if (!oo.getClass().isArray() || !String.class.isAssignableFrom(oo.getClass().getComponentType())) {
                                logger.log(Level.FINE, "Expected string array in element: {0}", s);
                                continue;
                            }
                            rec = (String[])Array.get(o, 0);
                        }
                        for (int i = 0; i < rec.length; ++i) {
                            String snode = String.format("%d: %s", i, rec[i]);
                            DefaultMutableTreeNode child = new DefaultMutableTreeNode(snode);
                            node.add(child);
                            if (!e.getKey().equals(param)) continue;
                            if (slice1 != null) {
                                if (!String.valueOf(i).equals(slice1)) continue;
                                selection = new TreePath(new Object[]{root, node, child});
                                continue;
                            }
                            selection = new TreePath(new Object[]{root, node});
                        }
                        root.add(node);
                        if (rec.length >= 4) continue;
                        expand.add(new TreePath(new Object[]{root, node}));
                    }
                    catch (CDFException.ReaderError | ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
                        logger.log(Level.WARNING, "parameter name found: " + s + " referred to by " + e.getKey(), ex);
                        root.add(node);
                    }
                    continue;
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(e.getKey());
                root.add(node);
                if (!e.getKey().equals(param)) continue;
                selection = new TreePath(new Object[]{root, node});
            }
            catch (CDFException.ReaderError t) {
                logger.log(Level.WARNING, t.getMessage(), t);
            }
        }
        DefaultTreeModel tm = new DefaultTreeModel(root);
        parameterTree.setRootVisible(false);
        parameterTree.setModel(tm);
        if (selection != null) {
            parameterTree.setSelectionPath(selection);
            parameterTree.scrollPathToVisible(selection);
        }
        for (TreePath tp : expand) {
            parameterTree.expandPath(tp);
        }
    }
}

