/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import gov.nasa.gsfc.spdf.cdfj.CDFDataType;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import gov.nasa.gsfc.spdf.cdfj.CDFWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class CdfDataSourceFormat
implements DataSourceFormat {
    CDFWriter cdf;
    Map<QDataSet, String> names = new HashMap<QDataSet, String>();
    Map<String, QDataSet> seman = new HashMap<String, QDataSet>();
    private static final Logger logger = LoggerManager.getLogger("apdss.cdf");

    private synchronized String nameFor(QDataSet dep0) {
        String name = this.names.get(dep0);
        if (name != null) {
            return name;
        }
        if (name == null) {
            QDataSet ds1;
            name = (String)dep0.property("NAME");
            while (this.seman.containsKey(name) && (ds1 = this.seman.get(name)) != null) {
                name = name + "_1";
            }
        }
        Units units = (Units)dep0.property("UNITS");
        if (name == null) {
            name = units != null && UnitsUtil.isTimeLocation(units) ? "Epoch" : "Variable_" + this.seman.size();
        }
        this.names.put(dep0, name);
        this.seman.put(name, dep0);
        return name;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        split = URISplit.parse(uri);
        params = URISplit.parseParams(split.params);
        ffile = new File(split.resourceUri.getPath());
        append = "T".equals(params.get("append"));
        if (!append) {
            CdfDataSourceFormat.logger.log(Level.FINE, "create CDF file {0}", ffile);
            CdfDataSourceFormat.logger.log(Level.FINE, "call cdf= new CDFWriter( false )");
            this.cdf = new CDFWriter(false);
        } else {
            read = new CDFReader(ffile.toString());
            for (String n : read.getVariableNames()) {
                this.seman.put(n, null);
            }
            CdfDataSourceFormat.logger.log(Level.FINE, "call cdf= new CDFWriter( {0}, false )", ffile.toString());
            this.cdf = new CDFWriter(ffile.toString(), false);
        }
        name1 = (String)params.get("arg_0");
        if (name1 != null) {
            this.names.put(data, name1);
            this.seman.put(name1, data);
        }
        this.nameFor(data);
        dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep0 != null) {
            if (!append) {
                name = this.nameFor(dep0);
                params1 = new HashMap<String, String>();
                params1.put("timeType", (String)params.get("timeType"));
                this.addVariableRankN(dep0, name, true, params1, mon);
            } else {
                name = this.nameFor(dep0);
                params1 = new HashMap<String, String>();
                params1.put("timeType", (String)params.get("timeType"));
                try {
                    this.addVariableRankN(dep0, name, true, params1, mon);
                }
                catch (Exception e) {
                    CdfDataSourceFormat.logger.fine("CDF Exception, presumably because the variable already exists.");
                }
            }
        }
        if ((dep1 = (QDataSet)data.property("DEPEND_1")) != null) {
            if (!append) {
                name = this.nameFor(dep1);
                this.addVariableRank1NoVary(dep1, name, true, new HashMap<String, String>(), new NullProgressMonitor());
            } else {
                name = this.nameFor(dep1);
                params1 = new HashMap<String, String>();
                try {
                    if (dep1.rank() == 1) {
                        this.addVariableRank1NoVary(dep1, name, true, params1, mon);
                    } else {
                        this.addVariableRankN(dep1, name, true, params1, mon);
                    }
                }
                catch (Exception e) {
                    CdfDataSourceFormat.logger.fine("CDF Exception, presumably because the variable already exists.");
                }
            }
        }
        if ((dep2 = (QDataSet)data.property("DEPEND_2")) != null) {
            if (!append) {
                name = this.nameFor(dep2);
                this.addVariableRank1NoVary(dep2, name, true, new HashMap<String, String>(), new NullProgressMonitor());
            } else {
                name = this.nameFor(dep2);
                params1 = new HashMap<String, String>();
                try {
                    if (dep2.rank() == 1) {
                        this.addVariableRank1NoVary(dep2, name, true, params1, mon);
                    } else {
                        this.addVariableRankN(dep2, name, true, params1, mon);
                    }
                }
                catch (Exception e) {
                    CdfDataSourceFormat.logger.fine("CDF Exception, presumably because the variable already exists.");
                }
            }
        }
        if ((bds = (QDataSet)data.property("BUNDLE_1")) != null) {
            if (!append && data.rank() == 2) {
                if (dep1 == null) {
                    CdfDataSourceFormat.logger.fine("writing bundled datasets to CDF separately.");
                } else {
                    name = this.nameFor(bds);
                    this.addVariableRank1NoVary(bds, name, true, new HashMap<String, String>(), new NullProgressMonitor());
                }
            } else {
                name = this.nameFor(bds);
                params1 = new HashMap<String, String>();
                try {
                    this.addVariableRank1NoVary(bds, name, true, params1, mon);
                }
                catch (Exception e) {
                    CdfDataSourceFormat.logger.fine("CDF Exception, presumably because the variable already exists.");
                }
            }
        }
        if (bds != null && dep1 == null && "T".equals(params.get("bundle"))) {
            for (i = 0; i < bds.length(); ++i) {
                data1 = Ops.unbundle(data, i);
                this.addVariableRankN(data1, this.nameFor(data1), false, params, mon);
                if (dep0 == null) continue;
                this.cdf.addVariableAttributeEntry(this.nameFor(data1), "DEPEND_0", CDFDataType.CHAR, (Object)this.nameFor(dep0));
            }
        } else {
            this.addVariableRankN(data, this.nameFor(data), false, params, mon);
            try {
                if (dep0 != null) {
                    this.cdf.addVariableAttributeEntry(this.nameFor(data), "DEPEND_0", CDFDataType.CHAR, (Object)this.nameFor(dep0));
                }
                if (dep1 != null) {
                    this.cdf.addVariableAttributeEntry(this.nameFor(data), "DEPEND_1", CDFDataType.CHAR, (Object)this.nameFor(dep1));
                }
                if (dep2 != null) {
                    this.cdf.addVariableAttributeEntry(this.nameFor(data), "DEPEND_2", CDFDataType.CHAR, (Object)this.nameFor(dep2));
                }
                if (bds == null) ** GOTO lbl109
                this.cdf.addVariableAttributeEntry(this.nameFor(data), "LABL_PTR_1", CDFDataType.CHAR, (Object)this.nameFor(bds));
            }
            catch (CDFException.WriterError ex) {
                CdfDataSourceFormat.logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
lbl109:
        // 4 sources

        if (!append) {
            if (ffile.exists()) {
                CdfDataSource.cdfCacheReset();
                tempFile = File.createTempFile("deleteme", ".cdf");
                if (!ffile.renameTo(tempFile)) {
                    ffile.delete();
                    CdfDataSourceFormat.logger.log(Level.WARNING, "file {0} cannot be renamed", ffile);
                }
                this.write(ffile.toString());
                if (tempFile.exists() && !tempFile.delete()) {
                    CdfDataSourceFormat.logger.log(Level.WARNING, "file {0} cannot be deleted", tempFile);
                }
            } else {
                this.write(ffile.toString());
            }
        } else {
            this.write(ffile.toString());
        }
    }

    private void addVariableRank1NoVary(QDataSet ds, String name, boolean isSupport, Map<String, String> params, ProgressMonitor mon) throws Exception {
        Units units = (Units)ds.property("UNITS");
        CDFDataType type = CDFDataType.DOUBLE;
        UnitsConverter uc = UnitsConverter.IDENTITY;
        if (units != null && UnitsUtil.isTimeLocation(units)) {
            type = CDFDataType.EPOCH;
            uc = units.getConverter(Units.cdfEpoch);
        }
        if (ds.rank() == 1) {
            Object array = this.dataSetToArray(ds, uc, type, mon);
            logger.log(Level.FINE, "call cdf.addNRVVariable( {0},{1},{2})", new Object[]{name, this.logName(type), this.logName(new int[]{ds.length()}), this.logName(array)});
            this.cdf.addNRVVariable(name, type, new int[]{ds.length()}, array);
        } else if (Schemes.isBundleDescriptor(ds)) {
            String[] array = new String[ds.length()];
            String[] ss = DataSetOps.bundleNames(ds);
            int dim = 0;
            for (int i = 0; i < ds.length(); ++i) {
                String s = (String)ds.property("LABEL", i);
                if (s == null) {
                    s = (String)ds.property("NAME", i);
                }
                if (s == null) {
                    s = ss[i];
                }
                array[i] = s;
                int l = s.length();
                dim = dim < l ? l : dim;
            }
            logger.log(Level.FINE, "call cdf.addNRVVariable( {0},{1},{2})", new Object[]{name, this.logName(type), this.logName(new int[]{ds.length()}), this.logName(array)});
            this.cdf.addNRVVariable(name, CDFDataType.CHAR, new int[]{ds.length()}, dim, (Object)array);
        } else {
            throw new IllegalArgumentException("not supported!");
        }
        this.copyMetadata(units, name, type, isSupport, ds);
    }

    private int encodeUINT4(double d) {
        return (int)(d > 2.147483648E9 ? d - 4.294967296E9 : d);
    }

    private short encodeUINT2(double d) {
        return (short)(d > 32768.0 ? d - 65536.0 : d);
    }

    private byte encodeUINT1(double d) {
        return (byte)(d > 128.0 ? d - 256.0 : d);
    }

    private ByteBuffer doIt1Nio(QDataSet ds, UnitsConverter uc, CDFDataType type) {
        ByteBuffer export;
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        if (type == CDFDataType.DOUBLE || type == CDFDataType.EPOCH) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putDouble(uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.TT2000) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putLong((long)uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.FLOAT) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 4);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putFloat((float)uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.INT4) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 4);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putInt((int)uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.INT2) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 2);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putShort((short)uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.INT1) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 1);
            while (iter.hasNext()) {
                iter.next();
                buf.put((byte)uc.convert(iter.getValue(ds)));
            }
            export = buf;
        } else if (type == CDFDataType.UINT4) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 4);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putInt(this.encodeUINT4(uc.convert(iter.getValue(ds))));
            }
            export = buf;
        } else if (type == CDFDataType.UINT2) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 2);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (iter.hasNext()) {
                iter.next();
                buf.putShort(this.encodeUINT2(uc.convert(iter.getValue(ds))));
            }
            export = buf;
        } else if (type == CDFDataType.UINT1) {
            ByteBuffer buf = ByteBuffer.allocate(ds.length() * 1);
            while (iter.hasNext()) {
                iter.next();
                buf.put(this.encodeUINT1(uc.convert(iter.getValue(ds))));
            }
            export = buf;
        } else {
            throw new IllegalArgumentException("not supported: " + type);
        }
        export.flip();
        return export;
    }

    private ByteBuffer dataSetToNioArray(QDataSet ds, UnitsConverter uc, CDFDataType type, ProgressMonitor mon) {
        switch (ds.rank()) {
            case 1: {
                return this.doIt1Nio(ds, uc, type);
            }
            case 2: {
                throw new UnsupportedOperationException("not implemented");
            }
            case 3: {
                throw new UnsupportedOperationException("not implemented");
            }
            case 4: {
                throw new UnsupportedOperationException("not implemented");
            }
        }
        throw new IllegalArgumentException("rank 0 not supported");
    }

    private Object doIt1(QDataSet ds, UnitsConverter uc, CDFDataType type) {
        Object[] export;
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        if (type == CDFDataType.DOUBLE || type == CDFDataType.EPOCH) {
            double[] dexport = new double[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                dexport[i++] = uc.convert(iter.getValue(ds));
            }
            export = dexport;
        } else if (type == CDFDataType.TT2000) {
            long[] dexport = new long[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                dexport[i++] = (long)uc.convert(iter.getValue(ds));
            }
            export = dexport;
        } else if (type == CDFDataType.FLOAT) {
            float[] fexport = new float[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                fexport[i++] = (float)uc.convert(iter.getValue(ds));
            }
            export = fexport;
        } else if (type == CDFDataType.INT4) {
            int[] bexport = new int[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (int)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.INT2) {
            short[] bexport = new short[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (short)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else if (type == CDFDataType.INT1) {
            byte[] bexport = new byte[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (byte)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else {
            throw new IllegalArgumentException("not supported: " + type);
        }
        return export;
    }

    private Object dataSetToArray(QDataSet ds, UnitsConverter uc, CDFDataType type, ProgressMonitor mon) {
        switch (ds.rank()) {
            case 1: {
                return this.doIt1(ds, uc, type);
            }
            case 2: {
                Object oexport;
                if (type == CDFDataType.DOUBLE) {
                    oexport = new double[ds.length()][];
                } else if (type == CDFDataType.TT2000) {
                    oexport = new long[ds.length()][];
                } else if (type == CDFDataType.FLOAT) {
                    oexport = new float[ds.length()][];
                } else if (type == CDFDataType.INT4) {
                    oexport = new int[ds.length()][];
                } else if (type == CDFDataType.INT2) {
                    oexport = new short[ds.length()][];
                } else if (type == CDFDataType.INT1) {
                    oexport = new byte[ds.length()][];
                } else {
                    throw new IllegalArgumentException("type not supported: " + type);
                }
                for (int i = 0; i < ds.length(); ++i) {
                    Array.set(oexport, i, this.dataSetToArray(ds.slice(i), uc, type, mon));
                }
                return oexport;
            }
            case 3: {
                Object oexport;
                if (type == CDFDataType.DOUBLE) {
                    oexport = new double[ds.length()][][];
                } else if (type == CDFDataType.TT2000) {
                    oexport = new long[ds.length()][][];
                } else if (type == CDFDataType.FLOAT) {
                    oexport = new float[ds.length()][][];
                } else if (type == CDFDataType.INT4) {
                    oexport = new int[ds.length()][][];
                } else if (type == CDFDataType.INT2) {
                    oexport = new short[ds.length()][][];
                } else if (type == CDFDataType.INT1) {
                    oexport = new byte[ds.length()][][];
                } else {
                    throw new IllegalArgumentException("type not supported" + type);
                }
                for (int i = 0; i < ds.length(); ++i) {
                    Array.set(oexport, i, this.dataSetToArray(ds.slice(i), uc, type, mon));
                }
                return oexport;
            }
            case 4: {
                Object oexport;
                if (type == CDFDataType.DOUBLE) {
                    oexport = new double[ds.length()][][][];
                } else if (type == CDFDataType.TT2000) {
                    oexport = new long[ds.length()][][][];
                } else if (type == CDFDataType.FLOAT) {
                    oexport = new float[ds.length()][][][];
                } else if (type == CDFDataType.INT4) {
                    oexport = new int[ds.length()][][][];
                } else if (type == CDFDataType.INT2) {
                    oexport = new short[ds.length()][][][];
                } else if (type == CDFDataType.INT1) {
                    oexport = new byte[ds.length()][][][];
                } else {
                    throw new IllegalArgumentException("type not supported" + type);
                }
                for (int i = 0; i < ds.length(); ++i) {
                    Array.set(oexport, i, this.dataSetToArray(ds.slice(i), uc, type, mon));
                }
                return oexport;
            }
        }
        throw new IllegalArgumentException("rank 0 not supported");
    }

    private void addVariableRankN(QDataSet ds, String name, boolean isSupport, Map<String, String> params, ProgressMonitor mon) throws Exception {
        Units units = (Units)ds.property("UNITS");
        CDFDataType type = CDFDataType.DOUBLE;
        String t = params.get("type");
        if (t != null) {
            switch (t) {
                case "float": {
                    type = CDFDataType.FLOAT;
                    break;
                }
                case "byte": {
                    type = CDFDataType.INT1;
                    break;
                }
                case "int1": {
                    type = CDFDataType.INT1;
                    break;
                }
                case "int2": {
                    type = CDFDataType.INT2;
                    break;
                }
                case "int4": {
                    type = CDFDataType.INT4;
                    break;
                }
                case "uint1": {
                    type = CDFDataType.UINT1;
                    break;
                }
                case "uint2": {
                    type = CDFDataType.UINT2;
                    break;
                }
                case "uint4": {
                    type = CDFDataType.UINT4;
                    break;
                }
                case "double": {
                    type = CDFDataType.DOUBLE;
                    break;
                }
            }
        } else {
            type = ds.rank() < 3 ? CDFDataType.DOUBLE : CDFDataType.FLOAT;
        }
        boolean compressed = "T".equals(params.get("compressed"));
        UnitsConverter uc = UnitsConverter.IDENTITY;
        if (units != null && UnitsUtil.isTimeLocation(units)) {
            boolean tt2000;
            boolean bl = tt2000 = !"epoch".equals(params.get("timeType"));
            if (tt2000) {
                type = CDFDataType.TT2000;
                uc = units.getConverter(Units.cdfTT2000);
                units = Units.cdfTT2000;
            } else {
                type = CDFDataType.EPOCH;
                uc = units.getConverter(Units.cdfEpoch);
                units = Units.cdfEpoch;
            }
        }
        if (ds.rank() == 0) {
            throw new IllegalArgumentException("rank 0 data not supported");
        }
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("high rank data not supported");
        }
        if (compressed) {
            if (ds.rank() == 1) {
                logger.log(Level.FINE, "call cdf.defineCompressedVariable( {0}, {1}, {2} )", new Object[]{name, this.logName(type), this.logName(new int[0])});
                this.cdf.defineCompressedVariable(name, type, new int[0]);
                this.addData(name, this.dataSetToNioArray(ds, uc, type, mon));
            } else {
                switch (ds.rank()) {
                    case 2: {
                        this.defineCompressedVariable(name, type, new int[]{ds.length(0)});
                        break;
                    }
                    case 3: {
                        this.defineCompressedVariable(name, type, new int[]{ds.length(0), ds.length(0, 0)});
                        break;
                    }
                    case 4: {
                        this.defineCompressedVariable(name, type, new int[]{ds.length(0), ds.length(0, 0), ds.length(0, 0, 0)});
                        break;
                    }
                }
                Object o = this.dataSetToArray(ds, uc, type, mon);
                this.addData(name, o);
            }
        } else if (ds.rank() == 1) {
            this.defineVariable(name, type, new int[0]);
            this.addData(name, this.dataSetToNioArray(ds, uc, type, mon));
        } else {
            switch (ds.rank()) {
                case 2: {
                    this.defineVariable(name, type, new int[]{ds.length(0)});
                    break;
                }
                case 3: {
                    this.defineVariable(name, type, new int[]{ds.length(0), ds.length(0, 0)});
                    break;
                }
                case 4: {
                    this.defineVariable(name, type, new int[]{ds.length(0), ds.length(0, 0), ds.length(0, 0, 0)});
                    break;
                }
            }
            this.addData(name, this.dataSetToArray(ds, uc, type, mon));
        }
        this.copyMetadata(units, name, type, isSupport, ds);
    }

    private String logName(Object o) {
        if (o.getClass().isArray()) {
            StringBuilder s = new StringBuilder(o.getClass().getComponentType().toString() + "[");
            s.append(Array.getLength(o));
            if (Array.getLength(o) > 0) {
                o = Array.get(o, 0);
                while (o.getClass().isArray()) {
                    s.append(",").append(Array.getLength(o));
                    o = Array.get(o, 0);
                }
            }
            s.append("]");
            return s.toString();
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof CDFDataType) {
            return "CDFDataType=" + ((CDFDataType)o).getValue();
        }
        return o.toString();
    }

    private void write(String name) throws IOException {
        logger.log(Level.FINE, "call cdf.write({0})", new Object[]{this.logName(name)});
        try {
            CdfDataSource.cdfCacheReset();
            this.cdf.write(name);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "first attempt to write \"{0}\" fails, try again for good measure", name);
            CdfDataSource.cdfCacheReset();
            System.gc();
            try {
                Thread.sleep(1000L);
                System.gc();
                Thread.sleep(1000L);
                System.gc();
            }
            catch (InterruptedException ex1) {
                logger.log(Level.SEVERE, null, ex1);
            }
            this.cdf.write(name);
        }
    }

    private void defineCompressedVariable(String name, CDFDataType type, int[] dims) throws Exception {
        logger.log(Level.FINE, "call cdf.defineCompressedVariable({0},{1},{2})", new Object[]{this.logName(name), this.logName(type), this.logName(dims)});
        this.cdf.defineCompressedVariable(name, type, dims);
    }

    private void defineVariable(String name, CDFDataType type, int[] dims) throws Exception {
        logger.log(Level.FINE, "call cdf.defineVariable({0},{1},{2})", new Object[]{this.logName(name), this.logName(type), this.logName(dims)});
        this.cdf.defineVariable(name, type, dims);
    }

    private void addData(String name, Object d) throws Exception {
        logger.log(Level.FINE, "call cdf.addData({0},{1})", new Object[]{this.logName(name), this.logName(d)});
        this.cdf.addData(name, d);
    }

    private void addVariableAttributeEntry(String varName, String attrName, CDFDataType type, Object o) throws CDFException.WriterError {
        logger.log(Level.FINE, "call cdf.addVariableAttributeEntry( {0}, {1}, {2}, {3} )", new Object[]{this.logName(varName), this.logName(attrName), this.logName(type), this.logName(o)});
        if (type == CDFDataType.CHAR && o.toString().length() == 0) {
            o = " ";
        }
        this.cdf.addVariableAttributeEntry(varName, attrName, type, o);
    }

    private void copyMetadata(Units units, String name, CDFDataType type, boolean isSupport, QDataSet ds) throws Exception {
        String displayType;
        String format;
        String scaleTyp;
        Number fillval;
        String title;
        if (units != null) {
            if (units == Units.cdfEpoch) {
                this.addVariableAttributeEntry(name, "UNITS", CDFDataType.CHAR, "ms");
            } else if (units == Units.cdfTT2000) {
                this.addVariableAttributeEntry(name, "UNITS", CDFDataType.CHAR, "ns");
            } else {
                this.addVariableAttributeEntry(name, "UNITS", CDFDataType.CHAR, units.toString());
            }
        } else {
            this.addVariableAttributeEntry(name, "UNITS", CDFDataType.CHAR, " ");
        }
        String label = (String)ds.property("LABEL");
        if (label != null && label.length() > 0) {
            if (units != null && label.endsWith("(" + units + ")")) {
                label = label.substring(0, label.length() - units.toString().length() - 2);
            }
            this.addVariableAttributeEntry(name, "LABLAXIS", CDFDataType.CHAR, label);
        }
        if ((title = (String)ds.property("TITLE")) != null && title.length() > 0) {
            this.addVariableAttributeEntry(name, "CATDESC", CDFDataType.CHAR, title);
        }
        Number vmax = (Number)ds.property("VALID_MAX");
        Number vmin = (Number)ds.property("VALID_MIN");
        if ((vmax != null || vmin != null) && units != Units.cdfEpoch) {
            if (units == Units.cdfTT2000) {
                if (vmax != null && vmin != null) {
                    this.cdf.addVariableAttributeEntry(name, "VALIDMIN", CDFDataType.TT2000, (Object)new long[]{vmin.longValue()});
                    this.cdf.addVariableAttributeEntry(name, "VALIDMAX", CDFDataType.TT2000, (Object)new long[]{vmax.longValue()});
                }
            } else {
                if (vmax == null) {
                    vmax = 1.0E38;
                }
                if (vmin == null) {
                    vmin = -1.0E38;
                }
                this.cdf.addVariableAttributeEntry(name, "VALIDMIN", type, (Object)new double[]{vmin.doubleValue()});
                this.cdf.addVariableAttributeEntry(name, "VALIDMAX", type, (Object)new double[]{vmax.doubleValue()});
            }
        }
        if ((fillval = (Number)ds.property("FILL_VALUE")) != null) {
            this.cdf.addVariableAttributeEntry(name, "FILLVAL", type, (Object)new double[]{fillval.doubleValue()});
        }
        Number smax = (Number)ds.property("TYPICAL_MAX");
        Number smin = (Number)ds.property("TYPICAL_MIN");
        if ((smax != null || smin != null) && units != Units.cdfEpoch) {
            if (units == Units.cdfTT2000) {
                if (smax == null) {
                    smax = Units.cdfTT2000.parse("1958-01-01T00:00").doubleValue(Units.cdfTT2000);
                }
                if (smin == null) {
                    smin = Units.cdfTT2000.parse("2058-01-01T00:00").doubleValue(Units.cdfTT2000);
                }
                this.cdf.addVariableAttributeEntry(name, "SCALEMIN", CDFDataType.TT2000, (Object)new long[]{smin.longValue()});
                this.cdf.addVariableAttributeEntry(name, "SCALEMAX", CDFDataType.TT2000, (Object)new long[]{smax.longValue()});
            } else {
                if (smax == null) {
                    smax = 1.0E38;
                }
                if (smin == null) {
                    smin = -1.0E38;
                }
                this.cdf.addVariableAttributeEntry(name, "SCALEMIN", type, (Object)new double[]{smin.doubleValue()});
                this.cdf.addVariableAttributeEntry(name, "SCALEMAX", type, (Object)new double[]{smax.doubleValue()});
            }
        }
        if ((scaleTyp = (String)ds.property("SCALE_TYPE")) != null) {
            this.addVariableAttributeEntry(name, "SCALETYP", CDFDataType.CHAR, scaleTyp);
        }
        if ((format = (String)ds.property("FORMAT")) != null && format.trim().length() > 0) {
            this.addVariableAttributeEntry(name, "FORMAT", CDFDataType.CHAR, format);
        }
        if ((displayType = (String)ds.property("RENDER_TYPE")) == null || displayType.length() == 0) {
            displayType = DataSourceUtil.guessRenderType(ds);
        }
        switch (displayType) {
            case "nnSpectrogram": 
            case "spectrogram": {
                displayType = "spectrogram";
                break;
            }
            case "image": {
                displayType = "image";
                break;
            }
            case "series": 
            case "scatter": 
            case "hugeScatter": {
                displayType = "time_series";
                break;
            }
        }
        this.addVariableAttributeEntry(name, "DISPLAY_TYPE", CDFDataType.CHAR, displayType);
        this.addVariableAttributeEntry(name, "VAR_TYPE", CDFDataType.CHAR, isSupport ? "support_data" : "data");
    }

    @Override
    public boolean canFormat(QDataSet ds) {
        return ds.rank() != 0 && !SemanticOps.isJoin(ds);
    }

    @Override
    public String getDescription() {
        return "NASA Common Data Format";
    }
}

