/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import gov.nasa.gsfc.spdf.cdfj.ReaderFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.cdf.CdfDataSetUtil;
import org.autoplot.cdf.CdfUtil;
import org.autoplot.cdf.CdfVirtualVars;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.ReferenceCache;
import org.autoplot.metatree.IstpMetadataModel;
import org.autoplot.metatree.MetadataUtil;
import org.autoplot.util.TickleTimer;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.ReplicateDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class CdfDataSource
extends AbstractDataSource {
    protected static final String PARAM_DODEP = "doDep";
    protected static final String PARAM_WHERE = "where";
    protected static final String PARAM_DEPEND0 = "depend0";
    protected static final String PARAM_X = "x";
    protected static final String PARAM_Y = "y";
    protected static final String PARAM_INTERPMETA = "interpMeta";
    protected static final String PARAM_ID = "id";
    protected static final String PARAM_SLICE1 = "slice1";
    protected static final String ATTR_SLICE1_LABELS = "slice1_labels";
    protected static final String ATTR_SLICE1 = "slice1";
    private static final Logger logger = LoggerManager.getLogger("apdss.cdf");
    private Map<String, Object> attributes;
    private static final int FILE_CACHE_SIZE_LIMIT = 2;
    private static final LinkedHashMap<String, CDFReader> openFiles = new LinkedHashMap();
    private static final Map<CDFReader, String> openFilesRev = new HashMap<CDFReader, String>();
    private static final Map<String, Long> openFilesFresh = new HashMap<String, Long>();
    private static final Object lock = new Object();
    private static final int DS_CACHE_SIZE_LIMIT = 2;
    private static final LinkedHashMap<String, MutablePropertyDataSet> dsCache = new LinkedHashMap();
    private static final HashMap<String, Long> dsCacheFresh = new HashMap();
    private static final Object dslock = new Object();
    public static final TickleTimer timer = new TickleTimer(10000L, new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            logger.log(Level.FINER, "unloading CDF cache to resolve bug 1002");
            Object object = lock;
            synchronized (object) {
                openFiles.clear();
                openFilesRev.clear();
                openFilesFresh.clear();
            }
        }
    });
    private static int allocateDirect = -1;

    public CdfDataSource(URI uri) {
        super(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cdfCacheUnload(String fileName, boolean unloadDs) {
        Object object = lock;
        synchronized (object) {
            logger.log(Level.FINER, "cdfCacheUnload cdf file {0} from cache: unloadDs={1}", new Object[]{fileName, unloadDs});
            CDFReader cdf = (CDFReader)openFiles.remove(fileName);
            openFilesRev.remove(cdf);
            openFilesFresh.remove(fileName);
            if (unloadDs) {
                Object object2 = dslock;
                synchronized (object2) {
                    ArrayList<String> unload = new ArrayList<String>();
                    for (String ds : dsCache.keySet()) {
                        if (!ds.startsWith(fileName)) continue;
                        unload.add(ds);
                    }
                    for (String ds : unload) {
                        dsCache.remove(ds);
                        dsCacheFresh.remove(ds);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cdfCacheReset() {
        Object object = lock;
        synchronized (object) {
            openFiles.clear();
            openFilesRev.clear();
            openFilesFresh.clear();
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String cdfCacheFileForReader(CDFReader cdf) {
        String cdfFile;
        Object object = lock;
        synchronized (object) {
            cdfFile = openFilesRev.get(cdf);
        }
        return cdfFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dsCachePut(String uri, MutablePropertyDataSet ds) {
        Object object = dslock;
        synchronized (object) {
            logger.log(Level.FINER, "dsCachePut uri={0} ds={1}", new Object[]{uri, ds});
            dsCache.remove(uri);
            dsCache.put(uri, ds);
            dsCacheFresh.put(uri, System.currentTimeMillis());
            while (dsCache.size() > 2) {
                Map.Entry<String, MutablePropertyDataSet> first = dsCache.entrySet().iterator().next();
                dsCache.remove(first.getKey());
                logger.log(Level.FINER, "remove {0}", first.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printCacheReport() {
        Object object = dslock;
        synchronized (object) {
            for (Map.Entry<String, MutablePropertyDataSet> entry : dsCache.entrySet()) {
                int mem = CdfUtil.jvmMemory(entry.getValue());
                System.err.println(String.format("%9d %s %s", mem, entry.getKey(), entry.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDFReader getCdfFile(String fileName) {
        CDFReader cdf;
        block30: {
            if (allocateDirect == -1) {
                allocateDirect = BufferDataSet.shouldAllocateDirect();
            }
            try {
                Object object = lock;
                synchronized (object) {
                    cdf = openFiles.get(fileName);
                    logger.log(Level.FINER, "cdf open files cache contained: {0}", cdf);
                }
                if (cdf == null) {
                    object = lock;
                    synchronized (object) {
                        File cdfFile = new File(fileName);
                        if (!cdfFile.exists()) {
                            throw new IllegalArgumentException("CDF file does not exist: " + fileName);
                        }
                        if (cdfFile.length() == 0L) {
                            throw new IllegalArgumentException("CDF file length is zero: " + fileName);
                        }
                        if (cdfFile.length() < Integer.MAX_VALUE) {
                            if (allocateDirect == 0) {
                                try {
                                    cdf = ReaderFactory.getReader((String)fileName);
                                }
                                catch (Exception e) {
                                    try {
                                        cdf = new CDFReader(fileName);
                                    }
                                    catch (Exception e2) {
                                        throw e;
                                    }
                                }
                            } else {
                                cdf = new CDFReader(fileName);
                            }
                        } else {
                            cdf = ReaderFactory.getReader((String)fileName);
                        }
                        openFiles.put(fileName, cdf);
                        openFilesRev.put(cdf, fileName);
                        openFilesFresh.put(fileName, System.currentTimeMillis());
                        logger.log(Level.FINER, "added cdf file {0} to cache: {1}", new Object[]{fileName, cdf});
                        if (openFiles.size() > 2) {
                            String oldest = openFiles.entrySet().iterator().next().getKey();
                            CdfDataSource.cdfCacheUnload(oldest, true);
                        }
                        break block30;
                    }
                }
                object = lock;
                synchronized (object) {
                    Long date = openFilesFresh.get(fileName);
                    if (date == null || new File(fileName).lastModified() > date) {
                        if (allocateDirect == 0) {
                            cdf = ReaderFactory.getReader((String)fileName);
                        } else {
                            cdf = new CDFReader(fileName);
                        }
                        openFiles.put(fileName, cdf);
                        openFilesRev.put(cdf, fileName);
                        openFilesFresh.put(fileName, System.currentTimeMillis());
                    } else {
                        openFiles.put(fileName, cdf);
                        openFilesRev.put(cdf, fileName);
                        openFilesFresh.put(fileName, System.currentTimeMillis());
                        logger.log(Level.FINE, "using cached open CDF {0}", fileName);
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "An exception was caught in CdfJava openFiles caching", ex);
                throw new RuntimeException(ex);
            }
        }
        timer.tickle("unload cdf soon");
        return cdf;
    }

    @Override
    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        boolean useReferenceCache = "true".equals(System.getProperty("enableReferenceCache", "false"));
        ReferenceCache.ReferenceCacheEntry rcent = null;
        if (useReferenceCache) {
            rcent = ReferenceCache.getInstance().getDataSetOrLock(this.getURI(), mon);
            if (!rcent.shouldILoad(Thread.currentThread())) {
                QDataSet result = rcent.park(mon);
                logger.log(Level.FINE, "reference cache used to resolve {0}", new Object[]{String.valueOf(result)});
                logger.log(Level.FINE, "ref uri {0}", new Object[]{this.resourceURI});
                return result;
            }
            logger.log(Level.FINE, "reference cache in use, {0} is loading {1}", new Object[]{Thread.currentThread().toString(), this.resourceURI});
        }
        try {
            File cdfFile = this.getFile(mon.getSubtaskMonitor("download file"));
            logger.log(Level.FINE, "getDataSet ({0})", this.getURI());
            String fileName = cdfFile.toString();
            Map<String, String> map = this.getParams();
            mon.setProgressMessage("open CDF file");
            CDFReader cdf = CdfDataSource.getCdfFile(fileName);
            logger.log(Level.FINE, "got cdf file for {0} {1}", new Object[]{fileName, cdf});
            String svariable = map.get(PARAM_ID);
            if (svariable == null) {
                svariable = map.get("arg_0");
            }
            String constraint = null;
            if (svariable == null) {
                throw new IllegalArgumentException("CDF URI needs an argument");
            }
            String interpMeta = map.get(PARAM_INTERPMETA);
            if (!"no".equals(interpMeta)) {
                long numRec;
                List<String> ss;
                int i = svariable.indexOf("[");
                if (i != -1) {
                    constraint = svariable.substring(i);
                    svariable = svariable.substring(0, i);
                }
                if (!(ss = Arrays.asList(cdf.getVariableNames())).contains(svariable)) {
                    throw new IllegalArgumentException("No Such Variable: " + svariable);
                }
                try {
                    numRec = cdf.getNumberOfValues(svariable);
                }
                catch (CDFException ex) {
                    throw new Exception("CDFException " + ex.getMessage());
                }
                int[] dimensions = cdf.getDimensions(svariable);
                long[] ndimensions = new long[dimensions.length + 1];
                ndimensions[0] = numRec;
                for (i = 0; i < dimensions.length; ++i) {
                    ndimensions[i + 1] = dimensions[i];
                }
                Map<Integer, long[]> constraints = DataSourceUtil.parseConstraint(constraint, ndimensions);
                long[] recs = constraints.get(0);
                if (this.attributes == null) {
                    Matcher m;
                    this.getMetadata(new NullProgressMonitor());
                    this.attributes = this.readAttributes(cdf, svariable, 0);
                    if (recs[2] == -1L) {
                        this.attributes = MetadataUtil.sliceProperties(this.attributes, 0);
                    }
                    if (map.get("slice1") != null) {
                        this.attributes.put("slice1", map.get("slice1"));
                    }
                    if (constraint != null && (m = Pattern.compile("\\[\\:\\,(\\d+)\\]").matcher(constraint)).matches()) {
                        this.attributes.put("slice1", m.group(1));
                    }
                    if (map.get(PARAM_X) != null) {
                        Map<String, Object> xattr = this.readXorYAttributes(cdf, map.get(PARAM_X), 0);
                        this.attributes.put("DEPEND_0", xattr);
                    }
                    if (map.get(PARAM_Y) != null) {
                        Map<String, Object> yattr = this.readXorYAttributes(cdf, map.get(PARAM_Y), 0);
                        this.attributes.put("Y", yattr);
                    }
                }
            }
            QDataSet result = this.getDataSet(mon, this.attributes);
            if (rcent != null) {
                rcent.finished(result);
            }
            return result;
        }
        catch (Exception ex) {
            if (rcent != null) {
                rcent.exception(ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDataSet getDataSet(ProgressMonitor mon, Map<String, Object> attr1) throws Exception {
        Units dep1units;
        QDataSet dep1;
        String w;
        String sy;
        String sx;
        MutablePropertyDataSet result;
        boolean doDep;
        String lsurl = this.uri.toString();
        Object object = dslock;
        synchronized (object) {
            MutablePropertyDataSet cached = dsCache.get(lsurl);
            if (cached != null) {
                CdfDataSource.dsCachePut(lsurl, cached);
            }
        }
        mon.started();
        File cdfFile = this.getFile(mon.getSubtaskMonitor("download file"));
        String fileName = cdfFile.toString();
        Map<String, String> map = this.getParams();
        mon.setProgressMessage("open CDF file");
        CDFReader cdf = CdfDataSource.getCdfFile(fileName);
        String svariable = map.get(PARAM_ID);
        if (svariable == null) {
            svariable = map.get("arg_0");
        }
        if (svariable == null) {
            throw new IllegalArgumentException("CDF URI needs an argument");
        }
        String constraint = null;
        int i = svariable.indexOf("[");
        if (i != -1) {
            constraint = svariable.substring(i);
            svariable = svariable.substring(0, i);
        }
        String interpMeta = map.get(PARAM_INTERPMETA);
        boolean bl = doDep = !"no".equals(map.get(PARAM_DODEP));
        if (attr1 != null && attr1.containsKey("VIRTUAL") && (attr1.containsKey("FUNCTION") || attr1.containsKey("FUNCT"))) {
            ArrayList<QDataSet> args = new ArrayList<QDataSet>();
            String function = (String)attr1.get("FUNCTION");
            if (function == null) {
                function = (String)attr1.get("FUNCT");
            }
            if (attr1.get("COMPONENT_0") != null) {
                args.add(this.wrapDataSet(cdf, (String)attr1.get("COMPONENT_0"), constraint, false, true, null, -1, mon.getSubtaskMonitor("c0")));
            }
            if (attr1.get("COMPONENT_1") != null) {
                args.add(this.wrapDataSet(cdf, (String)attr1.get("COMPONENT_1"), constraint, false, true, null, -1, mon.getSubtaskMonitor("c1")));
            }
            if (attr1.get("COMPONENT_2") != null) {
                args.add(this.wrapDataSet(cdf, (String)attr1.get("COMPONENT_2"), constraint, false, true, null, -1, mon.getSubtaskMonitor("c2")));
            }
            if (attr1.get("COMPONENT_3") != null) {
                args.add(this.wrapDataSet(cdf, (String)attr1.get("COMPONENT_3"), constraint, false, true, null, -1, mon.getSubtaskMonitor("c3")));
            }
            if (attr1.get("COMPONENT_4") != null) {
                args.add(this.wrapDataSet(cdf, (String)attr1.get("COMPONENT_4"), constraint, false, true, null, -1, mon.getSubtaskMonitor("c4")));
            }
            Map<String, Object> qmetadata = new IstpMetadataModel().properties(attr1);
            result = (MutablePropertyDataSet)CdfVirtualVars.execute(qmetadata, function, args, mon.getSubtaskMonitor("virtual variable"));
            String os1 = map.get("slice1");
            if (os1 != null && !os1.equals("") && cdf.getDimensions(svariable).length > 0) {
                int is = Integer.parseInt(os1);
                result = (MutablePropertyDataSet)Ops.slice1((QDataSet)result, is);
            }
        } else {
            String os1 = map.get("slice1");
            if (os1 != null && !os1.equals("") && cdf.getDimensions(svariable).length > 0) {
                int is = Integer.parseInt(os1);
                result = this.wrapDataSet(cdf, svariable, constraint, false, doDep, attr1, is, mon.getSubtaskMonitor("reading " + svariable + " from CDF file"));
            } else {
                result = this.wrapDataSet(cdf, svariable, constraint, false, doDep, attr1, -1, mon.getSubtaskMonitor("reading " + svariable + " from CDF file"));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            int islash = fileName.lastIndexOf(47);
            logger.log(Level.FINE, "reading from {0}", fileName.substring(0, islash));
            logger.log(Level.FINE, "read variable {0}?{1} got {2}", new Object[]{fileName.substring(islash), svariable, String.valueOf(result)});
        }
        if ((sx = map.get(PARAM_X)) != null && sx.length() > 0) {
            String constraint1;
            int k = sx.indexOf("[");
            if (k != -1) {
                constraint1 = sx.substring(k);
                sx = sx.substring(0, k);
            } else {
                constraint1 = constraint;
            }
            MutablePropertyDataSet parm = this.wrapDataSet(cdf, sx, constraint1, false, false, null);
            result = (MutablePropertyDataSet)Ops.link(parm, result);
        }
        if ((sy = map.get(PARAM_Y)) != null && sy.length() > 0) {
            String constraint1;
            int k = sy.indexOf("[");
            if (k != -1) {
                constraint1 = sy.substring(k);
                sy = sy.substring(0, k);
            } else {
                constraint1 = constraint;
            }
            QDataSet parm = this.wrapDataSet(cdf, sy, constraint1, false, false, null);
            if (parm.length() == 1 && parm.rank() == 2 && result.rank() > 1 && result.length() > 1) {
                parm = parm.slice(0);
            }
            result = (MutablePropertyDataSet)Ops.link(result.property("DEPEND_0"), (Object)parm, (Object)result);
        }
        if ((w = map.get(PARAM_WHERE)) != null && w.length() > 0) {
            int ieq = w.indexOf(".");
            String sparm = w.substring(0, ieq);
            MutablePropertyDataSet parm = this.wrapDataSet(cdf, sparm, constraint, false, false, null);
            if (parm.length() == 1 && parm.rank() == 2 && result.rank() > 1 && result.length() > 1) {
                parm = Ops.replicate(parm.slice(0), result.length());
            }
            result = this.doWhereFilter(w, parm, result);
        }
        if (!doDep) {
            result.putProperty("DEPEND_0", null);
            result.putProperty("DEPEND_1", null);
            result.putProperty("DEPEND_2", null);
            result.putProperty("DEPEND_3", null);
            if (attr1 != null) {
                attr1.remove("DEPEND_0");
                attr1.remove("DEPEND_1");
                attr1.remove("DEPEND_2");
                attr1.remove("DEPEND_3");
            }
        }
        if ("T".equals(this.getParam("replaceLabels", "F"))) {
            this.maybeReplaceLabels(result);
        }
        if (!"no".equals(interpMeta)) {
            String os1;
            IstpMetadataModel model = new IstpMetadataModel();
            Map<String, Object> istpProps = ((MetadataModel)model).properties(attr1);
            CdfUtil.maybeAddValidRange(istpProps, result);
            Number n = (Number)istpProps.get("FILL_VALUE");
            if (result instanceof BufferDataSet) {
                Class c = ((BufferDataSet)result).getCompatibleComponentType();
                if (n instanceof Double && c == Float.TYPE) {
                    istpProps.put("FILL_VALUE", Float.valueOf((float)n.doubleValue()));
                }
            }
            result.putProperty("FILL_VALUE", istpProps.get("FILL_VALUE"));
            result.putProperty("LABEL", istpProps.get("LABEL"));
            result.putProperty("TITLE", istpProps.get("TITLE"));
            String renderType = (String)istpProps.get("RENDER_TYPE");
            if (renderType != null && renderType.equals("time_series") && result.rank() > 1 && result.length(0) > 50) {
                logger.log(Level.FINE, "result.length(0)>QDataSet.MAX_UNIT_BUNDLE_COUNT={0}, this cannot be treated as a time_series", 50);
                renderType = null;
            }
            if (renderType != null && renderType.startsWith("image")) {
                logger.fine("renderType=image not supported in CDF files");
                renderType = null;
            }
            if (UnitsUtil.isNominalMeasurement(SemanticOps.getUnits(result))) {
                renderType = "eventsbar";
            }
            if (sy != null || sx != null) {
                renderType = null;
            }
            if ((os1 = map.get("slice1")) != null && os1.length() > 0) {
                logger.finer("dropping render type because of slice1");
            } else {
                result.putProperty("RENDER_TYPE", renderType);
            }
            if (UnitsUtil.isNominalMeasurement(SemanticOps.getUnits(result))) {
                if (result.property("DEPEND_0") == null) {
                    result.putProperty("RENDER_TYPE", "digital");
                } else {
                    result.putProperty("RENDER_TYPE", "eventsBar");
                }
            } else if (result.rank() < 3 && result.rank() == 2 && result.length() > 0 && result.length(0) < 50 && sy == null) {
                String rt = (String)istpProps.get("RENDER_TYPE");
                if (rt != null) {
                    result.putProperty("RENDER_TYPE", rt);
                }
                if (istpProps.get("RENDER_TYPE") == null && result.property("DEPEND_1") == null) {
                    result.putProperty("RENDER_TYPE", "time_series");
                }
            }
            for (int j = 0; j < result.rank(); ++j) {
                MutablePropertyDataSet depds = (MutablePropertyDataSet)result.property("DEPEND_" + j);
                Map depProps = (Map)istpProps.get("DEPEND_" + j);
                if (depds == null || depProps == null) continue;
                CdfUtil.maybeAddValidRange(depProps, depds);
                Map<String, Object> istpProps2 = ((MetadataModel)model).properties(depProps);
                depds.putProperty("FILL_VALUE", istpProps2.get("FILL_VALUE"));
                if (UnitsUtil.isTimeLocation(SemanticOps.getUnits(depds))) continue;
                depds.putProperty("LABEL", istpProps2.get("LABEL"));
                depds.putProperty("TITLE", istpProps2.get("TITLE"));
            }
        } else {
            QDataSet dep = (QDataSet)result.property("DEPEND_0");
            if (dep != null && dep.length() != result.length()) {
                result.putProperty("DEPEND_0", null);
            }
            result.putProperty("DEPEND_1", null);
            result.putProperty("DEPEND_2", null);
            result.putProperty("DEPEND_3", null);
        }
        result.putProperty("METADATA", attr1);
        result.putProperty("METADATA_MODEL", "ISTP-CDF");
        if (this.attributes != null && "waveform".equals(this.attributes.get("DISPLAY_TYPE")) && (dep1 = (QDataSet)result.property("DEPEND_1")) != null && Units.ns != (dep1units = SemanticOps.getUnits(dep1))) {
            ArrayDataSet dep1_ = ArrayDataSet.copy(dep1);
            dep1_.putProperty("VALID_MIN", null);
            dep1_.putProperty("VALID_MAX", null);
            dep1_.putProperty("FILL_VALUE", null);
            while (dep1_.rank() > 0) {
                dep1_ = (ArrayDataSet)Ops.reduceMax(dep1_, 0);
            }
            if (dep1_.value() > 1000000.0) {
                logger.log(Level.WARNING, "offset units do not appear to be in {0}, using ns", dep1units);
                ((MutablePropertyDataSet)dep1).putProperty("UNITS", Units.ns);
            }
        }
        result.makeImmutable();
        if (!mon.isFinished()) {
            mon.finished();
        }
        return result;
    }

    private void maybeReplaceLabels(MutablePropertyDataSet ds) {
        for (int i = 1; i < 5; ++i) {
            MutablePropertyDataSet depDs = (MutablePropertyDataSet)((QDataSet)ds.property("DEPEND_" + i));
            MutablePropertyDataSet lablDs = (MutablePropertyDataSet)((QDataSet)ds.property("BUNDLE_" + i));
            if (depDs == null || depDs.rank() != 1 || lablDs == null) continue;
            ds.putProperty("BUNDLE_" + i, null);
        }
    }

    private boolean hasVariable(CDFReader cdf, String var) {
        List<String> names = Arrays.asList(cdf.getVariableNames());
        return names.contains(var);
    }

    private Object getAttribute(CDFReader cdf, String attr) {
        try {
            return cdf.getAttribute(attr);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private Map<String, Object> readXorYAttributes(CDFReader cdf, String var, int depth) {
        int i = var.indexOf("[");
        String slice = null;
        if (i > -1) {
            Matcher m = Pattern.compile("\\[\\:\\,(\\d+)\\]").matcher(var.substring(i));
            if (m.matches()) {
                slice = m.group(1);
            } else {
                logger.warning("only [:,i] supported");
            }
            var = var.substring(0, i);
        }
        HashMap<String, Object> xyAttributes = this.readAttributes(cdf, var, depth);
        if (slice != null) {
            String labl_ptr_1 = (String)xyAttributes.get("LABL_PTR_1");
            boolean labelsAreRead = false;
            if (labl_ptr_1 != null) {
                try {
                    MutablePropertyDataSet v = CdfUtil.wrapCdfData(cdf, labl_ptr_1, 0L, -1L, 1L, -1, new NullProgressMonitor());
                    xyAttributes.put(ATTR_SLICE1_LABELS, v);
                    xyAttributes.put("slice1", slice);
                    labelsAreRead = true;
                }
                catch (Exception ex) {
                    Logger.getLogger(CdfDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (!labelsAreRead) {
                try {
                    int[] qube = cdf.getDimensions(var);
                    String[] labels = new String[qube[0]];
                    for (int j = 0; j < qube[0]; ++j) {
                        labels[j] = "ch_" + j;
                    }
                    xyAttributes.put(ATTR_SLICE1_LABELS, Ops.labelsDataset(labels));
                    xyAttributes.put("slice1", slice);
                }
                catch (CDFException.ReaderError ex) {
                    Logger.getLogger(CdfDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return xyAttributes;
    }

    private synchronized HashMap<String, Object> readAttributes(CDFReader cdf, String var, int depth) {
        try {
            Object o;
            String[] vv;
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> gattrs = new LinkedHashMap<String, Object>();
            Pattern p = Pattern.compile("DEPEND_[0-9]");
            try {
                vv = cdf.variableAttributeNames(var);
            }
            catch (NullPointerException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                throw ex;
            }
            Object gattr = this.getAttribute(cdf, "Source_name");
            if (gattr != null && gattr.getClass().isArray() && Array.getLength(gattr) > 0) {
                props.put("Source_name", String.valueOf(Array.get(gattr, 0)));
            }
            if ((gattr = this.getAttribute(cdf, "Descriptor")) != null && gattr.getClass().isArray() && Array.getLength(gattr) > 0) {
                props.put("Descriptor", String.valueOf(Array.get(gattr, 0)));
            }
            for (int ipass = 0; ipass < 2; ++ipass) {
                String[] stringArray = vv;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Object val;
                    String vv1 = stringArray[i];
                    Object attrv = cdf.getAttribute(var, vv1);
                    boolean isDep = p.matcher(vv1).matches() & depth == 0;
                    if (ipass == 0 && isDep) {
                        String name = (String)((List)attrv).get(0);
                        if (this.hasVariable(cdf, name)) {
                            HashMap<String, Object> newVal = this.readAttributes(cdf, name, depth + 1);
                            newVal.put("NAME", name);
                            props.put(vv1, newVal);
                            continue;
                        }
                        logger.log(Level.FINE, "No such variable: {0} in CDF ", name);
                        continue;
                    }
                    if (ipass != 1 || isDep || (val = ((List)attrv).get(0)) == null) continue;
                    if (val.getClass().isArray() && Array.getLength(val) == 1) {
                        val = Array.get(val, 0);
                    }
                    props.put(vv1, val);
                }
            }
            if (depth == 0) {
                try {
                    vv = cdf.globalAttributeNames();
                }
                catch (NullPointerException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    throw ex;
                }
                for (String vv1 : vv) {
                    Object attr = cdf.getAttribute(vv1);
                    if (attr == null || !attr.getClass().isArray() || Array.getLength(attr) <= 0) continue;
                    int n = Array.getLength(attr);
                    if (n > 1) {
                        Object[] oo = new Object[n];
                        for (int ii = 0; ii < n; ++ii) {
                            oo[ii] = Array.get(attr, ii);
                        }
                        gattrs.put(vv1, oo);
                        continue;
                    }
                    gattrs.put(vv1, Array.get(attr, 0));
                }
                props.put("GlobalAttributes", gattrs);
            }
            if ((o = props.get("UNIT_PTR")) != null && o instanceof String) {
                try {
                    MutablePropertyDataSet v = CdfUtil.wrapCdfData(cdf, (String)o, 0L, -1L, 1L, -1, new NullProgressMonitor());
                    props.put("UNIT_PTR_VALUE", v);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            if ((o = props.get("LABL_PTR_1")) != null) {
                try {
                    MutablePropertyDataSet v = CdfUtil.wrapCdfData(cdf, (String)o, 0L, -1L, 1L, -1, new NullProgressMonitor());
                    props.put(ATTR_SLICE1_LABELS, v);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            return props;
        }
        catch (CDFException ex) {
            return new HashMap<String, Object>();
        }
    }

    private QDataSet getDeltaPlusMinus(CDFReader cdf, QDataSet ds, String deltaPlus, String constraints) throws Exception {
        QDataSet delta = this.wrapDataSet(cdf, deltaPlus, constraints, cdf.recordVariance(deltaPlus), false, null);
        if (delta.rank() > 0 && delta.length() == 1 && delta.length() != ds.length()) {
            delta = delta.slice(0);
        }
        if (ds.rank() == 2 && delta.length() == ds.length(0)) {
            delta = Ops.replicate(delta, ds.length());
        }
        return delta;
    }

    private static boolean isFinite(double v) {
        return !Double.isInfinite(v) && !Double.isNaN(v);
    }

    private MutablePropertyDataSet wrapDataSet(CDFReader cdf, String svariable, String constraints, boolean reform, boolean depend, Map<String, Object> attr) throws Exception, ParseException {
        return this.wrapDataSet(cdf, svariable, constraints, reform, depend, attr, -1, new NullProgressMonitor());
    }

    private synchronized MutablePropertyDataSet wrapDataSet(CDFReader cdf, String svariable, String constraints, boolean reform, boolean dependantVariable, Map<String, Object> thisAttributes, int slice1, ProgressMonitor mon) throws Exception, ParseException {
        Map dep0map;
        DatumRange vrange;
        MutablePropertyDataSet result;
        int n1;
        boolean slice;
        long[] slice1s;
        if (!this.hasVariable(cdf, svariable)) {
            throw new IllegalArgumentException("No such variable: " + svariable);
        }
        if (thisAttributes == null) {
            thisAttributes = this.readAttributes(cdf, svariable, 0);
        }
        long numRec = cdf.getNumberOfValues(svariable);
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        String displayType = (String)thisAttributes.get("DISPLAY_TYPE");
        if (numRec == 0L) {
            String funct = (String)thisAttributes.get("FUNCTION");
            if (funct == null) {
                funct = (String)thisAttributes.get("FUNCT");
            }
            if (thisAttributes.containsKey("COMPONENT_0") && funct != null && funct.startsWith("comp_themis_epoch")) {
                QDataSet c0 = this.wrapDataSet(cdf, (String)thisAttributes.get("COMPONENT_0"), constraints, true, false, null);
                if (thisAttributes.containsKey("COMPONENT_1")) {
                    MutablePropertyDataSet c1 = this.wrapDataSet(cdf, (String)thisAttributes.get("COMPONENT_1"), constraints, false, false, null);
                    if (c0.rank() == 1 && CdfDataSetUtil.validCount(c0, 2) == 1 && c1.length() > 1 && Units.cdfEpoch == (c0 = DataSetOps.slice0(c0, 0)).property("UNITS")) {
                        double value = ((RankZeroDataSet)c0).value();
                        double valueUs2000 = Units.cdfEpoch.convertDoubleTo(Units.us2000, value);
                        c0 = DataSetUtil.asDataSet(Units.us2000.createDatum(valueUs2000));
                    }
                    if (c0.property("UNITS") != null && c1.property("UNITS") != null) {
                        c0 = Ops.add(c0, c1);
                    }
                }
                return DDataSet.maybeCopy(c0);
            }
            throw new NoDataInIntervalException("variable " + svariable + " contains no records!");
        }
        int[] dimensions = cdf.getDimensions(svariable);
        long[] ndimensions = new long[dimensions.length + 1];
        ndimensions[0] = numRec;
        for (int i = 0; i < dimensions.length; ++i) {
            ndimensions[i + 1] = dimensions[i];
        }
        Map<Integer, long[]> mc = DataSourceUtil.parseConstraint(constraints, ndimensions);
        if (mc.size() > 1 && (slice1s = mc.get(1)) != null && slice1s[0] != -1L && slice1s[1] == -1L && slice1s[2] == -1L) {
            slice1 = (int)slice1s[0];
        }
        long[] recs = mc.get(0);
        if (numRec == 1L) {
            boolean[] varies = cdf.getVarys(svariable);
            if (CdfUtil.getEffectiveRank(varies) == cdf.getNumberOfElements(svariable)) {
                recs[0] = 0L;
            }
            if (CdfUtil.getEffectiveRank(varies) == 0) {
                recs[0] = 0L;
            }
        }
        boolean bl = slice = recs[1] == -1L;
        if (cdf.getDimensions(svariable).length > 0 && slice1 > -1 && slice1 >= (n1 = cdf.getDimensions(svariable)[0])) {
            throw new IllegalArgumentException("slice1=" + slice1 + " is too big for the dimension size (" + n1 + ")");
        }
        long recCount = (recs[1] - recs[0]) / recs[2];
        if (!reform && recCount == 0L && ndimensions.length > 0 && ndimensions[0] == 1L) {
            logger.fine("variable is not marked as non-time-varying");
            reform = true;
        }
        if (reform) {
            result = CdfUtil.wrapCdfData(cdf, svariable, 0L, -1L, 1L, slice1, dependantVariable, new NullProgressMonitor());
        } else {
            if (slice) {
                recCount = -1L;
                recs[2] = 1L;
            }
            result = CdfUtil.wrapCdfData(cdf, svariable, recs[0], recCount, recs[2], slice1, dependantVariable, mon);
        }
        if (slice1 > -1) {
            result.putProperty("NAME", svariable + "__" + slice1);
        } else {
            result.putProperty("NAME", svariable);
        }
        boolean doUnits = true;
        Units units = null;
        if (thisAttributes.containsKey("UNITS")) {
            String sunits = (String)thisAttributes.get("UNITS");
            Units mu = sunits.equalsIgnoreCase("row number") || sunits.equalsIgnoreCase("column number") ? Units.dimensionless : Units.lookupUnits(sunits);
            Units u = (Units)result.property("UNITS");
            if (u == null) {
                result.putProperty("UNITS", mu);
                units = mu;
            } else {
                units = u;
            }
        } else if (thisAttributes.containsKey("UNIT_PTR")) {
            String svar = (String)thisAttributes.get("UNIT_PTR");
            if (svar != null) {
                logger.log(Level.FINER, "found UNIT_PTR for {0}", svariable);
                boolean okay = true;
                QDataSet s = null;
                try {
                    if (this.hasVariable(cdf, svar)) {
                        s = CdfUtil.wrapCdfData(cdf, svar, 0L, 1L, 1L, -1, true, new NullProgressMonitor());
                        s = s.slice(0);
                        double s1 = s.value(0);
                        for (int i = 1; i < s.length(); ++i) {
                            if (s.value(i) == s1) continue;
                            logger.log(Level.INFO, "units are not all the same, unable to use: {0}", svar);
                            okay = false;
                        }
                    } else {
                        logger.log(Level.INFO, "units variable does not exist: {0}", svar);
                        okay = false;
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    okay = false;
                }
                if (okay) {
                    assert (s != null);
                    units = Units.lookupUnits(DataSetUtil.getStringValue(s, s.value(0)));
                    result.putProperty("UNITS", units);
                } else {
                    units = SemanticOps.getUnits(result);
                }
            } else {
                units = SemanticOps.getUnits(result);
            }
        } else {
            units = SemanticOps.getUnits(result);
        }
        Object f = thisAttributes.get("FILLVAL");
        double dv = IstpMetadataModel.doubleValue(f, units, Double.NaN, IstpMetadataModel.VALUE_MIN);
        if (!Double.isNaN(dv)) {
            result.putProperty("FILL_VALUE", dv);
        }
        if ((vrange = IstpMetadataModel.getValidRange(thisAttributes, units)) != null) {
            if (vrange.width().value() <= 0.0) {
                logger.fine("ignoring VALID_MIN and VALID_MAX because they are equal or out of order.");
            } else {
                QDataSet extentds = Ops.extentSimple(result, null);
                if (CdfDataSource.isFinite(extentds.value(0))) {
                    DatumRange extent = DataSetUtil.asDatumRange(extentds);
                    if (dependantVariable || extent.intersects(vrange)) {
                        if (UnitsUtil.isTimeLocation(vrange.getUnits())) {
                            if (extent.intersects(vrange)) {
                                result.putProperty("VALID_MIN", vrange.min().doubleValue(units));
                                result.putProperty("VALID_MAX", vrange.max().doubleValue(units));
                            }
                        } else {
                            result.putProperty("VALID_MIN", vrange.min().doubleValue(units));
                            result.putProperty("VALID_MAX", vrange.max().doubleValue(units));
                        }
                    } else {
                        logger.fine("ignoring VALID_MIN and VALID_MAX because no timetags would be considered valid.");
                    }
                } else {
                    logger.fine("using VALID_MIN and VALID_MAX to indictate that all data is invalid.");
                    result.putProperty("VALID_MIN", vrange.min().doubleValue(units));
                    result.putProperty("VALID_MAX", vrange.max().doubleValue(units));
                }
            }
        }
        if (slice && dependantVariable && (dep0map = (Map)thisAttributes.get("DEPEND_0")) != null) {
            MutablePropertyDataSet dep0 = this.wrapDataSet(cdf, (String)dep0map.get("NAME"), constraints, false, false, null);
            result.putProperty("CONTEXT_0", dep0);
        }
        boolean doPlusMinus = !dependantVariable;
        Object deltaPlus = thisAttributes.get("DELTA_PLUS_VAR");
        Object deltaMinus = thisAttributes.get("DELTA_MINUS_VAR");
        if (doPlusMinus && deltaPlus != null && deltaPlus instanceof String && !deltaPlus.equals(svariable) && deltaMinus != null && deltaMinus instanceof String && !deltaPlus.equals(svariable)) {
            if (this.hasVariable(cdf, (String)deltaPlus)) {
                QDataSet delta = this.getDeltaPlusMinus(cdf, result, (String)deltaPlus, constraints);
                Units deltaUnits = SemanticOps.getUnits(delta);
                if (UnitsUtil.isRatioMeasurement(deltaUnits) && deltaUnits.isConvertibleTo(SemanticOps.getUnits(result).getOffsetUnits()) && (delta.rank() == 0 || result.length() == delta.length())) {
                    result.putProperty("BIN_PLUS", delta);
                    if (!deltaMinus.equals(deltaPlus) && (delta = this.getDeltaPlusMinus(cdf, result, (String)deltaMinus, constraints)).length() == 1 && delta.rank() == 1 && delta.length() != result.length()) {
                        delta = delta.slice(0);
                    }
                    if (SemanticOps.getUnits(delta).isConvertibleTo(SemanticOps.getUnits(result).getOffsetUnits())) {
                        result.putProperty("BIN_MINUS", delta);
                    } else {
                        result.putProperty("BIN_PLUS", null);
                        logger.log(Level.FINE, "DELTA_MINUS_VAR units are not convertible: {0}", SemanticOps.getUnits(delta));
                    }
                } else if (!UnitsUtil.isRatioMeasurement(deltaUnits)) {
                    logger.log(Level.FINE, "DELTA_PLUS_VAR units are not ratio measurements having a meaningful zero: {0}", new Object[]{deltaUnits});
                } else if (result.length() != delta.length()) {
                    logger.log(Level.FINE, "DELTA_PLUS_VAR length ({0,number,#})!= data length ({1,number,#})", new Object[]{delta.length(), result.length()});
                } else {
                    logger.log(Level.FINE, "DELTA_PLUS_VAR units are not convertible: {0}", SemanticOps.getUnits(delta));
                }
            } else {
                logger.log(Level.FINE, "DELTA_PLUS_VAR variable is not found for {0}: {1}", new Object[]{svariable, deltaPlus});
            }
        }
        int[] qubeDims = DataSetUtil.qubeDims(result);
        if (dependantVariable) {
            for (int idep = 0; idep < result.rank(); ++idep) {
                MutablePropertyDataSet bundleDs;
                MutablePropertyDataSet b;
                int sidep = idep;
                Map dep = (Map)thisAttributes.get("DEPEND_" + sidep);
                Object oo = thisAttributes.get("LABL_PTR_" + sidep);
                MutablePropertyDataSet lablDs = null;
                String labl = null;
                if (oo instanceof MutablePropertyDataSet) {
                    labl = (String)((MutablePropertyDataSet)oo).property("NAME");
                } else if (oo instanceof String) {
                    if (this.hasVariable(cdf, (String)oo)) {
                        labl = (String)oo;
                    } else {
                        logger.log(Level.FINE, "LABL_PTR_{0} pointed to non-existant variable {1}", new Object[]{sidep, oo});
                    }
                }
                if (labl == null) {
                    labl = (String)thisAttributes.get("LABEL_" + sidep);
                }
                if (labl != null) {
                    try {
                        lablDs = this.wrapDataSet(cdf, labl, constraints, idep > 0, false, null);
                        if (idep == 1 && this.attributes != null) {
                            this.attributes.put("LABL_PTR_1", lablDs);
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.FINE, "unable to load LABL_PTR_" + sidep + " for " + svariable, ex);
                        thisAttributes.remove("LABL_PTR_" + sidep);
                    }
                    if (lablDs != null && lablDs.length() < 4 && displayType == null) {
                        logger.log(Level.FINER, "setting null displayType to time_series");
                        displayType = "time_series";
                    }
                }
                if (dep != null && qubeDims.length <= idep) {
                    if (slice1 != -1) continue;
                    logger.log(Level.INFO, "DEPEND_{0} found but data is lower rank", idep);
                    continue;
                }
                QDataSet depDs = null;
                logger.log(Level.FINER, "displayType={0}", displayType);
                if (dep != null) {
                    boolean reformDep;
                    String depName = (String)dep.get("NAME");
                    if (!this.hasVariable(cdf, depName)) {
                        logger.log(Level.FINE, "unable to find variable \"{0}\" for DEPEND_{1} of {2}", new Object[]{depName, sidep, svariable});
                        continue;
                    }
                    boolean bl2 = reformDep = idep > 0;
                    if (reformDep && cdf.recordVariance(depName)) {
                        reformDep = false;
                    }
                    depDs = this.wrapDataSet(cdf, depName, constraints, reformDep, false, dep, -1, null);
                    if (!(idep <= 0 || reformDep || depDs.length() != 1 || qubeDims[0] != 1 && qubeDims[0] <= depDs.length())) {
                        depDs = (MutablePropertyDataSet)depDs.slice(0);
                    }
                    if (idep == 0 && cdf.getNumberOfValues(svariable) == 1 && depDs.length() > 1) {
                        ReplicateDataSet nresult = new ReplicateDataSet(result.slice(0), depDs.length());
                        result = nresult;
                    }
                    if (DataSetUtil.isMonotonic(depDs)) {
                        depDs.putProperty("MONOTONIC", Boolean.TRUE);
                    }
                    if (slice1 < 0) {
                        result.putProperty("DEPEND_" + idep, depDs);
                    } else {
                        if (idep != 1) {
                            if (idep > 1) {
                                result.putProperty("DEPEND_" + (idep - 1), depDs);
                            } else {
                                result.putProperty("DEPEND_" + idep, depDs);
                            }
                        }
                        if (idep == 0) {
                            thisAttributes.remove("LABL_PTR_1");
                        }
                    }
                }
                if (lablDs == null || depDs != null && depDs.rank() != 2 && (depDs.rank() != 1 || depDs.length() >= 100)) continue;
                if (depDs != null && lablDs.rank() == 1 && depDs.rank() == 2 && DataSetUtil.asDatum(lablDs.slice(0)).toString().equals("channel00") && (b = IstpMetadataModel.maybeReduceRank2((MutablePropertyDataSet)depDs)) != null) {
                    lablDs = b;
                }
                if (depDs != null && lablDs.rank() == 1 && depDs.rank() == 2 && DataSetUtil.asDatum(lablDs.slice(0)).toString().equals("channel00")) {
                    QDataSet ex;
                    int i0;
                    QDataSet wds = SemanticOps.weightsDataSet(depDs);
                    int l0 = (wds.length(0) - 1) * 1 / 8;
                    int l1 = (wds.length(0) - 1) * 7 / 8;
                    for (i0 = 0; !(i0 >= depDs.length() || wds.value(i0, l0) > 0.0 && wds.value(i0, l1) > 0.0); ++i0) {
                    }
                    if (i0 < depDs.length() && (ex = Ops.extent(DataSetOps.slice1(depDs, 0))).value(0) == ex.value(1)) {
                        lablDs = (MutablePropertyDataSet)depDs.slice(i0);
                    }
                }
                if (slice1 < 0) {
                    bundleDs = lablDs;
                    result.putProperty("BUNDLE_" + idep, DataSetUtil.toBundleDs(bundleDs));
                    continue;
                }
                if (idep == 1) continue;
                if (idep > 1) {
                    bundleDs = lablDs;
                    result.putProperty("BUNDLE_" + (idep - 1), DataSetUtil.toBundleDs(bundleDs));
                    continue;
                }
                bundleDs = lablDs;
                result.putProperty("BUNDLE_" + idep, DataSetUtil.toBundleDs(bundleDs));
            }
        }
        boolean swapHack = false;
        if (result.rank() == 3) {
            int n12 = result.length(0);
            int n2 = result.length(0, 0);
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            QDataSet dep2 = (QDataSet)result.property("DEPEND_2");
            if (n12 != n2 && dep1 != null && dep1.length() == n2 && dep2 != null && dep2.length() == n12) {
                swapHack = true;
                logger.fine("swaphack avoids runtime error");
            }
        }
        if (slice && result.rank() == 2) {
            int n0 = result.length();
            int n13 = result.length(0);
            QDataSet dep0 = (QDataSet)result.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            if (n0 != n13 && dep0 != null && dep0.length() == n13 && dep1 != null && dep1.length() == n0) {
                swapHack = true;
                logger.fine("swaphack avoids runtime error");
            }
        }
        if (swapHack && result.rank() == 3) {
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            QDataSet dep2 = (QDataSet)result.property("DEPEND_2");
            result.putProperty("DEPEND_2", dep1);
            result.putProperty("DEPEND_1", dep2);
            Object att1 = thisAttributes.get("DEPEND_1");
            Object att2 = thisAttributes.get("DEPEND_2");
            thisAttributes.put("DEPEND_1", att2);
            thisAttributes.put("DEPEND_2", att1);
        }
        if (swapHack && slice && result.rank() == 2) {
            QDataSet dep0 = (QDataSet)result.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            result.putProperty("DEPEND_1", dep0);
            result.putProperty("DEPEND_0", dep1);
            Object att0 = thisAttributes.get("DEPEND_0");
            Object att1 = thisAttributes.get("DEPEND_1");
            thisAttributes.put("DEPEND_0", att1);
            thisAttributes.put("DEPEND_1", att0);
        }
        for (int idep = 1; idep < result.rank(); ++idep) {
            QDataSet depDs = (QDataSet)result.property("DEPEND_" + idep);
            if (depDs == null || depDs.rank() != 2 || depDs.length(0) != 2 || depDs.length() != qubeDims[idep]) continue;
            logger.warning("applying min,max kludge for old LANL cdf files");
            MutablePropertyDataSet depDs1 = (MutablePropertyDataSet)Ops.reduceMean(depDs, 1);
            MutablePropertyDataSet binmax = DataSetOps.slice1(depDs, 1);
            MutablePropertyDataSet binmin = DataSetOps.slice1(depDs, 0);
            depDs1.putProperty("DELTA_MINUS", Ops.subtract(depDs1, binmin));
            depDs1.putProperty("DELTA_PLUS", Ops.subtract(binmax, depDs1));
            depDs = depDs1;
            result.putProperty("DEPEND_" + idep, depDs);
        }
        return result;
    }

    @Override
    public MetadataModel getMetadataModel() {
        return new IstpMetadataModel();
    }

    @Override
    public synchronized Map<String, Object> getMetadata(ProgressMonitor mon) throws IOException {
        if (this.attributes == null) {
            try {
                File cdfFile = this.getFile(mon);
                String fileName = cdfFile.toString();
                Map<String, String> map = this.getParams();
                if (map.containsKey("slice1")) {
                    return null;
                }
                CDFReader cdf = CdfDataSource.getCdfFile(fileName);
                String svariable = map.get(PARAM_ID);
                if (svariable == null) {
                    svariable = map.get("arg_0");
                }
                if (svariable == null) {
                    throw new IllegalArgumentException("variable not specified");
                }
                int i = svariable.indexOf("[");
                if (i != -1) {
                    svariable = svariable.substring(0, i);
                }
                if (!this.hasVariable(cdf, svariable)) {
                    throw new IllegalArgumentException("No such variable \"" + svariable + "\"");
                }
                this.attributes = this.readAttributes(cdf, svariable, 0);
                if (map.containsKey(PARAM_X)) {
                    String s = map.get(PARAM_X);
                    i = s.indexOf("[");
                    if (i != -1) {
                        s = s.substring(0, i);
                    }
                    HashMap<String, Object> dep0m = this.readAttributes(cdf, s, 0);
                    this.attributes.put("DEPEND_0", dep0m);
                }
                if ("no".equals(map.get(PARAM_INTERPMETA))) {
                    this.attributes.remove("DEPEND_0");
                    this.attributes.remove("DEPEND_1");
                    this.attributes.remove("DEPEND_2");
                    this.attributes.remove("DEPEND_3");
                    this.attributes.remove("DEPEND_4");
                }
                return this.attributes;
            }
            catch (IOException | IllegalArgumentException ex) {
                if (ex instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)ex;
                }
                ex.printStackTrace();
                throw ex;
            }
        }
        return this.attributes;
    }

    private QDataSet labelToBundleDs(QDataSet depDs) {
        IDataSet result = IDataSet.createRank2(depDs.length(), 1);
        Units u = (Units)depDs.property("UNITS");
        for (int i = 0; i < depDs.length(); ++i) {
            String labl1 = u.createDatum(depDs.value()).toString();
            result.putProperty("LABEL__" + i, labl1);
            result.putProperty("NAME__" + i, Ops.safeName(labl1));
            result.putValue(i, 0, 1.0);
        }
        return result;
    }

    public static void checkCdf(File cdfFile) throws IOException {
        byte[] magic = new byte[4];
        if (cdfFile.length() < 4L) {
            throw new IllegalArgumentException("CDF file is empty");
        }
        try (FileInputStream in = new FileInputStream(cdfFile);){
            int n = ((InputStream)in).read(magic);
            if (n == 4) {
                if ((magic[0] & 0xFF) == 205 && (magic[1] & 0xFF) == 243) {
                    logger.fine("V2.6 or newer");
                } else {
                    if (magic[0] == 67 && magic[1] == 68 && magic[2] == 70) {
                        throw new IllegalArgumentException("File appears to be NetCDF, use vap+nc:");
                    }
                    if (magic[1] == 72 && magic[2] == 68 && magic[3] == 70) {
                        throw new IllegalArgumentException("File appears to be NetCDF (on HDF), use vap+nc:");
                    }
                    if (magic[0] == 0 && magic[1] == 0 && magic[2] == -1 && magic[3] == -1) {
                        logger.fine("pre-V2.6");
                    } else if ((magic[0] & 0xFF) == 204 && (magic[1] & 0xFF) == 204 && (magic[2] & 0xFF) == 0 && (magic[3] & 0xFF) == 1) {
                        logger.fine("compressed");
                    }
                }
            }
        }
    }
}

