/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdaweb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.autoplot.cdaweb.CDAWebDB;
import org.autoplot.cdaweb.CDAWebDataSetIdDialog;
import org.autoplot.cdaweb.CDAWebDataSource;
import org.autoplot.cdf.CdfJavaDataSourceEditorPanel;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.das2.components.DasProgressPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;

public class CDAWebEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = LoggerManager.getLogger("apdss.cdaweb");
    boolean initializing = true;
    public static final String PARAM_FILTER = "filter";
    CdfJavaDataSourceEditorPanel paramEditor;
    JComponent messageComponent = null;
    boolean haveAddedRecent = false;
    private static final String MSG_NO_DATASET = "<html><i>No dataset selected, pick initial dataset...</i></html>";
    private String currentDs = "";
    private String filter = "";
    private String id = "";
    private String providedTimeRange = "";
    private JCheckBox availabilityCB;
    private JLabel availableTextField;
    private JLabel descriptionLabel;
    private JComboBox dsidComboBox;
    private JComboBox<String> exampleTimeRangesCB;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel parameterPanel;
    private JButton pickDsButton;
    private RecentComboBox timeRangeComboBox;
    private JPanel timeRangePanel;
    private boolean expert = true;

    public CDAWebEditorPanel() {
        this.initComponents();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                CDAWebEditorPanel.this.refresh(CDAWebEditorPanel.this.getURI());
            }
        });
    }

    private boolean pickDs() {
        Window win = SwingUtilities.getWindowAncestor(this);
        Frame frame = null;
        CDAWebDataSetIdDialog t = win != null ? (win instanceof JDialog ? new CDAWebDataSetIdDialog((Dialog)((JDialog)win), true) : new CDAWebDataSetIdDialog(frame, true)) : new CDAWebDataSetIdDialog(frame, true);
        t.setLocationRelativeTo(this);
        t.setTitle("Pick Dataset");
        t.setFilter(this.filter);
        t.refresh();
        t.setResizable(true);
        WindowManager.getInstance().showModalDialog(t);
        if (t.isCancelled()) {
            return false;
        }
        this.filter = t.getFilter();
        this.dsidComboBox.setSelectedItem(t.getSelectedItem());
        final String uri = this.getURI();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                CDAWebEditorPanel.this.refresh(uri);
            }
        };
        new Thread(run).start();
        return true;
    }

    private void refreshDefaultTime(String ds, DatumRange dr) {
        try {
            final String timeDflt = CDAWebDB.getInstance().getSampleTime(ds);
            DatumRange tr = DatumRangeUtil.parseTimeRange(timeDflt);
            String str = this.providedTimeRange;
            str = str.trim();
            if (!str.equals("")) {
                try {
                    DatumRange tr1 = DatumRangeUtil.parseTimeRange(str);
                    DatumRange accept = DatumRangeUtil.union(dr, tr);
                    if (DatumRangeUtil.rescale(accept, -0.1, 1.1).intersects(tr1)) {
                        tr = tr1;
                    }
                }
                catch (ParseException ex) {
                    String t = ex.toString();
                    if (t.length() > 100) {
                        t = t.substring(0, 100) + "...";
                    }
                    this.availableTextField.setText("<html><span color='red'>" + t);
                }
            }
            final String ftr = tr.toString();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CDAWebEditorPanel.this.timeRangeComboBox.setText(ftr);
                    DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>(new String[]{"Example Time Ranges", timeDflt});
                    CDAWebEditorPanel.this.exampleTimeRangesCB.setModel(m);
                }
            });
        }
        catch (IOException | ParseException ex) {
            String t = ex.toString();
            if (t.length() > 100) {
                t = t.substring(0, 100) + "...";
            }
            this.availableTextField.setText("<html><span color='red'>" + t);
        }
    }

    private void refreshDataSet(CdfJavaDataSourceEditorPanel panel, final String ds, Map<String, String> args) throws Exception {
        try {
            if (!CDAWebDB.getInstance().getServiceProviderIds().containsKey(ds)) {
                this.messageComponent = new JLabel("<html>Service provider \"" + ds + "\" not found in ftp/cdaweb.gsfc.nasa.gov/pub/cdaweb/all.xml");
                this.descriptionLabel.setText("");
                this.timeRangeComboBox.setText("");
                this.paramEditor = null;
                return;
            }
            String avail = CDAWebDB.getInstance().getTimeRange(ds);
            if (avail.length() > 100) {
                avail = avail.substring(0, 100) + "...";
            }
            this.availableTextField.setText(avail);
            final DatumRange dr = DatumRangeUtil.roundSections(DatumRangeUtil.parseTimeRange(avail), 100);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    CDAWebEditorPanel.this.refreshDefaultTime(ds, dr);
                }
            };
            RequestProcessor.invokeLater(run);
        }
        catch (ParseException ex) {
            String t = ex.toString();
            if (t.length() > 100) {
                t = t.substring(0, 100) + "...";
            }
            this.availableTextField.setText("<html><span color='red'>" + t);
        }
    }

    private synchronized void doRefreshDataSet(final String ds, final Map<String, String> args, ProgressMonitor monitor) throws IOException, Exception {
        String master;
        Window w = SwingUtilities.getWindowAncestor(this);
        ProgressMonitor mon = monitor == null ? (w == null ? DasProgressPanel.createFramed("getting master CDF") : DasProgressPanel.createFramed(w, "getting master CDF")) : monitor;
        this.currentDs = ds;
        final String fmaster = ds != null && ds.length() > 0 ? (master = CDAWebDB.getInstance().getMasterFile(ds, mon)) : null;
        Runnable run = new Runnable(){

            @Override
            public synchronized void run() {
                block13: {
                    if (ds != null && ds.length() > 0) {
                        try {
                            String y;
                            String x;
                            String where;
                            String slice1;
                            CdfJavaDataSourceEditorPanel panel = new CdfJavaDataSourceEditorPanel();
                            String master = fmaster;
                            String id = (String)args.get("id");
                            if (id == null || id.length() == 0) {
                                id = CDAWebEditorPanel.this.id;
                            }
                            if (id != null) {
                                master = master + "?" + id;
                            }
                            if ((slice1 = (String)args.get("slice1")) != null) {
                                master = master + "&slice1=" + slice1;
                            }
                            if ((where = (String)args.get("where")) != null) {
                                master = master + "&where=" + where;
                            }
                            if ((x = (String)args.get("x")) != null) {
                                master = master + "&x=" + x;
                            }
                            if ((y = (String)args.get("y")) != null) {
                                master = master + "&y=" + y;
                            }
                            boolean status = panel.prepare(master, SwingUtilities.getWindowAncestor(CDAWebEditorPanel.this), new NullProgressMonitor());
                            panel.setURI(master);
                            if (!status) {
                                CDAWebEditorPanel.this.messageComponent = new JLabel("<html>CDF file subpanel prepare method failed");
                                CDAWebEditorPanel.this.paramEditor = null;
                                break block13;
                            }
                            if (CDAWebEditorPanel.this.messageComponent != null) {
                                CDAWebEditorPanel.this.parameterPanel.remove(CDAWebEditorPanel.this.messageComponent);
                            }
                            CDAWebEditorPanel.this.parameterPanel.add((Component)panel, "Center");
                            panel.setShowAdvancedSubpanel(false);
                            CDAWebEditorPanel.this.paramEditor = panel;
                            CDAWebEditorPanel.this.parameterPanel.revalidate();
                            CDAWebEditorPanel.this.messageComponent = null;
                            CDAWebEditorPanel.this.refreshDataSet(panel, ds, args);
                        }
                        catch (Exception ex) {
                            CDAWebEditorPanel.this.messageComponent = new JLabel("<html>Exception:<br>" + ex.toString().replaceAll("\n", "<br>"));
                            CDAWebEditorPanel.this.paramEditor = null;
                        }
                    } else {
                        CDAWebEditorPanel.this.messageComponent = new JLabel(CDAWebEditorPanel.MSG_NO_DATASET);
                    }
                }
                if (CDAWebEditorPanel.this.messageComponent != null) {
                    CDAWebEditorPanel.this.parameterPanel.removeAll();
                    CDAWebEditorPanel.this.parameterPanel.add((Component)CDAWebEditorPanel.this.messageComponent, "North");
                }
                CDAWebEditorPanel.this.parameterPanel.revalidate();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public synchronized void refresh(String suri) {
        if (EventQueue.isDispatchThread()) {
            CDAWebDataSource.logger.warning("TODO: refresh should not be called from the event thread");
        }
        if (!this.haveAddedRecent) {
            this.addRecent();
            this.haveAddedRecent = true;
        }
        String ds = (String)this.dsidComboBox.getSelectedItem();
        final LabelMonitor mon = new LabelMonitor();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CDAWebEditorPanel.this.paramEditor != null) {
                    CDAWebEditorPanel.this.parameterPanel.remove(CDAWebEditorPanel.this.paramEditor);
                }
                if (CDAWebEditorPanel.this.messageComponent != null) {
                    CDAWebEditorPanel.this.parameterPanel.remove(CDAWebEditorPanel.this.messageComponent);
                }
                CDAWebEditorPanel.this.messageComponent = mon.getLabelComponent();
                CDAWebEditorPanel.this.parameterPanel.add((Component)CDAWebEditorPanel.this.messageComponent, "North");
                CDAWebEditorPanel.this.parameterPanel.validate();
            }
        });
        URISplit split = URISplit.parse(suri);
        LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
        if (ds != null && ds.length() > 0) {
            String desc = CDAWebDB.getInstance().getServiceProviderIds().get(ds);
            this.descriptionLabel.setText("<html><small>" + desc + "</small></html>");
        } else {
            this.descriptionLabel.setText("<html><small> </small></html>");
        }
        try {
            if (ds != null && ds.length() != 0 || this.currentDs != null) {
                this.doRefreshDataSet(ds, args, mon);
            } else {
                this.messageComponent = new JLabel("<html><i><br>&nbsp;No dataset selected.</i></html>");
                this.parameterPanel.add((Component)this.messageComponent, "North");
                this.parameterPanel.validate();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, null, ex);
            final String msg = ex.toString();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CDAWebEditorPanel.this.paramEditor != null) {
                        CDAWebEditorPanel.this.parameterPanel.remove(CDAWebEditorPanel.this.paramEditor);
                    }
                    if (CDAWebEditorPanel.this.messageComponent != null) {
                        CDAWebEditorPanel.this.parameterPanel.remove(CDAWebEditorPanel.this.messageComponent);
                    }
                    CDAWebEditorPanel.this.messageComponent = new JLabel("<html><i><br>" + msg + "</i></html>");
                    CDAWebEditorPanel.this.parameterPanel.add((Component)CDAWebEditorPanel.this.messageComponent, "North");
                    CDAWebEditorPanel.this.parameterPanel.validate();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecent() {
        String val = (String)this.dsidComboBox.getSelectedItem();
        BufferedReader r = null;
        try {
            File home = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
            File book = new File(home, "bookmarks");
            File hist = new File(book, "history.txt");
            long t0 = System.currentTimeMillis();
            logger.log(Level.FINE, "reading recent datasources from {0}", hist.toString());
            if (!hist.exists()) {
                return;
            }
            r = new BufferedReader(new FileReader(hist));
            String s = r.readLine();
            LinkedHashSet<String> dss = new LinkedHashSet<String>();
            while (s != null) {
                int i;
                if (s.length() > 25 && s.substring(25).startsWith("vap+cdaweb") && (i = s.indexOf("ds=")) != -1) {
                    int j = s.indexOf("&", i);
                    if (j == -1) {
                        j = s.length();
                    }
                    String ds = s.substring(i + 3, j);
                    dss.add(ds);
                }
                s = r.readLine();
            }
            Object[] items = dss.toArray();
            Arrays.sort(items);
            this.dsidComboBox.setModel(new DefaultComboBoxModel<Object>(items));
            this.dsidComboBox.setSelectedItem(val);
            t0 = System.currentTimeMillis() - t0;
            logger.log(Level.FINE, "done in {0} millis\n", t0);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.dsidComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"error in parsing history.txt"}));
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dsidComboBox = new JComboBox();
        this.pickDsButton = new JButton();
        this.parameterPanel = new JPanel();
        this.timeRangePanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.availableTextField = new JLabel();
        this.jButton1 = new JButton();
        this.availabilityCB = new JCheckBox();
        this.timeRangeComboBox = new RecentComboBox();
        this.exampleTimeRangesCB = new JComboBox();
        this.descriptionLabel = new JLabel();
        this.setName("cdawebEditorPanel");
        this.jLabel1.setText("Dataset:");
        this.dsidComboBox.setEditable(true);
        this.dsidComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "recent items will go here"}));
        this.dsidComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CDAWebEditorPanel.this.dsidComboBoxActionPerformed(evt);
            }
        });
        this.pickDsButton.setText("Pick...");
        this.pickDsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CDAWebEditorPanel.this.pickDsButtonActionPerformed(evt);
            }
        });
        this.parameterPanel.setLayout(new BorderLayout());
        this.jLabel3.setText("Time Range: ");
        this.availableTextField.setText("data availability");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/cdaweb/calendar.png")));
        this.jButton1.setToolTipText("Time Range Tool");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CDAWebEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.availabilityCB.setText("availability");
        this.availabilityCB.setToolTipText("Show data availability instead of loading data.  This simply shows if granule files are found or not, so empty or near-empty granules still are marked as available.\n");
        this.availabilityCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CDAWebEditorPanel.this.availabilityCBActionPerformed(evt);
            }
        });
        this.exampleTimeRangesCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Example Time Ranges"}));
        this.exampleTimeRangesCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CDAWebEditorPanel.this.exampleTimeRangesCBItemStateChanged(evt);
            }
        });
        GroupLayout timeRangePanelLayout = new GroupLayout((Container)this.timeRangePanel);
        this.timeRangePanel.setLayout((LayoutManager)timeRangePanelLayout);
        timeRangePanelLayout.setHorizontalGroup((GroupLayout.Group)timeRangePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeRangePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)timeRangePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeRangePanelLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.timeRangeComboBox, -2, 192, -2).addPreferredGap(0).add((Component)this.jButton1, -2, 25, -2).addPreferredGap(0).add(this.exampleTimeRangesCB, 0, 164, Short.MAX_VALUE)).add(2, (GroupLayout.Group)timeRangePanelLayout.createSequentialGroup().add(0, 18, Short.MAX_VALUE).add((Component)this.availableTextField, -2, 370, -2).addPreferredGap(0).add((Component)this.availabilityCB))).addContainerGap()));
        timeRangePanelLayout.setVerticalGroup((GroupLayout.Group)timeRangePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeRangePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)timeRangePanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeRangePanelLayout.createSequentialGroup().add((GroupLayout.Group)timeRangePanelLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.timeRangeComboBox, -2, -1, -2)).add(0, 0, Short.MAX_VALUE)).add((Component)this.jButton1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)timeRangePanelLayout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add(this.exampleTimeRangesCB, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)timeRangePanelLayout.createParallelGroup(3).add((Component)this.availableTextField).add((Component)this.availabilityCB)).addContainerGap()));
        this.descriptionLabel.setText("Description of dataset goes here");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.timeRangePanel, -1, -1, Short.MAX_VALUE).add((Component)this.parameterPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.dsidComboBox, 0, 334, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pickDsButton, -2, 78, -2)).add((Component)this.descriptionLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.dsidComboBox, -2, -1, -2).add((Component)this.pickDsButton)).addPreferredGap(0).add((Component)this.descriptionLabel).add(4, 4, 4).add((Component)this.parameterPanel, -1, 191, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.timeRangePanel, -2, -1, -2)));
    }

    private void pickDsButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.pickDs();
    }

    private void dsidComboBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.parameterPanel.removeAll();
        this.messageComponent = new JLabel("<html><i>Resetting...</i></html>");
        this.parameterPanel.add((Component)this.messageComponent, "North");
        this.parameterPanel.revalidate();
        this.parameterPanel.repaint();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (!CDAWebEditorPanel.this.initializing) {
                    CDAWebEditorPanel.this.refresh(CDAWebEditorPanel.this.getURI());
                }
            }
        };
        RequestProcessor.invokeLater(run);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int r;
        LoggerManager.logGuiEvent(evt);
        TimeRangeTool tt = new TimeRangeTool();
        String s = this.timeRangeComboBox.getText();
        if (s != null) {
            tt.setSelectedRange(s);
        }
        if ((r = JOptionPane.showConfirmDialog(this, tt, "Select Time Range", 2)) == 0) {
            this.timeRangeComboBox.setText(tt.getSelectedRange());
        }
    }

    private void availabilityCBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
    }

    private void exampleTimeRangesCBItemStateChanged(ItemEvent evt) {
        String s = (String)this.exampleTimeRangesCB.getSelectedItem();
        if (!s.startsWith("Example")) {
            this.timeRangeComboBox.setSelectedItem(s);
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    private void initialize(String uri) {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
        this.dsidComboBox.setSelectedItem(args.get("ds"));
        String timeRange = (String)args.get("timerange");
        if (timeRange != null) {
            this.timeRangeComboBox.setText(timeRange.replaceAll("\\+", " "));
            this.providedTimeRange = timeRange.replaceAll("\\+", " ");
        }
        this.timeRangeComboBox.setPreferenceNode("timerange");
    }

    @Override
    public void setURI(String uri) {
        this.initialize(uri);
        URISplit split = URISplit.parse(uri);
        this.initializing = false;
        this.refresh(uri);
        LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
        String filter1 = (String)args.get(PARAM_FILTER);
        if (filter1 != null) {
            this.filter = filter1;
        }
        this.id = (String)args.get("id");
        this.availabilityCB.setSelected("T".equals(args.get("avail")));
        if (args.get("ds") == null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!CDAWebEditorPanel.this.isShowing()) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CDAWebEditorPanel.this.messageComponent = new JLabel(CDAWebEditorPanel.MSG_NO_DATASET);
                            CDAWebEditorPanel.this.parameterPanel.removeAll();
                            CDAWebEditorPanel.this.parameterPanel.add((Component)CDAWebEditorPanel.this.messageComponent, "North");
                            CDAWebEditorPanel.this.parameterPanel.revalidate();
                            if (!CDAWebEditorPanel.this.pickDs()) {
                                // empty if block
                            }
                        }
                    });
                }
            };
            new Thread(run).start();
        }
    }

    @Override
    public String getURI() {
        String lid = null;
        String slice1 = "";
        String where = null;
        String x = null;
        String y = null;
        if (this.paramEditor != null) {
            lid = this.paramEditor.getURI();
            URISplit split = URISplit.parse(lid);
            LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
            lid = (String)args.get("arg_0");
            slice1 = (String)args.get("slice1");
            where = (String)args.get("where");
            x = (String)args.get("x");
            y = (String)args.get("y");
        }
        if (lid != null) {
            this.id = lid;
        }
        if (lid == null && this.id != null) {
            lid = this.id;
        }
        if (lid == null) {
            lid = "";
        }
        String timeRange = this.timeRangeComboBox.getText();
        timeRange = timeRange.replaceAll(" ", "+");
        String result = "vap+cdaweb:ds=" + this.dsidComboBox.getSelectedItem() + "&id=" + lid;
        if (this.filter.length() > 0) {
            this.filter = this.filter.trim();
            int i = this.filter.indexOf(" ");
            if (i > -1) {
                this.filter = this.filter.substring(0, i);
            }
            result = result + "&filter=" + this.filter;
        }
        if (slice1 != null && slice1.length() > 0) {
            result = result + "&slice1=" + slice1;
        }
        if (where != null) {
            result = result + "&where=" + where;
        }
        if (this.availabilityCB.isSelected()) {
            result = result + "&avail=T";
        }
        if (x != null) {
            result = result + "&x=" + x;
        }
        if (y != null) {
            result = result + "&y=" + y;
        }
        return result + "&timerange=" + timeRange;
    }

    @Override
    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        this.initialize(uri);
        CDAWebDB.getInstance().maybeRefresh(mon);
        this.refresh(uri);
        return true;
    }

    @Override
    public boolean reject(String uri) throws Exception {
        return false;
    }

    public void setExpertMode(boolean expert) {
        this.expert = expert;
    }

    @Override
    public void markProblems(List<String> problems) {
    }

    private static class LabelMonitor
    extends NullProgressMonitor {
        int ndot = 2;
        JLabel label = new JLabel();
        Timer repaintTimer = new Timer(333, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String p = LabelMonitor.this.getTaskSize() == -1L ? "" : "" + LabelMonitor.this.getTaskProgress() + "/" + LabelMonitor.this.getTaskSize();
                ++LabelMonitor.this.ndot;
                if (LabelMonitor.this.ndot == 4) {
                    LabelMonitor.this.ndot = 1;
                }
                LabelMonitor.this.label.setText("<html><i><br>&nbsp;Loading file" + "...".substring(0, LabelMonitor.this.ndot) + p + "</i></html>");
            }
        });

        LabelMonitor() {
            this.repaintTimer.setRepeats(true);
            this.repaintTimer.start();
        }

        public JLabel getLabelComponent() {
            return this.label;
        }

        @Override
        public void finished() {
            this.repaintTimer.setRepeats(false);
        }
    }
}

