/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdaweb;

import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import java.io.File;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.autoplot.cdaweb.CDAWebDB;
import org.autoplot.cdaweb.CDAWebDataSource;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.cdf.CdfUtil;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DefaultTimeSeriesBrowse;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.fsm.FileStorageModel;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class CDAWebDataSourceFactory
implements DataSourceFactory {
    protected static final Logger logger = LoggerManager.getLogger("apdss.cdaweb");

    @Override
    public DataSource getDataSource(URI uri) throws Exception {
        return new CDAWebDataSource(uri);
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        CDAWebDB.getInstance().maybeRefresh(mon);
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>(10);
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "ds="));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "id="));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "timerange="));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "ws=", "ws=", "use web service"));
            return ccresult;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String param;
            switch (param = CompletionContext.get(CompletionContext.CONTEXT_PARAMETER_NAME, cc)) {
                case "ds": {
                    Map<String, String> dss = CDAWebDB.getInstance().getServiceProviderIds();
                    ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>(dss.size());
                    for (String ds : dss.keySet()) {
                        CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, ds, this, null, ds, ds, false);
                        ccresult.add(cc1);
                    }
                    return ccresult;
                }
                case "timerange": {
                    DatumRange dr;
                    URISplit split = URISplit.parse(cc.surl);
                    LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
                    String ds = (String)params.get("ds");
                    if (ds == null || ds.length() <= 0) break;
                    ds = ds.toUpperCase();
                    CDAWebDB db = CDAWebDB.getInstance();
                    String tr = db.getTimeRange(ds);
                    String tmpl = db.getNaming(ds);
                    String base = db.getBaseUrl(ds);
                    FileSystem fs = FileSystem.create(new URI(base));
                    FileStorageModel fsm = FileStorageModel.create(fs, tmpl);
                    String[] names = fsm.getNamesFor(dr = DatumRangeUtil.parseTimeRangeValid(tr));
                    String name = names.length > 1 ? names[1] : names[0];
                    DatumRange one = fsm.getRangeFor(name);
                    ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                    String key = one.toString().replaceAll(" ", "+");
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, this, null, key, key, true);
                    ccresult.add(cc1);
                    return ccresult;
                }
                case "id": {
                    URISplit split = URISplit.parse(cc.surl);
                    LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
                    String ds = (String)params.get("ds");
                    if (ds == null || ds.length() <= 0) break;
                    ds = ds.toUpperCase();
                    String master = CDAWebDB.getInstance().getMasterFile(ds.toLowerCase(), mon);
                    File f = FileSystemUtil.doDownload(master, mon);
                    CDFReader cdf = CdfDataSource.getCdfFile(f.toString());
                    Map<String, String> result = CdfUtil.getPlottable(cdf, true, 4);
                    ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                    for (Map.Entry<String, String> e : result.entrySet()) {
                        String key = e.getKey();
                        CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, this, null, key, e.getValue(), true);
                        ccresult.add(cc1);
                    }
                    return ccresult;
                }
                case "ws": {
                    ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>(10);
                    ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "T", "T", "use webservice"));
                    ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "F", "F", "use files for offline use"));
                    return ccresult;
                }
            }
        }
        return new ArrayList<CompletionContext>(){};
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new DefaultTimeSeriesBrowse();
        }
        return null;
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        if (!params.containsKey("ds") || !params.containsKey("id") && !"T".equals(params.get("avail")) || !params.containsKey("timerange")) {
            return true;
        }
        String tr = (String)params.get("timerange");
        if (tr == null) {
            return true;
        }
        tr = tr.replaceAll("\\+", " ");
        try {
            DatumRangeUtil.parseTimeRange(tr);
        }
        catch (ParseException ex) {
            return true;
        }
        if (((String)params.get("ds")).equals("")) {
            return true;
        }
        if ("T".equals(params.get("avail"))) {
            return false;
        }
        if (((String)params.get("id")).equals("")) {
            return true;
        }
        String slice1 = (String)params.get("slice1");
        if (slice1 != null) {
            try {
                Integer.parseInt(slice1);
            }
            catch (NumberFormatException ex) {
                problems.add("misformatted slice");
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDiscovery() {
        return true;
    }
}

