/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdaweb;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.cdaweb.CDAWebDB;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.cdf.CdfVirtualVars;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.metatree.IstpMetadataModel;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;

public class CDAWebDataSource
extends AbstractDataSource {
    protected static final Logger logger = LoggerManager.getLogger("apdss.cdaweb");
    public static final String PARAM_ID = "id";
    public static final String PARAM_DS = "ds";
    public static final String PARAM_TIMERANGE = "timerange";
    public static final String PARAM_WS = "ws";
    public static final String PARAM_AVAIL = "avail";
    Map<String, Object> metadata;
    DatumRange tr;
    String ds;
    String id;
    String ws;
    String savail;

    public CDAWebDataSource(URI uri) {
        super(uri);
        String timerange = this.getParam(PARAM_TIMERANGE, "2010-01-17").replaceAll("\\+", " ");
        try {
            this.tr = DatumRangeUtil.parseTimeRange(timerange);
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new IllegalArgumentException(ex);
        }
        this.ds = this.getParam(PARAM_DS, "ac_k0_epm");
        this.id = this.getParam("arg_0", null);
        this.ws = this.getParam(PARAM_WS, null);
        this.savail = this.getParam(PARAM_AVAIL, "F");
        if (this.id == null) {
            this.id = this.getParam(PARAM_ID, "H_lo");
        }
        if (this.id == null) {
            throw new IllegalArgumentException("param not specified");
        }
    }

    private DataSourceFactory getDelegateFactory() {
        DataSourceFactory cdfFileDataSourceFactory = DataSourceRegistry.getInstance().getSource("cdfj");
        return cdfFileDataSourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        CDAWebDB db = CDAWebDB.getInstance();
        if (!db.isOnline()) {
            throw new IOException("CDAWeb is not accessible.");
        }
        mon.started();
        QDataSet result = null;
        QDataSet accum = null;
        try {
            QDataSet labelDs;
            DataSource labelDss;
            String master;
            Map dep1p;
            try {
                mon.setProgressMessage("refreshing database");
                db.maybeRefresh(SubTaskMonitor.create(mon, 0L, 10L));
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                mon.setProgressMessage("unable to connect via ftp");
                Thread.sleep(1000L);
                throw ex;
            }
            String[] files = db.getFiles(this.ds.toUpperCase(), this.tr, this.ws, mon.getSubtaskMonitor("lookup files"));
            if ("T".equals(this.savail)) {
                logger.log(Level.FINE, "availablility {0} ", new Object[]{this.tr});
                DataSetBuilder build = new DataSetBuilder(2, files.length, 4);
                TimeLocationUnits u = Units.us2000;
                EnumerationUnits eu = new EnumerationUnits("default");
                for (String file : files) {
                    String[] ss = file.split("\\|");
                    file = ss[0];
                    DatumRange dr = DatumRangeUtil.parseTimeRange(ss[1] + " to " + ss[2]);
                    build.putValues(-1, DDataSet.wrap(new double[]{dr.min().doubleValue(u), dr.max().doubleValue(u), 8454016.0, eu.createDatum(ss[0]).doubleValue(eu)}), 4);
                    build.nextRecord();
                }
                DDataSet tresult = build.getDataSet();
                DDataSet bds = DDataSet.createRank2(4, 0);
                bds.putProperty("NAME__0", "StartTime");
                bds.putProperty("UNITS__0", u);
                bds.putProperty("NAME__1", "StopTime");
                bds.putProperty("UNITS__1", u);
                bds.putProperty("NAME__2", "Color");
                bds.putProperty("NAME__3", "Filename");
                bds.putProperty("UNITS__3", eu);
                tresult.putProperty("BUNDLE_1", bds);
                tresult.putProperty("RENDER_TYPE", "eventsBar");
                tresult.putProperty("LABEL", this.ds.toUpperCase() + "!cAvailability");
                tresult.putProperty("TITLE", this.ds.toUpperCase() + " Availability");
                DDataSet dDataSet = tresult;
                return dDataSet;
            }
            DataSourceFactory cdfFileDataSourceFactory = this.getDelegateFactory();
            mon.setTaskSize(files.length * 10 + 10);
            if (mon.isCancelled()) {
                throw new CancelledOperationException("user cancelled task");
            }
            mon.setTaskProgress(0L);
            mon.setProgressMessage("getting metadata for " + this.ds);
            this.getMetadata(SubTaskMonitor.create(mon, 0L, 10L));
            String virtual = (String)this.metadata.get("VIRTUAL");
            DatumRange range = null;
            for (int i = 0; i < files.length && !mon.isCancelled(); ++i) {
                MutablePropertyDataSet ds1;
                DatumRange range1;
                block54: {
                    String file = files[i];
                    String[] ss = file.split("\\|");
                    file = ss[0];
                    range1 = DatumRangeUtil.parseTimeRange(ss[1] + " to " + ss[2]);
                    mon.setTaskProgress((i + 1) * 10);
                    mon.setProgressMessage("load " + file);
                    SubTaskMonitor t1 = SubTaskMonitor.create(mon, (i + 1) * 10, (i + 2) * 10);
                    ds1 = null;
                    try {
                        if (virtual != null && !virtual.equals("")) {
                            int nc = 0;
                            ArrayList<QDataSet> comps = new ArrayList<QDataSet>();
                            String function = (String)this.metadata.get("FUNCTION");
                            if (function == null) {
                                function = (String)this.metadata.get("FUNCT");
                            }
                            if (function != null) {
                                String comp = (String)this.metadata.get("COMPONENT_" + nc);
                                while (comp != null) {
                                    HashMap<String, String> fileParams = new HashMap<String, String>(this.getParams());
                                    fileParams.remove(PARAM_TIMERANGE);
                                    fileParams.remove(PARAM_DS);
                                    fileParams.put(PARAM_ID, comp);
                                    URI file1 = DataSetURI.getURI(file + "?" + URISplit.formatParams(fileParams));
                                    DataSource dataSource = cdfFileDataSourceFactory.getDataSource(file1);
                                    try {
                                        ds1 = (MutablePropertyDataSet)dataSource.getDataSet(t1);
                                    }
                                    catch (Exception ex) {
                                        ds1 = null;
                                    }
                                    comps.add(ds1);
                                    comp = (String)this.metadata.get("COMPONENT_" + ++nc);
                                }
                                boolean missingComponent = false;
                                for (QDataSet comp1 : comps) {
                                    if (comp1 != null) continue;
                                    missingComponent = true;
                                }
                                if (missingComponent) break block54;
                                try {
                                    Map<String, Object> qmetadata = new IstpMetadataModel().properties(this.metadata);
                                    ds1 = (MutablePropertyDataSet)CdfVirtualVars.execute(qmetadata, function, comps, t1);
                                    break block54;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new IllegalArgumentException("The virtual variable " + this.id + " cannot be plotted because the function is not supported: " + function);
                                }
                            }
                            throw new IllegalArgumentException("The virtual variable " + this.id + " cannot be plotted because the function is not identified");
                        }
                        HashMap<String, String> fileParams = new HashMap<String, String>(this.getParams());
                        fileParams.remove(PARAM_TIMERANGE);
                        fileParams.remove(PARAM_DS);
                        URI file1 = DataSetURI.getURI(file + "?" + URISplit.formatParams(fileParams));
                        logger.log(Level.FINE, "loading {0}", file1);
                        CdfDataSource dataSource = (CdfDataSource)cdfFileDataSourceFactory.getDataSource(file1);
                        try {
                            ds1 = (MutablePropertyDataSet)dataSource.getDataSet(t1, this.metadata);
                        }
                        catch (IllegalArgumentException ex) {
                            String p = (String)this.params.get(PARAM_ID);
                            logger.log(Level.INFO, "parameter not found for interval: {0}", p);
                            throw new NoDataInIntervalException("parameter not found for interval: " + p);
                        }
                    }
                    catch (NoDataInIntervalException fileParams) {
                        // empty catch block
                    }
                }
                if (ds1 != null) {
                    if (result == null && accum == null) {
                        range = range1;
                        if (files.length == 1) {
                            result = ds1;
                            continue;
                        }
                        accum = ArrayDataSet.maybeCopy(ds1);
                        ((ArrayDataSet)accum).grow(((ArrayDataSet)accum).length() * files.length * 11 / 10);
                        continue;
                    }
                    assert (accum != null);
                    ArrayDataSet ads1 = ArrayDataSet.maybeCopy(((ArrayDataSet)accum).getComponentType(), ds1);
                    if (((ArrayDataSet)accum).canAppend(ads1)) {
                        ((ArrayDataSet)accum).append(ads1);
                    } else {
                        ((ArrayDataSet)accum).grow(((ArrayDataSet)accum).length() + ads1.length() * (files.length - i));
                        ((ArrayDataSet)accum).append(ads1);
                    }
                    range = DatumRangeUtil.union(range, range1);
                    continue;
                }
                logger.log(Level.FINE, "failed to read data for granule: {0}", files[i]);
            }
            if (result == null) {
                result = accum;
            }
            if (result != null && result.property("UNITS") == null && this.metadata.containsKey("UNIT_PTR_VALUE")) {
                QDataSet unitss = (QDataSet)this.metadata.get("UNIT_PTR_VALUE");
                boolean allSame = true;
                for (int i = 0; i < unitss.length(); ++i) {
                    if (unitss.value(i) == unitss.value(0)) continue;
                    allSame = false;
                }
                if (allSame) {
                    result = Ops.putProperty(result, "UNITS", (Object)Units.lookupUnits(unitss.slice(0).toString()));
                }
            }
            if (result != null && result.property("DEPEND_1") == null && (dep1p = (Map)this.metadata.get("DEPEND_1")) != null && dep1p.containsKey("NAME") && result.rank() > 1) {
                String dep1 = (String)dep1p.get("NAME");
                String master2 = db.getMasterFile(this.ds.toUpperCase(), new NullProgressMonitor());
                DataSource masterSource = cdfFileDataSourceFactory.getDataSource(DataSetURI.getURI(master2 + "?" + dep1 + "[0]&doDep=no"));
                MutablePropertyDataSet ds1 = (MutablePropertyDataSet)masterSource.getDataSet(new NullProgressMonitor());
                result = Ops.putProperty(result, "DEPEND_1", (Object)ds1);
            }
            if (result != null && result.rank() == 2) {
                QDataSet labels = (QDataSet)result.property("DEPEND_1");
                String labelVar = (String)this.metadata.get("LABL_PTR_1");
                String renderType = (String)result.property("RENDER_TYPE");
                if (labelVar != null && (renderType == null || renderType.equals("time_series"))) {
                    labels = null;
                }
                if (labels == null && labelVar != null) {
                    master = db.getMasterFile(this.ds.toLowerCase(), mon.getSubtaskMonitor("get master file"));
                    labelDss = this.getDelegateFactory().getDataSource(DataSetURI.getURI(master + "?" + labelVar));
                    labelDs = (MutablePropertyDataSet)labelDss.getDataSet(new NullProgressMonitor());
                    if (labelDs != null && labelDs.rank() > 1 && labelDs.length() == 1) {
                        labelDs = labelDs.slice(0);
                    }
                }
            }
            String slice1 = this.getParam("slice1", "");
            if (result != null && slice1.length() > 0) {
                int islice1 = Integer.parseInt(slice1);
                String labelVar = (String)this.metadata.get("LABL_PTR_1");
                if (labelVar != null) {
                    master = db.getMasterFile(this.ds.toLowerCase(), mon.getSubtaskMonitor("get master file"));
                    labelDss = this.getDelegateFactory().getDataSource(DataSetURI.getURI(master + "?" + labelVar));
                    labelDs = (MutablePropertyDataSet)labelDss.getDataSet(new NullProgressMonitor());
                    if (labelDs != null) {
                        if (labelDs.rank() > 1 && labelDs.length() == 1) {
                            labelDs = labelDs.slice(0);
                        }
                        result = Ops.putProperty(result, "LABEL", (Object)DataSetUtil.getStringValue(labelDs.slice(islice1)).trim());
                    }
                }
            }
            if (result != null) {
                MutablePropertyDataSet dep0 = (MutablePropertyDataSet)result.property("DEPEND_0");
                if (dep0 != null && range != null) {
                    Units dep0units = (Units)dep0.property("UNITS");
                    dep0 = Ops.putProperty(dep0, "TYPICAL_MIN", (Object)range.min().doubleValue(dep0units));
                    dep0 = Ops.putProperty(dep0, "TYPICAL_MAX", (Object)range.max().doubleValue(dep0units));
                    dep0 = Ops.putProperty(dep0, "CACHE_TAG", (Object)new CacheTag(range, null));
                    result = Ops.putProperty(result, "DEPEND_0", (Object)dep0);
                }
                HashMap<String, String> user = new HashMap<String, String>();
                for (int i = 0; i < Math.min(files.length, 10); ++i) {
                    user.put("delegate_" + i, files[i]);
                }
                if (files.length >= 10) {
                    user.put("delegate_10", files.length - 10 + " more files.");
                }
                if (!result.isImmutable()) {
                    result.putProperty("USER_PROPERTIES", user);
                }
            }
        }
        finally {
            if (!mon.isFinished()) {
                mon.finished();
            }
        }
        if (result != null) {
            ArrayList<String> problems;
            String displayType = (String)result.property("RENDER_TYPE");
            if (displayType != null && displayType.equals("spectrogram")) {
                int rank = result.rank();
                int nphys = 0;
                for (int i = 1; i < rank; ++i) {
                    QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
                    if (dep1 != null && UnitsUtil.isNominalMeasurement(SemanticOps.getUnits(dep1))) continue;
                    ++nphys;
                }
                if (nphys == 0) {
                    logger.fine("removing display type because of ordinal units");
                    result = Ops.putProperty(result, "RENDER_TYPE", null);
                }
            }
            if (!DataSetUtil.validate(result, problems = new ArrayList<String>())) {
                throw new Exception("calculated dataset is not well-formed: " + this.uri + ". " + problems);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        if ("T".equals(this.savail)) {
            return null;
        }
        if (this.metadata == null) {
            mon.started();
            CDAWebDB db = CDAWebDB.getInstance();
            String master = db.getMasterFile(this.ds.toLowerCase(), mon.getSubtaskMonitor("getMasterFile"));
            master = master + "?" + this.id;
            String x = this.getParam("x", null);
            String y = this.getParam("y", null);
            if (x != null) {
                master = master + "&x=" + x;
            }
            if (y != null) {
                master = master + "&y=" + y;
            }
            DataSource cdf = this.getDelegateFactory().getDataSource(DataSetURI.getURI(master));
            this.metadata = cdf.getMetadata(mon.getSubtaskMonitor("getMetadata"));
            String slice1 = this.getParam("slice1", "");
            if (!slice1.equals("")) {
                this.metadata.remove("LABLAXIS");
                String labelVar = (String)this.metadata.get("LABL_PTR_1");
                if (labelVar != null) {
                    String master1 = db.getMasterFile(this.ds.toLowerCase(), mon.getSubtaskMonitor("getMasterFile"));
                    DataSource labelDss = this.getDelegateFactory().getDataSource(DataSetURI.getURI(master1 + "?" + labelVar));
                    QDataSet labelDs = (MutablePropertyDataSet)labelDss.getDataSet(new NullProgressMonitor());
                    if (labelDs != null) {
                        if (labelDs.rank() > 1 && labelDs.length() == 1) {
                            labelDs = labelDs.slice(0);
                        }
                        this.metadata.put("LABLAXIS", DataSetUtil.getStringValue(labelDs.slice(Integer.parseInt(slice1))));
                    }
                }
            }
            mon.finished();
        }
        return this.metadata;
    }

    @Override
    public MetadataModel getMetadataModel() {
        return new IstpMetadataModel();
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new TimeSeriesBrowse(){

                @Override
                public void setTimeRange(DatumRange dr) {
                    CDAWebDataSource.this.tr = dr;
                }

                @Override
                public DatumRange getTimeRange() {
                    return CDAWebDataSource.this.tr;
                }

                @Override
                public void setTimeResolution(Datum d) {
                }

                @Override
                public Datum getTimeResolution() {
                    return null;
                }

                @Override
                public String getURI() {
                    Map p = CDAWebDataSource.this.getParams();
                    p.put(CDAWebDataSource.PARAM_TIMERANGE, CDAWebDataSource.this.tr.toString().replace(' ', '+'));
                    return "vap+cdaweb:" + URISplit.formatParams(p);
                }

                @Override
                public String blurURI() {
                    Map p = CDAWebDataSource.this.getParams();
                    p.remove(CDAWebDataSource.PARAM_TIMERANGE);
                    return "vap+cdaweb:" + URISplit.formatParams(p);
                }

                @Override
                public void setURI(String suri) throws ParseException {
                    URISplit split = URISplit.parse(suri);
                    LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
                    CDAWebDataSource.this.tr = DatumRangeUtil.parseTimeRange((String)params.get(CDAWebDataSource.PARAM_TIMERANGE));
                }
            };
        }
        return null;
    }

    public static void main(String[] args) throws URISyntaxException, Exception {
        CDAWebDataSource dss = new CDAWebDataSource(new URI("vap+cdaweb:file:///foo.xml?ds=cl_sp_fgm&id=B_mag&timerange=2001-10-10"));
        QDataSet ds = dss.getDataSet(new NullProgressMonitor());
        logger.fine(ds.toString());
    }
}

