/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdaweb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.das2.components.DasProgressPanel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.fsm.FileStorageModel;
import org.das2.util.AboutUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CDAWebDB {
    private static final Logger logger = LoggerManager.getLogger("apdss.cdaweb");
    private static CDAWebDB instance = null;
    public static final String CDAWeb = System.getProperty("cdawebHttps", "true").equals("false") ? "http://cdaweb.gsfc.nasa.gov/" : "https://cdaweb.gsfc.nasa.gov/";
    public static final String dbloc = CDAWeb + "pub/catalogs/all.xml";
    private Document document;
    private Map<String, String> ids;
    private long refreshTime = 0L;
    private final Map<String, String> bases = new HashMap<String, String>();
    private final Map<String, String> tmpls = new HashMap<String, String>();
    private Boolean online = null;

    public static synchronized CDAWebDB getInstance() {
        if (instance == null) {
            instance = new CDAWebDB();
        }
        return instance;
    }

    public synchronized boolean isOnline() {
        if (this.online == null) {
            try {
                DataSetURI.getFile(CDAWeb + "pub/software/cdawlib/AAREADME.txt", false, new NullProgressMonitor());
                this.online = true;
            }
            catch (IOException ex) {
                try {
                    if (!AboutUtil.isJreVersionAtLeast("1.8.0_102")) {
                        logger.warning("Java version is probably too old to connect to CDAWeb");
                    }
                }
                catch (ParseException ex1) {
                    logger.warning("Java version may be too old to connect to CDAWeb");
                }
                this.online = false;
            }
        }
        return this.online;
    }

    public synchronized void maybeRefresh(ProgressMonitor mon) throws IOException {
        long t = System.currentTimeMillis();
        if (t - this.refreshTime > 600000L) {
            this.refresh(mon);
            this.refreshTime = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh(ProgressMonitor mon) throws IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            mon.setProgressMessage("refreshing database");
            mon.started();
            mon.setTaskSize(30L);
            mon.setProgressMessage("downloading file " + dbloc);
            logger.log(Level.FINE, "downloading file {0}", dbloc);
            File f = DataSetURI.getFile(new URI(dbloc), (ProgressMonitor)SubTaskMonitor.create(mon, 0L, 10L));
            FileInputStream fin = null;
            InputStream altin = null;
            try {
                fin = new FileInputStream(f);
                InputSource source = new InputSource(fin);
                mon.setTaskProgress(10L);
                mon.setProgressMessage("parsing file " + dbloc);
                this.document = builder.parse(source);
                mon.setTaskProgress(20L);
                mon.setProgressMessage("reading IDs");
                altin = CDAWebDB.class.getResourceAsStream("/org/autoplot/cdaweb/filenames_alt.txt");
                if (altin == null) {
                    throw new RuntimeException("Unable to locate /org/autoplot/cdaweb/filenames_alt.txt");
                }
                try (BufferedReader rr = new BufferedReader(new InputStreamReader(altin));){
                    String ss = rr.readLine();
                    while (ss != null) {
                        int i = ss.indexOf("#");
                        if (i > -1) {
                            ss = ss.substring(0, i);
                        }
                        if (ss.trim().length() > 0) {
                            String[] sss = ss.split("\\s+");
                            String naming = sss[2];
                            naming = naming.replaceAll("\\%", "\\$");
                            this.tmpls.put(sss[0], naming);
                            if (sss[1].length() > 1) {
                                this.bases.put(sss[0], sss[1]);
                            }
                        }
                        ss = rr.readLine();
                    }
                }
                this.refreshServiceProviderIds(mon.getSubtaskMonitor(20, 30, "process document"));
                mon.setTaskProgress(30L);
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (altin != null) {
                    altin.close();
                }
                mon.finished();
            }
        }
        catch (SAXException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (URISyntaxException | ParserConfigurationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public String[] getFiles(String spid, DatumRange tr, String useWebServiceHint, ProgressMonitor mon) throws IOException, CancelledOperationException {
        String[] result;
        boolean useService = !"F".equals(useWebServiceHint);
        logger.log(Level.FINE, "getFiles {0} {1} ws={2}", new Object[]{spid, tr, useService});
        if (useService) {
            String[] ff = this.getOriginalFilesAndRangesFromWebService(spid, tr, mon);
            ArrayList<String> resultList = new ArrayList<String>(ff.length);
            for (String ff1 : ff) {
                try {
                    String[] ss = ff1.split("\\|");
                    DatumRange dr = DatumRangeUtil.parseTimeRange(ss[1] + " to " + ss[2]);
                    if (!dr.intersects(tr)) continue;
                    resultList.add(ff1);
                }
                catch (ParseException ex) {
                    Logger.getLogger(CDAWebDB.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            result = resultList.toArray(new String[resultList.size()]);
        } else {
            try {
                String tmpl = this.getNaming(spid);
                String base = this.getBaseUrl(spid);
                logger.log(Level.FINE, "tmpl={0}", tmpl);
                logger.log(Level.FINE, "base={0}", base);
                logger.log(Level.FINE, "{0}/{1}", new Object[]{base, tmpl});
                FileSystem fs = FileSystem.create(new URI(base));
                FileStorageModel fsm = FileStorageModel.create(fs, tmpl);
                String[] ff = fsm.getBestNamesFor(tr, mon);
                result = new String[ff.length];
                TimeParser tp = TimeParser.create("$Y-$m-$dT$H:$M:$SZ");
                for (int i = 0; i < ff.length; ++i) {
                    DatumRange tr1 = fsm.getRangeFor(ff[i]);
                    result[i] = base + "/" + ff[i] + "|" + tp.format(tr1.min()) + "|" + tp.format(tr1.max());
                }
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        logger.log(Level.FINER, "found {0} files.", result.length);
        return result;
    }

    public String[] getOriginalFilesAndRangesFromWebService(String spid, DatumRange tr, ProgressMonitor mon) throws IOException, CancelledOperationException {
        TimeParser tp = TimeParser.create("$Y$m$dT$H$M$SZ");
        String tstart = tp.format(tr.min(), tr.min());
        String tstop = tp.format(tr.max(), tr.max());
        InputStream ins = null;
        try {
            URL url = new URL(String.format(CDAWeb + "WS/cdasr/1/dataviews/sp_phys/datasets/%s/orig_data/%s,%s", spid, tstart, tstop));
            logger.fine(url.toString());
            Logger loggerUrl = LoggerManager.getLogger("das2.url");
            URLConnection urlc = url.openConnection();
            urlc.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
            loggerUrl.log(Level.FINE, "GET data from CDAWeb {0}", urlc.getURL());
            ins = urlc.getInputStream();
            InputSource source = new InputSource(ins);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(source);
            XPath xp = XPathFactory.newInstance().newXPath();
            NodeList set = (NodeList)xp.evaluate("/DataResult/FileDescription", doc.getDocumentElement(), XPathConstants.NODESET);
            mon.setTaskSize(set.getLength());
            mon.started();
            String[] result = new String[set.getLength()];
            for (int i = 0; i < set.getLength(); ++i) {
                if (mon.isCancelled()) {
                    throw new CancelledOperationException("cancel during parse");
                }
                mon.setTaskProgress(i);
                Node item = set.item(i);
                result[i] = xp.evaluate("Name/text()", item) + "|" + xp.evaluate("StartTime/text()", item) + "|" + xp.evaluate("EndTime/text()", item);
            }
            String[] stringArray = result;
            return stringArray;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (SAXException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        catch (ParserConfigurationException | XPathExpressionException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        finally {
            mon.finished();
            if (ins != null) {
                ins.close();
            }
        }
    }

    public String[] getFilesAndRangesFromWebService(String spid, DatumRange tr) throws IOException {
        TimeParser tp = TimeParser.create("$Y$m$dT$H$M$SZ");
        String tstart = tp.format(tr.min(), tr.min());
        String tstop = tp.format(tr.max(), tr.max());
        try (InputStream ins = null;){
            URL url = new URL(String.format(CDAWeb + "WS/cdasr/1/dataviews/sp_phys/datasets/%s/data/%s,%s/ALL-VARIABLES?format=cdf", spid, tstart, tstop));
            Logger loggerUrl = LoggerManager.getLogger("das2.url");
            loggerUrl.log(Level.FINE, "openConnection {0}", url);
            URLConnection urlc = url.openConnection();
            urlc.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
            loggerUrl.log(Level.FINE, "getInputStream {0}", url);
            ins = urlc.getInputStream();
            InputSource source = new InputSource(ins);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(source);
            XPath xp = XPathFactory.newInstance().newXPath();
            NodeList set = (NodeList)xp.evaluate("/DataResult/FileDescription", doc.getDocumentElement(), XPathConstants.NODESET);
            String[] result = new String[set.getLength()];
            for (int i = 0; i < set.getLength(); ++i) {
                Node item = set.item(i);
                result[i] = xp.evaluate("Name/text()", item) + "|" + xp.evaluate("StartTime/text()", item) + "|" + xp.evaluate("EndTime/text()", item);
            }
            String[] stringArray = result;
            return stringArray;
        }
    }

    private static XPathFactory getXPathFactory() {
        return DataSourceUtil.getXPathFactory();
    }

    public String getNaming(String spid) throws IOException {
        if (this.document == null) {
            throw new IllegalArgumentException("document has not been read, refresh must be called first");
        }
        try {
            spid = spid.toUpperCase();
            if (this.tmpls.containsKey(spid)) {
                return this.tmpls.get(spid);
            }
            XPathFactory xpf = CDAWebDB.getXPathFactory();
            XPath xp = xpf.newXPath();
            logger.log(Level.FINER, "getting node for {0}", spid);
            Node node = (Node)xp.evaluate(String.format("/sites/datasite/dataset[@serviceprovider_ID='%s']/access", spid), this.document, XPathConstants.NODE);
            if (node == null) {
                throw new IOException("unable to find node for " + spid + " in " + dbloc);
            }
            NamedNodeMap attrs = node.getAttributes();
            String subdividedby = attrs.getNamedItem("subdividedby").getTextContent();
            String filenaming = attrs.getNamedItem("filenaming").getTextContent();
            logger.log(Level.FINER, "subdividedby={0}", subdividedby);
            logger.log(Level.FINER, "filenaming={0}", filenaming);
            if (filenaming.contains("%Q")) {
                filenaming = filenaming.replaceFirst("%Q.*\\.cdf", "?%(v,sep).cdf");
            }
            String naming = subdividedby.equals("None") ? filenaming : subdividedby + "/" + filenaming;
            naming = naming.replaceAll("\\%", "\\$");
            return naming;
        }
        catch (XPathExpressionException ex) {
            throw new IOException("unable to read node " + spid);
        }
    }

    public String getBaseUrl(String spid) throws IOException {
        if (this.document == null) {
            throw new IllegalArgumentException("document has not been read, refresh must be called first");
        }
        try {
            String lookfor;
            spid = spid.toUpperCase();
            if (this.bases.containsKey(spid)) {
                return this.bases.get(spid);
            }
            XPathFactory xpf = CDAWebDB.getXPathFactory();
            XPath xp = xpf.newXPath();
            String url = (String)xp.evaluate(String.format("/sites/datasite/dataset[@serviceprovider_ID='%s']/access/URL/text()", spid), this.document, XPathConstants.STRING);
            if ((url = url.trim()).contains(" ")) {
                String[] ss = url.split("\\s+");
                url = ss[ss.length - 1];
            }
            if (url.startsWith("/tower3/public/pub/istp/")) {
                url = "ftp://cdaweb.gsfc.nasa.gov/" + url.substring("/tower3/public/".length());
            }
            if (url.startsWith("/tower4/public/pub/istp/")) {
                url = "ftp://cdaweb.gsfc.nasa.gov/" + url.substring("/tower4/public/".length());
            }
            if (url.startsWith("/tower5/public/pub/istp/")) {
                url = "ftp://cdaweb.gsfc.nasa.gov/" + url.substring("/tower5/public/".length());
            }
            if (url.startsWith("/tower6/public/pub/istp/")) {
                url = "ftp://cdaweb.gsfc.nasa.gov/" + url.substring("/tower6/public/".length());
            }
            if (url.startsWith("/tower3/private/cdaw_data/cluster_private/st")) {
                url = "ftp://cdaweb.gsfc.nasa.gov/" + url.substring("/tower3/private/".length());
            }
            if (url.startsWith(lookfor = "ftp://cdaweb.gsfc.nasa.gov/pub/")) {
                url = CDAWeb + "pub/" + url.substring(lookfor.length());
            }
            return url;
        }
        catch (XPathExpressionException ex) {
            throw new IOException("unable to read node " + spid);
        }
    }

    public String getSampleTime(String spid) throws IOException {
        try {
            Datum width;
            String last = this.getTimeRange(spid);
            int i = last.indexOf(" to ");
            last = last.substring(i + 4);
            String tmpl = this.getNaming(spid);
            String base = this.getBaseUrl(spid);
            try {
                FileSystem fs = FileSystem.create(new URI(base));
                FileStorageModel fsm = FileStorageModel.create(fs, tmpl);
                String ff = fsm.getRepresentativeFile(new NullProgressMonitor());
                if (ff != null) {
                    return fsm.getRangeFor(ff).toString();
                }
                width = Units.hours.createDatum(24);
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                width = Units.hours.createDatum(24);
            }
            Datum d = TimeUtil.prevMidnight(TimeUtil.create(last));
            d = d.subtract(width);
            Datum d1 = d.add(width);
            DatumRange dr = new DatumRange(d, d1);
            return dr.toString();
        }
        catch (ParseException ex) {
            throw new IOException(ex.toString());
        }
    }

    public String getSampleFile(String spid) throws IOException {
        String tmpl = this.getNaming(spid);
        String base = this.getBaseUrl(spid);
        try {
            FileSystem fs = FileSystem.create(new URI(base));
            FileStorageModel fsm = FileStorageModel.create(fs, tmpl);
            String ff = fsm.getRepresentativeFile(new NullProgressMonitor());
            if (ff != null) {
                return base + "/" + ff;
            }
            throw new IllegalArgumentException("unable to find sample file");
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getTimeRange(String spid) throws IOException {
        if (this.document == null) {
            throw new IllegalArgumentException("document has not been read, refresh must be called first");
        }
        try {
            spid = spid.toUpperCase();
            XPath xp = CDAWebDB.getXPathFactory().newXPath();
            Node node = (Node)xp.evaluate(String.format("/sites/datasite/dataset[@serviceprovider_ID='%s']", spid), this.document, XPathConstants.NODE);
            if (node == null) {
                throw new IllegalArgumentException("unable to find node for serviceprovider_ID=" + spid);
            }
            NamedNodeMap attrs = node.getAttributes();
            String start = attrs.getNamedItem("timerange_start").getTextContent();
            String stop = attrs.getNamedItem("timerange_stop").getTextContent();
            return start + " to " + stop;
        }
        catch (XPathExpressionException ex) {
            throw new IOException("unable to read node " + spid);
        }
    }

    public String getMasterFile(String ds, ProgressMonitor p) throws IOException {
        String master;
        logger.log(Level.FINE, "getMasterFile for {0}, looking for v02 then v01.", ds);
        p.started();
        FileSystem mastersFs = FileSystem.create(CDAWeb + "pub/software/cdawlib/0MASTERS/");
        FileObject fo = mastersFs.getFileObject(ds.toLowerCase() + "_00000000_v02.cdf");
        if (!fo.exists()) {
            fo = mastersFs.getFileObject(ds.toLowerCase() + "_00000000_v01.cdf");
        }
        if ((master = fo.exists() ? mastersFs.getRootURI().toString() + fo.getNameExt() : null) != null) {
            logger.log(Level.FINER, "found master file: {0}", master);
            p.finished();
        } else {
            DatumRange dr;
            String tmpl = this.getNaming(ds.toUpperCase());
            String base = this.getBaseUrl(ds.toUpperCase());
            URI baseUri = DataSetURI.toUri(base);
            FileSystem fs = FileSystem.create(baseUri);
            FileStorageModel fsm = FileStorageModel.create(fs, tmpl);
            String avail = CDAWebDB.getInstance().getSampleTime(ds);
            try {
                dr = DatumRangeUtil.parseTimeRange(avail);
            }
            catch (ParseException ex1) {
                logger.log(Level.SEVERE, ex1.getMessage(), ex1);
                master = fsm.getRepresentativeFile(p);
                dr = fsm.getRangeFor(master);
            }
            String[] files = fsm.getBestNamesFor(dr, p);
            if (files.length == 0) {
                master = fsm.getRepresentativeFile(p);
                if (master == null) {
                    throw new FileNotFoundException("unable to find any files to serve as master file in " + fsm);
                }
                master = fs.getRootURI().toString() + master;
            } else {
                master = fs.getRootURI().toString() + files[0];
            }
            logger.log(Level.FINER, "using arbitary representative as master file: {0}", master);
            p.finished();
        }
        p.setProgressMessage(" ");
        return master;
    }

    private String getURL(String id, Node dataset) {
        NodeList kids = dataset.getChildNodes();
        String lookfor = "ftp://cdaweb.gsfc.nasa.gov/pub/istp/";
        String lookfor2 = "ftp://cdaweb.gsfc.nasa.gov/pub/cdaweb_data";
        for (int j = 0; j < kids.getLength(); ++j) {
            Node childNode = kids.item(j);
            if (!childNode.getNodeName().equals("access")) continue;
            NodeList kids2 = childNode.getChildNodes();
            for (int k = 0; k < kids2.getLength(); ++k) {
                if (!kids2.item(k).getNodeName().equals("URL")) continue;
                if (kids2.item(k).getFirstChild() == null) {
                    logger.warning("URL is missing for " + id);
                    return null;
                }
                String url = kids2.item(k).getFirstChild().getTextContent().trim();
                if (url.startsWith(lookfor)) {
                    url = CDAWeb + "sp_phys/data/" + url.substring(lookfor.length());
                }
                if (url.startsWith(lookfor2)) {
                    url = CDAWeb + "sp_phys/data/" + url.substring(lookfor2.length());
                }
                return url;
            }
        }
        return null;
    }

    private String getDescription(Node dataset) {
        NodeList kids = dataset.getChildNodes();
        for (int j = 0; j < kids.getLength(); ++j) {
            Node childNode = kids.item(j);
            if (!childNode.getNodeName().equals("description")) continue;
            NamedNodeMap kids2 = childNode.getAttributes();
            Node shortDesc = kids2.getNamedItem("short");
            if (shortDesc != null) {
                return shortDesc.getNodeValue();
            }
            return null;
        }
        return null;
    }

    private String getFilenaming(Node dataset) {
        NodeList kids = dataset.getChildNodes();
        for (int j = 0; j < kids.getLength(); ++j) {
            Node childNode = kids.item(j);
            if (!childNode.getNodeName().equals("access")) continue;
            NamedNodeMap kids2 = childNode.getAttributes();
            Node shortDesc = kids2.getNamedItem("filenaming");
            if (shortDesc != null) {
                return shortDesc.getNodeValue();
            }
            return null;
        }
        return null;
    }

    public Map<String, String> getServiceProviderIds() {
        return this.ids;
    }

    private void refreshServiceProviderIds(ProgressMonitor mon) throws IOException {
        if (this.document == null) {
            throw new IllegalArgumentException("document has not been read, refresh must be called first");
        }
        try {
            XPath xp = CDAWebDB.getXPathFactory().newXPath();
            NodeList nodes = (NodeList)xp.evaluate("//sites/datasite/dataset", this.document, XPathConstants.NODESET);
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            mon.setTaskSize(nodes.getLength());
            mon.started();
            for (int i = 0; i < nodes.getLength(); ++i) {
                mon.setTaskProgress(i);
                Node node = nodes.item(i);
                NamedNodeMap attrs = node.getAttributes();
                try {
                    String name;
                    String url;
                    String st = attrs.getNamedItem("timerange_start").getTextContent();
                    String en = attrs.getNamedItem("timerange_stop").getTextContent();
                    if (st.length() <= 1 || !Character.isDigit(st.charAt(0)) || en.length() <= 1 || !Character.isDigit(en.charAt(0)) || (url = this.getURL(name = attrs.getNamedItem("serviceprovider_ID").getTextContent(), node)) == null || !url.startsWith(CDAWeb + "istp_public/data/") && !url.startsWith(CDAWeb + "sp_phys/data/") && !url.startsWith("ftp://cdaweb.gsfc.nasa.gov") || url.startsWith("/tower3/private")) continue;
                    String filenaming = this.getFilenaming(node);
                    String s = attrs.getNamedItem("serviceprovider_ID").getTextContent();
                    if (filenaming.endsWith(".cdf")) {
                        String desc = this.getDescription(node);
                        result.put(s, desc);
                        continue;
                    }
                    logger.log(Level.FINE, "ignoring {0} because files do not end in .cdf", s);
                    continue;
                }
                catch (DOMException ex2) {
                    logger.log(Level.WARNING, "exception", ex2);
                }
            }
            mon.finished();
            this.ids = result;
        }
        catch (XPathExpressionException ex) {
            logger.log(Level.WARNING, "serviceprovider_IDs exception", ex);
            throw new IOException("unable to read serviceprovider_IDs");
        }
    }

    public static void main(String[] args) throws IOException, ParseException {
        String[] files;
        CDAWebDB db = CDAWebDB.getInstance();
        long t0 = System.currentTimeMillis();
        db.refresh(DasProgressPanel.createFramed("refreshing database"));
        System.err.println(db.getBaseUrl("AC_H3_CRIS"));
        System.err.println(db.getNaming("AC_H3_CRIS"));
        FileStorageModel fsm = FileStorageModel.create(FileSystem.create(db.getBaseUrl("AC_H3_CRIS")), db.getNaming("AC_H3_CRIS"));
        for (String s : files = fsm.getBestNamesFor(DatumRangeUtil.parseTimeRange("20110601-20110701"), new NullProgressMonitor())) {
            System.err.println(s);
        }
        db.getSampleTime("I1_AV_OTT");
        db.getSampleTime("IA_K0_ENF");
        for (String s : files = db.getFilesAndRangesFromWebService("AC_H0_MFI", DatumRangeUtil.parseTimeRange("20010101T000000Z-20010131T000000Z"))) {
            System.err.println(s);
        }
        for (String s : files = db.getFilesAndRangesFromWebService("TIMED_L1B_SABER", DatumRangeUtil.parseTimeRange("2002-01-26"))) {
            System.err.println(s);
        }
        Map<String, String> ids = db.getServiceProviderIds();
        for (Map.Entry<String, String> e : ids.entrySet()) {
            System.err.println(e.getKey() + ":\t" + e.getValue());
        }
        System.err.println(ids.size());
        System.err.println(db.getNaming("AC_H0_MFI"));
        System.err.println(db.getTimeRange("AC_H0_MFI"));
        System.err.println("Timer: " + (System.currentTimeMillis() - t0));
    }
}

