/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.bookmarks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.autoplot.AutoplotUtil;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.das2.util.LoggerManager;
import org.xml.sax.SAXException;

public class Util {
    private static final Logger logger = LoggerManager.getLogger("autoplot");

    public static void loadRecent(String nodeName, final DataSetSelector sel, List<Bookmark> deft) {
        File f;
        File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
        if (!f2.exists()) {
            boolean ok;
            boolean bl = ok = f2.exists() || f2.mkdirs();
            if (!ok) {
                throw new RuntimeException("unable to create folder " + f2);
            }
        }
        if ((f = new File(f2, nodeName + ".xml")).exists()) {
            try {
                List<Bookmark> recent = Bookmark.parseBookmarks(AutoplotUtil.readDoc(new FileInputStream(f)).getDocumentElement());
                Util.setRecent(sel, recent);
            }
            catch (IOException | ParserConfigurationException | BookmarksException | SAXException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        } else {
            Util.setRecent(sel, deft);
            try (PrintStream fout = new PrintStream(f);){
                Bookmark.formatBooks(fout, Util.getRecent(sel));
                fout.close();
            }
            catch (FileNotFoundException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        sel.addPropertyChangeListener("recent", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try (PrintStream fout = new PrintStream(f);){
                    Bookmark.formatBooks(fout, Util.getRecent(sel));
                    fout.close();
                }
                catch (FileNotFoundException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        });
        sel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try (PrintStream fout = new PrintStream(f);){
                    List<Bookmark> result = Util.getRecent(sel);
                    result.add(new Bookmark.Item(sel.getValue()));
                    Bookmark.formatBooks(fout, result);
                    fout.close();
                }
                catch (FileNotFoundException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        });
    }

    public static List<Bookmark> getRecent(DataSetSelector sel) {
        List<String> ls = sel.getRecent();
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        for (String l : ls) {
            result.add(new Bookmark.Item(l));
        }
        return result;
    }

    public static void setRecent(DataSetSelector sel, List<Bookmark> recent) {
        ArrayList<String> result = new ArrayList<String>();
        for (Bookmark b : recent) {
            if (!(b instanceof Bookmark.Item)) continue;
            String s = ((Bookmark.Item)b).getUri();
            result.remove(s);
            result.add(s);
        }
        sel.setRecent(result);
    }
}

