/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.bookmarks;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.bookmarks.BookmarksManager;
import org.autoplot.bookmarks.BookmarksManagerModel;
import org.das2.util.LoggerManager;
import org.xml.sax.SAXException;

public class BookmarksManagerTransferrable {
    private static final Logger logger = LoggerManager.getLogger("autoplot.bookmarks");
    private final BookmarksManagerModel model;
    private final JTree jTree1;
    public static final DataFlavor BOOKMARK_FLAVOR = new DataFlavor(Bookmark.class, "Bookmark");
    public static final DataFlavor BOOKMARK_LIST_FLAVOR = new DataFlavor(List.class, "BookmarkList");

    BookmarksManagerTransferrable(BookmarksManagerModel model, JTree jTree1) {
        this.model = model;
        this.jTree1 = jTree1;
    }

    DropTargetListener createDropTargetListener() {
        return new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                if (dtde.isDataFlavorSupported(BOOKMARK_FLAVOR)) {
                    dtde.acceptDrag(3);
                } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dtde.acceptDrag(1);
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    boolean readonly = false;
                    Transferable transferable = dtde.getTransferable();
                    if (transferable instanceof BookmarkTransferable) {
                        readonly = ((BookmarkTransferable)transferable).readonly;
                    }
                    Bookmark item = null;
                    List<Bookmark> items = null;
                    if (dtde.isDataFlavorSupported(BOOKMARK_FLAVOR)) {
                        item = (Bookmark)dtde.getTransferable().getTransferData(BOOKMARK_FLAVOR);
                    } else if (dtde.isDataFlavorSupported(BOOKMARK_LIST_FLAVOR)) {
                        items = (List<Bookmark>)dtde.getTransferable().getTransferData(BOOKMARK_LIST_FLAVOR);
                    } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String data = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                        if (data.length() > 19 && data.startsWith("<bookmark-list")) {
                            items = Bookmark.parseBookmarks(data);
                        } else {
                            item = data.length() > 14 && data.startsWith("<bookmark") ? Bookmark.parseBookmark(data) : new Bookmark.Item(data);
                        }
                    }
                    TreePath tp = BookmarksManagerTransferrable.this.jTree1.getPathForLocation((int)dtde.getLocation().getX(), (int)dtde.getLocation().getY());
                    Bookmark context = BookmarksManagerTransferrable.this.model.getSelectedBookmark(BookmarksManagerTransferrable.this.jTree1.getModel(), tp);
                    String remoteUrl = BookmarksManager.maybeGetRemoteBookmarkUrl(context, BookmarksManagerTransferrable.this.model, BookmarksManagerTransferrable.this.jTree1.getModel(), tp);
                    if (remoteUrl.length() > 0) {
                        JOptionPane.showMessageDialog(BookmarksManagerTransferrable.this.jTree1, "Drop target is within remote bookmarks\n" + remoteUrl, "Remote Bookmark Move Item", 0);
                        return;
                    }
                    if (item != null) {
                        if (item == context) {
                            return;
                        }
                        if (!readonly) {
                            BookmarksManagerTransferrable.this.model.removeBookmark(item);
                        }
                        BookmarksManagerTransferrable.this.model.insertBookmark(item, context);
                    } else if (items != null) {
                        if (!readonly) {
                            BookmarksManagerTransferrable.this.model.removeBookmarks(items);
                        }
                        BookmarksManagerTransferrable.this.model.addBookmarks(items, context, true);
                    }
                }
                catch (UnsupportedFlavorException | IOException | BookmarksException | SAXException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        };
    }

    DragGestureListener createDragGestureListener() {
        return new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                if (BookmarksManagerTransferrable.this.jTree1.getSelectionCount() == 1) {
                    TreePath tp = BookmarksManagerTransferrable.this.jTree1.getSelectionPath();
                    Bookmark b = BookmarksManagerTransferrable.this.model.getSelectedBookmark(BookmarksManagerTransferrable.this.jTree1.getModel(), tp);
                    String remoteUrl = BookmarksManager.maybeGetRemoteBookmarkUrl(b, BookmarksManagerTransferrable.this.model, BookmarksManagerTransferrable.this.jTree1.getModel(), tp);
                    if (remoteUrl.length() > 0) {
                        System.err.println("Copy from remote bookmarks");
                    }
                    if (b instanceof Bookmark.Item) {
                        dge.startDrag(null, new BookmarkTransferable((Bookmark.Item)b, remoteUrl.length() == 0));
                    } else if (b instanceof Bookmark.Folder) {
                        dge.startDrag(null, new BookmarkTransferable((Bookmark.Folder)b, remoteUrl.length() == 0));
                    }
                } else {
                    ArrayList<Bookmark> books = new ArrayList<Bookmark>();
                    TreePath[] tps = BookmarksManagerTransferrable.this.jTree1.getSelectionPaths();
                    if (tps == null) {
                        return;
                    }
                    for (TreePath tp : tps) {
                        Bookmark b = BookmarksManagerTransferrable.this.model.getSelectedBookmark(BookmarksManagerTransferrable.this.jTree1.getModel(), tp);
                        books.add(b);
                    }
                    dge.startDrag(null, BookmarksManagerTransferrable.this.createBookmarkListTransferrable(books));
                }
            }
        };
    }

    Transferable createBookmarkListTransferrable(final List<Bookmark> bookmarks) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor, BOOKMARK_LIST_FLAVOR};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor == BOOKMARK_LIST_FLAVOR || flavor == DataFlavor.stringFlavor;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (flavor == BOOKMARK_LIST_FLAVOR) {
                    return bookmarks;
                }
                if (flavor == DataFlavor.stringFlavor) {
                    return Bookmark.formatBooks(bookmarks);
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }

    public static class BookmarkTransferable
    implements Transferable {
        Bookmark bookmark;
        boolean readonly;

        public BookmarkTransferable(Bookmark bookmark, boolean readOnly) {
            this.bookmark = bookmark;
            this.readonly = readOnly;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor, BOOKMARK_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == DataFlavor.stringFlavor || flavor == BOOKMARK_FLAVOR;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.bookmark instanceof Bookmark.Item) {
                if (flavor == DataFlavor.stringFlavor) {
                    return ((Bookmark.Item)this.bookmark).getUri();
                }
                if (flavor == BOOKMARK_FLAVOR) {
                    return this.bookmark;
                }
                throw new UnsupportedFlavorException(flavor);
            }
            if (flavor == BOOKMARK_FLAVOR) {
                return this.bookmark;
            }
            if (flavor == DataFlavor.stringFlavor) {
                return Bookmark.formatBookmark(this.bookmark);
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

