/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.bookmarks;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import org.autoplot.AutoplotUtil;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.bookmarks.BookmarksManager;
import org.autoplot.bookmarks.MalformedRemoteBookmarksException;
import org.autoplot.bookmarks.RemoteStatus;
import org.das2.util.LoggerManager;
import org.xml.sax.SAXException;

public class BookmarksManagerModel {
    private static final Logger logger = LoggerManager.getLogger("autoplot.bookmarks");
    private static final String EMPTY_FOLDER = "(empty)";
    protected List<Bookmark> list = null;
    public static final String PROP_LIST = "list";
    public static final String PROP_BOOKMARK = "bookmark";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String name;

    protected void doImport(Component c) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "bookmarks files (*.xml)";
            }
        });
        int r = chooser.showOpenDialog(c);
        if (r == 0) {
            try {
                List<Bookmark> importBook = Bookmark.parseBookmarks(AutoplotUtil.readDoc(new FileInputStream(chooser.getSelectedFile())).getDocumentElement());
                ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.list.size());
                for (int i = 0; i < this.list.size(); ++i) {
                    newList.add(i, this.list.get(i).copy());
                }
                this.mergeList(importBook, newList);
                this.setList(newList);
            }
            catch (SAXException ex) {
                JOptionPane.showMessageDialog(c, ex.getMessage(), "Error when reading bookmarks", 0);
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (ParserConfigurationException | BookmarksException ex) {
                JOptionPane.showMessageDialog(c, ex.getMessage(), "Error when reading bookmarks", 0);
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    protected void doExport(Component c) {
        this.doExport(c, this.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExport(Component c, List<Bookmark> list) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "bookmarks files (*.xml)";
            }
        });
        int r = chooser.showSaveDialog(c);
        if (r == 0) {
            FileOutputStream out = null;
            try {
                File f = chooser.getSelectedFile();
                if (!f.toString().endsWith(".xml")) {
                    f = new File(f.toString() + ".xml");
                }
                out = new FileOutputStream(f);
                Bookmark.formatBooks(out, list);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
        }
    }

    public List<Bookmark> getList() {
        return this.list;
    }

    public void setList(List<Bookmark> list) {
        logger.log(Level.FINE, "setting list to {0}", list);
        this.list = list;
        this.propertyChangeSupport.firePropertyChange(PROP_LIST, null, list);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public TreeModel getTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.name);
        DefaultTreeModel model = new DefaultTreeModel(root);
        if (this.list != null) {
            this.addChildNodes(root, this.list);
        }
        return model;
    }

    Bookmark.Folder getFolder(List<Bookmark> newList, Bookmark context) {
        for (Bookmark item : newList) {
            Bookmark.Folder sub;
            if (item.equals(context)) {
                return (Bookmark.Folder)item;
            }
            if (!(item instanceof Bookmark.Folder) || (sub = this.getFolder(((Bookmark.Folder)item).getBookmarks(), context)) == null) continue;
            return sub;
        }
        return null;
    }

    void checkUniqueFolderNames(List<Bookmark> bookmarks) {
        ArrayList<String> folders = new ArrayList<String>();
        for (Bookmark b : bookmarks) {
            if (!(b instanceof Bookmark.Folder)) continue;
            if (folders.contains(b.getTitle())) {
                throw new IllegalArgumentException("two bookmark folders cannot have the same title");
            }
            folders.add(b.getTitle());
        }
    }

    void addBookmarks(List<Bookmark> bookmarks, Bookmark context, boolean insert) {
        ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.list.size());
        for (Bookmark bookmark : this.list) {
            newList.add(bookmark.copy());
        }
        boolean containsFolder = false;
        for (Bookmark b : bookmarks) {
            containsFolder = containsFolder || b instanceof Bookmark.Folder;
        }
        if (context == null) {
            if (newList.contains(null)) {
                newList.addAll(newList.indexOf(null) + (insert ? 0 : 1), bookmarks);
            } else {
                newList.addAll(bookmarks);
            }
        } else if (context instanceof Bookmark.Folder) {
            Bookmark.Folder folder = this.getFolder(newList, context);
            folder.getBookmarks().addAll(bookmarks);
        } else if (newList.contains(context)) {
            newList.addAll(newList.indexOf(context) + (insert ? 0 : 1), bookmarks);
        } else {
            boolean bl;
            boolean bl2 = false;
            for (Bookmark b : newList) {
                if (!(b instanceof Bookmark.Folder)) continue;
                List<Bookmark> bs = ((Bookmark.Folder)b).getBookmarks();
                if (bl || !bs.contains(context)) continue;
                bs.addAll(bs.indexOf(context) + (insert ? 0 : 1), bookmarks);
                bl = true;
            }
            if (!bl) {
                newList.addAll(bookmarks);
            }
        }
        this.checkUniqueFolderNames(newList);
        this.setList(newList);
    }

    void addBookmark(Bookmark bookmark, Bookmark context) {
        this.addBookmarks(Collections.singletonList(bookmark), context, false);
    }

    void insertBookmark(Bookmark bookmark, Bookmark context) {
        this.addBookmarks(Collections.singletonList(bookmark), context, true);
    }

    private Bookmark findItem(List<Bookmark> oldList, String title, boolean findFolder) {
        for (Bookmark item : oldList) {
            boolean isFolder = item instanceof Bookmark.Folder;
            if (findFolder != isFolder || !item.getTitle().equals(title)) continue;
            return item;
        }
        return null;
    }

    public void mergeList(List<Bookmark> src, List<Bookmark> dest) {
        if (src.isEmpty()) {
            return;
        }
        for (Bookmark item : src) {
            Bookmark old;
            if (item instanceof Bookmark.Folder) {
                String folderName = item.getTitle();
                old = (Bookmark.Folder)this.findItem(dest, folderName, true);
                Bookmark.Folder itemBook = (Bookmark.Folder)item;
                if (old != null) {
                    boolean replace;
                    int indx = dest.indexOf(old);
                    boolean bl = replace = ((Bookmark.Folder)old).remoteUrl != null;
                    if (itemBook.remoteUrl == null) {
                        this.mergeList(((Bookmark.Folder)item).getBookmarks(), ((Bookmark.Folder)old).getBookmarks());
                        continue;
                    }
                    Bookmark.Folder parent = old.getParent();
                    if (parent == null) {
                        dest.add(indx + 1, itemBook);
                        if (!replace) continue;
                        dest.remove(indx);
                        continue;
                    }
                    List<Bookmark> llist = parent.getBookmarks();
                    indx = llist.indexOf(old);
                    llist.add(indx + 1, itemBook);
                    if (!replace) continue;
                    llist.remove(indx);
                    continue;
                }
                dest.add(item);
                continue;
            }
            String id = item.getTitle();
            old = (Bookmark.Item)this.findItem(dest, id, false);
            if (old != null) {
                if (!((Bookmark.Item)old).equals(item)) continue;
                continue;
            }
            dest.add(item);
        }
    }

    void fireBookmarkChange(Bookmark book) {
        this.propertyChangeSupport.firePropertyChange(PROP_BOOKMARK, null, book);
    }

    TreePath getPathFor(Bookmark b, TreeModel model, TreePath root) {
        if (root == null) {
            return null;
        }
        Object parent = root.getLastPathComponent();
        int childCount = model.getChildCount(parent);
        for (int ii = 0; ii < childCount; ++ii) {
            TreePath childResult;
            Object child = model.getChild(parent, ii);
            if (b.equals(((DefaultMutableTreeNode)child).getUserObject())) {
                return root.pathByAddingChild(child);
            }
            if (model.getChildCount(child) <= 0 || (childResult = this.getPathFor(b, model, root.pathByAddingChild(child))) == null) continue;
            return childResult;
        }
        return null;
    }

    Bookmark.Folder removeBookmarks(Bookmark.Folder folder, Bookmark book) {
        ArrayList<Bookmark> newList = new ArrayList<Bookmark>(folder.getBookmarks().size());
        for (Bookmark b : folder.getBookmarks()) {
            newList.add(b.copy());
        }
        for (int i = 0; i < newList.size(); ++i) {
            Bookmark bookmark = (Bookmark)newList.get(i);
            if (bookmark instanceof Bookmark.Folder) {
                if (bookmark.equals(book)) {
                    newList.set(i, null);
                    continue;
                }
                bookmark = this.removeBookmarks((Bookmark.Folder)bookmark, book);
                newList.set(i, bookmark);
                continue;
            }
            if (!bookmark.equals(book)) continue;
            newList.set(i, null);
        }
        newList.removeAll(Collections.singleton(null));
        Bookmark.Folder result = new Bookmark.Folder(folder.getTitle());
        result.bookmarks = newList;
        return result;
    }

    void removeBookmarks(List<Bookmark> bookmarks) {
        ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.list.size());
        for (Bookmark b : this.list) {
            newList.add(b.copy());
        }
        for (Bookmark bookmark : bookmarks) {
            if (newList.contains(bookmark)) {
                newList.remove(bookmark);
                continue;
            }
            int i = 0;
            for (Bookmark b2 : newList) {
                if (b2 instanceof Bookmark.Folder) {
                    String remote = BookmarksManager.maybeGetRemoteBookmarkUrl(b2);
                    if (remote.length() == 0) {
                        b2 = this.removeBookmarks((Bookmark.Folder)b2, bookmark);
                        newList.set(i, b2);
                    }
                } else {
                    newList.set(i, null);
                }
                ++i;
            }
        }
        newList.removeAll(Collections.singleton(null));
        this.setList(newList);
    }

    void removeBookmark(Bookmark bookmark) {
        this.removeBookmarks(Collections.singletonList(bookmark));
    }

    private void addChildNodes(MutableTreeNode parent, List<Bookmark> bookmarks) {
        for (Bookmark b : bookmarks) {
            String node = b.toString();
            if (b instanceof Bookmark.Folder && ((Bookmark.Folder)b).remoteUrl != null && ((Bookmark.Folder)b).remoteUrl.length() > 0) {
                node = node + String.format(" [remoteUrl=%s]", ((Bookmark.Folder)b).remoteUrl);
            }
            final String fnode = node;
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(b){

                @Override
                public String toString() {
                    return fnode;
                }
            };
            parent.insert(child, parent.getChildCount());
            if (!(b instanceof Bookmark.Folder)) continue;
            List<Bookmark> kids = ((Bookmark.Folder)b).getBookmarks();
            if (kids.isEmpty()) {
                child.insert(new DefaultMutableTreeNode(EMPTY_FOLDER), 0);
                continue;
            }
            this.addChildNodes(child, kids);
        }
    }

    protected Bookmark getSelectedBookmark(TreeModel model, TreePath path) {
        if (path == null || path.getPathCount() == 1) {
            return null;
        }
        Object sel = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (sel.equals(EMPTY_FOLDER)) {
            return this.getSelectedBookmark(model, path.getParentPath());
        }
        return (Bookmark)sel;
    }

    protected List<Bookmark> getSelectedBookmarks(TreeModel model, TreePath[] paths) {
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        if (paths == null) {
            return result;
        }
        for (TreePath path : paths) {
            if (path == null) {
                return null;
            }
            if (path.getPathCount() == 1) {
                return this.list;
            }
            Object sel = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            Bookmark b = sel.equals(EMPTY_FOLDER) ? this.getSelectedBookmark(model, path.getParentPath()) : (Bookmark)sel;
            if (b == null) continue;
            result.add(b);
        }
        return result;
    }

    public void importList(List<Bookmark> books) {
        ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            newList.add(i, this.list.get(i).copy());
        }
        this.mergeList(books, newList);
        this.setList(newList);
    }

    public void addRemoteBookmarks(String surl) throws MalformedRemoteBookmarksException {
        this.addRemoteBookmarks(surl, null);
    }

    public void addRemoteBookmarks(String surl, Bookmark selectedBookmark) throws MalformedRemoteBookmarksException {
        ArrayList<Bookmark> importBook = new ArrayList<Bookmark>(100);
        RemoteStatus remote = Bookmark.getRemoteBookmarks(surl, 5, true, importBook);
        if (importBook.size() != 1) {
            throw new MalformedRemoteBookmarksException("Remote bookmarks file contains more than one root folder: " + surl);
        }
        if (remote.remoteRemote) {
            logger.fine("remote bookmarks found in remote bookmarks...");
        }
        ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            newList.add(i, this.list.get(i).copy());
        }
        ArrayList<Bookmark> copy = new ArrayList<Bookmark>();
        for (Bookmark m : importBook) {
            if (m instanceof Bookmark.Folder) {
                Bookmark.Folder bf = (Bookmark.Folder)m;
                if (bf.getRemoteUrl() == null) {
                    bf.setRemoteUrl(surl);
                }
                copy.add(m);
                continue;
            }
            if (!m.getTitle().equals("Error Occurred")) continue;
            copy.add(m);
        }
        this.mergeList(copy, newList);
        this.setList(newList);
    }

    protected void setName(String name) {
        this.name = name;
    }
}

