/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.bookmarks;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.ImportBookmarksGui;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.bookmarks.BookmarksManagerModel;
import org.autoplot.bookmarks.BookmarksManagerTransferrable;
import org.autoplot.bookmarks.DelayMenu;
import org.autoplot.bookmarks.MalformedRemoteBookmarksException;
import org.autoplot.bookmarks.RemoteStatus;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.scriptconsole.GuiExceptionHandler;
import org.das2.components.DasProgressPanel;
import org.das2.system.RequestProcessor;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BookmarksManager
extends JDialog {
    private static final Logger logger = LoggerManager.getLogger("autoplot.bookmarks");
    private boolean plotBelowAndOverplotVisible;
    BookmarksManagerModel model;
    Bookmark dirtyBookmark;
    JPopupMenu contextMenu = this.createContextMenu();
    private boolean menuIsDirty = false;
    private JMenu dirtyMenu = null;
    private DataSetSelector dirtySelector = null;
    private String name;
    DataSetSelector sel;
    private boolean isPlay = false;
    private boolean isEdit = false;
    private JLabel URILabel;
    private JTextField URLTextField;
    private JMenuItem addItemMenuItem;
    private JMenuItem closeMenuItem;
    private JMenuItem deleteMenuItem;
    private JTextField descriptionTextField;
    private JButton dismissButton;
    private JButton editButton;
    private JButton editDescriptionButton;
    private JMenu editMenu;
    private JMenuItem exportMenuItem;
    private JMenuItem importMenuItem;
    private JMenuItem importUrlMenuItem;
    private JLabel jLabel4;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JTree jTree1;
    private JMenuItem mergeInDefaultMenuItem;
    private JMenuItem newFolderMenuItem;
    private JButton overplotButton;
    private JButton plotBelowButton;
    private JButton plotButton;
    private JMenuItem reloadMenuItem;
    private JMenuItem resetToDefaultMenuItem;
    private JLabel titleLabel;
    private JTextField titleTextField;
    private JButton viewDetailsButton;
    String prefNode = null;
    File bookmarksFile = null;
    boolean haveReadRemote = false;
    private String defaultUrl = null;

    private int indexOfChild(TreeModel tree, Object root, Object find) {
        for (int i = 0; i < tree.getChildCount(root); ++i) {
            Object tt = tree.getChild(root, i);
            if (!tt.toString().equals(find.toString())) continue;
            return i;
        }
        return -1;
    }

    private TreePath moveTreePath(TreeModel mod, TreePath foriegn) {
        Object parent = mod.getRoot();
        Object[] path = new Object[foriegn.getPathCount()];
        path[0] = parent;
        for (int i = 1; i < foriegn.getPathCount(); ++i) {
            int j = this.indexOfChild(mod, parent, foriegn.getPathComponent(i));
            if (j <= -1) {
                Object[] parentPath = new Object[i];
                System.arraycopy(path, 0, parentPath, 0, i);
                return new TreePath(parentPath);
            }
            path[i] = parent = mod.getChild(parent, j);
        }
        return new TreePath(path);
    }

    public BookmarksManager(Frame parent, boolean modal) {
        this(parent, modal, null);
    }

    public BookmarksManager(Frame parent, boolean modal, String name) {
        super(parent, modal);
        if (name == null) {
            name = "Bookmarks";
        }
        this.name = name;
        this.setTitle(name + " Manager");
        this.initComponents();
        boolean bl = this.plotBelowAndOverplotVisible = !name.equals("Tools");
        if (name.equals("Tools")) {
            this.overplotButton.setVisible(false);
            this.plotBelowButton.setVisible(false);
            this.plotButton.setText("Execute");
            this.plotButton.setToolTipText("Execute");
        }
        this.setLocationRelativeTo(parent);
        this.model = new BookmarksManagerModel();
        this.model.setName(name);
        this.jTree1.setModel(this.model.getTreeModel());
        this.jTree1.addMouseListener(this.createContextMenuMouseListener());
        this.model.addPropertyChangeListener("list", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        TreeModel mod = BookmarksManager.this.model.getTreeModel();
                        TreePath tp = BookmarksManager.this.jTree1.getSelectionPath();
                        BookmarksManager.this.jTree1.setModel(mod);
                        if (tp != null) {
                            tp = BookmarksManager.this.moveTreePath(mod, tp);
                            BookmarksManager.this.jTree1.setSelectionPath(tp);
                            if (BookmarksManager.this.jTree1.getModel().isLeaf(tp.getLastPathComponent())) {
                                tp = tp.getParentPath();
                            }
                            BookmarksManager.this.jTree1.expandPath(tp);
                            BookmarksManager.this.jTree1.scrollPathToVisible(tp);
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    SwingUtilities.invokeLater(run);
                }
            }
        });
        BookmarksManagerTransferrable trans = new BookmarksManagerTransferrable(this.model, this.jTree1);
        DragSource dragSource = DragSource.getDefaultDragSource();
        DropTarget dropTarget = new DropTarget();
        try {
            dropTarget.addDropTargetListener(trans.createDropTargetListener());
        }
        catch (TooManyListenersException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.jTree1.setDropTarget(dropTarget);
        dragSource.createDefaultDragGestureRecognizer(this.jTree1, 3, trans.createDragGestureListener());
    }

    public BookmarksManagerModel getModel() {
        return this.model;
    }

    protected static String maybeGetRemoteBookmarkUrl(Bookmark b, BookmarksManagerModel model, TreeModel treeModel, TreePath ppath) {
        String remoteUrl = "";
        if (b != null && b instanceof Bookmark.Item) {
            ppath = ppath.getParentPath();
        }
        if (ppath == null) {
            return remoteUrl;
        }
        while (ppath.getPathCount() > 1) {
            Bookmark book = model.getSelectedBookmark(treeModel, ppath);
            Bookmark.Folder f = book instanceof Bookmark.Item ? book.getParent() : (Bookmark.Folder)book;
            if (f == null) {
                return "";
            }
            if (f.remoteUrl != null && !f.remoteUrl.equals("")) {
                remoteUrl = f.remoteUrl;
                break;
            }
            ppath = ppath.getParentPath();
        }
        return remoteUrl;
    }

    protected static String maybeGetRemoteBookmarkUrl(Bookmark book) {
        Bookmark.Folder p;
        String remoteUrl = "";
        Bookmark.Folder folder = p = book instanceof Bookmark.Folder ? (Bookmark.Folder)book : book.getParent();
        while (p != null) {
            if (p.remoteUrl != null && !p.remoteUrl.equals("")) {
                remoteUrl = p.remoteUrl;
                break;
            }
            p = p.getParent();
        }
        return remoteUrl;
    }

    private List<Bookmark> removeRemoteBookmarks(List<Bookmark> bs, TreeModel tmodel, TreePath[] selectionPaths) {
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        if (selectionPaths == null) {
            return result;
        }
        for (int i = 0; i < bs.size(); ++i) {
            TreePath parentPath;
            Bookmark bs1 = bs.get(i);
            Bookmark.Folder parent = bs1.getParent();
            boolean isNotPartOfRemoteBookmark = "".equals(BookmarksManager.maybeGetRemoteBookmarkUrl(parent, this.model, tmodel, parentPath = selectionPaths[i].getParentPath()));
            if (!isNotPartOfRemoteBookmark) continue;
            result.add(bs.get(i));
        }
        return result;
    }

    private void maybeDeleteBookmarks(List<Bookmark> bs) throws HeadlessException {
        boolean confirm = false;
        if (bs.size() > 1 && JOptionPane.showConfirmDialog(this, "Delete " + bs.size() + " bookmarks?", "Delete Bookmarks", 2) == 0) {
            confirm = true;
        }
        if (confirm) {
            this.model.removeBookmarks(bs);
        } else {
            for (Bookmark b : bs) {
                if (b instanceof Bookmark.Folder) {
                    if (!confirm && JOptionPane.showConfirmDialog(this, "Delete all bookmarks and folder?", "Delete Bookmarks Folder", 2) != 0) continue;
                    this.model.removeBookmark(b);
                    continue;
                }
                this.model.removeBookmark(b);
            }
        }
    }

    private void showMessage(String message, String title, int messageType) {
        if (!"true".equals(AutoplotUtil.getProperty("java.awt.headless", "false"))) {
            Component p = SwingUtilities.getRoot(this);
            if (p == null) {
                if (messageType == 2) {
                    logger.log(Level.WARNING, "{0}: {1}", new Object[]{title, message});
                } else if (messageType == 1) {
                    logger.log(Level.INFO, "{0}: {1}", new Object[]{title, message});
                } else {
                    logger.log(Level.FINE, "{0}: {1}", new Object[]{title, message});
                }
            } else {
                JOptionPane.showMessageDialog(p, message, title, messageType);
            }
        } else if (messageType == 2) {
            logger.log(Level.WARNING, "{0}: {1}", new Object[]{title, message});
        } else if (messageType == 1) {
            logger.log(Level.INFO, "{0}: {1}", new Object[]{title, message});
        } else {
            logger.log(Level.FINE, "{0}: {1}", new Object[]{title, message});
        }
    }

    public void setAddBookmark(Bookmark b) {
        TreePath tp = this.model.getPathFor(b, this.jTree1.getModel(), new TreePath(this.jTree1.getModel().getRoot()));
        this.jTree1.setSelectionPath(tp);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BookmarksManager.this.titleTextField.requestFocusInWindow();
                BookmarksManager.this.titleTextField.selectAll();
            }
        });
    }

    public boolean isPlay() {
        return this.isPlay;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.dismissButton = new JButton();
        this.URILabel = new JLabel();
        this.URLTextField = new JTextField();
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.descriptionTextField = new JTextField();
        this.editDescriptionButton = new JButton();
        this.plotButton = new JButton();
        this.plotBelowButton = new JButton();
        this.overplotButton = new JButton();
        this.viewDetailsButton = new JButton();
        this.editButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.importMenuItem = new JMenuItem();
        this.importUrlMenuItem = new JMenuItem();
        this.reloadMenuItem = new JMenuItem();
        this.resetToDefaultMenuItem = new JMenuItem();
        this.mergeInDefaultMenuItem = new JMenuItem();
        this.exportMenuItem = new JMenuItem();
        this.closeMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.newFolderMenuItem = new JMenuItem();
        this.addItemMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                BookmarksManager.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.dismissButton.setText("OK");
        this.dismissButton.setToolTipText("Dismiss the dialog.");
        this.dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.dismissButtonActionPerformed(evt);
            }
        });
        this.URILabel.setText("URI:");
        this.URILabel.setToolTipText("Location of the data (often the URL), or remote folder location");
        this.URLTextField.setToolTipText("");
        this.URLTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BookmarksManager.this.URLTextFieldFocusLost(evt);
            }
        });
        this.URLTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                BookmarksManager.this.URLTextFieldKeyTyped(evt);
            }
        });
        this.titleLabel.setText("Title:");
        this.titleLabel.setToolTipText("Title for the URI");
        this.titleTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.titleTextFieldActionPerformed(evt);
            }
        });
        this.titleTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BookmarksManager.this.titleTextFieldFocusLost(evt);
            }
        });
        this.titleTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BookmarksManager.this.titleTextFieldPropertyChange(evt);
            }
        });
        this.titleTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                BookmarksManager.this.titleTextFieldKeyTyped(evt);
            }
        });
        this.jLabel4.setText("Description:");
        this.jLabel4.setToolTipText("Up to a short paragraph describing the data");
        this.descriptionTextField.setToolTipText("Up to a short paragraph describing the data");
        this.descriptionTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BookmarksManager.this.descriptionTextFieldFocusLost(evt);
            }
        });
        this.descriptionTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                BookmarksManager.this.descriptionTextFieldKeyTyped(evt);
            }
        });
        this.editDescriptionButton.setText("Edit");
        this.editDescriptionButton.setToolTipText("Edit/View description");
        this.editDescriptionButton.setEnabled(false);
        this.editDescriptionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.editDescriptionButtonActionPerformed(evt);
            }
        });
        this.plotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/go.png")));
        this.plotButton.setText("Plot");
        this.plotButton.setToolTipText("Plot the URI in the current focus position");
        this.plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.plotButtonActionPerformed(evt);
            }
        });
        this.plotBelowButton.setText("Plot Below");
        this.plotBelowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.plotBelowButtonActionPerformed(evt);
            }
        });
        this.overplotButton.setText("Overplot");
        this.overplotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.overplotButtonActionPerformed(evt);
            }
        });
        this.viewDetailsButton.setText("Detailed Description");
        this.viewDetailsButton.setToolTipText("View description URL in browser");
        this.viewDetailsButton.setEnabled(false);
        this.viewDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.viewDetailsButtonActionPerformed(evt);
            }
        });
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/fileMag.png")));
        this.editButton.setText("Edit");
        this.editButton.setToolTipText("Inspect this resource before plotting.  If an editor is available, this will enter the editor before plotting.");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.editButtonActionPerformed(evt);
            }
        });
        this.jMenu1.setText("File");
        this.importMenuItem.setText("Import...");
        this.importMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.importMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.importMenuItem);
        this.importUrlMenuItem.setText("Import From Web...");
        this.importUrlMenuItem.setToolTipText("");
        this.importUrlMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.importUrlMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.importUrlMenuItem);
        this.reloadMenuItem.setText("Reload Bookmarks");
        this.reloadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.reloadMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.reloadMenuItem);
        this.resetToDefaultMenuItem.setText("Reset to Default");
        this.resetToDefaultMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.resetToDefaultMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.resetToDefaultMenuItem);
        this.mergeInDefaultMenuItem.setText("Merge in Default");
        this.mergeInDefaultMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.mergeInDefaultMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mergeInDefaultMenuItem);
        this.exportMenuItem.setText("Export...");
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.exportMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exportMenuItem);
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.closeMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.editMenu.setText("Edit");
        this.newFolderMenuItem.setAction(this.newFolderAction());
        this.newFolderMenuItem.setText("New Folder...");
        this.editMenu.add(this.newFolderMenuItem);
        this.addItemMenuItem.setAction(this.addItemAction());
        this.addItemMenuItem.setText("New Bookmark...");
        this.editMenu.add(this.addItemMenuItem);
        this.deleteMenuItem.setText("Delete Bookmark");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksManager.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteMenuItem);
        this.jMenuBar1.add(this.editMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 689, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.overplotButton, -2, 97, -2).addPreferredGap(0).add((Component)this.plotBelowButton, -2, 119, -2).addPreferredGap(0).add((Component)this.plotButton, -2, 117, -2).addPreferredGap(0).add((Component)this.editButton, -2, 94, -2).addPreferredGap(0).add((Component)this.dismissButton, -2, 71, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.URILabel).addPreferredGap(0).add((Component)this.URLTextField, -1, 652, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.descriptionTextField, -1, 516, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.editDescriptionButton, -2, 71, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.titleLabel).addPreferredGap(0).add((Component)this.titleTextField, -1, 475, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.viewDetailsButton, -2, 164, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.overplotButton, this.plotBelowButton, this.plotButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 346, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.titleLabel).add((Component)this.titleTextField, -2, -1, -2).add((Component)this.viewDetailsButton)).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.descriptionTextField, -2, -1, -2).add((Component)this.editDescriptionButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.URILabel).add((Component)this.URLTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.dismissButton).add((Component)this.plotButton).add((Component)this.plotBelowButton).add((Component)this.overplotButton).add((Component)this.editButton)).addContainerGap()));
        layout.linkSize(new Component[]{this.URLTextField, this.titleTextField}, 2);
        this.pack();
    }

    private void dismissButtonActionPerformed(ActionEvent evt) {
        this.isPlay = false;
        this.isEdit = false;
        if (this.dirtyBookmark != null) {
            this.dirtyBookmark.setTitle(this.titleTextField.getText());
            if (this.dirtyBookmark instanceof Bookmark.Item) {
                ((Bookmark.Item)this.dirtyBookmark).setUri(this.URLTextField.getText());
            }
            this.dirtyBookmark.setDescription(this.descriptionTextField.getText());
            this.model.fireBookmarkChange(this.dirtyBookmark);
            this.dirtyBookmark = null;
        }
        this.dispose();
        if (this.menuIsDirty) {
            this.updateBookmarks(this.dirtyMenu, this.dirtySelector);
        }
    }

    private void URLTextFieldFocusLost(FocusEvent evt) {
    }

    private void titleTextFieldFocusLost(FocusEvent evt) {
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        Bookmark b;
        if (this.dirtyBookmark != null) {
            this.dirtyBookmark.setTitle(this.titleTextField.getText());
            if (this.dirtyBookmark instanceof Bookmark.Item) {
                ((Bookmark.Item)this.dirtyBookmark).setUri(this.URLTextField.getText());
            }
            this.dirtyBookmark.setDescription(this.descriptionTextField.getText());
            this.model.fireBookmarkChange(this.dirtyBookmark);
            this.dirtyBookmark = null;
        }
        if ((b = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath())) != null) {
            this.titleTextField.setText(b.getTitle());
            this.descriptionTextField.setText(b.getDescription());
            URL descriptionUrl = this.getDescriptionUrl(b);
            this.viewDetailsButton.setEnabled(descriptionUrl != null);
            if (descriptionUrl == null) {
                this.viewDetailsButton.setToolTipText("(no details URL)");
            } else {
                this.viewDetailsButton.setToolTipText("View " + descriptionUrl);
            }
            this.URLTextField.setEditable(b instanceof Bookmark.Item);
            String err = "";
            if (b instanceof Bookmark.Item) {
                this.URLTextField.setText(((Bookmark.Item)b).getUri());
                this.URILabel.setText("URI:");
            } else if (b instanceof Bookmark.Folder && ((Bookmark.Folder)b).getRemoteUrl() != null) {
                String url = ((Bookmark.Folder)b).getRemoteUrl();
                int status = ((Bookmark.Folder)b).getRemoteStatus();
                if (status == 1) {
                    err = "<br>** Unable to connect to remote URL **";
                }
                this.URLTextField.setText(url);
                this.URILabel.setText("URL:");
            } else {
                this.URLTextField.setText("");
                this.URILabel.setText("URI:");
            }
            String remoteUrl = "";
            TreePath ppath = this.jTree1.getSelectionPath();
            if (ppath != null) {
                remoteUrl = BookmarksManager.maybeGetRemoteBookmarkUrl(b, this.model, this.jTree1.getModel(), ppath);
                this.URLTextField.setEditable(remoteUrl.length() == 0);
                if (remoteUrl.length() == 0) {
                    this.URLTextField.setToolTipText("Location of the remote folder" + err);
                } else {
                    this.URLTextField.setToolTipText("Location of the data (often the URL)");
                }
            } else {
                this.URLTextField.setEditable(false);
            }
            if (remoteUrl.length() == 0) {
                this.titleLabel.setText("Title:");
                this.titleLabel.setToolTipText("Title for the URI");
            } else {
                this.titleLabel.setText("[Title]:");
                this.titleLabel.setToolTipText("<html>Title for the URI.<br>This bookmark is part of a set of remote bookmarks from<br>" + remoteUrl + "<br> and cannot be edited." + err);
            }
            this.descriptionTextField.setEditable(remoteUrl.length() == 0);
            this.editDescriptionButton.setEnabled(true);
            this.editDescriptionButton.setText(remoteUrl.length() == 0 ? "Edit" : "View");
            this.titleTextField.setEditable(remoteUrl.length() == 0);
        } else {
            this.titleTextField.setText("");
            this.descriptionTextField.setText("");
            this.URLTextField.setText("");
            this.titleLabel.setText("Title:");
            this.editDescriptionButton.setEnabled(false);
            this.viewDetailsButton.setEnabled(false);
            this.viewDetailsButton.setToolTipText("(no details URL)");
            this.titleTextField.setEditable(false);
        }
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        this.model.doImport(this);
    }

    private void importUrlMenuItemActionPerformed(ActionEvent evt) {
        String ansr = null;
        String url = null;
        boolean okay = false;
        while (!okay) {
            String s = ansr == null ? JOptionPane.showInputDialog(this, "Enter the URL of a bookmarks file:", "") : JOptionPane.showInputDialog(this, "Whoops. Enter the URL of a bookmarks file:", ansr);
            if (s == null) {
                return;
            }
            ansr = s;
            url = s;
            okay = true;
        }
        this.doImportUrl(url);
    }

    void makeLocal(List<Bookmark> books) throws MalformedRemoteBookmarksException {
        for (Bookmark b : books) {
            if (!(b instanceof Bookmark.Folder)) continue;
            Bookmark.Folder bf = (Bookmark.Folder)b;
            if (bf.remoteUrl != null && bf.remoteStatus != 0) {
                ArrayList<Bookmark> importBook = new ArrayList<Bookmark>();
                RemoteStatus remote = Bookmark.getRemoteBookmarks(bf.remoteUrl, 5, true, importBook);
                if (remote.status == 0) {
                    bf.bookmarks = importBook;
                    bf.remoteUrl = null;
                    bf.remoteStatus = 0;
                } else {
                    throw new IllegalArgumentException("couldn't resolve " + bf.remoteUrl);
                }
            }
            this.makeLocal(bf.getBookmarks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doImportUrl(String url) {
        String lbookmarksFile = url;
        ImportBookmarksGui gui = new ImportBookmarksGui();
        gui.getBookmarksFilename().setText(lbookmarksFile + " ?");
        gui.getRemote().setSelected(true);
        int r = JOptionPane.showConfirmDialog(this, gui, "Import bookmarks file", 2);
        if (r == 0) {
            InputStream in = null;
            try {
                DasProgressPanel mon = DasProgressPanel.createFramed("importing bookmarks");
                if (gui.getRemote().isSelected()) {
                    try {
                        this.getModel().addRemoteBookmarks(lbookmarksFile);
                    }
                    catch (MalformedRemoteBookmarksException ex) {
                        JOptionPane.showMessageDialog(this, "Malformed " + lbookmarksFile + "\n" + ex.getMessage(), "Error in remote bookmarks", 2);
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException ex2) {
                            logger.log(Level.SEVERE, ex2.getMessage(), ex2);
                        }
                        return;
                    }
                    this.reload();
                } else {
                    in = DataSetURI.getInputStream(DataSetURI.getURIValid(lbookmarksFile), (ProgressMonitor)mon);
                    ByteArrayOutputStream boas = new ByteArrayOutputStream();
                    WritableByteChannel dest = Channels.newChannel(boas);
                    ReadableByteChannel src = Channels.newChannel(in);
                    DataSourceUtil.transfer(src, dest);
                    String sin = new String(boas.toByteArray());
                    List<Bookmark> books = Bookmark.parseBookmarks(sin);
                    this.makeLocal(books);
                    this.getModel().importList(books);
                }
                JOptionPane.showMessageDialog(this, "imported bookmarks file " + lbookmarksFile);
            }
            catch (BookmarksException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                JOptionPane.showMessageDialog(this, "Error parsing " + lbookmarksFile + "\n" + ex.getMessage(), "Error in import bookmarks", 2);
            }
            catch (SAXException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                JOptionPane.showMessageDialog(this, "XML error parsing " + lbookmarksFile + "\n" + ex.getMessage(), "Error in import bookmarks", 2);
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                JOptionPane.showMessageDialog(this, "Error parsing " + lbookmarksFile + "\n" + ex.getMessage(), "Error in import bookmarks", 2);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "File not found: " + lbookmarksFile, "Error in import bookmarks", 2);
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                JOptionPane.showMessageDialog(this, "Error parsing " + lbookmarksFile + "\n" + ex.getMessage(), "Error in import bookmarks", 2);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                JOptionPane.showMessageDialog(this, "I/O Error with " + lbookmarksFile, "Error in import bookmarks", 2);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }

    private void resetToDefaultMenuItemActionPerformed(ActionEvent evt) {
        String surl = this.defaultUrl;
        int r = JOptionPane.showConfirmDialog(this, "Reset your bookmarks to " + surl + "?", "Reset Bookmarks", 2);
        if (r == 0) {
            try {
                this.resetToDefault(surl);
            }
            catch (SAXException ex) {
                throw new RuntimeException("Default bookmarks are mis-formatted!  Please let the Autoplot developers know!", ex);
            }
            catch (BookmarksException ex) {
                new GuiExceptionHandler().handle(ex);
            }
            catch (FileNotFoundException ex) {
                new GuiExceptionHandler().handle(ex);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.rootPane, "<html>Unable to read in default bookmarks:<br>" + ex.getMessage());
            }
        }
    }

    private void exportMenuItemActionPerformed(ActionEvent evt) {
        this.model.doExport(this);
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        this.dispose();
        if (this.menuIsDirty) {
            this.updateBookmarks(this.dirtyMenu, this.dirtySelector);
        }
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        List<Bookmark> bs = this.model.getSelectedBookmarks(this.jTree1.getModel(), this.jTree1.getSelectionPaths());
        if (bs.size() > 0) {
            if ((bs = this.removeRemoteBookmarks(bs, this.jTree1.getModel(), this.jTree1.getSelectionPaths())).isEmpty()) {
                JOptionPane.showMessageDialog(this.rootPane, "Part of remote bookmarks tree cannot be deleted", "Remote Bookmark Delete", 0);
            } else {
                this.maybeDeleteBookmarks(bs);
            }
        }
    }

    private void titleTextFieldActionPerformed(ActionEvent evt) {
        Bookmark b = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
        if (b == null) {
            JOptionPane.showMessageDialog(this.rootPane, "No bookmark is selected", "No Bookmark Selected", 0);
            return;
        }
        b.setTitle(this.titleTextField.getText());
        this.jTree1.repaint();
        this.model.fireBookmarkChange(b);
    }

    private void titleTextFieldPropertyChange(PropertyChangeEvent evt) {
    }

    private void titleTextFieldKeyTyped(KeyEvent evt) {
        this.dirtyBookmark = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
    }

    private void URLTextFieldKeyTyped(KeyEvent evt) {
        this.dirtyBookmark = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
    }

    private void mergeInDefaultMenuItemActionPerformed(ActionEvent evt) {
        try {
            String surl = this.defaultUrl;
            URL url = new URL(surl);
            Document doc = AutoplotUtil.readDoc(url.openStream());
            List<Bookmark> importBook = Bookmark.parseBookmarks(doc.getDocumentElement());
            ArrayList<Bookmark> newList = new ArrayList<Bookmark>(this.model.list.size());
            for (int i = 0; i < this.model.list.size(); ++i) {
                newList.add(i, this.model.list.get(i).copy());
            }
            this.model.mergeList(importBook, newList);
            this.model.setList(newList);
            this.formatToFile(this.bookmarksFile);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Default bookmarks are mis-formatted!  Please let the Autoplot developers know!", ex);
        }
        catch (BookmarksException ex) {
            new GuiExceptionHandler().handle(ex);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.rootPane, "<html>Unable to read in default bookmarks:<br>" + ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void descriptionTextFieldFocusLost(FocusEvent evt) {
        Bookmark b = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
        if (b != null && (b.getDescription() == null || b.getDescription().equals(this.descriptionTextField.getText()))) {
            this.dirtyBookmark = b;
        }
    }

    private void descriptionTextFieldKeyTyped(KeyEvent evt) {
        this.dirtyBookmark = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
    }

    private void editDescriptionButtonActionPerformed(ActionEvent evt) {
        String ntxt;
        String txt = this.descriptionTextField.getText();
        if (txt.contains("<br>")) {
            txt = txt.replaceAll("<br>", "\n");
        }
        JTextArea edit = new JTextArea(txt);
        edit.setRows(5);
        edit.setColumns(80);
        JScrollPane jScrollPane2 = new JScrollPane(edit);
        edit.setEditable(this.descriptionTextField.isEditable());
        int ok = AutoplotUtil.showConfirmDialog(this, jScrollPane2, this.titleTextField.getText(), 2);
        if (edit.isEditable() && ok == 0 && !(ntxt = edit.getText()).equals(txt)) {
            ntxt = ntxt.replaceAll("\n", "<br>");
            this.descriptionTextField.setText(ntxt);
            Bookmark b = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
            if (b != null) {
                this.dirtyBookmark = b;
            }
        }
    }

    public Bookmark getSelectedBookmark() {
        return this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
    }

    private boolean maybePlot(int modifiers) {
        Bookmark book = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
        if (book instanceof Bookmark.Item) {
            if (this.getParent() instanceof AutoplotUI && this.sel != null) {
                this.sel.setValue(((Bookmark.Item)book).getUri());
                this.sel.maybePlot(modifiers);
            }
            this.dispose();
            if (this.menuIsDirty) {
                this.updateBookmarks(this.dirtyMenu, this.dirtySelector);
            }
            return true;
        }
        return false;
    }

    private void plotButtonActionPerformed(ActionEvent evt) {
        this.maybePlot(evt.getModifiers());
    }

    private void plotBelowButtonActionPerformed(ActionEvent evt) {
        this.maybePlot(2);
    }

    private void overplotButtonActionPerformed(ActionEvent evt) {
        this.maybePlot(1);
    }

    private void viewDetailsButtonActionPerformed(ActionEvent evt) {
        Bookmark book = this.model.getSelectedBookmark(this.jTree1.getModel(), this.jTree1.getSelectionPath());
        URL url = this.getDescriptionUrl(book);
        if (url != null) {
            AutoplotUtil.openBrowser(url.toString());
        }
    }

    private void reloadMenuItemActionPerformed(ActionEvent evt) {
        this.reload();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.maybePlot(8);
    }

    private MouseListener createContextMenuMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BookmarksManager.this.maybePlot(e.getModifiers());
                }
                if (e.isPopupTrigger()) {
                    BookmarksManager.this.contextMenu.show(BookmarksManager.this.jTree1, e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path = BookmarksManager.this.jTree1.getPathForLocation(e.getX(), e.getY());
                if (!BookmarksManager.this.jTree1.getSelectionModel().isPathSelected(path)) {
                    BookmarksManager.this.jTree1.getSelectionModel().setSelectionPath(path);
                }
                if (e.isPopupTrigger()) {
                    BookmarksManager.this.contextMenu.show(BookmarksManager.this.jTree1, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BookmarksManager.this.contextMenu.show(BookmarksManager.this.jTree1, e.getX(), e.getY());
                }
            }
        };
    }

    private JPopupMenu createContextMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.newFolderAction());
        menu.add(this.addItemAction());
        menu.add(this.createExportFolderAction());
        menu.add(this.createDeleteAction());
        return menu;
    }

    private Action addItemAction() throws HeadlessException {
        return new AbstractAction("New Bookmark..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                String s = JOptionPane.showInputDialog(BookmarksManager.this, (Object)"Bookmark URL:");
                if (s != null && !s.equals("")) {
                    String x = BookmarksManager.maybeGetRemoteBookmarkUrl(null, BookmarksManager.this.model, BookmarksManager.this.jTree1.getModel(), BookmarksManager.this.jTree1.getSelectionPath());
                    if (x.length() == 0) {
                        BookmarksManager.this.model.addBookmark(new Bookmark.Item(s), BookmarksManager.this.model.getSelectedBookmark(BookmarksManager.this.jTree1.getModel(), BookmarksManager.this.jTree1.getSelectionPath()));
                    } else {
                        JOptionPane.showMessageDialog(BookmarksManager.this.rootPane, "Cannot add item to remote bookmarks\n" + x, "Remote Bookmark Add Item", 0);
                    }
                }
            }
        };
    }

    private Action newFolderAction() throws HeadlessException {
        return new AbstractAction("New Folder..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Bookmark context = BookmarksManager.this.model.getSelectedBookmark(BookmarksManager.this.jTree1.getModel(), BookmarksManager.this.jTree1.getSelectionPath());
                String x = BookmarksManager.maybeGetRemoteBookmarkUrl(context, BookmarksManager.this.model, BookmarksManager.this.jTree1.getModel(), BookmarksManager.this.jTree1.getSelectionPath());
                if (x.length() > 0) {
                    JOptionPane.showMessageDialog(BookmarksManager.this.rootPane, "Cannot add folder to remote bookmarks\n" + x, "Remote Bookmark Add Folder", 0);
                    return;
                }
                String s = JOptionPane.showInputDialog(BookmarksManager.this, (Object)"New Folder Name:");
                if (s != null && !s.equals("")) {
                    if (s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:")) {
                        try {
                            BookmarksManager.this.model.addRemoteBookmarks(s, BookmarksManager.this.model.getSelectedBookmark(BookmarksManager.this.jTree1.getModel(), BookmarksManager.this.jTree1.getSelectionPath()));
                            BookmarksManager.this.reload();
                        }
                        catch (MalformedRemoteBookmarksException ex) {
                            BookmarksManager.this.showMessage("Error in format of remote " + s + "\n" + ex.toString(), "Error in remote bookmarks", 2);
                        }
                    } else {
                        try {
                            BookmarksManager.this.model.addBookmark(new Bookmark.Folder(s), context);
                        }
                        catch (IllegalArgumentException ex) {
                            BookmarksManager.this.showMessage(ex.getMessage(), "Error in add bookmark", 2);
                        }
                    }
                }
            }
        };
    }

    Action createDeleteAction() {
        return new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                List bs = BookmarksManager.this.model.getSelectedBookmarks(BookmarksManager.this.jTree1.getModel(), BookmarksManager.this.jTree1.getSelectionPaths());
                if (bs.size() > 0) {
                    if ((bs = BookmarksManager.this.removeRemoteBookmarks(bs, BookmarksManager.this.jTree1.getModel(), BookmarksManager.this.jTree1.getSelectionPaths())).isEmpty()) {
                        JOptionPane.showMessageDialog(BookmarksManager.this.rootPane, "Part of remote bookmarks tree cannot be deleted", "Remote Bookmark Delete", 0);
                    } else {
                        BookmarksManager.this.maybeDeleteBookmarks(bs);
                    }
                }
            }
        };
    }

    Action createExportFolderAction() {
        return new AbstractAction("Export Items..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                List<Bookmark> bs = BookmarksManager.this.model.getSelectedBookmarks(BookmarksManager.this.jTree1.getModel(), BookmarksManager.this.jTree1.getSelectionPaths());
                BookmarksManager.this.model.doExport(BookmarksManager.this, bs);
            }
        };
    }

    public boolean hasPrefNode(String nodeName) {
        File f = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/" + nodeName + ".xml");
        return f.exists();
    }

    private boolean checkUnresolved(List<Bookmark> book) {
        boolean unresolved = false;
        for (Bookmark b : book) {
            if (!(b instanceof Bookmark.Folder)) continue;
            Bookmark.Folder bf = (Bookmark.Folder)b;
            if (bf.remoteStatus != -1) continue;
            unresolved = true;
        }
        return unresolved;
    }

    public static void printBooks(List<Bookmark> book, String indent) {
        for (Bookmark b : book) {
            BookmarksManager.printBooks(b, indent);
        }
    }

    public static void printBooks(Bookmark book, String indent) {
        System.err.println(indent + book.getTitle());
        if (book instanceof Bookmark.Folder) {
            Bookmark.Folder bf = (Bookmark.Folder)book;
            for (Bookmark b : bf.getBookmarks()) {
                BookmarksManager.printBooks(b, indent + "  ");
            }
        }
    }

    private Runnable loadBooksRunnable(final String start, final int depthf) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    List<Bookmark> book = Bookmark.parseBookmarks(start, depthf);
                    BookmarksManager.this.model.setList(book);
                    int depthLimit = 5;
                    if (BookmarksManager.this.checkUnresolved(book) && depthf < depthLimit) {
                        Runnable run = BookmarksManager.this.loadBooksRunnable(start, depthLimit);
                        logger.finer(String.format(" invokeLater( loadBooksRunnable( start, %d )\n", depthf + 1));
                        RequestProcessor.invokeLater(run);
                    } else if (BookmarksManager.this.checkUnresolved(book) && depthf >= depthLimit) {
                        logger.fine("remote bookmarks depth limit met");
                    }
                    if (!BookmarksManager.this.checkUnresolved(book)) {
                        BookmarksManager.this.haveReadRemote = true;
                    }
                }
                catch (BookmarksException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    BookmarksManager.this.showMessage("Semantic error while parsing " + BookmarksManager.this.bookmarksFile + "\n" + ex.getMessage(), "Error while parsing bookmarks", 2);
                }
                catch (SAXException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    BookmarksManager.this.showMessage("XML error while parsing " + BookmarksManager.this.bookmarksFile + "\n" + ex.getMessage(), "Error while parsing bookmarks", 2);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    BookmarksManager.this.showMessage("IO error while parsing " + BookmarksManager.this.bookmarksFile + "\n" + ex.getMessage(), "Error while parsing bookmarks", 2);
                }
            }
        };
        return run;
    }

    public void reload() {
        File tmp = new File(FileSystem.settings().getLocalCacheDir(), "temp");
        if (!FileUtil.deleteFileTree(tmp)) {
            logger.warning("unable to delete temp folder");
        }
        this.haveReadRemote = false;
        this.setPrefNode(this.prefNode);
    }

    public void resetToDefault(String surl) throws MalformedURLException, IOException, SAXException, BookmarksException {
        Document doc;
        URL url = new URL(surl);
        try (InputStream in = url.openStream();){
            doc = AutoplotUtil.readDoc(in);
        }
        List<Bookmark> book = Bookmark.parseBookmarks(doc.getDocumentElement());
        this.model.setList(book);
        this.formatToFile(this.bookmarksFile);
    }

    public void setPrefNode(String nodeName, String propName, String deft) {
        File f;
        boolean ok;
        File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
        if (!f2.exists() && !(ok = f2.mkdirs())) {
            throw new RuntimeException("unable to create folder " + f2);
        }
        this.bookmarksFile = f = new File(f2, nodeName + ".xml");
        this.setPrefNode(nodeName);
        if (!this.bookmarksFile.exists()) {
            this.defaultUrl = AutoplotUtil.getProperty(propName, deft);
            try {
                this.resetToDefault(this.defaultUrl);
            }
            catch (MalformedURLException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            catch (BookmarksException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            catch (SAXException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        this.defaultUrl = AutoplotUtil.getProperty(propName, deft);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefNode(String nodeName) {
        this.defaultUrl = nodeName.equals("bookmarks") ? AutoplotUtil.getProperty("autoplot.default.bookmarks", "http://autoplot.org/data/demos.xml") : AutoplotUtil.getProperty("autoplot.default." + nodeName, "http://autoplot.org/data/" + nodeName + ".xml");
        this.prefNode = nodeName;
        BufferedReader read = null;
        try {
            File f;
            boolean ok;
            File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
            if (!f2.exists() && !(ok = f2.mkdirs())) {
                throw new RuntimeException("unable to create folder " + f2);
            }
            this.bookmarksFile = f = new File(f2, nodeName + ".xml");
            if (!f.exists()) {
                this.model.setList(new ArrayList<Bookmark>());
            } else {
                List<Bookmark> book;
                read = new BufferedReader(new FileReader(f));
                StringBuilder buff = new StringBuilder();
                String s = null;
                do {
                    if (s == null) continue;
                    buff.append(s).append("\n");
                } while ((s = read.readLine()) != null);
                int depth = 0;
                if (this.haveReadRemote) {
                    depth = -1;
                }
                if ((book = Bookmark.parseBookmarks(buff.toString(), depth)).isEmpty() && nodeName.equals("tools")) {
                    URL url = new URL(this.defaultUrl);
                    try (InputStream ins = null;){
                        URLConnection urlc = url.openConnection();
                        urlc.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
                        urlc.setReadTimeout(FileSystem.settings().getConnectTimeoutMs());
                        ins = urlc.getInputStream();
                        Document doc = AutoplotUtil.readDoc(ins);
                        List<Bookmark> importBook = Bookmark.parseBookmarks(doc.getDocumentElement());
                        book.addAll(importBook);
                    }
                }
                this.model.setList(book);
                boolean unresolved = this.checkUnresolved(book);
                if (unresolved) {
                    String start = buff.toString();
                    Runnable run = this.loadBooksRunnable(start, 5);
                    logger.finer(String.format("invokeLater( loadBooksRunnable( start, %d )\n", depth + 1));
                    RequestProcessor.invokeLater(run);
                }
            }
            this.model.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BookmarksManager.this.formatToFile(BookmarksManager.this.bookmarksFile);
                }
            });
        }
        catch (BookmarksException ex) {
            this.showMessage("Semantic error while parsing " + this.bookmarksFile + "\n" + ex.getMessage(), "Error while parsing bookmarks", 2);
            this.model.setList(new ArrayList<Bookmark>());
        }
        catch (SAXException ex) {
            this.showMessage("XML error while parsing " + this.bookmarksFile + "\n" + ex.getMessage(), "Error while parsing bookmarks", 2);
            this.model.setList(new ArrayList<Bookmark>());
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("403")) {
                Container p = this.getParent();
                if (p instanceof AutoplotUI) {
                    ((AutoplotUI)p).setMessage(AutoplotUI.WARNING_ICON, ex.getMessage());
                } else {
                    this.showMessage("IO Error while parsing. " + this.bookmarksFile + "\n" + ex.getMessage(), "Error while parsing bookmarks", 2);
                }
            } else {
                this.showMessage("IO Error while parsing. " + this.bookmarksFile + "\n" + ex.getMessage(), "Error while parsing bookmarks", 2);
            }
            this.model.setList(new ArrayList<Bookmark>());
        }
        finally {
            try {
                if (read != null) {
                    read.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public void resetPrefNode(String nodeName) {
        boolean ok;
        File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
        if (!f2.exists() && !(ok = f2.mkdirs())) {
            throw new RuntimeException("unable to create folder " + f2);
        }
        this.prefNode = nodeName;
        File f = new File(f2, nodeName + ".xml");
        if (f.exists()) {
            throw new IllegalArgumentException("bookmarks pref node already exists: " + f);
        }
        this.formatToFile(f);
        this.bookmarksFile = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatToFile(File f) {
        logger.log(Level.FINE, "formatting {0}", f);
        OutputStream out = null;
        try {
            if (f.getParentFile() == null) {
                throw new NullPointerException("file does not have a parent: " + f);
            }
            String p = this.prefNode;
            if (p == null) {
                p = f.getName();
                p = p.replaceAll("\\.xml", "");
            }
            File temp = File.createTempFile(p, ".temp.xml", f.getParentFile());
            out = new FileOutputStream(temp);
            Bookmark.formatBooks(out, this.model.getList());
            out.close();
            if (f.exists() && !f.delete()) {
                logger.warning("delete old file failed");
            }
            if (!temp.renameTo(f)) {
                logger.warning("formatToFile mv failed");
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public void updateBookmarks(JMenu bookmarksMenu, DataSetSelector dataSetSelector) {
        Container c = this.getParent();
        if (c instanceof AutoplotUI) {
            this.updateBookmarks(bookmarksMenu, (AutoplotUI)c, dataSetSelector);
        } else {
            this.updateBookmarks(bookmarksMenu, null, dataSetSelector);
        }
    }

    public void setPlotActionsVisible(boolean v) {
        if (this.plotBelowAndOverplotVisible) {
            this.plotBelowButton.setVisible(v);
            this.overplotButton.setVisible(v);
        } else {
            this.plotBelowButton.setVisible(false);
            this.overplotButton.setVisible(false);
        }
        this.plotButton.setVisible(v);
        this.editButton.setVisible(v);
    }

    public void updateBookmarks(JMenu bookmarksMenu, AutoplotUI app, DataSetSelector dataSetSelector) {
        this.updateBookmarks(bookmarksMenu, null, app, dataSetSelector);
    }

    public void updateBookmarks(JMenu bookmarksMenu, String afterName, AutoplotUI app, final DataSetSelector dataSetSelector) {
        int i;
        if (this.name.equalsIgnoreCase("tools")) {
            afterName = "userSep";
        }
        if (this.isVisible()) {
            this.menuIsDirty = true;
            this.dirtyMenu = bookmarksMenu;
            this.dirtySelector = dataSetSelector;
            return;
        }
        List<Bookmark> bookmarks = this.model.getList();
        int n = bookmarksMenu.getMenuComponentCount();
        int idx = -1;
        if (afterName == null) {
            idx = 0;
        } else {
            for (i = 0; i < n; ++i) {
                if (!afterName.equals(bookmarksMenu.getMenuComponent(i).getName())) continue;
                idx = i;
                break;
            }
        }
        if (idx == -1) {
            throw new IllegalArgumentException("name not found: " + afterName);
        }
        if (idx == 0) {
            bookmarksMenu.removeAll();
        } else {
            n = bookmarksMenu.getMenuComponentCount();
            for (i = n - 1; i > idx; --i) {
                try {
                    bookmarksMenu.remove(i);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    logger.log(Level.SEVERE, "xzxzx", ex);
                }
            }
        }
        JMenuItem mi = new JMenuItem(new AbstractAction("Manage and Browse " + this.name + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Container parent = BookmarksManager.this.getParent();
                BookmarksManager.this.setLocationRelativeTo(parent);
                BookmarksManager.this.setPlotActionsVisible(true);
                BookmarksManager.this.setVisible(true);
            }
        });
        mi.setToolTipText("Manage bookmarks, or select bookmark to plot");
        bookmarksMenu.add(mi);
        if (afterName == null) {
            mi = new JMenuItem(new AbstractAction("Add Bookmark..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    Bookmark bookmark = BookmarksManager.this.addBookmark(dataSetSelector.getValue());
                    BookmarksManager.this.setAddBookmark(bookmark);
                    if (!BookmarksManager.this.isVisible()) {
                        Container parent = BookmarksManager.this.getParent();
                        BookmarksManager.this.setLocationRelativeTo(parent);
                        BookmarksManager.this.setPlotActionsVisible(false);
                    }
                    BookmarksManager.this.setVisible(true);
                }
            });
            mi.setToolTipText("Add the current URI to the bookmarks");
            bookmarksMenu.add(mi);
        }
        JSeparator js = new JSeparator();
        bookmarksMenu.add(js);
        if (bookmarks == null) {
            bookmarks = Collections.emptyList();
        }
        this.addBookmarks(bookmarksMenu, bookmarks, 0, app, dataSetSelector);
        this.menuIsDirty = false;
    }

    private void addBookmarks(JMenu bookmarksMenu, List<Bookmark> bookmarks, int treeDepth, AutoplotUI app, DataSetSelector select) {
        this.sel = select;
        DelayMenu.calculateMenu(bookmarksMenu, bookmarks, treeDepth, select, app);
        if (bookmarksMenu.isPopupMenuVisible()) {
            select.setMessage("Bookmarks updated");
        }
    }

    public Bookmark addBookmark(String surl) {
        ArrayList<Bookmark> newValue;
        String autoTitle;
        Bookmark.Item item = new Bookmark.Item(surl);
        URISplit split = URISplit.parse(surl);
        String string = autoTitle = split.file == null ? surl : split.file.substring(split.path.length());
        if (autoTitle.length() == 0) {
            autoTitle = surl;
        }
        item.setTitle(autoTitle);
        List<Bookmark> bookmarks = this.model.getList();
        if (bookmarks == null) {
            bookmarks = new ArrayList<Bookmark>();
        }
        if ((newValue = new ArrayList<Bookmark>(bookmarks)).contains(item)) {
            Bookmark.Item old;
            item = old = (Bookmark.Item)newValue.get(newValue.indexOf(item));
            newValue.remove(old);
        }
        newValue.add(item);
        if (this.prefNode == null) {
            Preferences prefs = AutoplotSettings.settings().getPreferences(ApplicationModel.class);
            prefs.put("bookmarks", Bookmark.formatBooks(newValue));
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.model.setList(newValue);
        this.formatToFile(this.bookmarksFile);
        return item;
    }

    public static void main(String[] args) {
        new BookmarksManager(null, false, "Bookmarks").setPrefNode("bookmarks");
    }

    public boolean haveRemoteBookmark(String bookmarksFile) {
        List<Bookmark> list = this.model.getList();
        for (Bookmark book : list) {
            String rurl;
            if (!(book instanceof Bookmark.Folder) || (rurl = ((Bookmark.Folder)book).getRemoteUrl()) == null || !rurl.equals(bookmarksFile)) continue;
            return true;
        }
        return false;
    }

    public static Bookmark findBookmarkByUri(List<Bookmark> list, String bookmarkURI, int remoteLimit) {
        for (Bookmark book : list) {
            Bookmark.Item item;
            if (book instanceof Bookmark.Folder) {
                Bookmark.Folder folder = (Bookmark.Folder)book;
                Bookmark b = folder.remoteUrl != null && !folder.remoteUrl.equals("") ? (remoteLimit > 0 ? BookmarksManager.findBookmarkByUri(folder.getBookmarks(), bookmarkURI, remoteLimit - 1) : null) : BookmarksManager.findBookmarkByUri(folder.getBookmarks(), bookmarkURI, remoteLimit);
                if (b == null) continue;
                return b;
            }
            if (!(book instanceof Bookmark.Item) || !(item = (Bookmark.Item)book).getUri().equals(bookmarkURI)) continue;
            return item;
        }
        return null;
    }

    private URL getDescriptionUrl(Bookmark book) {
        URL result = book.getDescriptionUrl();
        if (result == null) {
            Bookmark.Folder p = book.getParent();
            if (p == null) {
                return null;
            }
            return this.getDescriptionUrl(p);
        }
        return result;
    }

    public void setHidePlotButtons(boolean b) {
        this.overplotButton.setVisible(!b);
        this.plotBelowButton.setVisible(!b);
        this.plotButton.setVisible(!b);
    }
}

