/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.binarydatasource;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import org.autoplot.binarydatasource.BinaryDataSourceFactory;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.ui.ParamsTextArea;
import org.das2.qds.QDataSet;
import org.das2.qds.util.QDataSetTableModel;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;

public class BinaryDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = Logger.getLogger("apdss.binary");
    String suri;
    public JButton jButton1;
    public JLabel jLabel1;
    public JScrollPane jScrollPane1;
    public JScrollPane jScrollPane2;
    public JTable jTable1;
    public ParamsTextArea paramsTextArea1;

    public BinaryDataSourceEditorPanel() {
        this.initComponents();
        InputMap im = this.paramsTextArea1.getInputMap();
        KeyStroke tab = KeyStroke.getKeyStroke("TAB");
        this.paramsTextArea1.getActionMap().put(im.get(tab), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinaryDataSourceEditorPanel.this.jButton1ActionPerformed(e);
                try {
                    Rectangle r = BinaryDataSourceEditorPanel.this.paramsTextArea1.modelToView(BinaryDataSourceEditorPanel.this.paramsTextArea1.getCaretPosition());
                    BinaryDataSourceEditorPanel.this.paramsTextArea1.showPopup(r.x, r.y);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.jTable1.getTableHeader().setReorderingAllowed(false);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.paramsTextArea1 = new ParamsTextArea();
        this.jLabel1 = new JLabel();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jButton1.setText("Update");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryDataSourceEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.paramsTextArea1.setColumns(20);
        this.paramsTextArea1.setRows(5);
        this.paramsTextArea1.setMaximumSize(new Dimension(1000, 1000));
        this.jScrollPane1.setViewportView(this.paramsTextArea1);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 8));
        this.jLabel1.setText("<html>right-click to get completions.  Click update to see how it parses.</html>");
        this.jLabel1.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 403, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButton1).add((Component)this.jLabel1, -1, 117, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButton1).addPreferredGap(0).add((Component)this.jLabel1, -2, 52, -2)).add((Component)this.jScrollPane1, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 287, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            String suri1 = this.getURI();
            DataSource dss = DataSetURI.getDataSource(suri1);
            QDataSet ds = dss.getDataSet(new NullProgressMonitor());
            QDataSetTableModel model = new QDataSetTableModel(ds);
            this.jTable1.setModel(model);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setURI(String uri) {
        try {
            this.suri = uri;
            URISplit split = URISplit.parse(uri);
            DataSetURI.getFile(new URL(split.file), (ProgressMonitor)new NullProgressMonitor());
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            this.paramsTextArea1.setParams(params);
            this.paramsTextArea1.setFactory(new BinaryDataSourceFactory(), new ArrayList<String>());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public void markProblems(List<String> problems) {
    }

    @Override
    public String getURI() {
        URISplit split = URISplit.parse(this.suri);
        Map<String, String> params = this.paramsTextArea1.getParams();
        split.params = URISplit.formatParams(params);
        if (split.params != null && split.params.length() == 0) {
            split.params = null;
        }
        return URISplit.format(split);
    }

    @Override
    public boolean reject(String url) throws IOException, URISyntaxException {
        URISplit split = URISplit.parse(url);
        FileSystem fs = FileSystem.create(DataSetURI.getWebURL(DataSetURI.toUri(split.path)).toURI());
        return fs.isDirectory(split.file.substring(split.path.length()));
    }

    @Override
    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse(uri);
        DataSetURI.getFile(new URL(split.file), mon);
        return true;
    }
}

