/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.asdatasource;

import java.awt.Window;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class AudioSystemDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private JCheckBox fftCB;
    private JComboBox fftLenComboBox;
    private JComboBox<String> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JFormattedTextField lenTF;
    private BindingGroup bindingGroup;

    public AudioSystemDataSourceEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jLabel1 = new JLabel();
        this.lenTF = new JFormattedTextField();
        this.fftCB = new JCheckBox();
        this.fftLenComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel1.setText("Sample Length, Seconds:");
        this.lenTF.setText("1.0");
        this.fftCB.setText("Perform FFT");
        this.fftLenComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"128", "256", "512", "1024"}));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.fftCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.fftLenComboBox, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel2.setText("FFT Length:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.fftCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.jLabel2, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel3.setText("Sampling Rate (1/Seconds):");
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"8000", "16000", "32000", "64000"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fftLenComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lenTF, -2, 75, -2)).addComponent(this.fftCB).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2))).addContainerGap(49, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lenTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fftCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fftLenComboBox, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox1, -2, -1, -2)).addContainerGap(167, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    @Override
    public boolean reject(String uri) throws Exception {
        boolean allowDiscovery = false;
        return allowDiscovery;
    }

    @Override
    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        return true;
    }

    @Override
    public void setURI(String uri) {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String len = (String)params.get("len");
        if (len != null) {
            this.lenTF.setValue(Float.valueOf(Float.parseFloat(len)));
        } else {
            this.lenTF.setValue(Float.valueOf(1.0f));
        }
        String fft = (String)params.get("spec");
        this.fftCB.setSelected(fft != null);
        if (fft != null) {
            this.fftLenComboBox.setSelectedItem(fft);
        }
    }

    @Override
    public void markProblems(List<String> problems) {
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public String getURI() {
        String result = "vap+audiosystem:len=" + this.lenTF.getValue();
        if (this.fftCB.isSelected()) {
            result = result + "&spec=" + this.fftLenComboBox.getSelectedItem();
        }
        return result;
    }
}

