/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.ascii;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import org.autoplot.ascii.ColSpanTableCellRenderer;
import org.das2.qds.util.AsciiParser;
import org.das2.util.LoggerManager;

public class AsciiTableTableModel
extends AbstractTableModel
implements ColSpanTableCellRenderer.ColSpanTableModel {
    private static final Logger logger = LoggerManager.getLogger("apdss");
    String[] lines = null;
    int lineStart;
    int lineCount;
    List<Integer> recCountAtLineStart;
    String[] fields;
    boolean[] isRecord;
    int lineNumber = -1;
    int recCount;
    int fieldCount = 12;
    private static final int LINE_BUFFER_COUNT = 1000;
    protected File file = null;
    public static final String PROP_FILE = "file";
    protected AsciiParser.RecordParser recParser = null;
    public static final String PROP_RECPARSER = "recParser";
    protected AsciiParser parser = null;
    public static final String PROP_PARSER = "parser";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public int getColumnCount() {
        return this.fieldCount;
    }

    @Override
    public int getRowCount() {
        return this.recCount;
    }

    public synchronized boolean isRecord(int row) {
        return this.isRecord[row - this.lineStart];
    }

    @Override
    public boolean isColSpan(int row, int column) {
        return !this.isRecord(row);
    }

    @Override
    public synchronized Object getValueAt(int row, int column) {
        if (row < this.lineStart || row >= this.lineStart + this.lineCount) {
            this.readLines(row / 1000 * 1000, 1000);
        }
        if (this.lineCount == 0 || this.recParser == null) {
            return "";
        }
        if (this.lineNumber != row) {
            this.fields = new String[this.recParser.fieldCount()];
            this.isRecord[row - this.lineStart] = this.parser.isHeader(row, this.lines[Math.max(0, row - this.lineStart - 1)], this.lines[row - this.lineStart], 1) ? false : this.recParser.splitRecord(this.lines[row - this.lineStart], this.fields);
        }
        if (this.isRecord[row - this.lineStart]) {
            if (this.fields.length <= column) {
                return "";
            }
            return this.fields[column];
        }
        return this.lines[row - this.lineStart];
    }

    public synchronized String getLine(int skip) {
        this.readLines(skip, 1000);
        if (this.lineCount > 0) {
            return this.lines[skip - this.lineStart];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readLines(int lineNumber, int count) {
        if (this.file == null) {
            this.lines = null;
            this.lineCount = 0;
            return;
        }
        BufferedReader reader = null;
        try {
            int i;
            reader = new BufferedReader(new FileReader(this.file));
            for (i = 0; i < lineNumber; ++i) {
                String s = reader.readLine();
            }
            this.lines = new String[count];
            this.isRecord = new boolean[count];
            for (i = 0; i < count; ++i) {
                this.lines[i] = reader.readLine();
            }
            this.lineStart = lineNumber;
            this.lineCount = count;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        File oldFile = this.file;
        this.file = file;
        this.recCount = this.countLines();
        this.fireTableDataChanged();
        this.propertyChangeSupport.firePropertyChange(PROP_FILE, oldFile, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countLines() {
        BufferedReader reader = null;
        try {
            int lineCount1 = 0;
            reader = new BufferedReader(new FileReader(this.file));
            String s = reader.readLine();
            while (s != null) {
                ++lineCount1;
                s = reader.readLine();
            }
            int n = lineCount1;
            return n;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return -1;
    }

    public synchronized AsciiParser.RecordParser getRecParser() {
        return this.recParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecParser(AsciiParser.RecordParser recParser) {
        AsciiParser.RecordParser oldRecParser;
        AsciiTableTableModel asciiTableTableModel = this;
        synchronized (asciiTableTableModel) {
            oldRecParser = this.recParser;
            this.recParser = recParser;
            this.fieldCount = recParser.fieldCount();
        }
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        this.propertyChangeSupport.firePropertyChange(PROP_RECPARSER, oldRecParser, recParser);
    }

    public AsciiParser getParser() {
        return this.parser;
    }

    public void setParser(AsciiParser parser) {
        AsciiParser oldParser = this.parser;
        this.parser = parser;
        this.fireTableDataChanged();
        this.propertyChangeSupport.firePropertyChange(PROP_PARSER, oldParser, parser);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

