/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.ascii;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public class AsciiTableDataSourceFormatEditorPanel
extends JPanel
implements DataSourceFormatEditorPanel {
    private static final Logger logger = LoggerManager.getLogger("apdss");
    String file;
    private JPanel explicitFormatSpecPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox justDataCB;
    private JCheckBox noHeadersCB;
    private JTextField numberFormatSpecifierTF;
    private JCheckBox richHeadersCB;
    private JCheckBox timeUnitsCB;
    private JComboBox timeUnitsDropList;
    private JComboBox timesFormatTF;
    private JCheckBox useFormatSpecCB;
    private BindingGroup bindingGroup;

    public AsciiTableDataSourceFormatEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.useFormatSpecCB = new JCheckBox();
        this.richHeadersCB = new JCheckBox();
        this.explicitFormatSpecPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.numberFormatSpecifierTF = new JTextField();
        this.timesFormatTF = new JComboBox();
        this.jLabel2 = new JLabel();
        this.noHeadersCB = new JCheckBox();
        this.justDataCB = new JCheckBox();
        this.timeUnitsDropList = new JComboBox();
        this.timeUnitsCB = new JCheckBox();
        this.useFormatSpecCB.setText("Explicit Format Specifiers");
        this.useFormatSpecCB.setToolTipText("Specify the format to for numbers and times.");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.explicitFormatSpecPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.useFormatSpecCB, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.richHeadersCB.setText("Rich Headers");
        this.richHeadersCB.setToolTipText("<html>Add additional information about the dataset, <br>\nsuch as titles and valid ranges, in a comment block <br>\nat the top of the ascii output.</html>");
        this.richHeadersCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceFormatEditorPanel.this.richHeadersCBActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Numbers:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.explicitFormatSpecPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.jLabel1, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.numberFormatSpecifierTF.setText("%5.2f");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.explicitFormatSpecPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.numberFormatSpecifierTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.timesFormatTF.setModel(new DefaultComboBoxModel<String>(new String[]{"Day", "Minute", "Second", "Millisecond", "Microsecond", " "}));
        this.timesFormatTF.setSelectedIndex(3);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.explicitFormatSpecPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.timesFormatTF, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel2.setText("Time Resolution:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.explicitFormatSpecPanel, (Property)ELProperty.create((String)"${enabled}"), (Object)this.jLabel2, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout explicitFormatSpecPanelLayout = new GroupLayout((Container)this.explicitFormatSpecPanel);
        this.explicitFormatSpecPanel.setLayout((LayoutManager)explicitFormatSpecPanelLayout);
        explicitFormatSpecPanelLayout.setHorizontalGroup((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(1).add((GroupLayout.Group)explicitFormatSpecPanelLayout.createSequentialGroup().add((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(1).add((Component)this.numberFormatSpecifierTF, -2, 80, -2).add((Component)this.timesFormatTF, -2, -1, -2)).addContainerGap(144, Short.MAX_VALUE)));
        explicitFormatSpecPanelLayout.setVerticalGroup((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(1).add((GroupLayout.Group)explicitFormatSpecPanelLayout.createSequentialGroup().add((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.numberFormatSpecifierTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)explicitFormatSpecPanelLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.timesFormatTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.noHeadersCB.setText("No Headers");
        this.noHeadersCB.setToolTipText("Don't use any headers, making import into IDL and Matlab easier.");
        this.noHeadersCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceFormatEditorPanel.this.noHeadersCBActionPerformed(evt);
            }
        });
        this.justDataCB.setText("Just Data, don't format timetags and other dependencies");
        this.justDataCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceFormatEditorPanel.this.justDataCBActionPerformed(evt);
            }
        });
        this.timeUnitsDropList.setEditable(true);
        this.timeUnitsDropList.setModel(new DefaultComboBoxModel<String>(new String[]{"hours since 2015-01-01T00:00", "seconds since 2015-09-22T00:00"}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.timeUnitsCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.timeUnitsDropList, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.timeUnitsCB.setText("Time Units:");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.useFormatSpecCB).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.richHeadersCB).add(18, 18, 18).add((Component)this.noHeadersCB)).add((Component)this.justDataCB).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.timeUnitsCB).addPreferredGap(0).add((Component)this.timeUnitsDropList, 0, 353, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.explicitFormatSpecPanel, -2, -1, -2)))).add(18, 18, 18)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.richHeadersCB).add((Component)this.noHeadersCB)).addPreferredGap(0).add((Component)this.justDataCB).addPreferredGap(0).add((Component)this.useFormatSpecCB).addPreferredGap(0).add((Component)this.explicitFormatSpecPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timeUnitsDropList, -2, -1, -2).add((Component)this.timeUnitsCB)).addContainerGap(-1, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    private void richHeadersCBActionPerformed(ActionEvent evt) {
        if (this.richHeadersCB.isSelected()) {
            this.noHeadersCB.setSelected(false);
        }
    }

    private void noHeadersCBActionPerformed(ActionEvent evt) {
        if (this.noHeadersCB.isSelected()) {
            this.richHeadersCB.setSelected(false);
        }
    }

    private void justDataCBActionPerformed(ActionEvent evt) {
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setURI(String uri) {
        URISplit split = URISplit.parse(uri);
        this.file = split.file;
        LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
        this.useFormatSpecCB.setSelected(false);
        String s = (String)args.get("format");
        if (s != null) {
            this.numberFormatSpecifierTF.setText((String)args.get("format"));
            this.useFormatSpecCB.setSelected(true);
        }
        if ((s = (String)args.get("tformat")) != null) {
            this.timesFormatTF.setSelectedItem(s);
            this.useFormatSpecCB.setSelected(true);
        }
        if ("rich".equals(s = (String)args.get("header"))) {
            this.richHeadersCB.setSelected(true);
        }
        if ((s = (String)args.get("depend0Units")) != null) {
            this.timeUnitsDropList.setSelectedItem(s);
            this.timeUnitsCB.setSelected(true);
        }
        if ((s = (String)args.get("doDep")) != null && s.length() > 0 && 'F' == s.substring(0, 1).toUpperCase().charAt(0)) {
            this.justDataCB.setSelected(true);
        }
    }

    @Override
    public String getURI() {
        String result = this.file;
        HashMap<String, String> args = new HashMap<String, String>();
        if (this.useFormatSpecCB.isSelected()) {
            try {
                args.put("format", URLEncoder.encode(this.numberFormatSpecifierTF.getText(), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            String ts = String.valueOf(this.timesFormatTF.getSelectedItem());
            args.put("tformat", ts);
        }
        if (this.timeUnitsCB.isSelected()) {
            args.put("depend0Units", this.timeUnitsDropList.getSelectedItem().toString());
        }
        if (this.richHeadersCB.isSelected()) {
            args.put("header", "rich");
        } else if (this.noHeadersCB.isSelected()) {
            args.put("header", "none");
        }
        if (this.justDataCB.isSelected()) {
            args.put("doDep", "F");
        }
        String params = URISplit.formatParams(args);
        if (result == null) {
            result = "file:///";
        }
        URISplit ss = URISplit.parse(result);
        if (params.length() > 0) {
            ss.params = params;
        }
        return URISplit.format(ss);
    }
}

