/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.ascii;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.autoplot.ascii.AsciiTableTableModel;
import org.autoplot.ascii.ColSpanTableCellRenderer;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.ui.TableRowHeader;
import org.autoplot.datasource.ui.Util;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.datum.TimeParser;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.util.AsciiHeadersParser;
import org.das2.qds.util.AsciiParser;
import org.das2.qds.util.AutoHistogram;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public class AsciiTableDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = Logger.getLogger("apdss.ascii");
    AsciiTableTableModel model;
    Map<Integer, String> columns;
    AsciiParser parser;
    boolean focusDep0 = false;
    TableCellRenderer defaultCellRenderer;
    boolean isRichHeader = false;
    boolean initializing = true;
    private static final String PARAMS_KEY_COMMENT = "comment";
    Tool currentTool = Tool.NONE;
    JToggleButton currentToolButton;
    URISplit split = null;
    Map<String, String> params;
    protected File file = null;
    public static final String PROP_FILE = "file";
    protected int skipLines = 0;
    public static final String PROP_FIRST_ROW = "skipLines";
    protected String column = "";
    public static final String PROP_COLUMN = "column";
    protected String dep0 = "";
    public static final String PROP_DEP0 = "dep0";
    public JCheckBox bundleCheckBox;
    public JComboBox columnsComboBox;
    public JComboBox commentComboBox;
    public JLabel dataStatusLabel;
    public JComboBox dep0Columns;
    public JCheckBox dep0timeCheckBox;
    public JComboBox<String> depend0unitsCB;
    public JTextField fillValueTextField;
    public JButton guessFillButton;
    public JToggleButton guessTimeFormatToggleButton;
    public JLabel headerLabel;
    public JLabel jLabel1;
    public JLabel jLabel10;
    public JLabel jLabel11;
    public JLabel jLabel12;
    public JLabel jLabel13;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel6;
    public JLabel jLabel7;
    public JLabel jLabel8;
    public JLabel jLabel9;
    public JLayeredPane jLayeredPane1;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JPanel jPanel3;
    public JPanel jPanel4;
    public JScrollPane jScrollPane1;
    public JSeparator jSeparator1;
    public JTabbedPane jTabbedPane1;
    public JTable jTable1;
    public JToggleButton jToggleButton1;
    public JToggleButton jToggleButton2;
    public JToggleButton jToggleButton3;
    public JToggleButton jToggleButton4;
    public JTextField labelTextField;
    public JFormattedTextField skipLinesTextField;
    public JComboBox<String> timeFormatCB;
    public JComboBox timeFormatFieldsComboBox;
    public JToggleButton timeFormatToggleButton;
    public JLabel timesStatusLabel;
    public JTextField titleTextField;
    public JTextField unitsTF;
    public JTextField validMaxTextField;
    public JTextField validMinTextField;

    @Override
    public void markProblems(List<String> problems) {
    }

    Action createToolAction(String label, final Tool t) {
        assert (t != Tool.NONE);
        return new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JToggleButton) {
                    if (AsciiTableDataSourceEditorPanel.this.currentTool != Tool.NONE) {
                        AsciiTableDataSourceEditorPanel.this.clearTool();
                        return;
                    }
                    if (AsciiTableDataSourceEditorPanel.this.jTable1.getSelectionModel().isSelectionEmpty()) {
                        AsciiTableDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        AsciiTableDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                        AsciiTableDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        Util.enableComponents((Container)AsciiTableDataSourceEditorPanel.this.jTabbedPane1.getSelectedComponent(), false, (Component)e.getSource());
                        AsciiTableDataSourceEditorPanel.this.jTabbedPane1.setEnabled(false);
                        AsciiTableDataSourceEditorPanel.this.setCurrentTool(t);
                    } else {
                        AsciiTableDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        AsciiTableDataSourceEditorPanel.this.currentTool = t;
                        AsciiTableDataSourceEditorPanel.this.setCurrentTool(t);
                        AsciiTableDataSourceEditorPanel.this.doSelect(t);
                        AsciiTableDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        AsciiTableDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                    }
                }
            }
        };
    }

    private void doSelect(Tool tool) {
        if (tool == Tool.SKIPLINES && this.jTable1.getSelectedRow() != -1) {
            this.setSkipLines(this.jTable1.getSelectedRow());
            this.clearTool();
        }
        switch (this.jTable1.getColumnModel().getSelectedColumnCount()) {
            case 0: {
                break;
            }
            case 1: {
                int col = this.jTable1.getColumnModel().getSelectedColumns()[0];
                String name = null;
                if (this.columns != null) {
                    name = this.columns.get(col);
                }
                if (name == null) {
                    name = "field" + col;
                }
                if (tool == Tool.DEPEND_0) {
                    this.setDep0(name);
                    break;
                }
                if (tool == Tool.COLUMN) {
                    this.setColumn(name);
                    break;
                }
                if (tool == Tool.TIMEFORMAT) {
                    int row = this.jTable1.getSelectedRow();
                    String val = this.timeFormatCB.getSelectedItem().toString() + (String)this.jTable1.getModel().getValueAt(row, col);
                    this.timeFormatCB.setSelectedItem(val);
                    break;
                }
                if (tool == Tool.GUESSTIMEFORMAT) {
                    int row = this.jTable1.getSelectedRow();
                    String val = (String)this.jTable1.getModel().getValueAt(row, col);
                    this.timeFormatCB.setSelectedItem(val);
                    this.guessTimeFormatButtonAP(row, col, col);
                    break;
                }
                if (tool != Tool.FILLVALUE) break;
                int row = this.jTable1.getSelectedRow();
                String val = (String)this.jTable1.getModel().getValueAt(row, col);
                if (val.contains("+")) {
                    val = "" + Double.parseDouble(val);
                }
                this.fillValueTextField.setText(val);
                break;
            }
            default: {
                int[] cols = this.jTable1.getColumnModel().getSelectedColumns();
                int first = cols[0];
                int last = cols[cols.length - 1];
                String sfirst = this.columns.get(first);
                if (sfirst == null) {
                    sfirst = "" + first;
                }
                boolean haveColumnNames = true;
                String slast = this.columns.get(last);
                if (slast == null) {
                    slast = "" + last;
                    haveColumnNames = false;
                }
                if (tool == Tool.DEPEND_0) break;
                if (tool == Tool.COLUMN) {
                    if (haveColumnNames) {
                        this.setColumn(sfirst + "-" + slast);
                        break;
                    }
                    this.setColumn("" + first + ":" + (last + 1));
                    break;
                }
                if (tool == Tool.TIMEFORMAT) {
                    int row = this.jTable1.getSelectedRow();
                    StringBuilder val = new StringBuilder(this.timeFormatCB.getSelectedItem().toString());
                    val.append(this.jTable1.getModel().getValueAt(row, first));
                    for (int icol = first + 1; icol <= last; ++icol) {
                        val.append("+").append(this.jTable1.getModel().getValueAt(row, icol));
                    }
                    this.timeFormatCB.setSelectedItem(val.toString());
                    this.dep0timeCheckBox.setSelected(true);
                    this.setDep0(this.columns.get(first));
                    break;
                }
                if (tool != Tool.GUESSTIMEFORMAT) break;
                int row = this.jTable1.getSelectedRow();
                StringBuilder val = new StringBuilder();
                val.append(this.jTable1.getModel().getValueAt(row, first));
                for (int icol = first + 1; icol <= last; ++icol) {
                    val.append("+").append(this.jTable1.getModel().getValueAt(row, icol));
                }
                this.timeFormatCB.setSelectedItem(val.toString());
                this.dep0timeCheckBox.setSelected(true);
                this.setDep0(this.columns.get(first));
                this.guessTimeFormatButtonAP(row, first, last);
            }
        }
        Tool oldTool = tool;
        this.clearTool();
        if (oldTool != Tool.NONE) {
            this.jTable1.getSelectionModel().clearSelection();
            this.jTable1.getColumnModel().getSelectionModel().clearSelection();
        }
    }

    public AsciiTableDataSourceEditorPanel() {
        this.initComponents();
        AutoplotHelpSystem.getHelpSystem().registerHelpID(this, "ascii_main");
        this.columnsComboBox.requestFocusInWindow();
        this.parser = new AsciiParser();
        this.model = new AsciiTableTableModel();
        this.model.setParser(this.parser);
        this.jTable1.setModel(this.model);
        this.defaultCellRenderer = this.jTable1.getDefaultRenderer(Object.class);
        this.jTable1.setDefaultRenderer(Object.class, new ColSpanTableCellRenderer());
        this.jScrollPane1.setRowHeaderView(new TableRowHeader(this.jTable1));
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AsciiTableDataSourceEditorPanel.this.columns != null) {
                    AsciiTableDataSourceEditorPanel.this.updateColumns();
                }
                AsciiTableDataSourceEditorPanel.this.jTable1.repaint();
            }
        });
        this.jTable1.setCellSelectionEnabled(true);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AsciiTableDataSourceEditorPanel.this.doSelect(AsciiTableDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jTable1.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = AsciiTableDataSourceEditorPanel.this.jTable1.columnAtPoint(e.getPoint());
                String name = null;
                if (AsciiTableDataSourceEditorPanel.this.columns != null) {
                    name = AsciiTableDataSourceEditorPanel.this.columns.get(col);
                }
                if (name == null) {
                    name = "field" + col;
                }
                if (null != AsciiTableDataSourceEditorPanel.this.currentTool) {
                    switch (AsciiTableDataSourceEditorPanel.this.currentTool) {
                        case COLUMN: {
                            AsciiTableDataSourceEditorPanel.this.setColumn(name);
                            break;
                        }
                        case DEPEND_0: {
                            AsciiTableDataSourceEditorPanel.this.setDep0(name);
                            break;
                        }
                        case NONE: {
                            AsciiTableDataSourceEditorPanel.this.setColumn(name);
                            break;
                        }
                    }
                }
            }
        });
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AsciiTableDataSourceEditorPanel.this.doSelect(AsciiTableDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jTable1.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                int i = AsciiTableDataSourceEditorPanel.this.jTable1.getTableHeader().columnAtPoint(e.getPoint());
                String name = AsciiTableDataSourceEditorPanel.this.columns.get(i);
                if (AsciiTableDataSourceEditorPanel.this.currentTool == Tool.DEPEND_0) {
                    AsciiTableDataSourceEditorPanel.this.setDep0(name);
                    AsciiTableDataSourceEditorPanel.this.clearTool();
                } else if (AsciiTableDataSourceEditorPanel.this.currentTool == Tool.COLUMN) {
                    AsciiTableDataSourceEditorPanel.this.setColumn(name);
                    AsciiTableDataSourceEditorPanel.this.clearTool();
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        AsciiTableDataSourceEditorPanel.this.clearTool();
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        });
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)PROP_FIRST_ROW), (Object)this.skipLinesTextField, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)PROP_COLUMN), (Object)this.columnsComboBox, (Property)BeanProperty.create((String)"selectedItem")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)PROP_DEP0), (Object)this.dep0Columns, (Property)BeanProperty.create((String)"selectedItem")));
        bc.bind();
    }

    private void clearTool() {
        if (this.currentTool != Tool.NONE) {
            if (!this.jTabbedPane1.isEnabled()) {
                this.jTabbedPane1.setEnabled(true);
                Util.enableComponents((Container)this.jTabbedPane1.getSelectedComponent(), true, null);
            }
            this.currentTool = Tool.NONE;
            this.currentToolButton.setSelected(false);
            this.currentToolButton = null;
            this.timesStatusLabel.setText("");
            this.dataStatusLabel.setText("");
            this.headerLabel.setText("");
        }
    }

    private void setCurrentTool(Tool tool) {
        this.currentTool = tool;
        String message = "set tool " + (Object)((Object)tool);
        if (null != tool) {
            switch (tool) {
                case FILLVALUE: {
                    message = "Click on value to use as fill (missing) value.";
                    break;
                }
                case GUESSTIMEFORMAT: {
                    message = "Select cells which should be used to guess time format.";
                    break;
                }
                case TIMEFORMAT: {
                    message = "Select cells to copy, which must then be converted to time format template.";
                    break;
                }
                case SKIPLINES: {
                    message = "Click on the row of the first record.";
                    break;
                }
                case DEPEND_0: {
                    message = "Click on the first column which is the independent parameter, often time.";
                    break;
                }
                case COLUMN: {
                    message = "Click on the column to use.";
                    break;
                }
                case NONE: {
                    message = "";
                    break;
                }
            }
        }
        this.dataStatusLabel.setText(message);
        this.timesStatusLabel.setText(message);
        this.headerLabel.setText(message);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.skipLinesTextField = new JFormattedTextField();
        this.jToggleButton1 = new JToggleButton();
        this.jLabel5 = new JLabel();
        this.commentComboBox = new JComboBox();
        this.headerLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.timeFormatFieldsComboBox = new JComboBox();
        this.timeFormatToggleButton = new JToggleButton();
        this.jLabel9 = new JLabel();
        this.guessTimeFormatToggleButton = new JToggleButton();
        this.timesStatusLabel = new JLabel();
        this.timeFormatCB = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.dep0Columns = new JComboBox();
        this.columnsComboBox = new JComboBox();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.dep0timeCheckBox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.fillValueTextField = new JTextField();
        this.validMinTextField = new JTextField();
        this.validMaxTextField = new JTextField();
        this.jToggleButton4 = new JToggleButton();
        this.guessFillButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.bundleCheckBox = new JCheckBox();
        this.dataStatusLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.titleTextField = new JTextField();
        this.labelTextField = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.unitsTF = new JTextField();
        this.depend0unitsCB = new JComboBox();
        this.jLayeredPane1 = new JLayeredPane();
        this.setName("asciiTableDataSourceEditorPanel");
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel1.setText("Skip Lines:");
        this.jLabel1.setToolTipText("Skip this many lines before attempting to parse data.  Note if the first line contains parsable column labels, they will be used to identify each column.\n");
        this.skipLinesTextField.setText("11");
        this.skipLinesTextField.setToolTipText("");
        this.skipLinesTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.skipLinesTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.skipLinesTextFieldFocusLost(evt);
            }
        });
        this.jToggleButton1.setAction(this.createToolAction("skiplines", Tool.SKIPLINES));
        this.jToggleButton1.setText("Select");
        this.jToggleButton1.setToolTipText("Select the first row to parse as data or column headers.");
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Comment Prefix:");
        this.jLabel5.setToolTipText("Select a character that is the beginning of records that can be ignored.  \n");
        this.commentComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"# hash", "; semicolon", "none", ""}));
        this.commentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.commentComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.skipLinesTextField, -2, 47, -2).add(18, 18, 18).add((Component)this.jToggleButton1)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.commentComboBox, -2, 109, -2))).add(0, 582, Short.MAX_VALUE)).add((Component)this.headerLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.skipLinesTextField, -2, -1, -2).add((Component)this.jToggleButton1).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.commentComboBox, -2, -1, -2).add((Component)this.jLabel5)).addPreferredGap(0).add((Component)this.headerLabel, -1, 19, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("header", this.jPanel2);
        this.jLabel2.setText("Time Format:");
        this.jLabel2.setToolTipText("<html>Specify the format of time strings, such as \"%Y %m %d.\"<br>\nPluses join adjacent fields, and the droplist to the right<br>\ncan be used to select field types.  The Guess button attempts <br>\nto guess the format of selected fields.</html>\n");
        this.timeFormatFieldsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"select field type...", "$Y: four digit year", "$y: two digit year", "$m: two-digit month", "$b: month name", "$d: two-digit day of month", "$j: three-digit day of year", "$H: two-digit hour", "$M: two-digit minute", "$S: two-digit second", "$(milli): three-digit milliseconds", "$(micro): three-digit microseconds", "$(ignore): ignore this field", "+: field separator"}));
        this.timeFormatFieldsComboBox.setToolTipText("Use this droplist to select a field type, and the Select button copies the field type to the Time Format text field.");
        this.timeFormatFieldsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.timeFormatFieldsComboBoxActionPerformed(evt);
            }
        });
        this.timeFormatToggleButton.setAction(this.createToolAction("timeFormat", Tool.TIMEFORMAT));
        this.timeFormatToggleButton.setText("Select");
        this.timeFormatToggleButton.setToolTipText("Select column or range of columns which contain the times.  These column values will be copied into the time format and you will have to create a template.");
        this.timeFormatToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.timeFormatToggleButtonActionPerformed(evt);
            }
        });
        this.jLabel9.setText("<html><i>Specify time format (e.g. $Y$m+$d) when times are not ISO8601 or span multiple fields.</i></html>");
        this.guessTimeFormatToggleButton.setAction(this.createToolAction("guessTimeFormat", Tool.GUESSTIMEFORMAT));
        this.guessTimeFormatToggleButton.setText("Guess");
        this.guessTimeFormatToggleButton.setToolTipText("<html>This will scan the selected columns and try to identify field types.<br> This uses the number of digits in each field to identify the type<br> (e.g. 3 digits implies day of year), so select the cells accordingly.</html>");
        this.guessTimeFormatToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.guessTimeFormatToggleButtonActionPerformed(evt);
            }
        });
        this.timesStatusLabel.setText(" ");
        this.timeFormatCB.setEditable(true);
        this.timeFormatCB.setModel(new DefaultComboBoxModel<String>(new String[]{"$Y$m+$d", "$Y+$m+$S", "$Y-$j+$H:$M:$S", "ISO8601"}));
        this.timeFormatCB.setSelectedIndex(-1);
        this.timeFormatCB.setSelectedItem("");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(24, 24, 24).add((Component)this.timesStatusLabel, -1, -1, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel9, -2, 678, -2).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add(this.timeFormatCB, -2, 353, -2).addPreferredGap(0).add((Component)this.timeFormatFieldsComboBox, -2, 167, -2).addPreferredGap(0).add((Component)this.timeFormatToggleButton).addPreferredGap(0).add((Component)this.guessTimeFormatToggleButton))).addContainerGap(45, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jLabel9, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.timeFormatFieldsComboBox, -2, -1, -2).add((Component)this.timeFormatToggleButton).add((Component)this.jLabel2).add((Component)this.guessTimeFormatToggleButton).add(this.timeFormatCB, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.timesStatusLabel, -2, 15, -2)));
        this.jTabbedPane1.addTab("times", this.jPanel3);
        this.jLabel3.setText("Column(s):");
        this.jLabel3.setToolTipText("Select the column to plot.  Multiple, adjacent columns can be plotted as a spectrogram by using the colon or dash character\n");
        this.jLabel4.setText("Depends On:");
        this.jLabel4.setToolTipText("Select the variable that is the independent parameter that Columns depends on.  Note ISO8601 times are handled, or use the \"times\" tab to specify a time format.\n");
        this.dep0Columns.setEditable(true);
        this.dep0Columns.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.dep0Columns.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AsciiTableDataSourceEditorPanel.this.dep0ColumnsItemStateChanged(evt);
            }
        });
        this.dep0Columns.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.dep0ColumnsFocusGained(evt);
            }
        });
        this.columnsComboBox.setEditable(true);
        this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.columnsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AsciiTableDataSourceEditorPanel.this.columnsComboBoxItemStateChanged(evt);
            }
        });
        this.columnsComboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.columnsComboBoxFocusGained(evt);
            }
        });
        this.jToggleButton2.setAction(this.createToolAction(PROP_COLUMN, Tool.COLUMN));
        this.jToggleButton2.setText("Select");
        this.jToggleButton2.setToolTipText("Select column or range of columns");
        this.jToggleButton3.setAction(this.createToolAction("depend0", Tool.DEPEND_0));
        this.jToggleButton3.setText("Select");
        this.jToggleButton3.setToolTipText("Select the column that is the independent variable on which the data values depend.");
        this.dep0timeCheckBox.setText("time");
        this.dep0timeCheckBox.setToolTipText("If selected, then the field should be parsed as a time.\n");
        this.jLabel6.setText("Fill Value:");
        this.jLabel6.setToolTipText("This numeric value will be treated as fill.  Note non-numeric values are automatically handled as fill.\n");
        this.jLabel7.setText("Valid Min:");
        this.jLabel7.setToolTipText("Numbers below this value are treated as invalid.\n");
        this.jLabel8.setText("Valid Max:");
        this.jLabel8.setToolTipText("Numbers above this value are treated as invalid.");
        this.fillValueTextField.setText(" ");
        this.fillValueTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.fillValueTextFieldFocusLost(evt);
            }
        });
        this.validMinTextField.setText("   ");
        this.validMaxTextField.setText("    ");
        this.validMaxTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.validMaxTextFieldActionPerformed(evt);
            }
        });
        this.jToggleButton4.setAction(this.createToolAction("fillValue", Tool.FILLVALUE));
        this.jToggleButton4.setText("Select");
        this.jToggleButton4.setToolTipText("Click on a value to be treated as fill (invalid)");
        this.guessFillButton.setText("Guess");
        this.guessFillButton.setToolTipText("try to guess the fill value by looking for an outlier.");
        this.guessFillButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.guessFillButtonActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.bundleCheckBox.setText("bundle");
        this.bundleCheckBox.setToolTipText("<html>Range of columns should be treated as a bundle of parameters, like X, Y, Z.  When plotted, these will result in separate traces instead of a spectrogram.</html>");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.dep0Columns, 0, -1, Short.MAX_VALUE).add((Component)this.columnsComboBox, 0, 166, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.bundleCheckBox).addPreferredGap(0).add((Component)this.jToggleButton2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.dep0timeCheckBox).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jToggleButton3).add(1, 1, 1))).add((Component)this.jSeparator1, -2, -1, -2).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jLabel6)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabel7))).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.fillValueTextField, -1, 111, Short.MAX_VALUE).add((Component)this.validMinTextField, -2, 94, -2)).add(17, 17, 17).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jToggleButton4).addPreferredGap(0).add((Component)this.guessFillButton)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel8).addPreferredGap(0).add((Component)this.validMaxTextField, -2, 87, -2))).addPreferredGap(0, 28, Short.MAX_VALUE)).add((Component)this.dataStatusLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.validMaxTextField, this.validMinTextField}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.columnsComboBox, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.dep0Columns, -2, -1, -2).add((Component)this.jLabel4))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jToggleButton4).add((Component)this.guessFillButton).add((Component)this.fillValueTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jLabel8).add((Component)this.validMinTextField, -2, -1, -2).add((Component)this.validMaxTextField, -2, -1, -2))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jSeparator1, -2, 55, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jToggleButton2).add((Component)this.bundleCheckBox)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.dep0timeCheckBox).add((Component)this.jToggleButton3)))).addPreferredGap(0).add((Component)this.dataStatusLabel, -1, -1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("data", this.jPanel1);
        this.jLabel10.setText("Title:");
        this.jLabel10.setToolTipText("Title for the data.");
        this.jLabel11.setText("Label:");
        this.jLabel11.setToolTipText("Short label for the data");
        this.titleTextField.setText(" ");
        this.jLabel12.setText("Units:");
        this.jLabel12.setToolTipText("units for the data");
        this.jLabel13.setText("Depend Units:");
        this.jLabel13.setToolTipText("Units of the depend0 column (typically x-axis), such as \"seconds\" or \"nanoseconds since 2000-01-01T12:00\"  Droplist shows examples.");
        this.depend0unitsCB.setEditable(true);
        this.depend0unitsCB.setModel(new DefaultComboBoxModel<String>(new String[]{"seconds since 2010-01-01T00:00", "nanoseconds since 2000-01-01T12:00", "seconds"}));
        this.depend0unitsCB.setSelectedIndex(-1);
        this.depend0unitsCB.setToolTipText("");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel10).add(18, 18, 18).add((Component)this.titleTextField, -2, 326, -2)).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel11).addPreferredGap(0).add((Component)this.labelTextField, -2, 116, -2))).add(36, 36, 36).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel13).addPreferredGap(0).add(this.depend0unitsCB, -2, -1, -2)).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel12).addPreferredGap(0).add((Component)this.unitsTF, -2, 150, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add(6, 6, 6).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.titleTextField, -2, -1, -2).add((Component)this.jLabel12).add((Component)this.unitsTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.labelTextField, -2, -1, -2)).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel13).add(this.depend0unitsCB, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("labels", this.jPanel4);
        GroupLayout jLayeredPane1Layout = new GroupLayout((Container)this.jLayeredPane1);
        this.jLayeredPane1.setLayout((LayoutManager)jLayeredPane1Layout);
        jLayeredPane1Layout.setHorizontalGroup((GroupLayout.Group)jLayeredPane1Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        jLayeredPane1Layout.setVerticalGroup((GroupLayout.Group)jLayeredPane1Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1).add((Component)this.jTabbedPane1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 341, Short.MAX_VALUE).add((Component)this.jLayeredPane1, -2, -1, -2).add(0, 341, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTabbedPane1, -2, 112, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 354, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jLayeredPane1, -2, -1, -2).add(0, 0, Short.MAX_VALUE))));
    }

    private void timeFormatFieldsComboBoxActionPerformed(ActionEvent evt) {
        String s = (String)this.timeFormatFieldsComboBox.getSelectedItem();
        int i = s.indexOf(":");
        String insert = s.substring(0, i);
        int i0 = ((JTextField)this.timeFormatCB.getEditor().getEditorComponent()).getCaret().getDot();
        int i1 = ((JTextField)this.timeFormatCB.getEditor().getEditorComponent()).getCaret().getMark();
        if (i1 < i0) {
            int t = i0;
            i0 = i1;
            i1 = t;
        }
        String text = this.timeFormatCB.getSelectedItem().toString();
        String n = text.substring(0, i0) + insert + text.substring(i1);
        this.timeFormatCB.setSelectedItem(n);
        this.timeFormatFieldsComboBox.setSelectedIndex(0);
    }

    private int[] getDataColumns() {
        int[] result = new int[2];
        String scol = this.column;
        String ecol = this.column;
        if (this.column.contains("-")) {
            int i = this.column.indexOf("-");
            ecol = this.column.substring(i + 1);
        }
        for (Map.Entry<Integer, String> e : this.columns.entrySet()) {
            if (e.getValue().equals(scol)) {
                result[0] = e.getKey();
            }
            if (!e.getValue().equals(ecol)) continue;
            result[1] = e.getKey();
        }
        return result;
    }

    private boolean isIso8601TimeField0() {
        int i = this.getSkipLines();
        int nl = this.jTable1.getRowCount();
        String text1 = String.valueOf(this.jTable1.getValueAt(i, 0));
        String text2 = String.valueOf(this.jTable1.getValueAt(nl > i + 1 ? i + 1 : i, 0));
        return !text1.equals(text2) && TimeParser.isIso8601String(text1) && TimeParser.isIso8601String(text2);
    }

    private int guessTimeFormatColumn(String example, int column, int current, StringBuilder template) {
        int i = this.getSkipLines();
        int nl = this.jTable1.getRowCount();
        int step = 1;
        if (nl > 10000) {
            nl = 10000;
        }
        int digits = 0;
        int max = -999999999;
        int min = 999999999;
        while (i < nl) {
            String s = String.valueOf(this.jTable1.getValueAt(i, column));
            if (this.model.isRecord(i) && s.length() > digits) {
                digits = s.length();
            }
            try {
                int value = (int)Double.parseDouble(s);
                if (value > max) {
                    max = value;
                }
                if (value < min) {
                    min = value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            i += step;
        }
        switch (current) {
            case 1: {
                if (digits == 2) {
                    template.append("$y");
                    return 2;
                }
                if (digits == 4) {
                    template.append("$Y");
                    return 2;
                }
                if (digits == 5) {
                    template.append("$Y$j");
                    return 4;
                }
                if (digits == 6) {
                    template.append("$y$m$d");
                    return 4;
                }
                if (digits == 8) {
                    if (!Character.isDigit(example.charAt(4))) {
                        template.append("$Y").append(example.charAt(4)).append("$j");
                        return 4;
                    }
                    template.append("$Y$m$d");
                    return 4;
                }
                if (digits == 10) {
                    if (!Character.isDigit(example.charAt(4))) {
                        template.append("$Y").append(example.charAt(4)).append("$m").append(example.charAt(7)).append("$d");
                        return 4;
                    }
                    template.append("$X");
                    return current;
                }
                template.append("$X");
                return current;
            }
            case 2: {
                if (min == 999999999) {
                    template.append("$b");
                    return 3;
                }
                if (max <= 12) {
                    template.append("$m");
                    return 3;
                }
                if (max <= 366) {
                    template.append("$j");
                    return 4;
                }
                template.append("$x");
                return current;
            }
            case 3: {
                if (max <= 31) {
                    template.append("$d");
                    return 4;
                }
                template.append("$x");
                return current;
            }
            case 4: {
                if (digits < 3 && max < 25) {
                    template.append("$H");
                    return 5;
                }
                if (digits == 4) {
                    template.append("$H$M");
                    return 6;
                }
                if (digits == 5 && !Character.isDigit(example.charAt(2))) {
                    template.append("$H").append(example.charAt(2)).append("$M");
                    return 6;
                }
                if (digits == 6) {
                    template.append("$H$M$S");
                    return 7;
                }
                if (digits == 7 && !Character.isDigit(example.charAt(2))) {
                    template.append("$H").append(example.charAt(2)).append("$M").append(example.charAt(5)).append("$S");
                    return 7;
                }
                if (digits != 8 || Character.isDigit(example.charAt(2))) break;
                template.append("$H").append(example.charAt(2)).append("$M").append(example.charAt(5)).append("$S");
                return 7;
            }
            case 5: {
                template.append("$M");
                return 6;
            }
            case 6: {
                template.append("$S");
                return 7;
            }
            case 7: {
                template.append("$(milli)");
                return 8;
            }
        }
        template.append("$X");
        return current;
    }

    private void guessTimeFormatButtonAP(int row, int first, int last) {
        int curr = 1;
        StringBuilder template = new StringBuilder();
        if (first == last) {
            String example = String.valueOf(this.jTable1.getValueAt(row, first));
            if (TimeParser.isIso8601String(example)) {
                this.timeFormatCB.setSelectedItem("ISO8601");
                return;
            }
            logger.fine("time does not appear to be ISO8601");
        }
        for (int i = first; i <= last; ++i) {
            String example = String.valueOf(this.jTable1.getValueAt(row, i));
            curr = this.guessTimeFormatColumn(example, i, curr, template);
            if (i >= last) continue;
            template.append("+");
        }
        this.timeFormatCB.setSelectedItem(template.toString());
    }

    private void guessTimeFormatToggleButtonActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedColumn() == -1) {
            this.timesStatusLabel.setText("select time columns, and the time format is guessed (4 digits implies $Y, 3 implies $j, etc)");
        } else {
            int[] jj = this.jTable1.getSelectedColumns();
            int imin = Integer.MAX_VALUE;
            int imax = Integer.MIN_VALUE;
            for (int j : jj) {
                if (j < imin) {
                    imin = j;
                }
                if (j <= imax) continue;
                imax = j;
            }
            this.timesStatusLabel.setText("selected time columns (" + imin + " though " + imax + ") were used to infer time");
        }
    }

    private void timeFormatToggleButtonActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedColumn() == -1) {
            this.timesStatusLabel.setText("select by dragging the data columns that together form the time");
        } else {
            int[] jj = this.jTable1.getSelectedColumns();
            int imin = Integer.MAX_VALUE;
            int imax = Integer.MIN_VALUE;
            for (int j : jj) {
                if (j < imin) {
                    imin = j;
                }
                if (j <= imax) continue;
                imax = j;
            }
            this.timesStatusLabel.setText("selected time columns (" + imin + " though " + imax + ") were copied to format");
        }
    }

    private void guessFillButtonActionPerformed(ActionEvent evt) {
        this.fillValueTextField.setText("moment...");
        this.guessFillButton.setEnabled(false);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ProgressMonitor mon = null;
                try {
                    DataSetBuilder builder = new DataSetBuilder(1, 100);
                    int[] cols = AsciiTableDataSourceEditorPanel.this.getDataColumns();
                    mon = new NullProgressMonitor();
                    mon.setTaskSize(AsciiTableDataSourceEditorPanel.this.model.getRowCount());
                    mon.started();
                    for (int i = 0; i < AsciiTableDataSourceEditorPanel.this.model.getRowCount(); ++i) {
                        mon.setTaskProgress(i);
                        for (int j = cols[0]; j <= cols[1]; ++j) {
                            try {
                                builder.putValue(-1, Double.parseDouble(String.valueOf(AsciiTableDataSourceEditorPanel.this.model.getValueAt(i, j))));
                                builder.nextRecord();
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    mon.finished();
                    AutoHistogram ah = new AutoHistogram();
                    QDataSet hist = ah.doit(builder.getDataSet());
                    Map outliers = (Map)DataSetUtil.getUserProperty(hist, "outliers");
                    if (outliers != null && outliers.size() == 1) {
                        AsciiTableDataSourceEditorPanel.this.fillValueTextField.setText(String.valueOf(outliers.keySet().iterator().next()));
                    } else {
                        AsciiTableDataSourceEditorPanel.this.fillValueTextField.setText("");
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    if (mon != null) {
                        mon.finished();
                    }
                    AsciiTableDataSourceEditorPanel.this.guessFillButton.setEnabled(true);
                }
            }
        };
        new Thread(run).start();
    }

    private void validMaxTextFieldActionPerformed(ActionEvent evt) {
    }

    private void fillValueTextFieldFocusLost(FocusEvent evt) {
        String val = this.fillValueTextField.getText();
        if (val.trim().length() > 0) {
            try {
                double d = Double.parseDouble(val);
                if (val.contains("+")) {
                    this.fillValueTextField.setText(String.valueOf(d));
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Only enter numbers here.  Non-numbers are treated as fill.");
            }
        }
    }

    private void columnsComboBoxFocusGained(FocusEvent evt) {
        this.focusDep0 = false;
    }

    private void columnsComboBoxItemStateChanged(ItemEvent evt) {
        this.setColumn((String)this.columnsComboBox.getSelectedItem());
    }

    private void dep0ColumnsFocusGained(FocusEvent evt) {
        this.focusDep0 = true;
    }

    private void dep0ColumnsItemStateChanged(ItemEvent evt) {
        this.setDep0((String)this.dep0Columns.getSelectedItem());
    }

    private void commentComboBoxActionPerformed(ActionEvent evt) {
        String value = (String)this.commentComboBox.getSelectedItem();
        if (value.equals("# hash")) {
            this.params.remove(PARAMS_KEY_COMMENT);
            this.parser.setCommentPrefix("#");
            this.update();
        } else if (value.equals("none") || value.trim().equals("")) {
            this.params.put(PARAMS_KEY_COMMENT, "");
            this.parser.setCommentPrefix(null);
            this.update();
        } else {
            int i = value.indexOf(" ");
            String prefix = i == -1 ? value : value.substring(0, i);
            this.params.put(PARAMS_KEY_COMMENT, prefix);
            this.parser.setCommentPrefix(prefix);
            this.update();
        }
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.headerLabel.setText("select the first column of data or column headings");
    }

    private void skipLinesTextFieldFocusLost(FocusEvent evt) {
    }

    private void skipLinesTextFieldFocusGained(FocusEvent evt) {
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws IOException {
        this.file = file;
        this.model.setFile(file);
    }

    public Map<Integer, String> getColumnNames() throws IOException {
        String[] lcolumns = this.parser.getFieldNames();
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < lcolumns.length; ++i) {
            result.put(i, lcolumns[i]);
        }
        return result;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(int row) {
        int oldRow = this.skipLines;
        this.skipLines = row;
        Rectangle rect = this.jTable1.getCellRect(Math.max(0, this.getSkipLines() - 3), 0, true);
        this.parser.setSkipLines(this.skipLines);
        this.update();
        this.jTable1.scrollRectToVisible(rect);
        this.firePropertyChange(PROP_FIRST_ROW, oldRow, row);
    }

    public String getColumn() {
        int i = this.column.indexOf(": ");
        if (i > -1) {
            return this.column.substring(0, i);
        }
        return this.column;
    }

    public void setColumn(String column) {
        String oldColumn = this.column;
        this.column = column;
        if (!this.initializing) {
            this.labelTextField.setText("");
            this.titleTextField.setText("");
            this.unitsTF.setText("");
            this.depend0unitsCB.setSelectedItem("");
        }
        this.firePropertyChange(PROP_COLUMN, oldColumn, column);
    }

    public String getDep0() {
        int i = this.dep0.indexOf(": ");
        if (i > -1) {
            return this.dep0.substring(0, i);
        }
        return this.dep0;
    }

    public void setDep0(String dep0) {
        String oldDep0 = this.dep0;
        this.dep0 = dep0;
        this.firePropertyChange(PROP_DEP0, oldDep0, dep0);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public boolean reject(String url) throws IOException, URISyntaxException {
        this.split = URISplit.parse(url);
        FileSystem fs = FileSystem.create(DataSetURI.toUri(this.split.path));
        return fs.isDirectory(this.split.file.substring(this.split.path.length()));
    }

    @Override
    public boolean prepare(String url, Window parent, ProgressMonitor mon) throws Exception {
        this.split = URISplit.parse(url);
        DataSetURI.getFile(DataSetURI.toUri(this.split.file), mon);
        return true;
    }

    @Override
    public void setURI(String url) {
        try {
            String arg0;
            this.split = URISplit.parse(url);
            this.params = URISplit.parseParams(this.split.params);
            File f = DataSetURI.getFile(DataSetURI.toUri(this.split.file), (ProgressMonitor)new NullProgressMonitor());
            this.setFile(f);
            int tab = 2;
            if (this.params.containsKey(PROP_FIRST_ROW)) {
                this.setSkipLines(Integer.parseInt(this.params.get(PROP_FIRST_ROW)));
            }
            if (this.params.containsKey("skip")) {
                this.setSkipLines(Integer.parseInt(this.params.get("skip")));
            }
            if (this.params.containsKey(PROP_COLUMN)) {
                this.setColumn(this.params.get(PROP_COLUMN));
            }
            if (this.params.containsKey("arg_0")) {
                this.setColumn(this.params.get("arg_0"));
            }
            if (this.params.containsKey("rank2")) {
                this.setColumn(this.params.get("rank2"));
            }
            if (this.params.containsKey("bundle")) {
                this.setColumn(this.params.get("bundle"));
                this.bundleCheckBox.setSelected(true);
            }
            if (this.params.containsKey("title")) {
                this.titleTextField.setText(this.params.get("title"));
            }
            if (this.params.containsKey("label")) {
                this.labelTextField.setText(this.params.get("label"));
            }
            if (this.params.containsKey("units")) {
                this.unitsTF.setText(this.params.get("units"));
            }
            if (this.params.containsKey("depend0Units")) {
                this.depend0unitsCB.setSelectedItem(this.params.get("depend0Units"));
            }
            if ((arg0 = this.params.get("arg_0")) != null) {
                String col = ":";
                if (arg0.equals("rank2")) {
                    this.setColumn(col);
                } else if (arg0.equals("bundle")) {
                    this.setColumn(col);
                    this.bundleCheckBox.setSelected(true);
                }
            }
            if (this.params.containsKey("depend0")) {
                this.setDep0(this.params.get("depend0"));
            }
            if (this.params.containsKey("time")) {
                this.setDep0(this.params.get("time"));
                this.dep0timeCheckBox.setSelected(true);
            }
            if (this.params.containsKey("timeFormat")) {
                this.timeFormatCB.setSelectedItem(this.params.get("timeFormat"));
            }
            this.fillValueTextField.setText(this.getParam(this.params, "fill"));
            this.validMinTextField.setText(this.getParam(this.params, "validMin"));
            this.validMaxTextField.setText(this.getParam(this.params, "validMax"));
            this.jTabbedPane1.setSelectedIndex(tab);
            this.update();
            this.checkHeaders();
            this.initializing = false;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    private String getParam(Map<String, String> params, String name) {
        String result = params.get(name);
        if (result == null) {
            return "";
        }
        return result;
    }

    private void setParam(Map<String, String> params, String name, String s) {
        if ((s = s.trim()).length() > 0) {
            params.put(name, s);
        } else {
            params.remove(name);
        }
    }

    @Override
    public String getURI() {
        if (this.skipLines > 0) {
            this.params.put(PROP_FIRST_ROW, "" + this.skipLines);
        } else {
            this.params.remove(PROP_FIRST_ROW);
        }
        this.params.remove("skip");
        if (!this.getDep0().equals("")) {
            if (this.dep0timeCheckBox.isSelected()) {
                this.params.put("time", this.getDep0());
                this.params.remove("depend0");
            } else {
                this.params.put("depend0", this.getDep0());
                this.params.remove("time");
            }
        } else {
            this.params.remove("time");
            this.params.remove("depend0");
        }
        this.params.remove("arg_0");
        this.params.remove(PROP_COLUMN);
        if (this.getColumn().contains(":") || this.getColumn().contains("-")) {
            if (this.bundleCheckBox.isSelected()) {
                this.params.put("bundle", this.getColumn());
                this.params.remove("rank2");
            } else {
                this.params.put("rank2", this.getColumn());
                this.params.remove("bundle");
            }
        } else {
            if (this.isIso8601TimeField0()) {
                if (this.getDep0().equals("") || this.getDep0().equals("field0")) {
                    this.params.put("arg_0", this.getColumn());
                    this.params.remove("depend0");
                } else {
                    this.params.put(PROP_COLUMN, this.getColumn());
                }
            } else {
                String s = this.getColumn();
                if (s.trim().length() > 0) {
                    this.params.put(PROP_COLUMN, s);
                }
            }
            this.params.remove("rank2");
            this.params.remove("bundle");
        }
        this.params.remove("group");
        this.setParam(this.params, "title", this.titleTextField.getText());
        this.setParam(this.params, "label", this.labelTextField.getText());
        this.setParam(this.params, "units", this.unitsTF.getText());
        if (this.depend0unitsCB.getSelectedItem() != null) {
            this.setParam(this.params, "depend0Units", this.depend0unitsCB.getSelectedItem().toString());
        } else {
            this.params.remove("depend0Units");
        }
        if (this.timeFormatCB.getSelectedItem() != null) {
            if (!this.timeFormatCB.getSelectedItem().toString().equals("ISO8601")) {
                this.setParam(this.params, "timeFormat", this.timeFormatCB.getSelectedItem().toString());
            } else {
                this.params.remove("timeFormat");
            }
        } else {
            this.params.remove("timeFormat");
        }
        this.setParam(this.params, "fill", this.fillValueTextField.getText());
        this.setParam(this.params, "validMin", this.validMinTextField.getText());
        this.setParam(this.params, "validMax", this.validMaxTextField.getText());
        this.split.params = URISplit.formatParams(this.params);
        if (this.split.params != null && this.split.params.length() == 0) {
            this.split.params = null;
        }
        return URISplit.format(this.split);
    }

    private void updateColumns() {
        int n = this.jTable1.getColumnCount();
        int wide = n < 5 ? 210 : 170;
        int norm = n < 5 ? 100 : 70;
        int narrow = n < 5 ? 60 : 50;
        for (int i = 0; i < this.jTable1.getColumnCount(); ++i) {
            String label = i < this.columns.size() ? this.columns.get(i) : "x";
            this.jTable1.getColumnModel().getColumn(i).setHeaderValue(label);
            int nrow = this.jTable1.getRowCount();
            Object o = this.jTable1.getValueAt(nrow - 1, i);
            String s = String.valueOf(o);
            if (s.length() > 16) {
                this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(wide);
                continue;
            }
            if (s.length() < 5) {
                this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(narrow);
                continue;
            }
            this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(norm);
        }
        this.jTable1.getTableHeader().repaint();
    }

    private void checkHeaders() {
        try {
            AsciiParser.DelimParser p = this.parser.guessSkipAndDelimParser(this.file.toString());
            if (p == null) {
                return;
            }
            this.model.setRecParser(p);
            this.columns = this.getColumnNames();
            Exception richHeaderWarn = null;
            this.isRichHeader = AsciiParser.isRichHeader(p.header);
            if (this.isRichHeader) {
                try {
                    String[] columns1 = new String[p.fieldCount()];
                    for (int i = 0; i < columns1.length; ++i) {
                        columns1[i] = "";
                    }
                    AsciiHeadersParser.parseMetadata(p.header, columns1, columns1);
                }
                catch (IllegalArgumentException | ParseException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    richHeaderWarn = ex;
                }
            }
            if (richHeaderWarn != null) {
                JOptionPane.showMessageDialog(this.jTable1, "<html>Rich headers are JSON headers that provide additional information about the parameters in the text file.<br>There was an error when parsing the headers.<br><br>" + richHeaderWarn.toString() + "</html>", "Rich Headers parser error detected", 0);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void update() {
        try {
            AsciiParser.DelimParser p = this.parser.guessSkipAndDelimParser(this.file.toString());
            if (p == null) {
                return;
            }
            this.model.setRecParser(p);
            LinkedHashMap<Integer, String> list = new LinkedHashMap<Integer, String>();
            this.columns = this.getColumnNames();
            Map<String, String> xx = this.parser.getRichFields();
            int ij = this.columns.size();
            for (Map.Entry<String, String> s : xx.entrySet()) {
                list.put(ij, s.getKey());
                ++ij;
            }
            list.putAll(this.columns);
            this.updateColumns();
            String lcol = this.getColumn();
            int icol = this.jTable1.getSelectedColumn();
            this.columnsComboBox.setModel(new DefaultComboBoxModel<Object>(list.values().toArray()));
            this.columnsComboBox.setSelectedItem(this.getColumn());
            if (icol != -1) {
                this.setColumn(this.columns.get(icol));
            } else {
                this.setColumn(lcol);
            }
            ArrayList dep0Values = new ArrayList(list.values());
            String ldep0 = this.getDep0();
            dep0Values.add(0, "");
            this.dep0Columns.setModel(new DefaultComboBoxModel<Object>(dep0Values.toArray()));
            this.dep0Columns.setSelectedItem(ldep0);
            String comment = "#";
            if (this.params.containsKey(PARAMS_KEY_COMMENT) && (comment = this.params.get(PARAMS_KEY_COMMENT)).trim().length() == 0) {
                comment = "none";
            }
            ComboBoxModel model1 = this.commentComboBox.getModel();
            for (int i = 0; i < model1.getSize(); ++i) {
                if (!((String)model1.getElementAt(i)).startsWith(comment)) continue;
                this.commentComboBox.setSelectedIndex(i);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private static enum Tool {
        NONE,
        SKIPLINES,
        COLUMN,
        DEPEND_0,
        TIMEFORMAT,
        GUESSTIMEFORMAT,
        FILLVALUE;

    }
}

