/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.ascii;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.ascii.MultiFieldTimeParser;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSourceUtil;
import org.das2.CancelledOperationException;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.AsciiHeadersParser;
import org.das2.qds.util.AsciiParser;
import org.das2.util.ByteBufferInputStream;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class AsciiTableDataSource
extends AbstractDataSource {
    AsciiParser parser;
    File file;
    String column = null;
    String depend0 = null;
    private static final Logger logger = LoggerManager.getLogger("apdss.ascii");
    public static final String PARAM_INTERVAL_TAG = "intervalTag";
    TimeParser timeParser;
    String[] timeFormats;
    int timeColumn = -1;
    DDataSet ds = null;
    int[] rank2 = null;
    int[] bundle = null;
    int[] depend1Labels = null;
    String[] depend1Label = null;
    int[] depend1Values = null;
    private double validMin = Double.NEGATIVE_INFINITY;
    private double validMax = Double.POSITIVE_INFINITY;
    String eventListColumn = null;
    int eventListColorColumn = -1;

    public AsciiTableDataSource(URI uri) throws FileNotFoundException, IOException {
        super(uri);
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws IOException, CancelledOperationException, NoDataInIntervalException {
        String title;
        MutablePropertyDataSet bds;
        logger.fine("read file");
        this.ds = this.doReadFile(mon);
        logger.fine("done read file");
        if (mon.isCancelled()) {
            throw new CancelledOperationException("cancelled data read");
        }
        MutablePropertyDataSet vds = null;
        ArrayDataSet dep0 = null;
        if (this.column == null && this.timeColumn != -1) {
            this.column = this.parser.getFieldNames()[this.timeColumn];
        }
        QDataSet bundleDescriptor = (QDataSet)this.ds.property("BUNDLE_1");
        if (this.eventListColumn != null) {
            Units u1;
            dep0 = ArrayDataSet.maybeCopy(DataSetOps.leafTrim(this.ds, 0, 2));
            Units u0 = this.parser.getUnits(0);
            if (u0 != (u1 = this.parser.getUnits(1))) {
                if (UnitsUtil.isTimeLocation(u0) && UnitsUtil.isTimeLocation(u1)) {
                    throw new IllegalArgumentException("somehow the parser was misconfigured to have two different time units.");
                }
                if (!u1.isConvertibleTo(u0.getOffsetUnits())) {
                    throw new IllegalArgumentException("first two columns should have the same units, or second column should be offset (e.g. seconds) from first");
                }
            }
            dep0.putProperty("UNITS", this.parser.getUnits(0));
            dep0.putProperty("BINS_1", "min,max");
            if (!this.eventListColumn.equals("")) {
                this.column = this.eventListColumn;
            }
        }
        if (this.ds.length() == 0) {
            logger.info("===========================================");
            logger.info("no records found when parsing ascii file!!!");
            logger.info("===========================================");
            throw new NoDataInIntervalException("no records found");
        }
        String group = this.getParam("group", null);
        if (group != null) {
            vds = ArrayDataSet.copy(DataSetOps.unbundle((QDataSet)this.ds, group));
        } else if (this.column != null) {
            block77: {
                if (bundleDescriptor != null) {
                    try {
                        vds = ArrayDataSet.copy(DataSetOps.unbundle((QDataSet)this.ds, this.column));
                    }
                    catch (IllegalArgumentException ex) {
                        int icol = this.parser.getFieldIndex(this.column);
                        if (icol != -1) {
                            vds = ArrayDataSet.copy(DataSetOps.slice1(this.ds, icol));
                            vds.putProperty("CONTEXT_0", null);
                            vds.putProperty("UNITS", this.parser.getUnits(icol));
                            if (this.column.length() > 1) {
                                vds.putProperty("NAME", this.column);
                            }
                            vds.putProperty("LABEL", this.parser.getFieldNames()[icol]);
                            break block77;
                        }
                        QDataSet _vds = AsciiHeadersParser.getInlineDataSet(bundleDescriptor, this.column);
                        if (_vds == null) {
                            throw new IllegalArgumentException("No such dataset: " + this.column);
                        }
                        vds = ArrayDataSet.maybeCopy(_vds);
                    }
                } else {
                    int icol = this.parser.getFieldIndex(this.column);
                    if (icol == -1) {
                        throw new IllegalArgumentException("bad column parameter: " + this.column + ", should be field1, or 1, or <name>");
                    }
                    vds = ArrayDataSet.copy(DataSetOps.slice1(this.ds, icol));
                    vds.putProperty("CONTEXT_0", null);
                    vds.putProperty("UNITS", this.parser.getUnits(icol));
                    if (this.column.length() > 1) {
                        vds.putProperty("NAME", this.column);
                    }
                    vds.putProperty("LABEL", this.parser.getFieldNames()[icol]);
                }
            }
            if (this.validMax != Double.POSITIVE_INFINITY) {
                vds.putProperty("VALID_MAX", this.validMax);
            }
            if (this.validMin != Double.NEGATIVE_INFINITY) {
                vds.putProperty("VALID_MIN", this.validMin);
            }
        } else if (this.eventListColumn != null) {
            EnumerationUnits eu = EnumerationUnits.create("events");
            vds = ArrayDataSet.maybeCopy(Ops.replicate(DataSetUtil.asDataSet(eu.createDatum("event")), this.ds.length()));
        }
        if (this.depend0 != null) {
            String dep0Units;
            Units xunits;
            RankZeroDataSet cadence;
            String intervalType;
            int icol = this.parser.getFieldIndex(this.depend0);
            if (icol == -1) {
                throw new IllegalArgumentException("bad depend0 parameter: " + this.depend0 + ", should be field1, or 1, or <name>");
            }
            dep0 = this.ds.property("BUNDLE_1") != null ? ArrayDataSet.copy(DataSetOps.unbundle((QDataSet)this.ds, icol)) : ArrayDataSet.copy(DataSetOps.slice1(this.ds, icol));
            dep0.putProperty("UNITS", this.parser.getUnits(icol));
            if (UnitsUtil.isTimeLocation(this.parser.getUnits(icol))) {
                dep0.putProperty("LABEL", null);
                dep0.putProperty("NAME", "time");
            }
            if (DataSetUtil.isMonotonic(dep0)) {
                dep0.putProperty("MONOTONIC", Boolean.TRUE);
            }
            if ((intervalType = (String)this.params.get(PARAM_INTERVAL_TAG)) != null && intervalType.equals("start") && (cadence = DataSetUtil.guessCadenceNew(dep0, null)) != null && !"log".equals(cadence.property("SCALE_TYPE"))) {
                double add = cadence.value() / 2.0;
                logger.log(Level.FINE, "adding half-interval width to dep0 because of %s: %s", new Object[]{PARAM_INTERVAL_TAG, cadence});
                for (int i = 0; i < dep0.length(); ++i) {
                    dep0.putValue(i, dep0.value(i) + add);
                }
            }
            if (this.depend0.length() > 1) {
                dep0.putProperty("NAME", this.depend0);
            }
            if (!((xunits = (Units)dep0.property("UNITS")) != null && UnitsUtil.isTimeLocation(xunits) || dep0.property("LABEL") != null)) {
                dep0.putProperty("LABEL", this.parser.getFieldNames()[icol]);
            }
            if ((dep0Units = this.getParam("depend0Units", null)) != null) {
                dep0Units = dep0Units.replaceAll("\\+", " ");
                Units newDep0Units = Units.lookupUnits(dep0Units);
                if (UnitsUtil.isTimeLocation(SemanticOps.getUnits(dep0)) && UnitsUtil.isTimeLocation(newDep0Units)) {
                    dep0 = ArrayDataSet.maybeCopy(Ops.convertUnitsTo(dep0, newDep0Units));
                } else {
                    dep0.putProperty("UNITS", newDep0Units);
                }
            }
        } else if (this.ds.rank() == 2 && (bds = (MutablePropertyDataSet)this.ds.property("BUNDLE_1")) != null) {
            for (int i = 0; i < bds.length(); ++i) {
                Units u = (Units)bds.property("UNITS", i);
                if (u == null || !UnitsUtil.isTimeLocation(u)) continue;
                bds.putProperty("LABEL", i, null);
            }
        }
        String x = this.getParam("X", null);
        String y = this.getParam("Y", null);
        String z = this.getParam("Z", null);
        if (z != null) {
            ArrayDataSet xds;
            ArrayDataSet zds = ArrayDataSet.copy(DataSetOps.unbundle((QDataSet)this.ds, this.parser.getFieldIndex(z)));
            if (y == null) {
                throw new IllegalArgumentException("expected param Y");
            }
            ArrayDataSet yds = ArrayDataSet.copy(DataSetOps.unbundle((QDataSet)this.ds, this.parser.getFieldIndex(y)));
            if (x != null) {
                xds = ArrayDataSet.copy(DataSetOps.unbundle((QDataSet)this.ds, this.parser.getFieldIndex(x)));
            } else if (dep0 != null) {
                xds = dep0;
            } else {
                throw new IllegalArgumentException("expected param X");
            }
            vds = (MutablePropertyDataSet)Ops.bundle(xds, yds, zds);
        }
        if (this.bundle != null) {
            this.rank2 = this.bundle;
        }
        if (this.rank2 != null) {
            String title2;
            String label;
            if (dep0 != null) {
                this.ds.putProperty("DEPEND_0", dep0);
            }
            if (this.rank2[0] == -1) {
                throw new IllegalArgumentException("bad parameter: rank2");
            }
            Units u = this.parser.getUnits(this.rank2[0]);
            for (int i = this.rank2[0]; i < this.rank2[1]; ++i) {
                if (u == this.parser.getUnits(i)) continue;
                u = null;
            }
            if (u != null) {
                this.ds.putProperty("UNITS", u);
            }
            if (this.validMax != Double.POSITIVE_INFINITY) {
                this.ds.putProperty("VALID_MAX", this.validMax);
            }
            if (this.validMin != Double.NEGATIVE_INFINITY) {
                this.ds.putProperty("VALID_MIN", this.validMin);
            }
            MutablePropertyDataSet mds = this.rank2[0] == 0 && this.rank2[1] == this.ds.length(0) ? this.ds : DataSetOps.leafTrim(this.ds, this.rank2[0], this.rank2[1]);
            if (this.bundle != null) {
                QDataSet labels = Ops.labelsDataset(this.parser.getFieldLabels());
                labels = labels.trim(this.bundle[0], this.bundle[1]);
                mds.putProperty("DEPEND_1", labels);
            }
            if (this.depend1Label != null) {
                mds.putProperty("DEPEND_1", Ops.labelsDataset(this.depend1Label));
            }
            if (this.depend1Labels != null) {
                QDataSet labels = Ops.labelsDataset(this.parser.getFieldLabels());
                labels = labels.trim(this.depend1Labels[0], this.depend1Labels[1]);
                mds.putProperty("DEPEND_1", labels);
            }
            if (this.depend1Values != null) {
                String[] fieldNames = this.parser.getFieldNames();
                String[] fieldUnits = this.parser.getFieldUnits();
                DDataSet dep1 = DDataSet.createRank1(this.depend1Values[1] - this.depend1Values[0]);
                boolean firstRecordIsDep1 = false;
                for (int i = this.depend1Values[0]; i < this.depend1Values[1]; ++i) {
                    double d;
                    if (firstRecordIsDep1) {
                        d = mds.value(0, i - this.depend1Values[0]);
                    } else {
                        try {
                            d = Double.parseDouble(fieldNames[i]);
                        }
                        catch (NumberFormatException ex) {
                            try {
                                if (fieldUnits[i] != null) {
                                    d = Double.parseDouble(fieldUnits[i]);
                                } else {
                                    d = mds.value(0, i - this.depend1Values[0]);
                                    firstRecordIsDep1 = true;
                                }
                            }
                            catch (NumberFormatException ex2) {
                                d = i - this.depend1Values[0];
                            }
                        }
                    }
                    dep1.putValue(i - this.depend1Values[0], d);
                }
                mds.putProperty("DEPEND_1", dep1);
                if (firstRecordIsDep1) {
                    mds = (MutablePropertyDataSet)mds.trim(1, mds.length());
                }
            }
            if (!this.parser.isRichHeader()) {
                mds.putProperty("BUNDLE_1", null);
            }
            if ((label = this.getParam("label", null)) != null) {
                mds.putProperty("LABEL", label);
            }
            if ((title2 = this.getParam("title", null)) != null) {
                mds.putProperty("TITLE", title2);
            }
            return mds;
        }
        if (vds == null) {
            throw new IllegalArgumentException("didn't find column: " + this.column);
        }
        String label = this.getParam("label", null);
        if (label != null) {
            vds.putProperty("LABEL", label);
        }
        if ((title = this.getParam("title", null)) != null) {
            vds.putProperty("TITLE", title);
        }
        if (dep0 != null) {
            vds.putProperty("DEPEND_0", dep0);
        }
        if (this.eventListColumn != null && dep0 != null) {
            Units u1;
            Units u0 = this.parser.getUnits(0);
            if (u0 != (u1 = this.parser.getUnits(1)) && u1.isConvertibleTo(u0.getOffsetUnits())) {
                UnitsConverter uc = u1.getConverter(u0.getOffsetUnits());
                for (int i = 0; i < dep0.length(); ++i) {
                    dep0.putValue(i, 1, dep0.value(i, 0) + uc.convert(dep0.value(i, 1)));
                }
            }
            if (this.eventListColorColumn > -1) {
                vds = ArrayDataSet.copy(Ops.bundle(Ops.slice1((QDataSet)dep0, 0), Ops.slice1((QDataSet)dep0, 1), Ops.slice1((QDataSet)this.ds, this.eventListColorColumn), vds));
                ((MutablePropertyDataSet)vds.property("BUNDLE_1")).putProperty("FORMAT", 2, "0x%06x");
            }
            vds.putProperty("RENDER_TYPE", "eventsBar");
        }
        return vds;
    }

    private DDataSet doReadFile(ProgressMonitor mon) throws NumberFormatException, IOException, FileNotFoundException {
        DDataSet ds1;
        String w;
        Units u;
        String s;
        boolean haveColumn;
        int columnCount;
        AsciiParser.RecordParser p;
        logger.finer("maybe download file");
        this.file = this.getFile(mon.getSubtaskMonitor("getFile"));
        logger.finer("got file");
        if (this.file.isDirectory()) {
            throw new IOException("expected file but got directory");
        }
        this.parser = new AsciiParser();
        boolean fixedColumns = false;
        String o = (String)this.params.get("skip");
        if (o != null) {
            this.parser.setSkipLines(Integer.parseInt(o));
        }
        if ((o = (String)this.params.get("skipLines")) != null) {
            this.parser.setSkipLines(Integer.parseInt(o));
        }
        if ((o = (String)this.params.get("recCount")) != null) {
            this.parser.setRecordCountLimit(Integer.parseInt(o));
        }
        this.parser.setKeepFileHeader(true);
        o = (String)this.params.get("comment");
        if (o != null) {
            if (o.equals("")) {
                this.parser.setCommentPrefix(null);
            } else {
                this.parser.setCommentPrefix(o);
            }
        }
        if ((o = (String)this.params.get("headerDelim")) != null) {
            this.parser.setHeaderDelimiter(o);
        }
        String delim = (String)this.params.get("delim");
        String sFixedColumns = (String)this.params.get("fixedColumns");
        if (sFixedColumns == null) {
            String format = (String)this.params.get("format");
            if (format != null) {
                p = this.parser.getRegexParserForFormat(format);
                columnCount = ((AsciiParser.RegexParser)p).fieldCount();
                this.parser.setRecordParser(p);
                delim = " ";
            } else if (delim == null) {
                p = this.parser.guessSkipAndDelimParser(this.file.toString());
                if (p == null) {
                    throw new IllegalArgumentException("no records found in " + this.file);
                }
                columnCount = ((AsciiParser.DelimParser)p).fieldCount();
                delim = ((AsciiParser.DelimParser)p).getDelim();
                ((AsciiParser.DelimParser)p).setShowException(true);
            } else {
                if (delim.equals(",")) {
                    delim = "COMMA";
                }
                delim = delim.replaceAll("WHITESPACE", "\\s+");
                delim = delim.replaceAll("SPACE", " ");
                delim = delim.replaceAll("COMMA", ",");
                delim = delim.replaceAll("SEMICOLON", ";");
                delim = delim.replaceAll("COLON", ":");
                delim = delim.replaceAll("TAB", "\t");
                delim = delim.replaceAll("whitespace", "\\s+");
                delim = delim.replaceAll("space", " ");
                delim = delim.replaceAll("comma", ",");
                delim = delim.replaceAll("semicolon", ";");
                delim = delim.replaceAll("colon", ":");
                if ((delim = delim.replaceAll("tab", "\t")).equals("+")) {
                    delim = " ";
                }
                columnCount = this.parser.setDelimParser(this.file.toString(), delim).fieldCount();
            }
            this.parser.setPropertyPattern(AsciiParser.NAME_COLON_VALUE_PATTERN);
        } else {
            String s2 = sFixedColumns;
            p = this.parser.setFixedColumnsParser(this.file.toString(), "\\s+");
            try {
                columnCount = Integer.parseInt(sFixedColumns);
            }
            catch (NumberFormatException ex) {
                if (sFixedColumns.equals("")) {
                    columnCount = p.fieldCount();
                }
                String[] ss = s2.split(",");
                int[] starts = new int[ss.length];
                int[] widths = new int[ss.length];
                AsciiParser.FieldParser[] fparsers = new AsciiParser.FieldParser[ss.length];
                for (int i = 0; i < ss.length; ++i) {
                    String[] ss2 = ss[i].split("-");
                    starts[i] = Integer.parseInt(ss2[0]);
                    widths[i] = Integer.parseInt(ss2[1]) - starts[i] + 1;
                    fparsers[i] = AsciiParser.DOUBLE_PARSER;
                }
                p = this.parser.setFixedColumnsParser(starts, widths, fparsers);
                columnCount = p.fieldCount();
            }
            this.parser.setPropertyPattern(null);
            fixedColumns = true;
            delim = null;
        }
        o = (String)this.params.get("columnCount");
        if (columnCount == 0) {
            columnCount = o != null ? Integer.parseInt(o) : AsciiParser.guessFieldCount(this.file.toString());
        }
        if ((o = (String)this.params.get("fill")) != null) {
            this.parser.setFillValue(Double.parseDouble(o));
        }
        if ((o = (String)this.params.get("validMin")) != null) {
            this.validMin = Double.parseDouble(o);
        }
        if ((o = (String)this.params.get("validMax")) != null) {
            this.validMax = Double.parseDouble(o);
        }
        if ((o = (String)this.params.get("time")) != null) {
            int i = this.parser.getFieldIndex(o);
            if (i == -1) {
                throw new IllegalArgumentException("field not found for time in column named \"" + o + "\"");
            }
            this.parser.setFieldParser(i, this.parser.UNITS_PARSER);
            this.parser.setUnits(i, AsciiParser.UNIT_UTC);
            this.depend0 = o;
            this.timeColumn = i;
        }
        if ((o = (String)this.params.get("timeFormat")) != null) {
            AsciiParser.FieldParser timeFieldParser;
            Units u2;
            String timeFormat = o;
            if (",".equals(delim) && !timeFormat.contains(",")) {
                timeFormat = timeFormat.replaceAll("\\+", ",");
            }
            if (!timeFormat.contains(" ")) {
                timeFormat = timeFormat.replaceAll("\\+", " ");
            }
            timeFormat = timeFormat.replaceAll("\\%", "\\$");
            timeFormat = timeFormat.replaceAll("\\{", "(");
            timeFormat = timeFormat.replaceAll("\\}", ")");
            String timeColumnName = (String)this.params.get("time");
            if (timeColumnName == null) {
                this.timeColumn = 0;
            } else {
                int i = timeColumnName.indexOf("-");
                if (i > -1) {
                    timeColumnName = timeColumnName.substring(0, i);
                } else {
                    i = timeColumnName.indexOf(":");
                    if (i > -1) {
                        timeColumnName = timeColumnName.substring(0, i);
                    }
                }
                this.timeColumn = this.parser.getFieldIndex(timeColumnName);
            }
            String timeFormatDelim = delim;
            if (delim == null) {
                timeFormatDelim = " ";
            }
            this.timeFormats = timeFormat.split(timeFormatDelim, -2);
            if (this.timeFormats.length == 1) {
                timeFormatDelim = " ";
                this.timeFormats = timeFormat.split(timeFormatDelim, -2);
            }
            if (timeFormat.equals("ISO8601")) {
                String line = this.parser.readFirstParseableRecord(this.file.toString());
                if (line == null) {
                    throw new IllegalArgumentException("file contains no parseable records.");
                }
                String[] ss = new String[this.parser.getRecordParser().fieldCount()];
                this.parser.getRecordParser().splitRecord(line, ss);
                int i = this.timeColumn;
                if (i == -1) {
                    i = 0;
                }
                String atime = ss[i];
                timeFormat = TimeParser.iso8601String(atime.trim());
                this.timeParser = TimeParser.create(timeFormat);
                final Units u3 = AsciiParser.UNIT_UTC;
                this.parser.setUnits(i, u3);
                AsciiParser.FieldParser timeFieldParser2 = new AsciiParser.FieldParser(){

                    @Override
                    public double parseField(String field, int fieldIndex) throws ParseException {
                        return AsciiTableDataSource.this.timeParser.parse(field).getTime(u3);
                    }
                };
                this.parser.setFieldParser(i, timeFieldParser2);
            } else if (delim != null && this.timeFormats.length > 1) {
                this.timeParser = TimeParser.create(timeFormat);
                this.parser.setUnits(this.timeColumn, Units.dimensionless);
                u2 = AsciiParser.UNIT_UTC;
                timeFieldParser = new MultiFieldTimeParser(this.timeColumn, this.timeFormats, this.timeParser, u2);
                for (int i = this.timeColumn; i < this.timeColumn + this.timeFormats.length; ++i) {
                    this.parser.setFieldParser(i, timeFieldParser);
                    this.parser.setUnits(i, Units.dimensionless);
                }
                this.timeColumn = this.timeColumn + this.timeFormats.length - 1;
                if (this.params.get("time") != null) {
                    this.depend0 = this.parser.getFieldNames()[this.timeColumn];
                }
                this.parser.setUnits(this.timeColumn, u2);
            } else {
                this.timeParser = TimeParser.create(timeFormat);
                u2 = AsciiParser.UNIT_UTC;
                this.parser.setUnits(this.timeColumn, u2);
                timeFieldParser = new AsciiParser.FieldParser(){

                    @Override
                    public double parseField(String field, int fieldIndex) throws ParseException {
                        return AsciiTableDataSource.this.timeParser.parse(field).getTime(u2);
                    }
                };
                this.parser.setFieldParser(this.timeColumn, timeFieldParser);
            }
        } else {
            this.timeParser = null;
        }
        o = (String)this.params.get("arg_0");
        if (o != null && !o.equals("rank2")) {
            this.column = o;
            this.timeColumn = 0;
            Units u4 = AsciiParser.UNIT_UTC;
            this.parser.setUnits(0, u4);
            this.depend0 = "0";
        }
        if ((o = (String)this.params.get("column")) != null) {
            this.column = o;
        }
        if ((o = (String)this.params.get("depend0")) != null) {
            this.depend0 = o;
        }
        if ((o = (String)this.params.get("Z")) != null) {
            this.column = o;
        } else {
            o = (String)this.params.get("Y");
            if (o != null) {
                this.column = o;
            }
        }
        o = (String)this.params.get("X");
        if (o != null) {
            this.depend0 = o;
        }
        if ((o = (String)this.params.get("rank2")) != null) {
            this.rank2 = this.parseRangeStr(o, columnCount);
            this.column = null;
        }
        if ((o = (String)this.params.get("bundle")) != null) {
            this.bundle = this.parseRangeStr(o, columnCount);
            this.column = null;
        }
        if ((o = (String)this.params.get("arg_0")) != null) {
            if (o.equals("rank2")) {
                this.rank2 = new int[]{0, columnCount};
                this.column = null;
            } else if (o.equals("bundle")) {
                this.bundle = new int[]{0, columnCount};
                this.column = null;
            }
        }
        boolean bl = haveColumn = this.column != null;
        if (this.column == null && this.depend0 == null && this.rank2 == null) {
            if (this.parser.getFieldNames().length == 2) {
                this.depend0 = this.parser.getFieldNames()[0];
                this.column = this.parser.getFieldNames()[1];
            } else {
                this.column = this.parser.getFieldNames()[0];
            }
        }
        if ((o = (String)this.params.get("depend1Labels")) != null) {
            if (o.contains(",")) {
                this.depend1Label = o.split(",");
            } else {
                this.depend1Labels = this.parseRangeStr(o, columnCount);
            }
        }
        if ((o = (String)this.params.get("depend1Values")) != null) {
            this.depend1Values = this.parseRangeStr(o, columnCount);
        }
        this.eventListColumn = (String)this.params.get("eventListColumn");
        if (this.parser.getFieldLabels().length >= 2 && this.parser.getFieldLabels().length <= 5 && UnitsUtil.isTimeLocation(this.parser.getUnits(0)) && UnitsUtil.isTimeLocation(this.parser.getUnits(1)) && !haveColumn) {
            if (this.parser.getFieldCount() > 2) {
                this.eventListColumn = "field" + (this.parser.getFieldLabels().length - 1);
            } else {
                this.eventListColumn = "";
                this.depend0 = null;
                this.column = null;
            }
        }
        if (this.eventListColumn != null) {
            this.parser.setUnits(0, AsciiParser.UNIT_UTC);
            this.parser.setUnits(1, AsciiParser.UNIT_UTC);
            this.parser.setFieldParser(0, this.parser.UNITS_PARSER);
            this.parser.setFieldParser(1, this.parser.UNITS_PARSER);
            if (!this.eventListColumn.equals("")) {
                int icol = this.parser.getFieldIndex(this.eventListColumn);
                EnumerationUnits eu = EnumerationUnits.create("events");
                this.parser.setUnits(icol, (Units)eu);
                this.parser.setFieldParser(icol, this.parser.ENUMERATION_PARSER);
                if (icol > 2) {
                    String[] fields = new String[this.parser.getRecordParser().fieldCount()];
                    String s3 = this.parser.readFirstParseableRecord(this.file.toString());
                    this.parser.getRecordParser().splitRecord(s3, fields);
                    if (fields[2].startsWith("x") || fields[2].startsWith("0x")) {
                        this.parser.setUnits(2, Units.dimensionless);
                        this.parser.setFieldParser(2, new AsciiParser.FieldParser(){

                            @Override
                            public double parseField(String field, int columnIndex) throws ParseException {
                                if (field.startsWith("x")) {
                                    return Integer.decode("0" + field).intValue();
                                }
                                return Integer.decode(field).intValue();
                            }
                        });
                        this.eventListColorColumn = 2;
                    }
                }
            }
        }
        if (this.timeColumn == -1 && (s = this.parser.readFirstParseableRecord(this.file.toString())) != null) {
            int icol;
            Object field;
            int idep0;
            String[] fields = new String[this.parser.getRecordParser().fieldCount()];
            this.parser.getRecordParser().splitRecord(s, fields);
            if (this.depend0 != null && (idep0 = this.parser.getFieldIndex(this.depend0)) != -1) {
                field = fields[idep0];
                try {
                    TimeUtil.parseTime((String)field);
                    if (new StringTokenizer((String)field, ":T-/").countTokens() > 1) {
                        this.parser.setUnits(idep0, AsciiParser.UNIT_UTC);
                        this.parser.setFieldParser(idep0, this.parser.UNITS_PARSER);
                    }
                }
                catch (ParseException i) {
                    // empty catch block
                }
            }
            if (this.column != null && (icol = this.parser.getFieldIndex(this.column)) != -1) {
                field = fields[icol];
                try {
                    field = ((String)field).trim();
                    if (!UnitsUtil.isTimeLocation(this.parser.getUnits(icol)) && !((String)field).startsWith("-")) {
                        TimeUtil.parseTime((String)field);
                        if (new StringTokenizer((String)field, ":T-/").countTokens() > 2) {
                            this.parser.setUnits(icol, AsciiParser.UNIT_UTC);
                            this.parser.setFieldParser(icol, this.parser.UNITS_PARSER);
                        }
                    }
                }
                catch (ParseException i) {
                    // empty catch block
                }
            }
            for (icol = 0; icol < fields.length && icol < 2; ++icol) {
                field = fields[icol];
                try {
                    field = ((String)field).trim();
                    if (UnitsUtil.isTimeLocation(this.parser.getUnits(icol)) || ((String)field).startsWith("-")) continue;
                    TimeUtil.parseTime((String)field);
                    if (new StringTokenizer((String)field, ":T-/").countTokens() <= 2) continue;
                    this.parser.setUnits(icol, AsciiParser.UNIT_UTC);
                    this.parser.setFieldParser(icol, this.parser.UNITS_PARSER);
                    continue;
                }
                catch (ParseException i) {
                    // empty catch block
                }
            }
        }
        if ((o = (String)this.params.get("units")) != null) {
            String sunits = o;
            u = sunits.equals("enum") ? EnumerationUnits.create("default") : Units.lookupUnits(sunits);
            if (this.column != null) {
                int icol = this.parser.getFieldIndex(this.column);
                this.parser.setUnits(icol, u);
                if (sunits.equals("enum")) {
                    this.parser.setFieldParser(icol, this.parser.ENUMERATION_PARSER);
                } else {
                    this.parser.setFieldParser(icol, this.parser.UNITS_PARSER);
                }
            }
        }
        if ((o = (String)this.params.get("ordinal")) != null) {
            String sunits = o;
            u = EnumerationUnits.create("default");
            String[] ss = sunits.split(",");
            for (String s4 : ss) {
                ((EnumerationUnits)u).createDatum(s4);
            }
            if (this.column != null) {
                int icol = this.parser.getFieldIndex(this.column);
                this.parser.setUnits(icol, u);
                this.parser.setFieldParser(icol, this.parser.ENUMERATION_PARSER);
            }
        }
        if ((o = (String)this.params.get("where")) != null && (w = o).length() > 0) {
            Pattern p2 = Pattern.compile("\\.([nelg][qte])\\(");
            Matcher m = p2.matcher(w);
            if (!m.find()) {
                Pattern p22 = Pattern.compile("\\.(within|matches)\\(");
                Matcher m2 = p22.matcher(w);
                if (!m2.find()) {
                    throw new IllegalArgumentException("where can only contain .eq,.ne,.ge,.gt,.le,.lt, .within, or .matches");
                }
                int ieq = m2.start();
                String sop = m2.group(1);
                String sval = w.substring(ieq + sop.length() + 2, w.length() - 1);
                String sparm = w.substring(0, ieq);
                this.parser.setWhereConstraint(sparm, sop, DataSourceUtil.unescape(sval));
            } else {
                int ieq = m.start();
                String op = m.group(1);
                String sval = w.substring(ieq + 4, w.length() - 1);
                String sparm = w.substring(0, ieq);
                this.parser.setWhereConstraint(sparm, op, sval);
            }
        }
        logger.fine("done process parameters and peeking at file");
        o = (String)this.params.get("tail");
        if (o != null) {
            MappedByteBuffer buff = new FileInputStream(this.file).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.file.length());
            int tailNum = Integer.parseInt(o);
            int tailCount = 0;
            int ipos = (int)this.file.length();
            boolean foundNonEOL = false;
            block16: while (tailCount < tailNum && ipos > 0) {
                byte ch = buff.get(--ipos);
                switch (ch) {
                    case 10: {
                        if (ipos > 1 && buff.get(ipos - 1) == 13) {
                            --ipos;
                        }
                        if (!foundNonEOL) continue block16;
                        ++tailCount;
                        continue block16;
                    }
                    case 13: {
                        if (!foundNonEOL) continue block16;
                        ++tailCount;
                        continue block16;
                    }
                }
                foundNonEOL = true;
            }
            ((ByteBuffer)buff).position(tailCount < tailNum ? 0 : ipos + 1);
            ByteBufferInputStream in = new ByteBufferInputStream(buff);
            mon.setProgressMessage("reading " + this.file);
            ds1 = (DDataSet)this.parser.readStream(new InputStreamReader(in), mon.getSubtaskMonitor("read file"));
        } else {
            mon.setProgressMessage("reading " + this.file);
            ds1 = (DDataSet)this.parser.readFile(this.file.toString(), mon.getSubtaskMonitor("read file"));
        }
        logger.fine("done parsing file");
        return ds1;
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        String firstRecord;
        if (this.ds == null) {
            return new HashMap<String, Object>();
        }
        Map props = (Map)this.ds.property("USER_PROPERTIES");
        String header = (String)props.get("fileHeader");
        if (header != null) {
            header = header.replaceAll("\t", "\\\\t");
            props.put("fileHeader", header);
        }
        if ((firstRecord = (String)props.get("firstRecord")) != null) {
            firstRecord = firstRecord.replaceAll("\t", "\\\\t");
            props.put("firstRecord", firstRecord);
        }
        ArrayList<String> remove = new ArrayList<String>();
        for (Map.Entry e : props.entrySet()) {
            String k = (String)e.getKey();
            Object v = e.getValue();
            if (v == null || v instanceof Number || v instanceof String || v instanceof Datum) continue;
            remove.add(k);
        }
        for (String k : remove) {
            props.remove(k);
        }
        return props;
    }

    private int columnIndex(String name, int count) {
        if (Pattern.matches("\\d+", name)) {
            return Integer.parseInt(name);
        }
        if (Pattern.matches("-\\d+", name)) {
            return count + Integer.parseInt(name);
        }
        if (Pattern.matches("field\\d+", name)) {
            return Integer.parseInt(name.substring(5));
        }
        int idx = this.parser.getFieldIndex(name);
        return idx;
    }

    private int[] parseRangeStr(String o, int columnCount) throws NumberFormatException {
        String s = o;
        int first = 0;
        int last = columnCount;
        if (s.contains(":")) {
            String[] ss = s.split(":", -2);
            if (ss[0].length() > 0) {
                first = this.columnIndex(ss[0], columnCount);
            }
            if (ss[1].length() > 0) {
                last = this.columnIndex(ss[1], columnCount);
            }
        } else if (s.contains("--")) {
            int isplit = s.indexOf("--", 1);
            if (isplit > 0) {
                first = this.columnIndex(s.substring(0, isplit), columnCount);
            }
            if (isplit < s.length() - 2) {
                last = 1 + this.columnIndex(s.substring(isplit + 1), columnCount);
            }
        } else if (s.contains("-")) {
            String[] ss = s.split("-", -2);
            if (ss[0].length() > 0) {
                first = this.columnIndex(ss[0], columnCount);
            }
            if (ss[1].length() > 0) {
                last = 1 + this.columnIndex(ss[1], columnCount);
            }
        }
        return new int[]{first, last};
    }
}

