/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.aggregator;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.aggregator.AggregatingDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.capability.Streaming;
import org.das2.datum.LoggerManager;
import org.das2.qds.QDataSet;
import org.das2.util.monitor.ProgressMonitor;

public class StreamingCapability
implements Streaming {
    private static final Logger logger = LoggerManager.getLogger("apdss.agg");
    URI uri;
    AggregatingDataSource dss;

    public StreamingCapability(URI uri, AggregatingDataSource dss) {
        this.uri = uri;
        this.dss = dss;
    }

    @Override
    public Iterator<QDataSet> streamDataSet(ProgressMonitor mon) throws Exception {
        return new StreamIterator(mon);
    }

    private class StreamIterator
    implements Iterator<QDataSet> {
        ProgressMonitor mon;
        String[] granules;
        int igranule;
        QDataSet currentDataSet;
        int currentIndex;

        private StreamIterator(ProgressMonitor mon) throws Exception {
            this.mon = mon;
            String[] ss = StreamingCapability.this.dss.getFsm().getBestNamesFor(StreamingCapability.this.dss.getViewRange(), mon.getSubtaskMonitor(StreamingCapability.this.dss.getSParams()));
            this.mon.setTaskSize(ss.length * 10);
            this.granules = ss;
            this.igranule = 0;
            this.currentIndex = 0;
            this.loadNext();
        }

        private void loadNext() throws Exception {
            if (this.granules.length == 0) {
                return;
            }
            String scompUrl = StreamingCapability.this.dss.getFsm().getFileSystem().getRootURI().toString() + this.granules[this.igranule];
            if (!StreamingCapability.this.dss.getSParams().equals("")) {
                scompUrl = scompUrl + "?" + StreamingCapability.this.dss.getSParams();
            }
            URI delegateUri = null;
            try {
                delegateUri = DataSetURI.getURIValid(scompUrl);
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException(ex);
            }
            DataSource delegateDataSource = StreamingCapability.this.dss.delegateDataSourceFactory.getDataSource(delegateUri);
            this.currentDataSet = delegateDataSource.getDataSet(this.mon.getSubtaskMonitor(this.igranule * 10, this.igranule * 10 + 10, "g" + this.igranule));
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.currentDataSet == null) {
                return false;
            }
            if (this.currentIndex == this.currentDataSet.length()) {
                ++this.igranule;
                if (this.igranule == this.granules.length) {
                    return false;
                }
                try {
                    this.loadNext();
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public QDataSet next() {
            QDataSet result = this.currentDataSet.slice(this.currentIndex);
            ++this.currentIndex;
            return result;
        }

        @Override
        public void remove() {
        }
    }
}

