/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.aggregator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.autoplot.aggregator.AggregatingDataSourceFactory;
import org.autoplot.datasource.CompletionsDataSourceEditor;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceEditorPanelUtil;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.datasource.SourceTypesBrowser;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.ui.PromptComboBoxEditor;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.fsm.FileStorageModel;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;

public class AggregatingDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = LoggerManager.getLogger("apdss.agg");
    String uri;
    List<DatumRange> ranges;
    boolean updatingDropLists = false;
    boolean droplistIsDirty = false;
    boolean hasTimeFields = true;
    private JCheckBox availabilityCB;
    private JComboBox daysComboBox;
    private JPanel delegatePanel;
    private JTextField delegateTextField;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JComboBox monthsComboBox;
    private JLabel outerRangeTextField;
    private JCheckBox reduceCB;
    private RecentComboBox timeRangeComboBox;
    private JButton timeRangeToolButton;
    private JComboBox yearsComboBox;
    JComponent delegateComponent = null;
    DataSourceEditorPanel delegateEditorPanel = null;
    URISplit split;
    Map<String, String> params;

    public AggregatingDataSourceEditorPanel() {
        this.initComponents();
        this.timeRangeComboBox.setName("timeRangeEditor");
        this.timeRangeComboBox.setMinimumSize(new Dimension(200, 30));
        this.timeRangeComboBox.setPreferenceNode("timerange");
        this.timeRangeComboBox.setEditor(new PromptComboBoxEditor("Time range to view (e.g. 2010-01-01)"));
        this.timeRangeComboBox.setToolTipText("Recently entered time ranges");
        ((JComponent)this.timeRangeComboBox.getEditor().getEditorComponent()).setToolTipText("Time Range, right-click for examples");
        AutoplotHelpSystem.getHelpSystem().registerHelpID(this, "aggregator_main");
    }

    public void setDelegateEditorPanel(DataSourceEditorPanel edit) {
        this.delegateEditorPanel = edit;
    }

    private void copyTimes(int modifiers) {
        String syr = String.valueOf(this.yearsComboBox.getSelectedItem()).trim();
        String smn = String.valueOf(this.monthsComboBox.getSelectedItem()).trim();
        String sday = String.valueOf(this.daysComboBox.getSelectedItem()).trim();
        String range = syr + " " + smn + " " + sday;
        range = range.trim();
        if ((modifiers & 1) == 1) {
            DatumRange dr1 = DatumRangeUtil.parseTimeRangeValid(range);
            try {
                DatumRange dr2 = DatumRangeUtil.parseTimeRange(this.timeRangeComboBox.getSelectedItem().toString());
                dr2 = DatumRangeUtil.union(dr1, dr2);
                this.timeRangeComboBox.setSelectedItem(dr2.toString());
            }
            catch (ParseException ex) {
                this.timeRangeComboBox.setSelectedItem(range);
            }
        } else {
            this.timeRangeComboBox.setSelectedItem(range);
        }
    }

    private void initComponents() {
        this.delegatePanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.outerRangeTextField = new JLabel();
        this.yearsComboBox = new JComboBox();
        this.monthsComboBox = new JComboBox();
        this.daysComboBox = new JComboBox();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.delegateTextField = new JTextField();
        this.timeRangeToolButton = new JButton();
        this.reduceCB = new JCheckBox();
        this.availabilityCB = new JCheckBox();
        this.timeRangeComboBox = new RecentComboBox();
        this.delegatePanel.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Time Range for Aggregation:");
        this.jLabel1.setToolTipText("<html>Enter the time range to over which to aggregate data. <br>\nData from files within this range will be combined by concatenating over the first dimension.</br>\n</html>\n\n");
        this.outerRangeTextField.setFont(new Font("SansSerif", 0, 10));
        this.outerRangeTextField.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/aggregator/spinner_16.gif")));
        this.outerRangeTextField.setText("listing to get available time ranges...");
        this.yearsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"..."}));
        this.yearsComboBox.setToolTipText("Select from available years");
        this.yearsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AggregatingDataSourceEditorPanel.this.yearsComboBoxItemStateChanged(evt);
            }
        });
        this.yearsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AggregatingDataSourceEditorPanel.this.yearsComboBoxActionPerformed(evt);
            }
        });
        this.monthsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"...", " "}));
        this.monthsComboBox.setToolTipText("Select from available months");
        this.monthsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AggregatingDataSourceEditorPanel.this.monthsComboBoxItemStateChanged(evt);
            }
        });
        this.monthsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AggregatingDataSourceEditorPanel.this.monthsComboBoxActionPerformed(evt);
            }
        });
        this.daysComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"...", " "}));
        this.daysComboBox.setToolTipText("Select from available days");
        this.daysComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AggregatingDataSourceEditorPanel.this.daysComboBoxActionPerformed(evt);
            }
        });
        this.jButton1.setText("Select This Time Range");
        this.jButton1.setToolTipText("<html>\nCopy the date into the time range field.<br>\nHolding shift down will add the selected time to the aggregation.<br>\n</html>");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AggregatingDataSourceEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("jButton2");
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/help.png")));
        this.jButton3.setToolTipText("Help for this component\n");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AggregatingDataSourceEditorPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.delegateTextField.setEditable(false);
        this.delegateTextField.setFont(this.delegateTextField.getFont().deriveFont((float)this.delegateTextField.getFont().getSize() - 4.0f));
        this.delegateTextField.setText("example file used for editing goes here.");
        this.delegateTextField.setToolTipText("this only indicates the delegate file used to edit the rest of the URI above");
        this.timeRangeToolButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/calendar.png")));
        this.timeRangeToolButton.setToolTipText("Time Range Tool");
        this.timeRangeToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AggregatingDataSourceEditorPanel.this.timeRangeToolButtonActionPerformed(evt);
            }
        });
        this.reduceCB.setText("reduce");
        this.reduceCB.setToolTipText("Reduce data by averaging as it is loaded");
        this.availabilityCB.setText("availability");
        this.availabilityCB.setToolTipText("Show data availability instead of loading data.  This simply shows if granule files are found or not, so empty or near-empty granules still are marked as available.\n");
        this.availabilityCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AggregatingDataSourceEditorPanel.this.availabilityCBActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.timeRangeComboBox, -2, 264, -2).addPreferredGap(0).add((Component)this.timeRangeToolButton).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButton3)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(7, 7, 7).add((Component)this.yearsComboBox, -2, 93, -2).addPreferredGap(0).add((Component)this.monthsComboBox, -2, 88, -2).addPreferredGap(0).add((Component)this.daysComboBox, -2, 72, -2).addPreferredGap(0).add((Component)this.jButton1).addContainerGap(244, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.delegateTextField, -1, 679, Short.MAX_VALUE).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.outerRangeTextField, -1, 548, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.availabilityCB).add((Component)this.reduceCB, -2, 119, -2)))).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.monthsComboBox, this.yearsComboBox}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jButton3).add((Component)this.timeRangeToolButton).add((Component)this.timeRangeComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.reduceCB).add((Component)this.outerRangeTextField)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.yearsComboBox, -2, -1, -2).add((Component)this.monthsComboBox, -2, -1, -2).add((Component)this.daysComboBox, -2, -1, -2).add((Component)this.jButton1)).add((Component)this.availabilityCB)).addPreferredGap(0).add((Component)this.delegateTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.delegatePanel, -1, 707, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.delegatePanel, -1, 255, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jButton1.setEnabled(false);
        LoggerManager.logGuiEvent(evt);
        this.copyTimes(evt.getModifiers());
    }

    private void yearsComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.updatingDropLists) {
            this.updateDropLists(false, true);
        }
    }

    private void monthsComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.updatingDropLists) {
            this.updateDropLists(false, false);
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        AutoplotHelpSystem.getHelpSystem().displayHelpFromEvent(evt, this);
    }

    private void timeRangeToolButtonActionPerformed(ActionEvent evt) {
        String tr;
        LoggerManager.logGuiEvent(evt);
        TimeRangeTool t = new TimeRangeTool();
        Object otr = this.timeRangeComboBox.getSelectedItem();
        String string = tr = otr == null ? "" : otr.toString();
        if (tr.trim().length() == 0) {
            tr = "2010-01-01";
        }
        t.setSelectedRange(tr);
        if (0 == JOptionPane.showConfirmDialog(this, t, "Select time range", 2)) {
            String str = t.getSelectedRange();
            this.timeRangeComboBox.setSelectedItem(DatumRangeUtil.parseTimeRangeValid(str).toString());
        }
    }

    private void availabilityCBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
    }

    private void yearsComboBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.droplistIsDirty = true;
        this.jButton1.setEnabled(true);
    }

    private void monthsComboBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.droplistIsDirty = true;
        this.jButton1.setEnabled(true);
    }

    private void daysComboBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.droplistIsDirty = true;
        this.jButton1.setEnabled(true);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    private void setDelegateComponent(JComponent c) {
        if (this.delegateComponent != null) {
            this.delegatePanel.remove(this.delegateComponent);
        }
        this.delegateComponent = c;
        this.delegatePanel.add((Component)c, "Center");
        this.delegatePanel.validate();
    }

    private void updateTimeRanges() {
        DatumRange dr = null;
        try {
            FileStorageModel fsm = AggregatingDataSourceFactory.getFileStorageModel(this.uri);
            String[] names = fsm.getNamesFor(null, new NullProgressMonitor());
            this.ranges = new ArrayList<DatumRange>(names.length);
            for (int i = 0; i < names.length; ++i) {
                this.ranges.add(i, fsm.getRangeFor(names[i]));
                dr = dr == null ? this.ranges.get(i) : DatumRangeUtil.union(dr, this.ranges.get(i));
            }
        }
        catch (IOException ex) {
            this.outerRangeTextField.setText(ex.toString());
            return;
        }
        if (AggregatingDataSourceFactory.hasTimeFields(this.uri)) {
            this.outerRangeTextField.setText("found files for " + dr);
            this.outerRangeTextField.setIcon(null);
        } else {
            this.outerRangeTextField.setText("aggregation doesn't have time fields");
            this.outerRangeTextField.setIcon(null);
        }
    }

    private void updateDropLists(boolean updateYear, boolean updateMonth) {
        DefaultComboBoxModel<String> model;
        List<DatumRange> result;
        List<DatumRange> possible;
        this.updatingDropLists = true;
        DatumRange selectedRange = null;
        try {
            selectedRange = DatumRangeUtil.parseTimeRange(this.timeRangeComboBox.getSelectedItem().toString());
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (updateYear) {
            possible = DatumRangeUtil.generateList(DatumRangeUtil.parseTimeRangeValid("1800-2200"), DatumRangeUtil.parseTimeRangeValid("1800"));
            result = DatumRangeUtil.intersection(possible, this.ranges, false);
            String[] yrLabels = new String[result.size() + 1];
            yrLabels[0] = "";
            int isel = result.size() == 1 ? 1 : 0;
            for (int i = 0; i < result.size(); ++i) {
                yrLabels[i + 1] = result.get(i).toString();
                if (selectedRange == null || !result.get(i).intersects(selectedRange)) continue;
                isel = i + 1;
            }
            model = new DefaultComboBoxModel<String>(yrLabels);
            this.yearsComboBox.setModel(model);
            this.yearsComboBox.setSelectedIndex(isel);
        }
        String syr = String.valueOf(this.yearsComboBox.getSelectedItem()).trim();
        if (updateMonth) {
            if (syr.length() > 0) {
                possible = DatumRangeUtil.generateList(DatumRangeUtil.parseTimeRangeValid(syr), DatumRangeUtil.parseTimeRangeValid(syr + " jan"));
                result = DatumRangeUtil.intersection(possible, this.ranges, false);
                String[] mnLabels = new String[result.size() + 1];
                mnLabels[0] = "";
                int isel = result.size() == 1 ? 1 : 0;
                for (int i = 0; i < result.size(); ++i) {
                    mnLabels[i + 1] = result.get(i).toString().replace(syr, "").trim();
                    if (selectedRange == null || !result.get(i).intersects(selectedRange) || !selectedRange.width().le(result.get(i).width())) continue;
                    isel = i + 1;
                }
                model = new DefaultComboBoxModel<String>(mnLabels);
                this.monthsComboBox.setModel(model);
                this.monthsComboBox.setSelectedIndex(isel);
            } else {
                this.monthsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
            }
        }
        String smon = String.valueOf(this.monthsComboBox.getSelectedItem()).trim();
        if (syr.length() > 0 && smon.length() > 0) {
            possible = DatumRangeUtil.generateList(DatumRangeUtil.parseTimeRangeValid(syr + " " + smon), DatumRangeUtil.parseTimeRangeValid(syr + " " + smon + " 1"));
            result = DatumRangeUtil.intersection(possible, this.ranges, false);
            String[] dayLabels = new String[result.size() + 1];
            dayLabels[0] = "";
            int isel = result.size() == 1 ? 1 : 0;
            for (int i = 0; i < result.size(); ++i) {
                dayLabels[i + 1] = String.valueOf(TimeUtil.toTimeStruct((Datum)result.get((int)i).min()).day);
                if (selectedRange == null || !result.get(i).intersects(selectedRange) || !selectedRange.width().le(result.get(i).width())) continue;
                isel = i + 1;
            }
            model = new DefaultComboBoxModel<String>(dayLabels);
            this.daysComboBox.setModel(model);
            this.daysComboBox.setSelectedIndex(isel);
        } else {
            this.daysComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
        }
        this.updatingDropLists = false;
        this.droplistIsDirty = false;
        this.jButton1.setEnabled(false);
    }

    @Override
    public boolean reject(String uri) throws Exception {
        String delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(uri, new NullProgressMonitor());
        if (this.delegateEditorPanel == null) {
            this.delegateEditorPanel = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.toUri(delegateUrl));
        }
        if (this.delegateEditorPanel == null) {
            return false;
        }
        return this.delegateEditorPanel.reject(delegateUrl);
    }

    @Override
    public boolean prepare(String url, Window parent, ProgressMonitor mon) throws IOException, URISyntaxException, Exception {
        String delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(url, new NullProgressMonitor());
        Pattern p = Pattern.compile("(vap(\\+[a-z]+)?\\:)?([^\\?]*)(\\?.*)");
        Matcher m = p.matcher(delegateUrl);
        if (m.matches()) {
            this.delegateTextField.setText("editing example URI " + m.group(3) + " above");
        } else {
            this.delegateTextField.setText("editing example URI " + delegateUrl + " above");
        }
        if (this.delegateEditorPanel == null) {
            this.delegateEditorPanel = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.toUri(delegateUrl));
        }
        if (this.delegateEditorPanel == null) {
            this.delegateEditorPanel = new CompletionsDataSourceEditor();
            return this.delegateEditorPanel.prepare(delegateUrl, parent, mon);
        }
        return this.delegateEditorPanel.prepare(delegateUrl, parent, mon);
    }

    @Override
    public void setURI(String url) {
        this.split = URISplit.parse(url);
        this.params = URISplit.parseParams(this.split.params);
        this.uri = url;
        this.hasTimeFields = AggregatingDataSourceFactory.hasTimeFields(url);
        try {
            if (this.hasTimeFields) {
                String timeRange = this.params.get("timerange");
                if (timeRange == null) {
                    timeRange = "";
                }
                if (timeRange.trim().length() > 0) {
                    timeRange = timeRange.replaceAll("\\+", " ");
                    try {
                        DatumRange datumRange = DatumRangeUtil.parseTimeRange(timeRange);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                this.timeRangeComboBox.setSelectedItem(timeRange);
                String reduce = this.params.get("reduce");
                this.reduceCB.setSelected("T".equals(reduce));
                String avail = this.params.get("avail");
                this.availabilityCB.setSelected("T".equals(avail));
            } else {
                this.jPanel1.setEnabled(false);
                this.timeRangeComboBox.setSelectedItem("");
                this.timeRangeComboBox.setEnabled(false);
                this.reduceCB.setEnabled(false);
                this.availabilityCB.setEnabled(false);
                this.yearsComboBox.setEnabled(false);
                this.monthsComboBox.setEnabled(false);
                this.daysComboBox.setEnabled(false);
                this.timeRangeToolButton.setEnabled(false);
            }
            String delegateUrl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(url, null);
            if (this.delegateEditorPanel == null) {
                this.delegateEditorPanel = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.toUri(delegateUrl));
            }
            this.delegateEditorPanel.setURI(delegateUrl);
            this.setDelegateComponent(this.delegateEditorPanel.getPanel());
        }
        catch (IOException | IllegalArgumentException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            RuntimeException ex2 = new RuntimeException("Unable to create example file for aggregation", ex);
            throw ex2;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AggregatingDataSourceEditorPanel.this.updateTimeRanges();
                if (AggregatingDataSourceEditorPanel.this.ranges != null) {
                    AggregatingDataSourceEditorPanel.this.updateDropLists(true, true);
                }
            }
        };
        new Thread(run).start();
    }

    public void setTimeRange(DatumRange timerange) {
        this.timeRangeComboBox.setSelectedItem(timerange.toString());
    }

    public DatumRange getTimeRange() {
        if (this.timeRangeComboBox.getSelectedItem().toString().trim().equals("")) {
            return null;
        }
        try {
            return DatumRangeUtil.parseTimeRange(this.timeRangeComboBox.getSelectedItem().toString().trim());
        }
        catch (ParseException ex) {
            return null;
        }
    }

    @Override
    public String getURI() {
        String delegateUrl;
        String vapScheme = this.split.vapScheme;
        if (this.delegateEditorPanel != null) {
            delegateUrl = this.delegateEditorPanel.getURI();
        } else {
            delegateUrl = ((SourceTypesBrowser)this.delegateComponent).getUri();
            vapScheme = null;
        }
        URISplit dsplit = URISplit.parse(delegateUrl);
        LinkedHashMap<String, String> allParams = new LinkedHashMap<String, String>();
        if (this.droplistIsDirty) {
            this.copyTimes(0);
        }
        allParams.putAll(URISplit.parseParams(dsplit.params));
        if (this.hasTimeFields) {
            Object otr = this.timeRangeComboBox.getSelectedItem();
            String tr = otr == null ? "" : otr.toString().trim();
            tr = tr.replaceAll(" ", "+");
            String tr0 = (String)allParams.get("timerange");
            if (tr0 != null && tr0.length() > 0 && tr.trim().length() == 0) {
                logger.log(Level.FINE, "I didn't get timerange but delegate did");
                tr = tr0;
            }
            allParams.put("timerange", tr);
            if (this.reduceCB.isSelected()) {
                allParams.put("reduce", "T");
            } else {
                allParams.remove("reduce");
            }
            if (this.availabilityCB.isSelected()) {
                allParams.put("avail", "T");
            } else {
                allParams.remove("avail");
            }
        }
        this.split.params = URISplit.formatParams(allParams);
        if (vapScheme == null) {
            this.split.vapScheme = dsplit.vapScheme;
        }
        return URISplit.format(this.split);
    }

    @Override
    public void markProblems(List<String> problems) {
        ArrayList<String> p = new ArrayList<String>(problems);
        JTextField timeRangeTextField = (JTextField)this.timeRangeComboBox.getEditor().getEditorComponent();
        if (p.contains("no timerange provided")) {
            p.remove("no timerange provided");
            timeRangeTextField.setBackground(Color.YELLOW);
            this.jLabel1.setBackground(Color.YELLOW);
            this.jLabel1.setForeground(Color.RED);
            this.jLabel1.setToolTipText(this.jLabel1.getToolTipText() + "<br><b>" + "no timerange provided");
            this.timeRangeComboBox.setToolTipText("no timerange provided");
        } else if (p.contains("parse error in timeRange")) {
            p.remove("parse error in timeRange");
            timeRangeTextField.setBackground(Color.YELLOW);
            this.jLabel1.setBackground(Color.YELLOW);
            this.jLabel1.setForeground(Color.RED);
            this.jLabel1.setToolTipText(this.jLabel1.getToolTipText() + "<br><br><b>" + "parse error in timeRange");
            timeRangeTextField.setToolTipText("parse error in timeRange");
        }
    }
}

